/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.MCUtil;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spigotmc.AsyncCatcher;

public abstract class ChunkMapDistance {
    static final Logger a = LogManager.getLogger();
    private static final int b = 2;
    static final int c = 33 + ChunkStatus.a(ChunkStatus.o) - 2;
    private static final int d = 4;
    private static final int e = 32;
    private static final int f = 33;
    final Long2ObjectMap<ObjectSet<EntityPlayer>> g = new Long2ObjectOpenHashMap();
    public final Long2ObjectOpenHashMap<ArraySetSorted<Ticket<?>>> h = new Long2ObjectOpenHashMap();
    private final a i = new a();
    public static final int MOB_SPAWN_RANGE = 8;
    private final TickingTracker k = new TickingTracker();
    private final c l = new c(33);
    public final Queue<PlayerChunk> pendingChunkUpdates = new ArrayDeque<PlayerChunk>(){

        @Override
        public boolean add(PlayerChunk o2) {
            if (o2.isUpdateQueued) {
                return true;
            }
            o2.isUpdateQueued = true;
            return super.add(o2);
        }
    };
    final ChunkTaskQueueSorter n;
    final Mailbox<ChunkTaskQueueSorter.a<Runnable>> o;
    final Mailbox<ChunkTaskQueueSorter.b> p;
    final LongSet q = new LongOpenHashSet();
    final Executor r;
    private long s;
    private int t = 10;
    private final PlayerChunkMap chunkMap;
    boolean pollingPendingChunkUpdates = false;
    public static final int PRIORITY_TICKET_LEVEL = PlayerChunkMap.b;
    public static final int URGENT_PRIORITY = 29;
    public boolean delayDistanceManagerTick = false;

    protected ChunkMapDistance(Executor workerExecutor, Executor mainThreadExecutor, PlayerChunkMap chunkMap) {
        ChunkTaskQueueSorter chunktaskqueuesorter;
        Objects.requireNonNull(mainThreadExecutor);
        Mailbox<Runnable> mailbox = Mailbox.a("player ticket throttler", mainThreadExecutor::execute);
        this.n = chunktaskqueuesorter = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of(mailbox), workerExecutor, 4);
        this.o = chunktaskqueuesorter.a(mailbox, true);
        this.p = chunktaskqueuesorter.a(mailbox);
        this.r = mainThreadExecutor;
        this.chunkMap = chunkMap;
    }

    protected void a() {
        ++this.s;
        ObjectIterator objectiterator = this.h.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((ArraySetSorted)entry.getValue()).iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (!ticket.b(this.s)) continue;
                iterator.remove();
                flag = true;
                this.k.b(entry.getLongKey(), ticket);
            }
            if (flag) {
                this.i.b(entry.getLongKey(), ChunkMapDistance.a((ArraySetSorted)entry.getValue()), false);
            }
            if (!((ArraySetSorted)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    private static int a(ArraySetSorted<Ticket<?>> tickets) {
        AsyncCatcher.catchOp("ChunkMapDistance::getTicketLevelAt");
        return !tickets.isEmpty() ? tickets.b().b() : PlayerChunkMap.b + 1;
    }

    protected abstract boolean a(long var1);

    @Nullable
    protected abstract PlayerChunk b(long var1);

    @Nullable
    protected abstract PlayerChunk a(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean a(PlayerChunkMap chunkStorage) {
        boolean flag;
        this.k.a();
        AsyncCatcher.catchOp("DistanceManagerTick");
        this.l.a();
        int i2 = Integer.MAX_VALUE - this.i.a(Integer.MAX_VALUE);
        boolean bl = flag = i2 != 0;
        if (flag) {
            // empty if block
        }
        if (!this.pendingChunkUpdates.isEmpty()) {
            this.pollingPendingChunkUpdates = true;
            try {
                while (!this.pendingChunkUpdates.isEmpty()) {
                    PlayerChunk remove = this.pendingChunkUpdates.remove();
                    remove.isUpdateQueued = false;
                    remove.a(chunkStorage, this.r);
                }
            }
            finally {
                this.pollingPendingChunkUpdates = false;
            }
            return true;
        }
        if (!this.q.isEmpty()) {
            LongIterator longiterator = this.q.iterator();
            while (longiterator.hasNext()) {
                long j2 = longiterator.nextLong();
                if (!this.g(j2).stream().anyMatch(ticket -> ticket.a() == TicketType.c)) continue;
                PlayerChunk playerchunk = chunkStorage.a(j2);
                if (playerchunk == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<Either<Chunk, PlayerChunk.Failure>> completablefuture = playerchunk.b();
                completablefuture.thenAccept(either -> this.r.execute(() -> this.p.a(ChunkTaskQueueSorter.a(() -> {}, j2, false))));
            }
            this.q.clear();
        }
        return flag;
    }

    boolean addTicket(long i2, Ticket<?> ticket) {
        AsyncCatcher.catchOp("ChunkMapDistance::addTicket");
        ArraySetSorted<Ticket<?>> arraysetsorted = this.g(i2);
        int j2 = ChunkMapDistance.a(arraysetsorted);
        Ticket<?> ticket1 = arraysetsorted.a(ticket);
        ticket1.a(this.s);
        if (ticket.b() < j2) {
            this.i.b(i2, ticket.b(), true);
        }
        return ticket == ticket1;
    }

    boolean removeTicket(long i2, Ticket<?> ticket) {
        int newLevel;
        AsyncCatcher.catchOp("ChunkMapDistance::removeTicket");
        ArraySetSorted<Ticket<?>> arraysetsorted = this.g(i2);
        int oldLevel = ChunkMapDistance.a(arraysetsorted);
        boolean removed = false;
        if (arraysetsorted.remove(ticket)) {
            removed = true;
            long delayChunkUnloadsBy = this.chunkMap.q.paperConfig.delayChunkUnloadsBy;
            if (ticket.a() == TicketType.c && delayChunkUnloadsBy > 0L) {
                boolean hasPlayer = false;
                for (Ticket<?> ticket1 : arraysetsorted) {
                    if (ticket1.a() != TicketType.c) continue;
                    hasPlayer = true;
                    break;
                }
                PlayerChunk playerChunk = this.chunkMap.a(i2);
                if (!hasPlayer && playerChunk != null && playerChunk.isFullChunkReady()) {
                    Ticket<Long> delayUnload = new Ticket<Long>(TicketType.DELAY_UNLOAD, 33, i2);
                    delayUnload.delayUnloadBy = delayChunkUnloadsBy;
                    delayUnload.a(this.s);
                    arraysetsorted.remove(delayUnload);
                    arraysetsorted.add(delayUnload);
                }
            }
        }
        if (arraysetsorted.isEmpty()) {
            this.h.remove(i2);
        }
        if ((newLevel = ChunkMapDistance.a(arraysetsorted)) > oldLevel) {
            this.i.b(i2, newLevel, false);
        }
        return removed;
    }

    public <T> void a(TicketType<T> type, ChunkCoordIntPair pos, int level, T argument) {
        this.addTicketAtLevel(type, pos, level, argument);
    }

    public <T> boolean addTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkcoordintpair, int level, T identifier) {
        return this.addTicket(chunkcoordintpair.a(), new Ticket<T>(ticketType, level, identifier));
    }

    public <T> void b(TicketType<T> type, ChunkCoordIntPair pos, int level, T argument) {
        this.removeTicketAtLevel(type, pos, level, argument);
    }

    public <T> boolean removeTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkcoordintpair, int level, T identifier) {
        Ticket<T> ticket = new Ticket<T>(ticketType, level, identifier);
        return this.removeTicket(chunkcoordintpair.a(), ticket);
    }

    public <T> void c(TicketType<T> type, ChunkCoordIntPair pos, int radius, T argument) {
        Ticket<T> ticket = new Ticket<T>(type, 33 - radius, argument);
        long j2 = pos.a();
        this.addTicket(j2, ticket);
        this.k.a(j2, ticket);
    }

    public <T> void d(TicketType<T> type, ChunkCoordIntPair pos, int radius, T argument) {
        Ticket<T> ticket = new Ticket<T>(type, 33 - radius, argument);
        long j2 = pos.a();
        this.removeTicket(j2, ticket);
        this.k.b(j2, ticket);
    }

    private ArraySetSorted<Ticket<?>> g(long position) {
        return (ArraySetSorted)this.h.computeIfAbsent(position, j2 -> ArraySetSorted.a(4));
    }

    public boolean markUrgent(ChunkCoordIntPair coords) {
        return this.addPriorityTicket(coords, TicketType.URGENT, 29);
    }

    public boolean markHighPriority(ChunkCoordIntPair coords, int priority) {
        priority = Math.min(28, Math.max(1, priority));
        return this.addPriorityTicket(coords, TicketType.PRIORITY, priority);
    }

    public void markAreaHighPriority(ChunkCoordIntPair center, int priority, int radius) {
        this.delayDistanceManagerTick = true;
        int finalPriority = priority = Math.min(28, Math.max(1, priority));
        MCUtil.getSpiralOutChunks(center.l(), radius).forEach(coords -> this.addPriorityTicket((ChunkCoordIntPair)coords, TicketType.PRIORITY, finalPriority));
        this.delayDistanceManagerTick = false;
        this.chunkMap.q.k().p();
    }

    public void clearAreaPriorityTickets(ChunkCoordIntPair center, int radius) {
        this.delayDistanceManagerTick = true;
        MCUtil.getSpiralOutChunks(center.l(), radius).forEach(coords -> this.removeTicket(coords.a(), new Ticket<ChunkCoordIntPair>(TicketType.PRIORITY, PRIORITY_TICKET_LEVEL, (ChunkCoordIntPair)coords)));
        this.delayDistanceManagerTick = false;
        this.chunkMap.q.k().p();
    }

    private boolean addPriorityTicket(ChunkCoordIntPair coords, TicketType<ChunkCoordIntPair> ticketType, int priority) {
        AsyncCatcher.catchOp("ChunkMapDistance::addPriorityTicket");
        long pair = coords.a();
        PlayerChunk chunk = this.chunkMap.a(pair);
        if (chunk != null && chunk.isFullChunkReady()) {
            return false;
        }
        boolean success = this.updatePriorityTicket(coords, ticketType, priority);
        if (!success) {
            Ticket<ChunkCoordIntPair> ticket = new Ticket<ChunkCoordIntPair>(ticketType, PRIORITY_TICKET_LEVEL, coords);
            ticket.priority = priority;
            success = this.addTicket(pair, ticket);
        } else {
            if (chunk == null) {
                chunk = this.chunkMap.a(pair);
            }
            this.chunkMap.queueHolderUpdate(chunk);
        }
        this.chunkMap.q.k().p();
        return success;
    }

    private boolean updatePriorityTicket(ChunkCoordIntPair coords, TicketType<ChunkCoordIntPair> type, int priority) {
        ArraySetSorted tickets = (ArraySetSorted)this.h.get(coords.a());
        if (tickets == null) {
            return false;
        }
        for (Ticket ticket : tickets) {
            if (ticket.a() != type) continue;
            ticket.a(this.s);
            ticket.priority = Math.max(ticket.priority, priority);
            return true;
        }
        return false;
    }

    public int getChunkPriority(ChunkCoordIntPair coords) {
        AsyncCatcher.catchOp("ChunkMapDistance::getChunkPriority");
        ArraySetSorted tickets = (ArraySetSorted)this.h.get(coords.a());
        if (tickets == null) {
            return 0;
        }
        for (Ticket ticket : tickets) {
            if (ticket.a() != TicketType.URGENT) continue;
            return 29;
        }
        for (Ticket ticket : tickets) {
            if (ticket.a() != TicketType.PRIORITY || ticket.priority <= 0) continue;
            return ticket.priority;
        }
        return 0;
    }

    public void clearPriorityTickets(ChunkCoordIntPair coords) {
        AsyncCatcher.catchOp("ChunkMapDistance::clearPriority");
        this.removeTicket(coords.a(), new Ticket<ChunkCoordIntPair>(TicketType.PRIORITY, PRIORITY_TICKET_LEVEL, coords));
    }

    public void clearUrgent(ChunkCoordIntPair coords) {
        AsyncCatcher.catchOp("ChunkMapDistance::clearUrgent");
        this.removeTicket(coords.a(), new Ticket<ChunkCoordIntPair>(TicketType.URGENT, PRIORITY_TICKET_LEVEL, coords));
    }

    protected void a(ChunkCoordIntPair pos, boolean forced) {
        Ticket<ChunkCoordIntPair> ticket = new Ticket<ChunkCoordIntPair>(TicketType.d, 31, pos);
        long i2 = pos.a();
        if (forced) {
            this.addTicket(i2, ticket);
            this.k.a(i2, ticket);
        } else {
            this.removeTicket(i2, ticket);
            this.k.b(i2, ticket);
        }
    }

    public void a(SectionPosition pos, EntityPlayer player) {
        ChunkCoordIntPair chunkcoordintpair = pos.r();
        long i2 = chunkcoordintpair.a();
        ((ObjectSet)this.g.computeIfAbsent(i2, j2 -> new ObjectOpenHashSet())).add((Object)player);
        this.l.b(i2, 0, true);
        this.k.a(TicketType.c, chunkcoordintpair, this.e(), chunkcoordintpair);
    }

    public void b(SectionPosition pos, EntityPlayer player) {
        ChunkCoordIntPair chunkcoordintpair = pos.r();
        long i2 = chunkcoordintpair.a();
        ObjectSet objectset = (ObjectSet)this.g.get(i2);
        if (objectset == null) {
            return;
        }
        if (objectset != null) {
            objectset.remove((Object)player);
        }
        if (objectset == null || objectset.isEmpty()) {
            this.g.remove(i2);
            this.l.b(i2, Integer.MAX_VALUE, false);
            this.k.b(TicketType.c, chunkcoordintpair, this.e(), chunkcoordintpair);
        }
    }

    private int e() {
        return Math.max(0, 31 - this.t);
    }

    public boolean c(long chunkPos) {
        return this.k.c(chunkPos) < 32;
    }

    public boolean d(long chunkPos) {
        return this.k.c(chunkPos) < 33;
    }

    protected String e(long pos) {
        ArraySetSorted arraysetsorted = (ArraySetSorted)this.h.get(pos);
        return arraysetsorted != null && !arraysetsorted.isEmpty() ? ((Ticket)arraysetsorted.b()).toString() : "no_ticket";
    }

    protected void a(int viewDistance) {
        this.l.a(viewDistance);
    }

    public void b(int simulationDistance) {
        if (simulationDistance != this.t) {
            this.t = simulationDistance;
            this.k.a(this.e());
        }
    }

    public int getSimulationDistance() {
        return this.t;
    }

    public int b() {
        return this.chunkMap.playerChunkTickRangeMap.size();
    }

    public boolean f(long chunkPos) {
        return this.chunkMap.playerChunkTickRangeMap.getObjectsInRange(chunkPos) != null;
    }

    public String c() {
        return this.n.a();
    }

    private void a(String path) {
        try (FileOutputStream fileoutputstream = new FileOutputStream(new File(path));){
            for (Long2ObjectMap.Entry entry : this.h.long2ObjectEntrySet()) {
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(entry.getLongKey());
                for (Ticket ticket : (ArraySetSorted)entry.getValue()) {
                    fileoutputstream.write((chunkcoordintpair.c + "\t" + chunkcoordintpair.d + "\t" + ticket.a() + "\t" + ticket.b() + "\t\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException ioexception) {
            a.error((Object)ioexception);
        }
    }

    @VisibleForTesting
    TickingTracker d() {
        return this.k;
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        Ticket<T> target = new Ticket<T>(ticketType, ticketLevel, ticketIdentifier);
        ObjectIterator iterator = this.h.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            ArraySetSorted tickets = (ArraySetSorted)entry.getValue();
            if (!tickets.remove(target)) continue;
            this.i.b(entry.getLongKey(), ChunkMapDistance.a(tickets), false);
            if (!tickets.isEmpty()) continue;
            iterator.remove();
        }
    }

    private class a
    extends ChunkMap {
        public a() {
            super(PlayerChunkMap.b + 2, 16, 256);
        }

        @Override
        protected int b(long id) {
            ArraySetSorted arraysetsorted = (ArraySetSorted)ChunkMapDistance.this.h.get(id);
            return arraysetsorted == null ? Integer.MAX_VALUE : (arraysetsorted.isEmpty() ? Integer.MAX_VALUE : ((Ticket)arraysetsorted.b()).b());
        }

        @Override
        protected int c(long id) {
            PlayerChunk playerchunk;
            if (!ChunkMapDistance.this.a(id) && (playerchunk = ChunkMapDistance.this.b(id)) != null) {
                return playerchunk.j();
            }
            return PlayerChunkMap.b + 1;
        }

        @Override
        protected void a(long id, int level) {
            int k2;
            PlayerChunk playerchunk = ChunkMapDistance.this.b(id);
            int n2 = k2 = playerchunk == null ? PlayerChunkMap.b + 1 : playerchunk.j();
            if (k2 != level && (playerchunk = ChunkMapDistance.this.a(id, level, playerchunk, k2)) != null) {
                ChunkMapDistance.this.pendingChunkUpdates.add(playerchunk);
            }
        }

        public int a(int distance) {
            return this.b(distance);
        }
    }

    private class c
    extends b {
        private int e;
        private final Long2IntMap f;
        private final LongSet g;

        protected c(int i2) {
            super(i2);
            this.e = 0;
            this.f = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.g = new LongOpenHashSet();
            this.f.defaultReturnValue(i2 + 2);
        }

        @Override
        protected void a(long pos, int oldDistance, int distance) {
            this.g.add(pos);
        }

        public void a(int watchDistance) {
            for (Long2ByteMap.Entry it_unimi_dsi_fastutil_longs_long2bytemap_entry : this.a.long2ByteEntrySet()) {
                byte b0 = it_unimi_dsi_fastutil_longs_long2bytemap_entry.getByteValue();
                long j2 = it_unimi_dsi_fastutil_longs_long2bytemap_entry.getLongKey();
                this.a(j2, b0, this.c(b0), b0 <= watchDistance - 2);
            }
            this.e = watchDistance;
        }

        private void a(long pos, int distance, boolean oldWithinViewDistance, boolean withinViewDistance) {
            if (oldWithinViewDistance != withinViewDistance) {
                Ticket<ChunkCoordIntPair> ticket = new Ticket<ChunkCoordIntPair>(TicketType.c, c, new ChunkCoordIntPair(pos));
                if (withinViewDistance) {
                    ChunkMapDistance.this.o.a(ChunkTaskQueueSorter.a(() -> ChunkMapDistance.this.r.execute(() -> {
                        if (this.c(this.c(pos))) {
                            ChunkMapDistance.this.addTicket(pos, ticket);
                            ChunkMapDistance.this.q.add(pos);
                        } else {
                            ChunkMapDistance.this.p.a(ChunkTaskQueueSorter.a(() -> {}, pos, false));
                        }
                    }), pos, () -> distance));
                } else {
                    ChunkMapDistance.this.p.a(ChunkTaskQueueSorter.a(() -> ChunkMapDistance.this.r.execute(() -> ChunkMapDistance.this.removeTicket(pos, ticket)), pos, true));
                }
            }
        }

        @Override
        public void a() {
            super.a();
            if (!this.g.isEmpty()) {
                LongIterator longiterator = this.g.iterator();
                while (longiterator.hasNext()) {
                    int k2;
                    long i2 = longiterator.nextLong();
                    int j2 = this.f.get(i2);
                    if (j2 == (k2 = this.c(i2))) continue;
                    ChunkMapDistance.this.n.onLevelChange(new ChunkCoordIntPair(i2), () -> this.f.get(i2), k2, l2 -> {
                        if (l2 >= this.f.defaultReturnValue()) {
                            this.f.remove(i2);
                        } else {
                            this.f.put(i2, l2);
                        }
                    });
                    this.a(i2, k2, this.c(j2), this.c(k2));
                }
                this.g.clear();
            }
        }

        private boolean c(int distance) {
            return distance <= this.e - 2;
        }
    }

    private class b
    extends ChunkMap {
        protected final Long2ByteMap a;
        protected final int b;

        protected b(int i2) {
            super(i2 + 2, 16, 256);
            this.a = new Long2ByteOpenHashMap();
            this.b = i2;
            this.a.defaultReturnValue((byte)(i2 + 2));
        }

        @Override
        protected int c(long id) {
            return this.a.get(id);
        }

        @Override
        protected void a(long id, int level) {
            byte b0 = level > this.b ? this.a.remove(id) : this.a.put(id, (byte)level);
            this.a(id, (int)b0, level);
        }

        protected void a(long pos, int oldDistance, int distance) {
        }

        @Override
        protected int b(long id) {
            return this.d(id) ? 0 : Integer.MAX_VALUE;
        }

        private boolean d(long chunkPos) {
            ObjectSet objectset = (ObjectSet)ChunkMapDistance.this.g.get(chunkPos);
            return objectset != null && !objectset.isEmpty();
        }

        public void a() {
            this.b(Integer.MAX_VALUE);
        }

        private void a(String path) {
            try (FileOutputStream fileoutputstream = new FileOutputStream(new File(path));){
                for (Long2ByteMap.Entry it_unimi_dsi_fastutil_longs_long2bytemap_entry : this.a.long2ByteEntrySet()) {
                    ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getLongKey());
                    String s1 = Byte.toString(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getByteValue());
                    fileoutputstream.write((chunkcoordintpair.c + "\t" + chunkcoordintpair.d + "\t" + s1 + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException ioexception) {
                a.error((Object)ioexception);
            }
        }
    }
}

