/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.BossBattle;
import net.minecraft.world.entity.player.EntityHuman;

public class CommandBossBar {
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(name -> new ChatMessage("commands.bossbar.create.failed", name));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(name -> new ChatMessage("commands.bossbar.unknown", name));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)new ChatMessage("commands.bossbar.set.players.unchanged"));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)new ChatMessage("commands.bossbar.set.name.unchanged"));
    private static final SimpleCommandExceptionType f = new SimpleCommandExceptionType((Message)new ChatMessage("commands.bossbar.set.color.unchanged"));
    private static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)new ChatMessage("commands.bossbar.set.style.unchanged"));
    private static final SimpleCommandExceptionType h = new SimpleCommandExceptionType((Message)new ChatMessage("commands.bossbar.set.value.unchanged"));
    private static final SimpleCommandExceptionType i = new SimpleCommandExceptionType((Message)new ChatMessage("commands.bossbar.set.max.unchanged"));
    private static final SimpleCommandExceptionType j = new SimpleCommandExceptionType((Message)new ChatMessage("commands.bossbar.set.visibility.unchanged.hidden"));
    private static final SimpleCommandExceptionType k = new SimpleCommandExceptionType((Message)new ChatMessage("commands.bossbar.set.visibility.unchanged.visible"));
    public static final SuggestionProvider<CommandListenerWrapper> a = (context, builder) -> ICompletionProvider.a(((CommandListenerWrapper)context.getSource()).j().aK().a(), builder);

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("bossbar").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).then(net.minecraft.commands.CommandDispatcher.a("name", ArgumentChatComponent.a()).executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.f((CommandContext<CommandListenerWrapper>)context, "id"), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context, "name"))))))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(context -> CommandBossBar.e((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context)))))).then(net.minecraft.commands.CommandDispatcher.a("list").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests(a).then(net.minecraft.commands.CommandDispatcher.a("name").then(net.minecraft.commands.CommandDispatcher.a("name", ArgumentChatComponent.a()).executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context, "name")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("color").then(net.minecraft.commands.CommandDispatcher.a("pink").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarColor.a)))).then(net.minecraft.commands.CommandDispatcher.a("blue").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarColor.b)))).then(net.minecraft.commands.CommandDispatcher.a("red").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarColor.c)))).then(net.minecraft.commands.CommandDispatcher.a("green").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarColor.d)))).then(net.minecraft.commands.CommandDispatcher.a("yellow").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarColor.e)))).then(net.minecraft.commands.CommandDispatcher.a("purple").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarColor.f)))).then(net.minecraft.commands.CommandDispatcher.a("white").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarColor.g))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("style").then(net.minecraft.commands.CommandDispatcher.a("progress").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarStyle.a)))).then(net.minecraft.commands.CommandDispatcher.a("notched_6").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarStyle.b)))).then(net.minecraft.commands.CommandDispatcher.a("notched_10").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarStyle.c)))).then(net.minecraft.commands.CommandDispatcher.a("notched_12").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarStyle.d)))).then(net.minecraft.commands.CommandDispatcher.a("notched_20").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BossBattle.BarStyle.e))))).then(net.minecraft.commands.CommandDispatcher.a("value").then(net.minecraft.commands.CommandDispatcher.a("value", IntegerArgumentType.integer((int)0)).executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(net.minecraft.commands.CommandDispatcher.a("max").then(net.minecraft.commands.CommandDispatcher.a("max", IntegerArgumentType.integer((int)1)).executes(context -> CommandBossBar.b((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), IntegerArgumentType.getInteger((CommandContext)context, (String)"max")))))).then(net.minecraft.commands.CommandDispatcher.a("visible").then(net.minecraft.commands.CommandDispatcher.a("visible", BoolArgumentType.bool()).executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), BoolArgumentType.getBool((CommandContext)context, (String)"visible")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("players").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), Collections.emptyList()))).then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.d()).executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), ArgumentEntity.d((CommandContext<CommandListenerWrapper>)context, "targets")))))))).then(net.minecraft.commands.CommandDispatcher.a("get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests(a).then(net.minecraft.commands.CommandDispatcher.a("value").executes(context -> CommandBossBar.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context))))).then(net.minecraft.commands.CommandDispatcher.a("max").executes(context -> CommandBossBar.b((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context))))).then(net.minecraft.commands.CommandDispatcher.a("visible").executes(context -> CommandBossBar.c((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context))))).then(net.minecraft.commands.CommandDispatcher.a("players").executes(context -> CommandBossBar.d((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context))))))));
    }

    private static int a(CommandListenerWrapper source, BossBattleCustom bossBar) {
        source.a(new ChatMessage("commands.bossbar.get.value", bossBar.e(), bossBar.c()), true);
        return bossBar.c();
    }

    private static int b(CommandListenerWrapper source, BossBattleCustom bossBar) {
        source.a(new ChatMessage("commands.bossbar.get.max", bossBar.e(), bossBar.d()), true);
        return bossBar.d();
    }

    private static int c(CommandListenerWrapper source, BossBattleCustom bossBar) {
        if (bossBar.g()) {
            source.a(new ChatMessage("commands.bossbar.get.visible.visible", bossBar.e()), true);
            return 1;
        }
        source.a(new ChatMessage("commands.bossbar.get.visible.hidden", bossBar.e()), true);
        return 0;
    }

    private static int d(CommandListenerWrapper source, BossBattleCustom bossBar) {
        if (bossBar.h().isEmpty()) {
            source.a(new ChatMessage("commands.bossbar.get.players.none", bossBar.e()), true);
        } else {
            source.a(new ChatMessage("commands.bossbar.get.players.some", bossBar.e(), bossBar.h().size(), ChatComponentUtils.b(bossBar.h(), EntityHuman::C_)), true);
        }
        return bossBar.h().size();
    }

    private static int a(CommandListenerWrapper source, BossBattleCustom bossBar, boolean visible) throws CommandSyntaxException {
        if (bossBar.g() == visible) {
            if (visible) {
                throw k.create();
            }
            throw j.create();
        }
        bossBar.d(visible);
        if (visible) {
            source.a(new ChatMessage("commands.bossbar.set.visible.success.visible", bossBar.e()), true);
        } else {
            source.a(new ChatMessage("commands.bossbar.set.visible.success.hidden", bossBar.e()), true);
        }
        return 0;
    }

    private static int a(CommandListenerWrapper source, BossBattleCustom bossBar, int value) throws CommandSyntaxException {
        if (bossBar.c() == value) {
            throw h.create();
        }
        bossBar.a(value);
        source.a(new ChatMessage("commands.bossbar.set.value.success", bossBar.e(), value), true);
        return value;
    }

    private static int b(CommandListenerWrapper source, BossBattleCustom bossBar, int value) throws CommandSyntaxException {
        if (bossBar.d() == value) {
            throw i.create();
        }
        bossBar.b(value);
        source.a(new ChatMessage("commands.bossbar.set.max.success", bossBar.e(), value), true);
        return value;
    }

    private static int a(CommandListenerWrapper source, BossBattleCustom bossBar, BossBattle.BarColor color) throws CommandSyntaxException {
        if (bossBar.l().equals((Object)color)) {
            throw f.create();
        }
        bossBar.a(color);
        source.a(new ChatMessage("commands.bossbar.set.color.success", bossBar.e()), true);
        return 0;
    }

    private static int a(CommandListenerWrapper source, BossBattleCustom bossBar, BossBattle.BarStyle style) throws CommandSyntaxException {
        if (bossBar.m().equals((Object)style)) {
            throw g.create();
        }
        bossBar.a(style);
        source.a(new ChatMessage("commands.bossbar.set.style.success", bossBar.e()), true);
        return 0;
    }

    private static int a(CommandListenerWrapper source, BossBattleCustom bossBar, IChatBaseComponent name) throws CommandSyntaxException {
        IChatMutableComponent component = ChatComponentUtils.a(source, name, null, 0);
        if (bossBar.j().equals(component)) {
            throw e.create();
        }
        bossBar.a(component);
        source.a(new ChatMessage("commands.bossbar.set.name.success", bossBar.e()), true);
        return 0;
    }

    private static int a(CommandListenerWrapper source, BossBattleCustom bossBar, Collection<EntityPlayer> players) throws CommandSyntaxException {
        boolean bl = bossBar.a(players);
        if (!bl) {
            throw d.create();
        }
        if (bossBar.h().isEmpty()) {
            source.a(new ChatMessage("commands.bossbar.set.players.success.none", bossBar.e()), true);
        } else {
            source.a(new ChatMessage("commands.bossbar.set.players.success.some", bossBar.e(), players.size(), ChatComponentUtils.b(players, EntityHuman::C_)), true);
        }
        return bossBar.h().size();
    }

    private static int a(CommandListenerWrapper source) {
        Collection<BossBattleCustom> collection = source.j().aK().b();
        if (collection.isEmpty()) {
            source.a(new ChatMessage("commands.bossbar.list.bars.none"), false);
        } else {
            source.a(new ChatMessage("commands.bossbar.list.bars.some", collection.size(), ChatComponentUtils.b(collection, BossBattleCustom::e)), false);
        }
        return collection.size();
    }

    private static int a(CommandListenerWrapper source, MinecraftKey name, IChatBaseComponent displayName) throws CommandSyntaxException {
        BossBattleCustomData customBossEvents = source.j().aK();
        if (customBossEvents.a(name) != null) {
            throw b.create((Object)name.toString());
        }
        BossBattleCustom customBossEvent = customBossEvents.a(name, ChatComponentUtils.a(source, displayName, null, 0));
        source.a(new ChatMessage("commands.bossbar.create.success", customBossEvent.e()), true);
        return customBossEvents.b().size();
    }

    private static int e(CommandListenerWrapper source, BossBattleCustom bossBar) {
        BossBattleCustomData customBossEvents = source.j().aK();
        bossBar.b();
        customBossEvents.a(bossBar);
        source.a(new ChatMessage("commands.bossbar.remove.success", bossBar.e()), true);
        return customBossEvents.b().size();
    }

    public static BossBattleCustom a(CommandContext<CommandListenerWrapper> context) throws CommandSyntaxException {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.f(context, "id");
        BossBattleCustom customBossEvent = ((CommandListenerWrapper)context.getSource()).j().aK().a(resourceLocation);
        if (customBossEvent == null) {
            throw c.create((Object)resourceLocation.toString());
        }
        return customBossEvent;
    }
}

