/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.destroystokyo.paper.block.TargetBlockInfo;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.scheduler.BukkitTask;
import org.spigotmc.AsyncCatcher;

public final class MCUtil {
    public static final ThreadPoolExecutor asyncExecutor = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Async Task Handler Thread - %1$d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.r)).build());
    public static final ThreadPoolExecutor cleanerExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Object Cleaner").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.r)).build());
    public static final long INVALID_CHUNK_KEY = MCUtil.getCoordinateKey(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final Executor MAIN_EXECUTOR = run -> {
        if (!MCUtil.isMainThread()) {
            MinecraftServer.getServer().execute(run);
        } else {
            run.run();
        }
    };

    public static Runnable once(Runnable run) {
        AtomicBoolean ran = new AtomicBoolean(false);
        return () -> {
            if (ran.compareAndSet(false, true)) {
                run.run();
            }
        };
    }

    public static <T> Runnable once(List<T> list, Consumer<T> cb) {
        return MCUtil.once(() -> list.forEach(cb));
    }

    private static Runnable makeCleanerCallback(Runnable run) {
        return MCUtil.once(() -> cleanerExecutor.execute(run));
    }

    public static Runnable registerCleaner(Object obj, Runnable run) {
        Runnable cleaner = MCUtil.makeCleanerCallback(run);
        CleanerHolder.CLEANER.register(obj, cleaner);
        return cleaner;
    }

    public static <T> Runnable registerListCleaner(Object obj, List<T> list, Consumer<T> cleaner) {
        return MCUtil.registerCleaner(obj, () -> {
            list.forEach(cleaner);
            list.clear();
        });
    }

    public static <T> Runnable registerCleaner(Object obj, T resource, Consumer<T> cleaner) {
        return MCUtil.registerCleaner(obj, () -> cleaner.accept(resource));
    }

    public static List<ChunkCoordIntPair> getSpiralOutChunks(BlockPosition blockposition, int radius) {
        ArrayList list = Lists.newArrayList();
        list.add(new ChunkCoordIntPair(blockposition.u() >> 4, blockposition.w() >> 4));
        for (int r2 = 1; r2 <= radius; ++r2) {
            int x2 = -r2;
            int z2 = r2;
            while (x2 <= r2 && z2 > -r2) {
                list.add(new ChunkCoordIntPair(blockposition.u() + (x2 << 4) >> 4, blockposition.w() + (z2 << 4) >> 4));
                list.add(new ChunkCoordIntPair(blockposition.u() - (x2 << 4) >> 4, blockposition.w() - (z2 << 4) >> 4));
                if (x2 < r2) {
                    ++x2;
                    continue;
                }
                --z2;
            }
        }
        return list;
    }

    public static int fastFloor(double x2) {
        int truncated = (int)x2;
        return x2 < (double)truncated ? truncated - 1 : truncated;
    }

    public static int fastFloor(float x2) {
        int truncated = (int)x2;
        return (double)x2 < (double)truncated ? truncated - 1 : truncated;
    }

    public static float normalizeYaw(float f2) {
        float f1 = f2 % 360.0f;
        if (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        if (f1 < -180.0f) {
            f1 += 360.0f;
        }
        return f1;
    }

    public static String stack() {
        return ExceptionUtils.getFullStackTrace((Throwable)new Throwable());
    }

    public static String stack(String str) {
        return ExceptionUtils.getFullStackTrace((Throwable)new Throwable(str));
    }

    public static long getCoordinateKey(BlockPosition blockPos) {
        return (long)(blockPos.w() >> 4) << 32 | (long)(blockPos.u() >> 4) & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(net.minecraft.world.entity.Entity entity) {
        return (long)(MCUtil.fastFloor(entity.di()) >> 4) << 32 | (long)(MCUtil.fastFloor(entity.dc()) >> 4) & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(ChunkCoordIntPair pair) {
        return (long)pair.d << 32 | (long)pair.c & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(int x2, int z2) {
        return (long)z2 << 32 | (long)x2 & 0xFFFFFFFFL;
    }

    public static int getCoordinateX(long key) {
        return (int)key;
    }

    public static int getCoordinateZ(long key) {
        return (int)(key >>> 32);
    }

    public static int getChunkCoordinate(double coordinate) {
        return MCUtil.fastFloor(coordinate) >> 4;
    }

    public static int getBlockCoordinate(double coordinate) {
        return MCUtil.fastFloor(coordinate);
    }

    public static long getBlockKey(int x2, int y2, int z2) {
        return (long)x2 & 0x7FFFFFFL | ((long)z2 & 0x7FFFFFFL) << 27 | (long)y2 << 54;
    }

    public static long getBlockKey(BlockPosition pos) {
        return (long)pos.u() & 0x7FFFFFFL | ((long)pos.w() & 0x7FFFFFFL) << 27 | (long)pos.v() << 54;
    }

    public static long getBlockKey(net.minecraft.world.entity.Entity entity) {
        return MCUtil.getBlockKey(MCUtil.getBlockCoordinate(entity.dc()), MCUtil.getBlockCoordinate(entity.de()), MCUtil.getBlockCoordinate(entity.di()));
    }

    public static <T> void mergeSortedSets(Consumer<T> consumer, Comparator<? super T> comparator, SortedSet<T> ... sets) {
        ObjectRBTreeSet all = new ObjectRBTreeSet(comparator);
        for (SortedSet<T> set : sets) {
            if (set == null) continue;
            all.addAll(set);
        }
        all.forEach(consumer);
    }

    private MCUtil() {
    }

    public static <T> CompletableFuture<T> ensureMain(CompletableFuture<T> future) {
        return future.thenApplyAsync(r2 -> r2, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, Consumer<T> consumer) {
        future.thenAcceptAsync((Consumer)consumer, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, BiConsumer<T, Throwable> consumer) {
        future.whenCompleteAsync((BiConsumer)consumer, MAIN_EXECUTOR);
    }

    public static boolean isMainThread() {
        return MinecraftServer.getServer().bl();
    }

    public static BukkitTask scheduleTask(int ticks, Runnable runnable) {
        return MCUtil.scheduleTask(ticks, runnable, null);
    }

    public static BukkitTask scheduleTask(int ticks, Runnable runnable, String taskName) {
        return MinecraftServer.getServer().server.getScheduler().scheduleInternalTask(runnable, ticks, taskName);
    }

    public static void processQueue() {
        Runnable runnable;
        Queue<Runnable> processQueue = MCUtil.getProcessQueue();
        while ((runnable = processQueue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Exception e2) {
                MinecraftServer.r.error("Error executing task", (Throwable)e2);
            }
        }
    }

    public static <T> T processQueueWhileWaiting(CompletableFuture<T> future) {
        try {
            if (MCUtil.isMainThread()) {
                while (!future.isDone()) {
                    try {
                        return future.get(1L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException ignored) {
                        MCUtil.processQueue();
                    }
                }
            }
            return future.get();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void ensureMain(Runnable run) {
        MCUtil.ensureMain(null, run);
    }

    public static void ensureMain(String reason, Runnable run) {
        if (AsyncCatcher.enabled && Thread.currentThread() != MinecraftServer.getServer().an) {
            if (reason != null) {
                new IllegalStateException("Asynchronous " + reason + "!").printStackTrace();
            }
            MCUtil.getProcessQueue().add(run);
            return;
        }
        run.run();
    }

    private static Queue<Runnable> getProcessQueue() {
        return MinecraftServer.getServer().processQueue;
    }

    public static <T> T ensureMain(Supplier<T> run) {
        return MCUtil.ensureMain(null, run);
    }

    public static <T> T ensureMain(String reason, final Supplier<T> run) {
        if (AsyncCatcher.enabled && Thread.currentThread() != MinecraftServer.getServer().an) {
            if (reason != null) {
                new IllegalStateException("Asynchronous " + reason + "! Blocking thread until it returns ").printStackTrace();
            }
            Waitable wait = new Waitable<T>(){

                @Override
                protected T evaluate() {
                    return run.get();
                }
            };
            MCUtil.getProcessQueue().add(wait);
            try {
                return wait.get();
            }
            catch (InterruptedException | ExecutionException e2) {
                e2.printStackTrace();
                return null;
            }
        }
        return run.get();
    }

    public static PlayerProfile toBukkit(GameProfile profile) {
        return CraftPlayerProfile.asBukkitMirror(profile);
    }

    public static double distance(net.minecraft.world.entity.Entity e1, net.minecraft.world.entity.Entity e2) {
        return Math.sqrt(MCUtil.distanceSq(e1, e2));
    }

    public static double distance(BlockPosition e1, BlockPosition e2) {
        return Math.sqrt(MCUtil.distanceSq(e1, e2));
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(MCUtil.distanceSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distanceSq(net.minecraft.world.entity.Entity e1, net.minecraft.world.entity.Entity e2) {
        return MCUtil.distanceSq(e1.dc(), e1.de(), e1.di(), e2.dc(), e2.de(), e2.di());
    }

    public static double distanceSq(BlockPosition pos1, BlockPosition pos2) {
        return MCUtil.distanceSq(pos1.u(), pos1.v(), pos1.w(), pos2.u(), pos2.v(), pos2.w());
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
    }

    public static Location toLocation(World world, double x2, double y2, double z2) {
        return new Location((org.bukkit.World)world.getWorld(), x2, y2, z2);
    }

    public static Location toLocation(World world, BlockPosition pos) {
        return new Location((org.bukkit.World)world.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w());
    }

    public static Location toLocation(net.minecraft.world.entity.Entity entity) {
        return new Location((org.bukkit.World)entity.cA().getWorld(), entity.dc(), entity.de(), entity.di());
    }

    public static Block toBukkitBlock(World world, BlockPosition pos) {
        return world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
    }

    public static BlockPosition toBlockPosition(Location loc) {
        return new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static boolean isEdgeOfChunk(BlockPosition pos) {
        int modX = pos.u() & 0xF;
        int modZ = pos.w() & 0xF;
        return modX == 0 || modX == 15 || modZ == 0 || modZ == 15;
    }

    public static void scheduleAsyncTask(Runnable run) {
        asyncExecutor.execute(run);
    }

    @Nonnull
    public static WorldServer getNMSWorld(@Nonnull org.bukkit.World world) {
        return ((CraftWorld)world).getHandle();
    }

    public static WorldServer getNMSWorld(@Nonnull Entity entity) {
        return MCUtil.getNMSWorld(entity.getWorld());
    }

    public static RayTrace.FluidCollisionOption getNMSFluidCollisionOption(TargetBlockInfo.FluidMode fluidMode) {
        switch (fluidMode) {
            case NEVER: {
                return RayTrace.FluidCollisionOption.a;
            }
            case SOURCE_ONLY: {
                return RayTrace.FluidCollisionOption.b;
            }
            case ALWAYS: {
                return RayTrace.FluidCollisionOption.c;
            }
        }
        return null;
    }

    public static BlockFace toBukkitBlockFace(EnumDirection enumDirection) {
        switch (enumDirection) {
            case a: {
                return BlockFace.DOWN;
            }
            case b: {
                return BlockFace.UP;
            }
            case c: {
                return BlockFace.NORTH;
            }
            case d: {
                return BlockFace.SOUTH;
            }
            case e: {
                return BlockFace.WEST;
            }
            case f: {
                return BlockFace.EAST;
            }
        }
        return null;
    }

    @Nullable
    public static IChatBaseComponent getBaseComponentFromNbt(String key, NBTTagCompound compound) {
        if (!compound.e(key)) {
            return null;
        }
        String string = compound.l(key);
        try {
            return IChatBaseComponent.ChatSerializer.a(string);
        }
        catch (JsonParseException e2) {
            Bukkit.getLogger().warning("Unable to parse " + key + " from " + compound + ": " + e2.getMessage());
            return null;
        }
    }

    public static ChunkStatus getChunkStatus(PlayerChunk chunk) {
        List<ChunkStatus> statuses = ChunkProviderServer.c;
        for (int i2 = statuses.size() - 1; i2 >= 0; --i2) {
            ChunkStatus curr = statuses.get(i2);
            CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> future = chunk.a(curr);
            if (future == PlayerChunk.b) continue;
            return curr;
        }
        return null;
    }

    public static void dumpChunks(File file) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
        List worlds = Bukkit.getWorlds();
        JsonObject data = new JsonObject();
        data.addProperty("server-version", Bukkit.getVersion());
        data.addProperty("data-version", (Number)0);
        JsonArray worldsData = new JsonArray();
        for (org.bukkit.World bukkitWorld : worlds) {
            Object chunk2;
            JsonObject worldData = new JsonObject();
            WorldServer world = ((CraftWorld)bukkitWorld).getHandle();
            PlayerChunkMap chunkMap = world.k().a;
            Long2ObjectLinkedOpenHashMap<PlayerChunk> visibleChunks = chunkMap.updatingChunks.getVisibleMap();
            PlayerChunkMap.ChunkDistanceManager chunkMapDistance = chunkMap.D;
            ArrayList allChunks = new ArrayList(visibleChunks.values());
            List<EntityPlayer> players = world.K;
            int fullLoadedChunks = 0;
            for (Object chunk2 : allChunks) {
                if (((PlayerChunk)chunk2).getFullChunkUnchecked() == null) continue;
                ++fullLoadedChunks;
            }
            allChunks.sort((v1, v2) -> {
                if (v1.r.c != v2.r.c) {
                    return Integer.compare(v1.r.c, v2.r.c);
                }
                return Integer.compare(v1.r.d, v2.r.d);
            });
            worldData.addProperty("name", world.getWorld().getName());
            worldData.addProperty("view-distance", (Number)world.spigotConfig.viewDistance);
            worldData.addProperty("keep-spawn-loaded", Boolean.valueOf(world.keepSpawnInMemory));
            worldData.addProperty("keep-spawn-loaded-range", (Number)world.paperConfig.keepLoadedRange);
            worldData.addProperty("visible-chunk-count", (Number)visibleChunks.size());
            worldData.addProperty("loaded-chunk-count", (Number)chunkMap.p.size());
            worldData.addProperty("verified-fully-loaded-chunks", (Number)fullLoadedChunks);
            JsonArray playersData = new JsonArray();
            chunk2 = players.iterator();
            while (chunk2.hasNext()) {
                EntityPlayer player = (EntityPlayer)chunk2.next();
                JsonObject playerData = new JsonObject();
                playerData.addProperty("name", player.co());
                playerData.addProperty("x", (Number)player.dc());
                playerData.addProperty("y", (Number)player.de());
                playerData.addProperty("z", (Number)player.di());
                playersData.add((JsonElement)playerData);
            }
            worldData.add("players", (JsonElement)playersData);
            JsonArray chunksData = new JsonArray();
            for (PlayerChunk playerChunk : allChunks) {
                JsonObject chunkData = new JsonObject();
                Set tickets = (Set)chunkMapDistance.h.get(playerChunk.r.longKey);
                ChunkStatus status = MCUtil.getChunkStatus(playerChunk);
                chunkData.addProperty("x", (Number)playerChunk.r.c);
                chunkData.addProperty("z", (Number)playerChunk.r.d);
                chunkData.addProperty("ticket-level", (Number)playerChunk.j());
                chunkData.addProperty("priority", (Number)playerChunk.q);
                chunkData.addProperty("state", PlayerChunk.c(playerChunk.j()).toString());
                chunkData.addProperty("queued-for-unload", Boolean.valueOf(chunkMap.w.contains(playerChunk.r.longKey)));
                chunkData.addProperty("status", status == null ? "unloaded" : status.toString());
                JsonArray ticketsData = new JsonArray();
                if (tickets != null) {
                    for (Ticket ticket : tickets) {
                        JsonObject ticketData = new JsonObject();
                        ticketData.addProperty("ticket-type", ticket.a().toString());
                        ticketData.addProperty("ticket-level", (Number)ticket.b());
                        ticketData.addProperty("object-reason", String.valueOf(ticket.c));
                        ticketData.addProperty("add-tick", (Number)ticket.d);
                        ticketsData.add((JsonElement)ticketData);
                    }
                }
                chunkData.add("tickets", (JsonElement)ticketsData);
                chunksData.add((JsonElement)chunkData);
            }
            worldData.add("chunk-data", (JsonElement)chunksData);
            worldsData.add((JsonElement)worldData);
        }
        data.add("worlds", (JsonElement)worldsData);
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.setIndent(" ");
        jsonWriter.setLenient(false);
        Streams.write((JsonElement)data, (JsonWriter)jsonWriter);
        String fileData = stringWriter.toString();
        try (PrintStream out = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");){
            out.print(fileData);
        }
    }

    public static int getTicketLevelFor(ChunkStatus status) {
        return 33 + ChunkStatus.a(status);
    }

    private static final class CleanerHolder {
        private static final Cleaner CLEANER = Cleaner.create();

        private CleanerHolder() {
        }
    }
}

