/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICommandListener;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.Tags;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomFunctionManager
implements IReloadListener {
    private static final Logger a = LogManager.getLogger();
    private static final String b = ".mcfunction";
    private static final int c = "functions/".length();
    private static final int d = ".mcfunction".length();
    private volatile Map<MinecraftKey, CustomFunction> e = ImmutableMap.of();
    private final TagDataPack<CustomFunction> f = new TagDataPack(this::a, "tags/functions");
    private volatile Tags<CustomFunction> g = Tags.c();
    private final int h;
    private final CommandDispatcher<CommandListenerWrapper> i;

    public Optional<CustomFunction> a(MinecraftKey id) {
        return Optional.ofNullable(this.e.get(id));
    }

    public Map<MinecraftKey, CustomFunction> a() {
        return this.e;
    }

    public Tags<CustomFunction> b() {
        return this.g;
    }

    public Tag<CustomFunction> b(MinecraftKey id) {
        return this.g.b(id);
    }

    public CustomFunctionManager(int level, CommandDispatcher<CommandListenerWrapper> commandDispatcher) {
        this.h = level;
        this.i = commandDispatcher;
    }

    @Override
    @Override
    public CompletableFuture<Void> a(IReloadListener.a synchronizer, IResourceManager manager, GameProfilerFiller prepareProfiler, GameProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        CompletableFuture<Map> completableFuture = CompletableFuture.supplyAsync(() -> this.f.a(manager), prepareExecutor);
        CompletionStage completableFuture2 = CompletableFuture.supplyAsync(() -> manager.a("functions", path -> path.endsWith(b)), prepareExecutor).thenCompose(ids -> {
            HashMap map = Maps.newHashMap();
            CommandListenerWrapper commandSourceStack = new CommandListenerWrapper(ICommandListener.a, Vec3D.a, Vec2F.a, null, this.h, "", ChatComponentText.d, null, null);
            for (MinecraftKey resourceLocation : ids) {
                String string = resourceLocation.a();
                MinecraftKey resourceLocation2 = new MinecraftKey(resourceLocation.b(), string.substring(c, string.length() - d));
                map.put(resourceLocation2, CompletableFuture.supplyAsync(() -> {
                    List<String> list = CustomFunctionManager.a(manager, resourceLocation);
                    return CustomFunction.a(resourceLocation2, this.i, commandSourceStack, list);
                }, prepareExecutor));
            }
            CompletableFuture[] completableFutures = map.values().toArray(new CompletableFuture[0]);
            return CompletableFuture.allOf(completableFutures).handle((unused, ex) -> map);
        });
        return ((CompletableFuture)((CompletableFuture)completableFuture.thenCombine(completableFuture2, Pair::of)).thenCompose(synchronizer::a)).thenAcceptAsync(intermediate -> {
            Map map = (Map)intermediate.getSecond();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            map.forEach((id, functionFuture) -> ((CompletableFuture)functionFuture.handle((function, ex) -> {
                if (ex != null) {
                    a.error("Failed to load function {}", id, ex);
                } else {
                    builder.put(id, function);
                }
                return null;
            })).join());
            this.e = builder.build();
            this.g = this.f.a((Map)intermediate.getFirst());
        }, applyExecutor);
    }

    private static List<String> a(IResourceManager resourceManager, MinecraftKey id) {
        List list;
        block8: {
            IResource resource = resourceManager.a(id);
            try {
                list = IOUtils.readLines((InputStream)resource.b(), (Charset)StandardCharsets.UTF_8);
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new CompletionException(iOException);
                }
            }
            resource.close();
        }
        return list;
    }
}

