/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.EnumGamemode;

public class PacketPlayOutPlayerInfo
implements Packet<PacketListenerPlayOut> {
    private final EnumPlayerInfoAction a;
    private final List<PlayerInfoData> b;

    public PacketPlayOutPlayerInfo(EnumPlayerInfoAction action, EntityPlayer ... players) {
        this.a = action;
        this.b = Lists.newArrayListWithCapacity((int)players.length);
        for (EntityPlayer serverPlayer : players) {
            this.b.add(new PlayerInfoData(serverPlayer.fp(), serverPlayer.e, serverPlayer.d.b(), serverPlayer.J()));
        }
    }

    public PacketPlayOutPlayerInfo(EnumPlayerInfoAction action, Collection<EntityPlayer> players) {
        this.a = action;
        this.b = Lists.newArrayListWithCapacity((int)players.size());
        for (EntityPlayer serverPlayer : players) {
            this.b.add(new PlayerInfoData(serverPlayer.fp(), serverPlayer.e, serverPlayer.d.b(), serverPlayer.J()));
        }
    }

    public PacketPlayOutPlayerInfo(PacketDataSerializer buf) {
        this.a = buf.a(EnumPlayerInfoAction.class);
        this.b = buf.a(this.a::a);
    }

    @Override
    @Override
    public void a(PacketDataSerializer buf) {
        buf.a(this.a);
        buf.a(this.b, this.a::a);
    }

    @Override
    @Override
    public void a(PacketListenerPlayOut listener) {
        listener.a(this);
    }

    public List<PlayerInfoData> b() {
        return this.b;
    }

    public EnumPlayerInfoAction c() {
        return this.a;
    }

    @Nullable
    static IChatBaseComponent b(PacketDataSerializer buf) {
        return buf.readBoolean() ? buf.i() : null;
    }

    static void a(PacketDataSerializer buf, @Nullable IChatBaseComponent text) {
        if (text == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.a(text);
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.a).add("entries", this.b).toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class EnumPlayerInfoAction
    extends Enum<EnumPlayerInfoAction> {
        public static final /* enum */ EnumPlayerInfoAction a = new EnumPlayerInfoAction(){

            @Override
            @Override
            protected PlayerInfoData a(PacketDataSerializer buf2) {
                GameProfile gameProfile = new GameProfile(buf2.l(), buf2.e(16));
                PropertyMap propertyMap = gameProfile.getProperties();
                buf2.a((PacketDataSerializer buf) -> {
                    String string = buf.p();
                    String string2 = buf.p();
                    if (buf.readBoolean()) {
                        String string3 = buf.p();
                        propertyMap.put((Object)string, (Object)new Property(string, string2, string3));
                    } else {
                        propertyMap.put((Object)string, (Object)new Property(string, string2));
                    }
                });
                EnumGamemode gameType = EnumGamemode.a(buf2.j());
                int i2 = buf2.j();
                IChatBaseComponent component = PacketPlayOutPlayerInfo.b(buf2);
                return new PlayerInfoData(gameProfile, i2, gameType, component);
            }

            @Override
            @Override
            protected void a(PacketDataSerializer buf2, PlayerInfoData entry) {
                buf2.a(entry.a().getId());
                buf2.a(entry.a().getName());
                buf2.a(entry.a().getProperties().values(), (PacketDataSerializer buf, T property) -> {
                    buf.a(property.getName());
                    buf.a(property.getValue());
                    if (property.hasSignature()) {
                        buf.writeBoolean(true);
                        buf.a(property.getSignature());
                    } else {
                        buf.writeBoolean(false);
                    }
                });
                buf2.d(entry.c().a());
                buf2.d(entry.b());
                PacketPlayOutPlayerInfo.a(buf2, entry.d());
            }
        };
        public static final /* enum */ EnumPlayerInfoAction b = new EnumPlayerInfoAction(){

            @Override
            @Override
            protected PlayerInfoData a(PacketDataSerializer buf) {
                GameProfile gameProfile = new GameProfile(buf.l(), null);
                EnumGamemode gameType = EnumGamemode.a(buf.j());
                return new PlayerInfoData(gameProfile, 0, gameType, null);
            }

            @Override
            @Override
            protected void a(PacketDataSerializer buf, PlayerInfoData entry) {
                buf.a(entry.a().getId());
                buf.d(entry.c().a());
            }
        };
        public static final /* enum */ EnumPlayerInfoAction c = new EnumPlayerInfoAction(){

            @Override
            @Override
            protected PlayerInfoData a(PacketDataSerializer buf) {
                GameProfile gameProfile = new GameProfile(buf.l(), null);
                int i2 = buf.j();
                return new PlayerInfoData(gameProfile, i2, null, null);
            }

            @Override
            @Override
            protected void a(PacketDataSerializer buf, PlayerInfoData entry) {
                buf.a(entry.a().getId());
                buf.d(entry.b());
            }
        };
        public static final /* enum */ EnumPlayerInfoAction d = new EnumPlayerInfoAction(){

            @Override
            @Override
            protected PlayerInfoData a(PacketDataSerializer buf) {
                GameProfile gameProfile = new GameProfile(buf.l(), null);
                IChatBaseComponent component = PacketPlayOutPlayerInfo.b(buf);
                return new PlayerInfoData(gameProfile, 0, null, component);
            }

            @Override
            @Override
            protected void a(PacketDataSerializer buf, PlayerInfoData entry) {
                buf.a(entry.a().getId());
                PacketPlayOutPlayerInfo.a(buf, entry.d());
            }
        };
        public static final /* enum */ EnumPlayerInfoAction e = new EnumPlayerInfoAction(){

            @Override
            @Override
            protected PlayerInfoData a(PacketDataSerializer buf) {
                GameProfile gameProfile = new GameProfile(buf.l(), null);
                return new PlayerInfoData(gameProfile, 0, null, null);
            }

            @Override
            @Override
            protected void a(PacketDataSerializer buf, PlayerInfoData entry) {
                buf.a(entry.a().getId());
            }
        };
        private static final /* synthetic */ EnumPlayerInfoAction[] f;

        public static EnumPlayerInfoAction[] values() {
            return (EnumPlayerInfoAction[])f.clone();
        }

        public static EnumPlayerInfoAction valueOf(String string) {
            return Enum.valueOf(EnumPlayerInfoAction.class, string);
        }

        protected abstract PlayerInfoData a(PacketDataSerializer var1);

        protected abstract void a(PacketDataSerializer var1, PlayerInfoData var2);

        private static /* synthetic */ EnumPlayerInfoAction[] a() {
            return new EnumPlayerInfoAction[]{a, b, c, d, e};
        }

        static {
            f = EnumPlayerInfoAction.a();
        }
    }

    public static class PlayerInfoData {
        private final int a;
        private final EnumGamemode b;
        private final GameProfile c;
        @Nullable
        private final IChatBaseComponent d;

        public PlayerInfoData(GameProfile profile, int latency, @Nullable EnumGamemode gameMode, @Nullable IChatBaseComponent displayName) {
            this.c = profile;
            this.a = latency;
            this.b = gameMode;
            this.d = displayName;
        }

        public GameProfile a() {
            return this.c;
        }

        public int b() {
            return this.a;
        }

        public EnumGamemode c() {
            return this.b;
        }

        @Nullable
        public IChatBaseComponent d() {
            return this.d;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("latency", this.a).add("gameMode", (Object)this.b).add("profile", (Object)this.c).add("displayName", this.d == null ? null : IChatBaseComponent.ChatSerializer.a(this.d)).toString();
        }
    }
}

