/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatBaseComponent;
import net.minecraft.network.chat.ChatComponentContextual;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatMessageException;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.entity.Entity;

public class ChatMessage
extends ChatBaseComponent
implements ChatComponentContextual {
    private static final Object[] d = new Object[0];
    private static final IChatFormatted e = IChatFormatted.b("%");
    private static final IChatFormatted f = IChatFormatted.b("null");
    private final String g;
    private final Object[] h;
    @Nullable
    private LocaleLanguage i;
    private List<IChatFormatted> j = ImmutableList.of();
    private static final Pattern k = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public ChatMessage(String key) {
        this.g = key;
        this.h = d;
    }

    public ChatMessage(String key, Object ... args) {
        this.g = key;
        this.h = args;
    }

    private void k() {
        LocaleLanguage language = LocaleLanguage.a();
        if (language == this.i) {
            return;
        }
        this.i = language;
        String string = language.a(this.g);
        try {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.a(string, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.j = builder.build();
        }
        catch (ChatMessageException translatableFormatException) {
            this.j = ImmutableList.of((Object)IChatFormatted.b(string));
        }
    }

    private void a(String translation, Consumer<IChatFormatted> partsConsumer) {
        Matcher matcher = k.matcher(translation);
        try {
            int i2 = 0;
            int j2 = 0;
            while (matcher.find(j2)) {
                int k2 = matcher.start();
                int l2 = matcher.end();
                if (k2 > j2) {
                    String string = translation.substring(j2, k2);
                    if (string.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    partsConsumer.accept(IChatFormatted.b(string));
                }
                String string2 = matcher.group(2);
                String string3 = translation.substring(k2, l2);
                if ("%".equals(string2) && "%%".equals(string3)) {
                    partsConsumer.accept(e);
                } else if ("s".equals(string2)) {
                    int m2;
                    String string4 = matcher.group(1);
                    int n2 = m2 = string4 != null ? Integer.parseInt(string4) - 1 : i2++;
                    if (m2 < this.h.length) {
                        partsConsumer.accept(this.b(m2));
                    }
                } else {
                    throw new ChatMessageException(this, "Unsupported format: '" + string3 + "'");
                }
                j2 = l2;
            }
            if (j2 < translation.length()) {
                String string5 = translation.substring(j2);
                if (string5.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                partsConsumer.accept(IChatFormatted.b(string5));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ChatMessageException(this, (Throwable)illegalArgumentException);
        }
    }

    private IChatFormatted b(int index) {
        if (index >= this.h.length) {
            throw new ChatMessageException(this, index);
        }
        Object object = this.h[index];
        if (object instanceof IChatBaseComponent) {
            return (IChatBaseComponent)object;
        }
        return object == null ? f : IChatFormatted.b(object.toString());
    }

    @Override
    public ChatMessage h() {
        return new ChatMessage(this.g, this.h);
    }

    @Override
    @Override
    public <T> Optional<T> b(IChatFormatted.b<T> visitor, ChatModifier style) {
        this.k();
        for (IChatFormatted formattedText : this.j) {
            Optional<T> optional = formattedText.a(visitor, style);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    @Override
    public <T> Optional<T> b(IChatFormatted.a<T> visitor) {
        this.k();
        for (IChatFormatted formattedText : this.j) {
            Optional<T> optional = formattedText.a(visitor);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        Object[] objects = new Object[this.h.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            Object object = this.h[i2];
            objects[i2] = object instanceof IChatBaseComponent ? ChatComponentUtils.a(source, (IChatBaseComponent)object, sender, depth) : object;
        }
        return new ChatMessage(this.g, objects);
    }

    @Override
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChatMessage) {
            ChatMessage translatableComponent = (ChatMessage)object;
            return Arrays.equals(this.h, translatableComponent.h) && this.g.equals(translatableComponent.g) && super.equals(object);
        }
        return false;
    }

    @Override
    @Override
    public int hashCode() {
        int i2 = super.hashCode();
        i2 = 31 * i2 + this.g.hashCode();
        i2 = 31 * i2 + Arrays.hashCode(this.h);
        return i2;
    }

    @Override
    @Override
    public String toString() {
        return "TranslatableComponent{key='" + this.g + "', args=" + Arrays.toString(this.h) + ", siblings=" + this.a + ", style=" + this.c() + "}";
    }

    public String i() {
        return this.g;
    }

    public Object[] j() {
        return this.h;
    }

    @Override
    public /* synthetic */ ChatBaseComponent d() {
        return this.h();
    }

    @Override
    public /* synthetic */ IChatMutableComponent g() {
        return this.h();
    }
}

