/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagList
extends NBTList<NBTBase> {
    private static final int b = 296;
    public static final NBTTagType<NBTTagList> a = new NBTTagType.b<NBTTagList>(){

        public NBTTagList a(DataInput dataInput, int i2, NBTReadLimiter nbtAccounter) throws IOException {
            nbtAccounter.a(296L);
            if (i2 > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            byte b2 = dataInput.readByte();
            int j2 = dataInput.readInt();
            if (b2 == 0 && j2 > 0) {
                throw new RuntimeException("Missing type on ListTag");
            }
            nbtAccounter.a(32L * (long)j2);
            NBTTagType<?> tagType = NBTTagTypes.a(b2);
            ArrayList list = Lists.newArrayListWithCapacity((int)j2);
            for (int k2 = 0; k2 < j2; ++k2) {
                list.add(tagType.b(dataInput, i2 + 1, nbtAccounter));
            }
            return new NBTTagList(list, b2);
        }

        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor) throws IOException {
            NBTTagType<?> tagType = NBTTagTypes.a(input.readByte());
            int i2 = input.readInt();
            switch (visitor.a(tagType, i2)) {
                case c: {
                    return StreamTagVisitor.b.c;
                }
                case b: {
                    tagType.a(input, i2);
                    return visitor.b();
                }
            }
            int j2 = 0;
            while (true) {
                block16: {
                    int k2;
                    block15: {
                        if (j2 >= i2) break block15;
                        block4 : switch (visitor.b(tagType, j2)) {
                            case d: {
                                return StreamTagVisitor.b.c;
                            }
                            case c: {
                                tagType.a(input);
                                break;
                            }
                            case b: {
                                tagType.a(input);
                                break block16;
                            }
                            default: {
                                switch (tagType.a(input, visitor)) {
                                    case c: {
                                        return StreamTagVisitor.b.c;
                                    }
                                    case b: {
                                        break block4;
                                    }
                                }
                                break block16;
                            }
                        }
                    }
                    if ((k2 = i2 - 1 - j2) > 0) {
                        tagType.a(input, k2);
                    }
                    return visitor.b();
                }
                ++j2;
            }
        }

        @Override
        public void a(DataInput input) throws IOException {
            NBTTagType<?> tagType = NBTTagTypes.a(input.readByte());
            int i2 = input.readInt();
            tagType.a(input, i2);
        }

        @Override
        public String a() {
            return "LIST";
        }

        @Override
        public String b() {
            return "TAG_List";
        }
    };
    private static final ByteSet INLINE_ELEMENT_TYPES = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private final List<NBTBase> c;
    private byte w;

    NBTTagList(List<NBTBase> list, byte type) {
        this.c = list;
        this.w = type;
    }

    public NBTTagList() {
        this(Lists.newArrayList(), 0);
    }

    @Override
    public void a(DataOutput output) throws IOException {
        this.w = this.c.isEmpty() ? (byte)0 : this.c.get(0).a();
        output.writeByte(this.w);
        output.writeInt(this.c.size());
        for (NBTBase tag : this.c) {
            tag.a(output);
        }
    }

    @Override
    public byte a() {
        return 9;
    }

    public NBTTagType<NBTTagList> b() {
        return a;
    }

    @Override
    public String toString() {
        return this.e_();
    }

    private void f() {
        if (this.c.isEmpty()) {
            this.w = 0;
        }
    }

    @Override
    public NBTBase c(int i2) {
        NBTBase tag = this.c.remove(i2);
        this.f();
        return tag;
    }

    @Override
    public boolean isEmpty() {
        return this.c.isEmpty();
    }

    public NBTTagCompound a(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).a() == 10) {
            return (NBTTagCompound)tag;
        }
        return new NBTTagCompound();
    }

    public NBTTagList b(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).a() == 9) {
            return (NBTTagList)tag;
        }
        return new NBTTagList();
    }

    public short d(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).a() == 2) {
            return ((NBTTagShort)tag).g();
        }
        return 0;
    }

    public int e(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).a() == 3) {
            return ((NBTTagInt)tag).f();
        }
        return 0;
    }

    public int[] f(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).a() == 11) {
            return ((NBTTagIntArray)tag).f();
        }
        return new int[0];
    }

    public long[] g(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).a() == 11) {
            return ((NBTTagLongArray)tag).f();
        }
        return new long[0];
    }

    public double h(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).a() == 6) {
            return ((NBTTagDouble)tag).i();
        }
        return 0.0;
    }

    public float i(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).a() == 5) {
            return ((NBTTagFloat)tag).j();
        }
        return 0.0f;
    }

    public String j(int index) {
        if (index >= 0 && index < this.c.size()) {
            NBTBase tag = this.c.get(index);
            return tag.a() == 8 ? tag.e_() : tag.toString();
        }
        return "";
    }

    @Override
    public int size() {
        return this.c.size();
    }

    public NBTBase k(int i2) {
        return this.c.get(i2);
    }

    @Override
    public NBTBase d(int i2, NBTBase tag) {
        NBTBase tag2 = this.k(i2);
        if (!this.a(i2, tag)) {
            throw new UnsupportedOperationException(String.format("Trying to add tag of type %d to list of %d", tag.a(), this.w));
        }
        return tag2;
    }

    @Override
    public void c(int i2, NBTBase tag) {
        if (!this.b(i2, tag)) {
            throw new UnsupportedOperationException(String.format("Trying to add tag of type %d to list of %d", tag.a(), this.w));
        }
    }

    @Override
    public boolean a(int index, NBTBase element) {
        if (this.a(element)) {
            this.c.set(index, element);
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int index, NBTBase element) {
        if (this.a(element)) {
            this.c.add(index, element);
            return true;
        }
        return false;
    }

    private boolean a(NBTBase element) {
        if (element.a() == 0) {
            return false;
        }
        if (this.w == 0) {
            this.w = element.a();
            return true;
        }
        return this.w == element.a();
    }

    public NBTTagList d() {
        List<NBTBase> iterable = NBTTagTypes.a(this.w).d() ? this.c : Iterables.transform(this.c, NBTBase::c);
        ArrayList list = Lists.newArrayList(iterable);
        return new NBTTagList(list, this.w);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof NBTTagList && Objects.equals(this.c, ((NBTTagList)object).c);
    }

    @Override
    public int hashCode() {
        return this.c.hashCode();
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    @Override
    public byte e() {
        return this.w;
    }

    @Override
    public void clear() {
        this.c.clear();
        this.w = 0;
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        switch (visitor.a(NBTTagTypes.a(this.w), this.c.size())) {
            case c: {
                return StreamTagVisitor.b.c;
            }
            case b: {
                return visitor.b();
            }
        }
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            NBTBase tag = this.c.get(i2);
            switch (visitor.b(tag.b(), i2)) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return visitor.b();
                }
                default: {
                    switch (tag.a(visitor)) {
                        case c: {
                            return StreamTagVisitor.b.c;
                        }
                        case b: {
                            return visitor.b();
                        }
                    }
                }
                case b: 
            }
        }
        return visitor.b();
    }
}

