/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.MathHelper;

public class NBTTagFloat
extends NBTNumber {
    private static final int c = 96;
    public static final NBTTagFloat a = new NBTTagFloat(0.0f);
    public static final NBTTagType<NBTTagFloat> b = new NBTTagType.a<NBTTagFloat>(){

        @Override
        public NBTTagFloat a(DataInput dataInput, int i2, NBTReadLimiter nbtAccounter) throws IOException {
            nbtAccounter.a(96L);
            return NBTTagFloat.a(dataInput.readFloat());
        }

        @Override
        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor) throws IOException {
            return visitor.a(input.readFloat());
        }

        @Override
        @Override
        public int c() {
            return 4;
        }

        @Override
        @Override
        public String a() {
            return "FLOAT";
        }

        @Override
        @Override
        public String b() {
            return "TAG_Float";
        }

        @Override
        @Override
        public boolean d() {
            return true;
        }

        @Override
        public /* synthetic */ NBTBase b(DataInput input, int depth, NBTReadLimiter tracker) throws IOException {
            return this.a(input, depth, tracker);
        }
    };
    private final float w;

    private NBTTagFloat(float value) {
        this.w = value;
    }

    public static NBTTagFloat a(float value) {
        if (value == 0.0f) {
            return a;
        }
        return new NBTTagFloat(value);
    }

    @Override
    @Override
    public void a(DataOutput output) throws IOException {
        output.writeFloat(this.w);
    }

    @Override
    @Override
    public byte a() {
        return 5;
    }

    @Override
    public NBTTagType<NBTTagFloat> b() {
        return b;
    }

    @Override
    public NBTTagFloat d() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof NBTTagFloat && this.w == ((NBTTagFloat)object).w;
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.w);
    }

    @Override
    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    @Override
    @Override
    public long e() {
        return (long)this.w;
    }

    @Override
    @Override
    public int f() {
        return MathHelper.d(this.w);
    }

    @Override
    @Override
    public short g() {
        return (short)(MathHelper.d(this.w) & 0xFFFF);
    }

    @Override
    @Override
    public byte h() {
        return (byte)(MathHelper.d(this.w) & 0xFF);
    }

    @Override
    @Override
    public double i() {
        return this.w;
    }

    @Override
    @Override
    public float j() {
        return this.w;
    }

    @Override
    @Override
    public Number k() {
        return Float.valueOf(this.w);
    }

    @Override
    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.w);
    }

    @Override
    public /* synthetic */ NBTBase c() {
        return this.d();
    }
}

