/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.MathHelper;

public class NBTTagDouble
extends NBTNumber {
    private static final int c = 128;
    public static final NBTTagDouble a = new NBTTagDouble(0.0);
    public static final NBTTagType<NBTTagDouble> b = new NBTTagType.a<NBTTagDouble>(){

        @Override
        public NBTTagDouble a(DataInput dataInput, int i2, NBTReadLimiter nbtAccounter) throws IOException {
            nbtAccounter.a(128L);
            return NBTTagDouble.a(dataInput.readDouble());
        }

        @Override
        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor) throws IOException {
            return visitor.a(input.readDouble());
        }

        @Override
        @Override
        public int c() {
            return 8;
        }

        @Override
        @Override
        public String a() {
            return "DOUBLE";
        }

        @Override
        @Override
        public String b() {
            return "TAG_Double";
        }

        @Override
        @Override
        public boolean d() {
            return true;
        }

        @Override
        public /* synthetic */ NBTBase b(DataInput input, int depth, NBTReadLimiter tracker) throws IOException {
            return this.a(input, depth, tracker);
        }
    };
    private final double w;

    private NBTTagDouble(double value) {
        this.w = value;
    }

    public static NBTTagDouble a(double value) {
        if (value == 0.0) {
            return a;
        }
        return new NBTTagDouble(value);
    }

    @Override
    @Override
    public void a(DataOutput output) throws IOException {
        output.writeDouble(this.w);
    }

    @Override
    @Override
    public byte a() {
        return 6;
    }

    @Override
    public NBTTagType<NBTTagDouble> b() {
        return b;
    }

    @Override
    public NBTTagDouble d() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof NBTTagDouble && this.w == ((NBTTagDouble)object).w;
    }

    @Override
    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.w);
        return (int)(l2 ^ l2 >>> 32);
    }

    @Override
    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    @Override
    @Override
    public long e() {
        return (long)Math.floor(this.w);
    }

    @Override
    @Override
    public int f() {
        return MathHelper.b(this.w);
    }

    @Override
    @Override
    public short g() {
        return (short)(MathHelper.b(this.w) & 0xFFFF);
    }

    @Override
    @Override
    public byte h() {
        return (byte)(MathHelper.b(this.w) & 0xFF);
    }

    @Override
    @Override
    public double i() {
        return this.w;
    }

    @Override
    @Override
    public float j() {
        return (float)this.w;
    }

    @Override
    @Override
    public Number k() {
        return this.w;
    }

    @Override
    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.w);
    }

    @Override
    public /* synthetic */ NBTBase c() {
        return this.d();
    }
}

