/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.locale;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.FormattedString;
import net.minecraft.util.StringDecomposer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LocaleLanguage {
    private static final Logger b = LogManager.getLogger();
    private static final Gson c = new Gson();
    private static final Pattern d = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
    public static final String a = "en_us";
    private static volatile LocaleLanguage e = LocaleLanguage.c();

    private static LocaleLanguage c() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BiConsumer<String, String> biConsumer = (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1);
        String string = "/assets/minecraft/lang/en_us.json";
        try (InputStream inputStream = LocaleLanguage.class.getResourceAsStream("/assets/minecraft/lang/en_us.json");){
            LocaleLanguage.a(inputStream, biConsumer);
        }
        catch (JsonParseException | IOException exception) {
            b.error("Couldn't read strings from {}", (Object)"/assets/minecraft/lang/en_us.json", (Object)exception);
        }
        ImmutableMap map = builder.build();
        return new LocaleLanguage((Map)map){
            final /* synthetic */ Map b;
            {
                this.b = map;
            }

            @Override
            @Override
            public String a(String key) {
                return this.b.getOrDefault(key, key);
            }

            @Override
            @Override
            public boolean b(String key) {
                return this.b.containsKey(key);
            }

            @Override
            @Override
            public boolean b() {
                return false;
            }

            @Override
            @Override
            public FormattedString a(IChatFormatted text) {
                return visitor -> text.a((style, string) -> StringDecomposer.c(string, style, visitor) ? Optional.empty() : IChatFormatted.b, ChatModifier.a).isPresent();
            }
        };
    }

    public static void a(InputStream inputStream, BiConsumer<String, String> entryConsumer) {
        JsonObject jsonObject = (JsonObject)c.fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry entry : jsonObject.entrySet()) {
            String string = d.matcher(ChatDeserializer.a((JsonElement)entry.getValue(), (String)entry.getKey())).replaceAll("%$1s");
            entryConsumer.accept((String)entry.getKey(), string);
        }
    }

    public static LocaleLanguage a() {
        return e;
    }

    public static void a(LocaleLanguage language) {
        e = language;
    }

    public abstract String a(String var1);

    public abstract boolean b(String var1);

    public abstract boolean b();

    public abstract FormattedString a(IChatFormatted var1);

    public List<FormattedString> a(List<IChatFormatted> texts) {
        return (List)texts.stream().map(this::a).collect(ImmutableList.toImmutableList());
    }
}

