/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Lifecycle;
import java.net.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldDataServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameTestServer
extends MinecraftServer {
    private static final Logger r = LogManager.getLogger();
    private static final int s = 20;
    private final List<GameTestHarnessBatch> t;
    private final BlockPosition u;
    private static final GameRules v = SystemUtils.a(new GameRules(), (T gameRules) -> {
        gameRules.a(GameRules.e).a(false, (MinecraftServer)null);
        gameRules.a(GameRules.u).a(false, (MinecraftServer)null);
    });
    private static final WorldSettings w = new WorldSettings("Test Level", EnumGamemode.b, false, EnumDifficulty.c, true, v, DataPackConfiguration.a);
    @Nullable
    private GameTestHarnessCollector x;

    public GameTestServer(Thread serverThread, Convertable.ConversionSession session, ResourcePackRepository dataPackManager, DataPackResources serverResourceManager, Collection<GameTestHarnessBatch> batches, BlockPosition pos, IRegistryCustom.Dimension registryManager) {
        this(serverThread, session, dataPackManager, serverResourceManager, batches, pos, registryManager, registryManager.d(IRegistry.aR), registryManager.d(IRegistry.Q));
    }

    private GameTestServer(Thread serverThread, Convertable.ConversionSession session, ResourcePackRepository dataPackManager, DataPackResources serverResourceManager, Collection<GameTestHarnessBatch> batches, BlockPosition pos, IRegistryCustom.Dimension registryManager, IRegistry<BiomeBase> biomeRegistry, IRegistry<DimensionManager> dimensionTypeRegistry) {
        super(serverThread, registryManager, session, (SaveData)new WorldDataServer(w, new GeneratorSettings(0L, false, false, GeneratorSettings.a(dimensionTypeRegistry, DimensionManager.a(registryManager, 0L), (ChunkGenerator)new ChunkProviderFlat(GeneratorSettingsFlat.a(biomeRegistry)))), Lifecycle.stable()), dataPackManager, Proxy.NO_PROXY, DataConverterRegistry.a(), serverResourceManager, null, null, null, WorldLoadListenerLogger::new);
        this.t = Lists.newArrayList(batches);
        this.u = pos;
        if (batches.isEmpty()) {
            throw new IllegalArgumentException("No test batches were given!");
        }
    }

    @Override
    @Override
    public boolean e() {
        this.a(new PlayerList(this, this.n, this.m, 1){});
        this.loadLevel();
        WorldServer serverLevel = this.D();
        serverLevel.a(this.u, 0.0f);
        int i2 = 20000000;
        serverLevel.a(20000000, 20000000, false, false);
        return true;
    }

    @Override
    @Override
    public void a(BooleanSupplier shouldKeepTicking) {
        super.a(shouldKeepTicking);
        WorldServer serverLevel = this.D();
        if (!this.be()) {
            this.b(serverLevel);
        }
        if (serverLevel.V() % 20L == 0L) {
            r.info(this.x.j());
        }
        if (this.x.i()) {
            this.a(false);
            r.info(this.x.j());
            GlobalTestReporter.a();
            r.info("========= {} GAME TESTS COMPLETE ======================", (Object)this.x.h());
            if (this.x.d()) {
                r.info("{} required tests failed :(", (Object)this.x.a());
                this.x.f().forEach(test -> r.info("   - {}", (Object)test.c()));
            } else {
                r.info("All {} required tests passed :)", (Object)this.x.h());
            }
            if (this.x.e()) {
                r.info("{} optional tests failed", (Object)this.x.b());
                this.x.g().forEach(test -> r.info("   - {}", (Object)test.c()));
            }
            r.info("====================================================");
        }
    }

    @Override
    @Override
    public SystemReport a(SystemReport details) {
        details.a("Type", "Game test server");
        return details;
    }

    @Override
    @Override
    public void f() {
        super.f();
        System.exit(this.x.a());
    }

    @Override
    @Override
    public void a(CrashReport report) {
        System.exit(1);
    }

    private void b(WorldServer world) {
        Collection<GameTestHarnessInfo> collection = GameTestHarnessRunner.a(this.t, new BlockPosition(0, -60, 0), EnumBlockRotation.a, world, GameTestHarnessTicker.a, 8);
        this.x = new GameTestHarnessCollector(collection);
        r.info("{} tests are now running!", (Object)this.x.h());
    }

    private boolean be() {
        return this.x != null;
    }

    @Override
    @Override
    public boolean g() {
        return false;
    }

    @Override
    @Override
    public int h() {
        return 0;
    }

    @Override
    @Override
    public int i() {
        return 4;
    }

    @Override
    @Override
    public boolean j() {
        return false;
    }

    @Override
    @Override
    public boolean k() {
        return false;
    }

    @Override
    @Override
    public int l() {
        return 0;
    }

    @Override
    @Override
    public boolean m() {
        return false;
    }

    @Override
    @Override
    public boolean n() {
        return true;
    }

    @Override
    @Override
    public boolean o() {
        return false;
    }

    @Override
    @Override
    public boolean F_() {
        return false;
    }

    @Override
    @Override
    public boolean a(GameProfile profile) {
        return false;
    }
}

