/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionTriggerEnterBlock;
import net.minecraft.advancements.critereon.CriterionTriggerImpossible;
import net.minecraft.advancements.critereon.CriterionTriggerInventoryChanged;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.IRegistry;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.DebugReportGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeSerializerCooking;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeProvider
implements DebugReportProvider {
    private static final Logger b = LogManager.getLogger();
    private static final Gson c = new GsonBuilder().setPrettyPrinting().create();
    private static final ImmutableList<IMaterial> d = ImmutableList.of((Object)Items.O, (Object)Items.P);
    private static final ImmutableList<IMaterial> e = ImmutableList.of((Object)Items.Q, (Object)Items.R, (Object)Items.mp);
    private static final ImmutableList<IMaterial> f = ImmutableList.of((Object)Items.S, (Object)Items.T, (Object)Items.mr);
    private static final ImmutableList<IMaterial> g = ImmutableList.of((Object)Items.U, (Object)Items.V, (Object)Items.ae, (Object)Items.mt);
    private static final ImmutableList<IMaterial> h = ImmutableList.of((Object)Items.ac, (Object)Items.ad);
    private static final ImmutableList<IMaterial> i = ImmutableList.of((Object)Items.aa, (Object)Items.ab);
    private static final ImmutableList<IMaterial> j = ImmutableList.of((Object)Items.W, (Object)Items.X);
    private static final ImmutableList<IMaterial> k = ImmutableList.of((Object)Items.Y, (Object)Items.Z);
    private final DebugReportGenerator l;
    private static final Map<BlockFamily.b, BiFunction<IMaterial, IMaterial, RecipeBuilder>> m = ImmutableMap.builder().put((Object)BlockFamily.b.a, (output, input) -> RecipeProvider.e(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.b, (output, input) -> RecipeProvider.d(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.d, (output, input) -> RecipeProvider.c(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.e, (output, input) -> RecipeProvider.f(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.f, (output, input) -> RecipeProvider.g(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.g, (output, input) -> RecipeProvider.h(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.h, (output, input) -> RecipeProvider.m(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.i, (output, input) -> RecipeProvider.j(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.j, (output, input) -> RecipeProvider.k(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.k, (output, input) -> RecipeProvider.i(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.l, (output, input) -> RecipeProvider.b(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.m, (output, input) -> RecipeProvider.l(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.n, (output, input) -> RecipeProvider.a(output, RecipeItemStack.a(input))).build();

    public RecipeProvider(DebugReportGenerator root) {
        this.l = root;
    }

    @Override
    @Override
    public void a(HashCache cache) {
        Path path = this.l.b();
        HashSet set = Sets.newHashSet();
        RecipeProvider.a((FinishedRecipe provider) -> {
            if (!set.add(provider.b())) {
                throw new IllegalStateException("Duplicate recipe " + provider.b());
            }
            RecipeProvider.a(cache, provider.a(), path.resolve("data/" + provider.b().b() + "/recipes/" + provider.b().a() + ".json"));
            JsonObject jsonObject = provider.d();
            if (jsonObject != null) {
                RecipeProvider.b(cache, jsonObject, path.resolve("data/" + provider.b().b() + "/advancements/" + provider.e().a() + ".json"));
            }
        });
        RecipeProvider.b(cache, Advancement.SerializedAdvancement.a().a("impossible", new CriterionTriggerImpossible.a()).b(), path.resolve("data/minecraft/advancements/recipes/root.json"));
    }

    private static void a(HashCache cache, JsonObject json, Path path) {
        try {
            String string = c.toJson((JsonElement)json);
            String string2 = a.hashUnencodedChars((CharSequence)string).toString();
            if (!Objects.equals(cache.a(path), string2) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedWriter.write(string);
                }
            }
            cache.a(path, string2);
        }
        catch (IOException iOException) {
            b.error("Couldn't save recipe {}", (Object)path, (Object)iOException);
        }
    }

    private static void b(HashCache cache, JsonObject json, Path path) {
        try {
            String string = c.toJson((JsonElement)json);
            String string2 = a.hashUnencodedChars((CharSequence)string).toString();
            if (!Objects.equals(cache.a(path), string2) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedWriter.write(string);
                }
            }
            cache.a(path, string2);
        }
        catch (IOException iOException) {
            b.error("Couldn't save recipe advancement {}", (Object)path, (Object)iOException);
        }
    }

    private static void a(Consumer<FinishedRecipe> exporter) {
        BlockFamilies.a().filter(BlockFamily::d).forEach(family -> RecipeProvider.a(exporter, family));
        RecipeProvider.a(exporter, (IMaterial)Blocks.r, TagsItem.u);
        RecipeProvider.b(exporter, (IMaterial)Blocks.p, TagsItem.t);
        RecipeProvider.b(exporter, (IMaterial)Blocks.mQ, TagsItem.x);
        RecipeProvider.a(exporter, (IMaterial)Blocks.s, TagsItem.r);
        RecipeProvider.b(exporter, (IMaterial)Blocks.q, TagsItem.v);
        RecipeProvider.b(exporter, (IMaterial)Blocks.n, TagsItem.s);
        RecipeProvider.b(exporter, (IMaterial)Blocks.o, TagsItem.w);
        RecipeProvider.b(exporter, (IMaterial)Blocks.mR, TagsItem.y);
        RecipeProvider.f(exporter, Blocks.ac, Blocks.Q);
        RecipeProvider.f(exporter, Blocks.aa, Blocks.O);
        RecipeProvider.f(exporter, Blocks.ad, Blocks.R);
        RecipeProvider.f(exporter, Blocks.ab, Blocks.P);
        RecipeProvider.f(exporter, Blocks.Y, Blocks.M);
        RecipeProvider.f(exporter, Blocks.Z, Blocks.N);
        RecipeProvider.f(exporter, Blocks.mG, Blocks.mE);
        RecipeProvider.f(exporter, Blocks.mx, Blocks.mv);
        RecipeProvider.f(exporter, Blocks.ai, Blocks.V);
        RecipeProvider.f(exporter, Blocks.ag, Blocks.T);
        RecipeProvider.f(exporter, Blocks.aj, Blocks.W);
        RecipeProvider.f(exporter, Blocks.ah, Blocks.U);
        RecipeProvider.f(exporter, Blocks.ae, Blocks.X);
        RecipeProvider.f(exporter, Blocks.af, Blocks.S);
        RecipeProvider.f(exporter, Blocks.mH, Blocks.mF);
        RecipeProvider.f(exporter, Blocks.my, Blocks.mw);
        RecipeProvider.g(exporter, Items.lY, Blocks.r);
        RecipeProvider.g(exporter, Items.lW, Blocks.p);
        RecipeProvider.g(exporter, Items.lZ, Blocks.s);
        RecipeProvider.g(exporter, Items.lX, Blocks.q);
        RecipeProvider.g(exporter, Items.lU, Blocks.n);
        RecipeProvider.g(exporter, Items.lV, Blocks.o);
        RecipeProvider.j(exporter, Blocks.bt, Items.oT);
        RecipeProvider.k(exporter, Blocks.he, Blocks.bt);
        RecipeProvider.l(exporter, Blocks.he, Items.oT);
        RecipeProvider.m(exporter, Items.pn, Blocks.bt);
        RecipeProvider.n(exporter, Items.pn, Items.oT);
        RecipeProvider.o(exporter, Items.sj, Blocks.bt);
        RecipeProvider.j(exporter, Blocks.bp, Items.oP);
        RecipeProvider.k(exporter, Blocks.ha, Blocks.bp);
        RecipeProvider.l(exporter, Blocks.ha, Items.oP);
        RecipeProvider.m(exporter, Items.pj, Blocks.bp);
        RecipeProvider.n(exporter, Items.pj, Items.oP);
        RecipeProvider.o(exporter, Items.sf, Blocks.bp);
        RecipeProvider.j(exporter, Blocks.bq, Items.oQ);
        RecipeProvider.k(exporter, Blocks.hb, Blocks.bq);
        RecipeProvider.l(exporter, Blocks.hb, Items.oQ);
        RecipeProvider.m(exporter, Items.pk, Blocks.bq);
        RecipeProvider.n(exporter, Items.pk, Items.oQ);
        RecipeProvider.o(exporter, Items.sg, Blocks.bq);
        RecipeProvider.j(exporter, Blocks.bn, Items.oN);
        RecipeProvider.k(exporter, Blocks.gY, Blocks.bn);
        RecipeProvider.l(exporter, Blocks.gY, Items.oN);
        RecipeProvider.m(exporter, Items.ph, Blocks.bn);
        RecipeProvider.n(exporter, Items.ph, Items.oN);
        RecipeProvider.o(exporter, Items.sd, Blocks.bn);
        RecipeProvider.j(exporter, Blocks.bl, Items.oL);
        RecipeProvider.k(exporter, Blocks.gW, Blocks.bl);
        RecipeProvider.l(exporter, Blocks.gW, Items.oL);
        RecipeProvider.m(exporter, Items.pf, Blocks.bl);
        RecipeProvider.n(exporter, Items.pf, Items.oL);
        RecipeProvider.o(exporter, Items.sb, Blocks.bl);
        RecipeProvider.j(exporter, Blocks.br, Items.oR);
        RecipeProvider.k(exporter, Blocks.hc, Blocks.br);
        RecipeProvider.l(exporter, Blocks.hc, Items.oR);
        RecipeProvider.m(exporter, Items.pl, Blocks.br);
        RecipeProvider.n(exporter, Items.pl, Items.oR);
        RecipeProvider.o(exporter, Items.sh, Blocks.br);
        RecipeProvider.j(exporter, Blocks.bh, Items.oH);
        RecipeProvider.k(exporter, Blocks.gS, Blocks.bh);
        RecipeProvider.l(exporter, Blocks.gS, Items.oH);
        RecipeProvider.m(exporter, Items.pb, Blocks.bh);
        RecipeProvider.n(exporter, Items.pb, Items.oH);
        RecipeProvider.o(exporter, Items.rX, Blocks.bh);
        RecipeProvider.j(exporter, Blocks.bm, Items.oM);
        RecipeProvider.k(exporter, Blocks.gX, Blocks.bm);
        RecipeProvider.l(exporter, Blocks.gX, Items.oM);
        RecipeProvider.m(exporter, Items.pg, Blocks.bm);
        RecipeProvider.n(exporter, Items.pg, Items.oM);
        RecipeProvider.o(exporter, Items.sc, Blocks.bm);
        RecipeProvider.j(exporter, Blocks.bj, Items.oJ);
        RecipeProvider.k(exporter, Blocks.gU, Blocks.bj);
        RecipeProvider.l(exporter, Blocks.gU, Items.oJ);
        RecipeProvider.m(exporter, Items.pd, Blocks.bj);
        RecipeProvider.n(exporter, Items.pd, Items.oJ);
        RecipeProvider.o(exporter, Items.rZ, Blocks.bj);
        RecipeProvider.j(exporter, Blocks.bg, Items.oG);
        RecipeProvider.k(exporter, Blocks.gR, Blocks.bg);
        RecipeProvider.l(exporter, Blocks.gR, Items.oG);
        RecipeProvider.m(exporter, Items.pa, Blocks.bg);
        RecipeProvider.n(exporter, Items.pa, Items.oG);
        RecipeProvider.o(exporter, Items.rW, Blocks.bg);
        RecipeProvider.j(exporter, Blocks.bf, Items.oF);
        RecipeProvider.k(exporter, Blocks.gQ, Blocks.bf);
        RecipeProvider.l(exporter, Blocks.gQ, Items.oF);
        RecipeProvider.m(exporter, Items.oZ, Blocks.bf);
        RecipeProvider.n(exporter, Items.oZ, Items.oF);
        RecipeProvider.o(exporter, Items.rV, Blocks.bf);
        RecipeProvider.j(exporter, Blocks.bk, Items.oK);
        RecipeProvider.k(exporter, Blocks.gV, Blocks.bk);
        RecipeProvider.l(exporter, Blocks.gV, Items.oK);
        RecipeProvider.m(exporter, Items.pe, Blocks.bk);
        RecipeProvider.n(exporter, Items.pe, Items.oK);
        RecipeProvider.o(exporter, Items.sa, Blocks.bk);
        RecipeProvider.j(exporter, Blocks.bo, Items.oO);
        RecipeProvider.k(exporter, Blocks.gZ, Blocks.bo);
        RecipeProvider.l(exporter, Blocks.gZ, Items.oO);
        RecipeProvider.m(exporter, Items.pi, Blocks.bo);
        RecipeProvider.n(exporter, Items.pi, Items.oO);
        RecipeProvider.o(exporter, Items.se, Blocks.bo);
        RecipeProvider.j(exporter, Blocks.bs, Items.oS);
        RecipeProvider.k(exporter, Blocks.hd, Blocks.bs);
        RecipeProvider.l(exporter, Blocks.hd, Items.oS);
        RecipeProvider.m(exporter, Items.pm, Blocks.bs);
        RecipeProvider.n(exporter, Items.pm, Items.oS);
        RecipeProvider.o(exporter, Items.si, Blocks.bs);
        RecipeProvider.k(exporter, Blocks.gP, Blocks.be);
        RecipeProvider.m(exporter, Items.oY, Blocks.be);
        RecipeProvider.o(exporter, Items.rU, Blocks.be);
        RecipeProvider.j(exporter, Blocks.bi, Items.oI);
        RecipeProvider.k(exporter, Blocks.gT, Blocks.bi);
        RecipeProvider.l(exporter, Blocks.gT, Items.oI);
        RecipeProvider.m(exporter, Items.pc, Blocks.bi);
        RecipeProvider.n(exporter, Items.pc, Items.oI);
        RecipeProvider.o(exporter, Items.rY, Blocks.bi);
        RecipeProvider.k(exporter, Blocks.pG, Blocks.pH);
        RecipeProvider.p(exporter, Blocks.dv, Items.oT);
        RecipeProvider.q(exporter, Blocks.gx, Blocks.dv);
        RecipeProvider.r(exporter, Blocks.gx, Items.oT);
        RecipeProvider.p(exporter, Blocks.dr, Items.oP);
        RecipeProvider.q(exporter, Blocks.gt, Blocks.dr);
        RecipeProvider.r(exporter, Blocks.gt, Items.oP);
        RecipeProvider.p(exporter, Blocks.ds, Items.oQ);
        RecipeProvider.q(exporter, Blocks.gu, Blocks.ds);
        RecipeProvider.r(exporter, Blocks.gu, Items.oQ);
        RecipeProvider.p(exporter, Blocks.dp, Items.oN);
        RecipeProvider.q(exporter, Blocks.gr, Blocks.dp);
        RecipeProvider.r(exporter, Blocks.gr, Items.oN);
        RecipeProvider.p(exporter, Blocks.dn, Items.oL);
        RecipeProvider.q(exporter, Blocks.gp, Blocks.dn);
        RecipeProvider.r(exporter, Blocks.gp, Items.oL);
        RecipeProvider.p(exporter, Blocks.dt, Items.oR);
        RecipeProvider.q(exporter, Blocks.gv, Blocks.dt);
        RecipeProvider.r(exporter, Blocks.gv, Items.oR);
        RecipeProvider.p(exporter, Blocks.dj, Items.oH);
        RecipeProvider.q(exporter, Blocks.gl, Blocks.dj);
        RecipeProvider.r(exporter, Blocks.gl, Items.oH);
        RecipeProvider.p(exporter, Blocks.do, Items.oM);
        RecipeProvider.q(exporter, Blocks.gq, Blocks.do);
        RecipeProvider.r(exporter, Blocks.gq, Items.oM);
        RecipeProvider.p(exporter, Blocks.dl, Items.oJ);
        RecipeProvider.q(exporter, Blocks.gn, Blocks.dl);
        RecipeProvider.r(exporter, Blocks.gn, Items.oJ);
        RecipeProvider.p(exporter, Blocks.di, Items.oG);
        RecipeProvider.q(exporter, Blocks.gk, Blocks.di);
        RecipeProvider.r(exporter, Blocks.gk, Items.oG);
        RecipeProvider.p(exporter, Blocks.dh, Items.oF);
        RecipeProvider.q(exporter, Blocks.gj, Blocks.dh);
        RecipeProvider.r(exporter, Blocks.gj, Items.oF);
        RecipeProvider.p(exporter, Blocks.dm, Items.oK);
        RecipeProvider.q(exporter, Blocks.go, Blocks.dm);
        RecipeProvider.r(exporter, Blocks.go, Items.oK);
        RecipeProvider.p(exporter, Blocks.dq, Items.oO);
        RecipeProvider.q(exporter, Blocks.gs, Blocks.dq);
        RecipeProvider.r(exporter, Blocks.gs, Items.oO);
        RecipeProvider.p(exporter, Blocks.du, Items.oS);
        RecipeProvider.q(exporter, Blocks.gw, Blocks.du);
        RecipeProvider.r(exporter, Blocks.gw, Items.oS);
        RecipeProvider.p(exporter, Blocks.dg, Items.oE);
        RecipeProvider.q(exporter, Blocks.gi, Blocks.dg);
        RecipeProvider.r(exporter, Blocks.gi, Items.oE);
        RecipeProvider.p(exporter, Blocks.dk, Items.oI);
        RecipeProvider.q(exporter, Blocks.gm, Blocks.dk);
        RecipeProvider.r(exporter, Blocks.gm, Items.oI);
        RecipeProvider.s(exporter, Blocks.gh, Items.oT);
        RecipeProvider.s(exporter, Blocks.gd, Items.oP);
        RecipeProvider.s(exporter, Blocks.ge, Items.oQ);
        RecipeProvider.s(exporter, Blocks.gb, Items.oN);
        RecipeProvider.s(exporter, Blocks.fZ, Items.oL);
        RecipeProvider.s(exporter, Blocks.gf, Items.oR);
        RecipeProvider.s(exporter, Blocks.fV, Items.oH);
        RecipeProvider.s(exporter, Blocks.ga, Items.oM);
        RecipeProvider.s(exporter, Blocks.fX, Items.oJ);
        RecipeProvider.s(exporter, Blocks.fU, Items.oG);
        RecipeProvider.s(exporter, Blocks.fT, Items.oF);
        RecipeProvider.s(exporter, Blocks.fY, Items.oK);
        RecipeProvider.s(exporter, Blocks.gc, Items.oO);
        RecipeProvider.s(exporter, Blocks.gg, Items.oS);
        RecipeProvider.s(exporter, Blocks.fS, Items.oE);
        RecipeProvider.s(exporter, Blocks.fW, Items.oI);
        RecipeProvider.t(exporter, Blocks.kp, Items.oT);
        RecipeProvider.t(exporter, Blocks.kl, Items.oP);
        RecipeProvider.t(exporter, Blocks.km, Items.oQ);
        RecipeProvider.t(exporter, Blocks.kj, Items.oN);
        RecipeProvider.t(exporter, Blocks.kh, Items.oL);
        RecipeProvider.t(exporter, Blocks.kn, Items.oR);
        RecipeProvider.t(exporter, Blocks.kd, Items.oH);
        RecipeProvider.t(exporter, Blocks.ki, Items.oM);
        RecipeProvider.t(exporter, Blocks.kf, Items.oJ);
        RecipeProvider.t(exporter, Blocks.kc, Items.oG);
        RecipeProvider.t(exporter, Blocks.kb, Items.oF);
        RecipeProvider.t(exporter, Blocks.kg, Items.oK);
        RecipeProvider.t(exporter, Blocks.kk, Items.oO);
        RecipeProvider.t(exporter, Blocks.ko, Items.oS);
        RecipeProvider.t(exporter, Blocks.ka, Items.oE);
        RecipeProvider.t(exporter, Blocks.ke, Items.oI);
        ShapedRecipeBuilder.b(Items.tN).a(Character.valueOf('S'), Items.ne).a(Character.valueOf('H'), Items.tt).b("S").b("H").b("has_string", RecipeProvider.a(Items.ne)).b("has_honeycomb", RecipeProvider.a(Items.tt)).a(exporter);
        RecipeProvider.a(exporter, (IMaterial)Blocks.on, (IMaterial)Items.oT);
        RecipeProvider.a(exporter, (IMaterial)Blocks.oj, (IMaterial)Items.oP);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ok, (IMaterial)Items.oQ);
        RecipeProvider.a(exporter, (IMaterial)Blocks.oh, (IMaterial)Items.oN);
        RecipeProvider.a(exporter, (IMaterial)Blocks.of, (IMaterial)Items.oL);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ol, (IMaterial)Items.oR);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ob, (IMaterial)Items.oH);
        RecipeProvider.a(exporter, (IMaterial)Blocks.og, (IMaterial)Items.oM);
        RecipeProvider.a(exporter, (IMaterial)Blocks.od, (IMaterial)Items.oJ);
        RecipeProvider.a(exporter, (IMaterial)Blocks.oa, (IMaterial)Items.oG);
        RecipeProvider.a(exporter, (IMaterial)Blocks.nZ, (IMaterial)Items.oF);
        RecipeProvider.a(exporter, (IMaterial)Blocks.oe, (IMaterial)Items.oK);
        RecipeProvider.a(exporter, (IMaterial)Blocks.oi, (IMaterial)Items.oO);
        RecipeProvider.a(exporter, (IMaterial)Blocks.om, (IMaterial)Items.oS);
        RecipeProvider.a(exporter, (IMaterial)Blocks.nY, (IMaterial)Items.oE);
        RecipeProvider.a(exporter, (IMaterial)Blocks.oc, (IMaterial)Items.oI);
        ShapedRecipeBuilder.a(Blocks.fQ, 6).a(Character.valueOf('#'), Blocks.cH).a(Character.valueOf('S'), Items.nb).a(Character.valueOf('X'), Items.mq).b("XSX").b("X#X").b("XSX").b("has_rail", RecipeProvider.a((IMaterial)Blocks.co)).a(exporter);
        ShapelessRecipeBuilder.a(Blocks.g, 2).c(Blocks.e).c(Blocks.m).b("has_stone", RecipeProvider.a((IMaterial)Blocks.e)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.fB).a(Character.valueOf('I'), Blocks.bL).a(Character.valueOf('i'), Items.mq).b("III").b(" i ").b("iii").b("has_iron_block", RecipeProvider.a((IMaterial)Blocks.bL)).a(exporter);
        ShapedRecipeBuilder.b(Items.rK).a(Character.valueOf('/'), Items.nb).a(Character.valueOf('_'), Blocks.if).b("///").b(" / ").b("/_/").b("has_stone_slab", RecipeProvider.a((IMaterial)Blocks.if)).a(exporter);
        ShapedRecipeBuilder.a(Items.mh, 4).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.nI).a(Character.valueOf('Y'), Items.nf).b("X").b("#").b("Y").b("has_feather", RecipeProvider.a(Items.nf)).b("has_flint", RecipeProvider.a(Items.nI)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.mg, 1).a(Character.valueOf('P'), TagsItem.c).a(Character.valueOf('S'), TagsItem.j).b("PSP").b("P P").b("PSP").b("has_planks", RecipeProvider.a(TagsItem.c)).b("has_wood_slab", RecipeProvider.a(TagsItem.j)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.eF).a(Character.valueOf('S'), Items.rx).a(Character.valueOf('G'), Blocks.au).a(Character.valueOf('O'), Blocks.bQ).b("GGG").b("GSG").b("OOO").b("has_nether_star", RecipeProvider.a(Items.rx)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.nr).a(Character.valueOf('P'), TagsItem.c).a(Character.valueOf('H'), Items.tt).b("PPP").b("HHH").b("PPP").b("has_honeycomb", RecipeProvider.a(Items.tt)).a(exporter);
        ShapelessRecipeBuilder.b(Items.sp).c(Items.nc).b(Items.sn, 6).b("has_beetroot", RecipeProvider.a(Items.sn)).a(exporter);
        ShapelessRecipeBuilder.b(Items.oT).c(Items.oB).b("black_dye").b("has_ink_sac", RecipeProvider.a(Items.oB)).a(exporter);
        RecipeProvider.a(exporter, (IMaterial)Items.oT, (IMaterial)Blocks.bG, "black_dye");
        ShapelessRecipeBuilder.a(Items.pJ, 2).c(Items.pB).b("has_blaze_rod", RecipeProvider.a(Items.pB)).a(exporter);
        ShapelessRecipeBuilder.b(Items.oP).c(Items.mm).b("blue_dye").b("has_lapis_lazuli", RecipeProvider.a(Items.mm)).a(exporter);
        RecipeProvider.a(exporter, (IMaterial)Items.oP, (IMaterial)Blocks.bF, "blue_dye");
        ShapedRecipeBuilder.b(Blocks.lj).a(Character.valueOf('#'), Blocks.hh).b("###").b("###").b("###").b("has_packed_ice", RecipeProvider.a((IMaterial)Blocks.hh)).a(exporter);
        ShapelessRecipeBuilder.a(Items.oU, 3).c(Items.oV).b("bonemeal").b("has_bone", RecipeProvider.a(Items.oV)).a(exporter);
        RecipeProvider.b(exporter, Items.oU, Items.hH, "bone_meal_from_bone_block", "bonemeal");
        ShapelessRecipeBuilder.b(Items.om).b(Items.ol, 3).c(Items.ob).b("has_paper", RecipeProvider.a(Items.ol)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.bO).a(Character.valueOf('#'), TagsItem.c).a(Character.valueOf('X'), Items.om).b("###").b("XXX").b("###").b("has_book", RecipeProvider.a(Items.om)).a(exporter);
        ShapedRecipeBuilder.b(Items.mg).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.ne).b(" #X").b("# X").b(" #X").b("has_string", RecipeProvider.a(Items.ne)).a(exporter);
        ShapedRecipeBuilder.a(Items.nc, 4).a(Character.valueOf('#'), TagsItem.c).b("# #").b(" # ").b("has_brown_mushroom", RecipeProvider.a((IMaterial)Blocks.bI)).b("has_red_mushroom", RecipeProvider.a((IMaterial)Blocks.bJ)).b("has_mushroom_stew", RecipeProvider.a(Items.nd)).a(exporter);
        ShapedRecipeBuilder.b(Items.nj).a(Character.valueOf('#'), Items.ni).b("###").b("has_wheat", RecipeProvider.a(Items.ni)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.ej).a(Character.valueOf('B'), Items.pB).a(Character.valueOf('#'), TagsItem.ap).b(" B ").b("###").b("has_blaze_rod", RecipeProvider.a(Items.pB)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.bM).a(Character.valueOf('#'), Items.oi).b("##").b("##").b("has_brick", RecipeProvider.a(Items.oi)).a(exporter);
        ShapelessRecipeBuilder.b(Items.oQ).c(Items.oD).b("brown_dye").b("has_cocoa_beans", RecipeProvider.a(Items.oD)).a(exporter);
        ShapedRecipeBuilder.b(Items.nW).a(Character.valueOf('#'), Items.mq).b("# #").b(" # ").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.de).a(Character.valueOf('A'), Items.oc).a(Character.valueOf('B'), Items.oW).a(Character.valueOf('C'), Items.ni).a(Character.valueOf('E'), Items.oo).b("AAA").b("BEB").b("CCC").b("has_egg", RecipeProvider.a(Items.oo)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.ms).a(Character.valueOf('L'), TagsItem.q).a(Character.valueOf('S'), Items.nb).a(Character.valueOf('C'), TagsItem.ak).b(" S ").b("SCS").b("LLL").b("has_stick", RecipeProvider.a(Items.nb)).b("has_coal", RecipeProvider.a(TagsItem.ak)).a(exporter);
        ShapedRecipeBuilder.b(Items.lR).a(Character.valueOf('#'), Items.or).a(Character.valueOf('X'), Items.rl).b("# ").b(" X").b("has_carrot", RecipeProvider.a(Items.rl)).a(exporter);
        ShapedRecipeBuilder.b(Items.lS).a(Character.valueOf('#'), Items.or).a(Character.valueOf('X'), Items.cI).b("# ").b(" X").b("has_warped_fungus", RecipeProvider.a(Items.cI)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.ek).a(Character.valueOf('#'), Items.mq).b("# #").b("# #").b("###").b("has_water_bucket", RecipeProvider.a(Items.nX)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.no).a(Character.valueOf('#'), TagsItem.j).b("# #").b("# #").b("###").b("has_wood_slab", RecipeProvider.a(TagsItem.j)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.bX).a(Character.valueOf('#'), TagsItem.c).b("###").b("# #").b("###").b("has_lots_of_items", new CriterionTriggerInventoryChanged.a(CriterionConditionEntity.b.a, CriterionConditionValue.IntegerRange.b(10), CriterionConditionValue.IntegerRange.e, CriterionConditionValue.IntegerRange.e, new CriterionConditionItem[0])).a(exporter);
        ShapedRecipeBuilder.b(Items.lN).a(Character.valueOf('A'), Blocks.bX).a(Character.valueOf('B'), Items.lM).b("A").b("B").b("has_minecart", RecipeProvider.a(Items.lM)).a(exporter);
        RecipeProvider.d((IMaterial)Blocks.fN, RecipeItemStack.a(Blocks.in)).b("has_chiseled_quartz_block", RecipeProvider.a((IMaterial)Blocks.fN)).b("has_quartz_block", RecipeProvider.a((IMaterial)Blocks.fM)).b("has_quartz_pillar", RecipeProvider.a((IMaterial)Blocks.fO)).a(exporter);
        RecipeProvider.d((IMaterial)Blocks.dF, RecipeItemStack.a(Blocks.il)).b("has_tag", RecipeProvider.a(TagsItem.d)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.cO).a(Character.valueOf('#'), Items.oj).b("##").b("##").b("has_clay_ball", RecipeProvider.a(Items.oj)).a(exporter);
        ShapedRecipeBuilder.b(Items.os).a(Character.valueOf('#'), Items.mu).a(Character.valueOf('X'), Items.kn).b(" # ").b("#X#").b(" # ").b("has_redstone", RecipeProvider.a(Items.kn)).a(exporter);
        RecipeProvider.w(exporter, Items.mi, Items.ah);
        ShapedRecipeBuilder.a(Blocks.k, 4).a(Character.valueOf('D'), Blocks.j).a(Character.valueOf('G'), Blocks.E).b("DG").b("GD").b("has_gravel", RecipeProvider.a((IMaterial)Blocks.E)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.fH).a(Character.valueOf('#'), Blocks.cH).a(Character.valueOf('X'), Items.mn).a(Character.valueOf('I'), Blocks.b).b(" # ").b("#X#").b("III").b("has_quartz", RecipeProvider.a(Items.mn)).a(exporter);
        ShapedRecipeBuilder.b(Items.op).a(Character.valueOf('#'), Items.mq).a(Character.valueOf('X'), Items.kn).b(" # ").b("#X#").b(" # ").b("has_redstone", RecipeProvider.a(Items.kn)).a(exporter);
        ShapedRecipeBuilder.a(Items.po, 8).a(Character.valueOf('#'), Items.ni).a(Character.valueOf('X'), Items.oD).b("#X#").b("has_cocoa", RecipeProvider.a(Items.oD)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.cc).a(Character.valueOf('#'), TagsItem.c).b("##").b("##").b("has_planks", RecipeProvider.a(TagsItem.c)).a(exporter);
        ShapedRecipeBuilder.b(Items.sT).a(Character.valueOf('~'), Items.ne).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('&'), Items.mq).a(Character.valueOf('$'), Blocks.ey).b("#&#").b("~$~").b(" # ").b("has_string", RecipeProvider.a(Items.ne)).b("has_stick", RecipeProvider.a(Items.nb)).b("has_iron_ingot", RecipeProvider.a(Items.mq)).b("has_tripwire_hook", RecipeProvider.a((IMaterial)Blocks.ey)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mf).a(Character.valueOf('#'), TagsItem.c).a(Character.valueOf('@'), Items.ne).b("@@").b("##").b("has_string", RecipeProvider.a(Items.ne)).a(exporter);
        RecipeProvider.d((IMaterial)Blocks.hV, RecipeItemStack.a(Blocks.io)).b("has_red_sandstone", RecipeProvider.a((IMaterial)Blocks.hU)).b("has_chiseled_red_sandstone", RecipeProvider.a((IMaterial)Blocks.hV)).b("has_cut_red_sandstone", RecipeProvider.a((IMaterial)Blocks.hW)).a(exporter);
        RecipeProvider.e(exporter, Blocks.aA, Blocks.ig);
        RecipeProvider.b(exporter, Items.ms, Items.ao, RecipeProvider.d(Items.ms), RecipeProvider.c(Items.ms));
        ShapelessRecipeBuilder.a(Items.ms, 9).c(Blocks.pi).b(RecipeProvider.c(Items.ms)).b(RecipeProvider.b(Blocks.pi), RecipeProvider.a((IMaterial)Blocks.pi)).a(exporter, RecipeProvider.a((IMaterial)Items.ms, (IMaterial)Blocks.pi));
        RecipeProvider.b(exporter);
        ShapelessRecipeBuilder.a(Items.oN, 2).c(Items.oP).c(Items.oR).b("has_green_dye", RecipeProvider.a(Items.oR)).b("has_blue_dye", RecipeProvider.a(Items.oP)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.gG).a(Character.valueOf('S'), Items.rD).a(Character.valueOf('I'), Items.oT).b("SSS").b("SIS").b("SSS").b("has_prismarine_shard", RecipeProvider.a(Items.rD)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.fI).a(Character.valueOf('Q'), Items.mn).a(Character.valueOf('G'), Blocks.au).a(Character.valueOf('W'), RecipeItemStack.a(TagsItem.j)).b("GGG").b("QQQ").b("WWW").b("has_quartz", RecipeProvider.a(Items.mn)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.qa, 4).a(Character.valueOf('S'), Blocks.pS).b("SS").b("SS").b("has_polished_deepslate", RecipeProvider.a((IMaterial)Blocks.pS)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.pW, 4).a(Character.valueOf('S'), Blocks.qa).b("SS").b("SS").b("has_deepslate_bricks", RecipeProvider.a((IMaterial)Blocks.qa)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.aU, 6).a(Character.valueOf('R'), Items.kn).a(Character.valueOf('#'), Blocks.cx).a(Character.valueOf('X'), Items.mq).b("X X").b("X#X").b("XRX").b("has_rail", RecipeProvider.a((IMaterial)Blocks.co)).a(exporter);
        ShapedRecipeBuilder.b(Items.mU).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mk).b("XX").b("X#").b(" #").b("has_diamond", RecipeProvider.a(Items.mk)).a(exporter);
        RecipeProvider.w(exporter, Items.mk, Items.aq);
        ShapedRecipeBuilder.b(Items.nz).a(Character.valueOf('X'), Items.mk).b("X X").b("X X").b("has_diamond", RecipeProvider.a(Items.mk)).a(exporter);
        ShapedRecipeBuilder.b(Items.nx).a(Character.valueOf('X'), Items.mk).b("X X").b("XXX").b("XXX").b("has_diamond", RecipeProvider.a(Items.mk)).a(exporter);
        ShapedRecipeBuilder.b(Items.nw).a(Character.valueOf('X'), Items.mk).b("XXX").b("X X").b("has_diamond", RecipeProvider.a(Items.mk)).a(exporter);
        ShapedRecipeBuilder.b(Items.mV).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mk).b("XX").b(" #").b(" #").b("has_diamond", RecipeProvider.a(Items.mk)).a(exporter);
        ShapedRecipeBuilder.b(Items.ny).a(Character.valueOf('X'), Items.mk).b("XXX").b("X X").b("X X").b("has_diamond", RecipeProvider.a(Items.mk)).a(exporter);
        ShapedRecipeBuilder.b(Items.mT).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mk).b("XXX").b(" # ").b(" # ").b("has_diamond", RecipeProvider.a(Items.mk)).a(exporter);
        ShapedRecipeBuilder.b(Items.mS).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mk).b("X").b("#").b("#").b("has_diamond", RecipeProvider.a(Items.mk)).a(exporter);
        ShapedRecipeBuilder.b(Items.mR).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mk).b("X").b("X").b("#").b("has_diamond", RecipeProvider.a(Items.mk)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.e, 2).a(Character.valueOf('Q'), Items.mn).a(Character.valueOf('C'), Blocks.m).b("CQ").b("QC").b("has_quartz", RecipeProvider.a(Items.mn)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.ay).a(Character.valueOf('R'), Items.kn).a(Character.valueOf('#'), Blocks.m).a(Character.valueOf('X'), Items.mg).b("###").b("#X#").b("#R#").b("has_bow", RecipeProvider.a(Items.mg)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.pA).a(Character.valueOf('#'), Items.ui).b("##").b("##").c("pointed_dripstone").b("has_pointed_dripstone", RecipeProvider.a(Items.ui)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.fR).a(Character.valueOf('R'), Items.kn).a(Character.valueOf('#'), Blocks.m).b("###").b("# #").b("#R#").b("has_redstone", RecipeProvider.a(Items.kn)).a(exporter);
        RecipeProvider.w(exporter, Items.ml, Items.ff);
        ShapedRecipeBuilder.b(Blocks.ei).a(Character.valueOf('B'), Items.om).a(Character.valueOf('#'), Blocks.bQ).a(Character.valueOf('D'), Items.mk).b(" B ").b("D#D").b("###").b("has_obsidian", RecipeProvider.a((IMaterial)Blocks.bQ)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.ex).a(Character.valueOf('#'), Blocks.bQ).a(Character.valueOf('E'), Items.pN).b("###").b("#E#").b("###").b("has_ender_eye", RecipeProvider.a(Items.pN)).a(exporter);
        ShapelessRecipeBuilder.b(Items.pN).c(Items.pA).c(Items.pJ).b("has_blaze_powder", RecipeProvider.a(Items.pJ)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.iQ, 4).a(Character.valueOf('#'), Blocks.eq).b("##").b("##").b("has_end_stone", RecipeProvider.a((IMaterial)Blocks.eq)).a(exporter);
        ShapedRecipeBuilder.b(Items.sk).a(Character.valueOf('T'), Items.pC).a(Character.valueOf('E'), Items.pN).a(Character.valueOf('G'), Blocks.au).b("GGG").b("GEG").b("GTG").b("has_ender_eye", RecipeProvider.a(Items.pN)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.iK, 4).a(Character.valueOf('#'), Items.sm).a(Character.valueOf('/'), Items.pB).b("/").b("#").b("has_chorus_fruit_popped", RecipeProvider.a(Items.sm)).a(exporter);
        ShapelessRecipeBuilder.b(Items.pI).c(Items.pH).c(Blocks.bI).c(Items.oW).b("has_spider_eye", RecipeProvider.a(Items.pH)).a(exporter);
        ShapelessRecipeBuilder.a(Items.rf, 3).c(Items.ng).c(Items.pJ).a(RecipeItemStack.a(Items.mi, Items.mj)).b("has_blaze_powder", RecipeProvider.a(Items.pJ)).a(exporter);
        ShapelessRecipeBuilder.a(Items.rz, 3).c(Items.ng).c(Items.ol).b("has_gunpowder", RecipeProvider.a(Items.ng)).a(exporter, "firework_rocket_simple");
        ShapedRecipeBuilder.b(Items.or).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.ne).b("  #").b(" #X").b("# X").b("has_string", RecipeProvider.a(Items.ne)).a(exporter);
        ShapelessRecipeBuilder.b(Items.me).c(Items.mq).c(Items.nI).b("has_flint", RecipeProvider.a(Items.nI)).b("has_obsidian", RecipeProvider.a((IMaterial)Blocks.bQ)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.eI).a(Character.valueOf('#'), Items.oi).b("# #").b(" # ").b("has_brick", RecipeProvider.a(Items.oi)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.cf).a(Character.valueOf('#'), TagsItem.ap).b("###").b("# #").b("###").b("has_cobblestone", RecipeProvider.a(TagsItem.ap)).a(exporter);
        ShapedRecipeBuilder.b(Items.lO).a(Character.valueOf('A'), Blocks.cf).a(Character.valueOf('B'), Items.lM).b("A").b("B").b("has_minecart", RecipeProvider.a(Items.lM)).a(exporter);
        ShapedRecipeBuilder.a(Items.pG, 3).a(Character.valueOf('#'), Blocks.au).b("# #").b(" # ").b("has_glass", RecipeProvider.a((IMaterial)Blocks.au)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.dR, 16).a(Character.valueOf('#'), Blocks.au).b("###").b("###").b("has_glass", RecipeProvider.a((IMaterial)Blocks.au)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.da).a(Character.valueOf('#'), Items.ou).b("##").b("##").b("has_glowstone_dust", RecipeProvider.a(Items.ou)).a(exporter);
        ShapelessRecipeBuilder.b(Items.rj).c(Items.ri).c(Items.oC).b("has_item_frame", RecipeProvider.a(Items.ri)).b("has_glow_ink_sac", RecipeProvider.a(Items.oC)).a(exporter);
        ShapedRecipeBuilder.b(Items.nM).a(Character.valueOf('#'), Items.mu).a(Character.valueOf('X'), Items.mf).b("###").b("#X#").b("###").b("has_gold_ingot", RecipeProvider.a(Items.mu)).a(exporter);
        ShapedRecipeBuilder.b(Items.mK).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mu).b("XX").b("X#").b(" #").b("has_gold_ingot", RecipeProvider.a(Items.mu)).a(exporter);
        ShapedRecipeBuilder.b(Items.nD).a(Character.valueOf('X'), Items.mu).b("X X").b("X X").b("has_gold_ingot", RecipeProvider.a(Items.mu)).a(exporter);
        ShapedRecipeBuilder.b(Items.rq).a(Character.valueOf('#'), Items.pD).a(Character.valueOf('X'), Items.rl).b("###").b("#X#").b("###").b("has_gold_nugget", RecipeProvider.a(Items.pD)).a(exporter);
        ShapedRecipeBuilder.b(Items.nB).a(Character.valueOf('X'), Items.mu).b("X X").b("XXX").b("XXX").b("has_gold_ingot", RecipeProvider.a(Items.mu)).a(exporter);
        ShapedRecipeBuilder.b(Items.nA).a(Character.valueOf('X'), Items.mu).b("XXX").b("X X").b("has_gold_ingot", RecipeProvider.a(Items.mu)).a(exporter);
        ShapedRecipeBuilder.b(Items.mL).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mu).b("XX").b(" #").b(" #").b("has_gold_ingot", RecipeProvider.a(Items.mu)).a(exporter);
        ShapedRecipeBuilder.b(Items.nC).a(Character.valueOf('X'), Items.mu).b("XXX").b("X X").b("X X").b("has_gold_ingot", RecipeProvider.a(Items.mu)).a(exporter);
        ShapedRecipeBuilder.b(Items.mJ).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mu).b("XXX").b(" # ").b(" # ").b("has_gold_ingot", RecipeProvider.a(Items.mu)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.aT, 6).a(Character.valueOf('R'), Items.kn).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mu).b("X X").b("X#X").b("XRX").b("has_rail", RecipeProvider.a((IMaterial)Blocks.co)).a(exporter);
        ShapedRecipeBuilder.b(Items.mI).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mu).b("X").b("#").b("#").b("has_gold_ingot", RecipeProvider.a(Items.mu)).a(exporter);
        ShapedRecipeBuilder.b(Items.mH).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mu).b("X").b("X").b("#").b("has_gold_ingot", RecipeProvider.a(Items.mu)).a(exporter);
        RecipeProvider.b(exporter, Items.mu, Items.ap, "gold_ingot_from_gold_block", "gold_ingot");
        RecipeProvider.a(exporter, (IMaterial)Items.pD, (IMaterial)Items.mu, "gold_ingot_from_nuggets", "gold_ingot");
        ShapelessRecipeBuilder.b(Blocks.c).c(Blocks.e).c(Items.mn).b("has_quartz", RecipeProvider.a(Items.mn)).a(exporter);
        ShapelessRecipeBuilder.a(Items.oL, 2).c(Items.oT).c(Items.oE).b("has_white_dye", RecipeProvider.a(Items.oE)).b("has_black_dye", RecipeProvider.a(Items.oT)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.gO).a(Character.valueOf('#'), Items.ni).b("###").b("###").b("###").b("has_wheat", RecipeProvider.a(Items.ni)).a(exporter);
        RecipeProvider.h(exporter, Blocks.fG, Items.mq);
        ShapelessRecipeBuilder.a(Items.tw, 4).c(Items.kv).b(Items.pG, 4).b("has_honey_block", RecipeProvider.a((IMaterial)Blocks.ns)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.ns, 1).a(Character.valueOf('S'), Items.tw).b("SS").b("SS").b("has_honey_bottle", RecipeProvider.a(Items.tw)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.nt).a(Character.valueOf('H'), Items.tt).b("HH").b("HH").b("has_honeycomb", RecipeProvider.a(Items.tt)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.fL).a(Character.valueOf('C'), Blocks.bX).a(Character.valueOf('I'), Items.mq).b("I I").b("ICI").b(" I ").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Items.lQ).a(Character.valueOf('A'), Blocks.fL).a(Character.valueOf('B'), Items.lM).b("A").b("B").b("has_minecart", RecipeProvider.a(Items.lM)).a(exporter);
        ShapedRecipeBuilder.b(Items.mP).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mq).b("XX").b("X#").b(" #").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.dP, 16).a(Character.valueOf('#'), Items.mq).b("###").b("###").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Items.nv).a(Character.valueOf('X'), Items.mq).b("X X").b("X X").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Items.nt).a(Character.valueOf('X'), Items.mq).b("X X").b("XXX").b("XXX").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        RecipeProvider.f((IMaterial)Blocks.cy, RecipeItemStack.a(Items.mq)).a(RecipeProvider.b(Items.mq), RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Items.ns).a(Character.valueOf('X'), Items.mq).b("XXX").b("X X").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Items.mQ).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mq).b("XX").b(" #").b(" #").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        RecipeProvider.b(exporter, Items.mq, Items.an, "iron_ingot_from_iron_block", "iron_ingot");
        RecipeProvider.a(exporter, (IMaterial)Items.sy, (IMaterial)Items.mq, "iron_ingot_from_nuggets", "iron_ingot");
        ShapedRecipeBuilder.b(Items.nu).a(Character.valueOf('X'), Items.mq).b("XXX").b("X X").b("X X").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Items.mO).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mq).b("XXX").b(" # ").b(" # ").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Items.mN).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mq).b("X").b("#").b("#").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Items.mM).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mq).b("X").b("X").b("#").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.gD).a(Character.valueOf('#'), Items.mq).b("##").b("##").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Items.ri).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.ob).b("###").b("#X#").b("###").b("has_leather", RecipeProvider.a(Items.ob)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.cQ).a(Character.valueOf('#'), TagsItem.c).a(Character.valueOf('X'), Items.mk).b("###").b("#X#").b("###").b("has_diamond", RecipeProvider.a(Items.mk)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.cn, 3).a(Character.valueOf('#'), Items.nb).b("# #").b("###").b("# #").b("has_stick", RecipeProvider.a(Items.nb)).a(exporter);
        RecipeProvider.w(exporter, Items.mm, Items.bP);
        ShapedRecipeBuilder.a(Items.rP, 2).a(Character.valueOf('~'), Items.ne).a(Character.valueOf('O'), Items.on).b("~~ ").b("~O ").b("  ~").b("has_slime_ball", RecipeProvider.a(Items.on)).a(exporter);
        ShapedRecipeBuilder.b(Items.ob).a(Character.valueOf('#'), Items.rJ).b("##").b("##").b("has_rabbit_hide", RecipeProvider.a(Items.rJ)).a(exporter);
        ShapedRecipeBuilder.b(Items.nn).a(Character.valueOf('X'), Items.ob).b("X X").b("X X").b("has_leather", RecipeProvider.a(Items.ob)).a(exporter);
        ShapedRecipeBuilder.b(Items.nl).a(Character.valueOf('X'), Items.ob).b("X X").b("XXX").b("XXX").b("has_leather", RecipeProvider.a(Items.ob)).a(exporter);
        ShapedRecipeBuilder.b(Items.nk).a(Character.valueOf('X'), Items.ob).b("XXX").b("X X").b("has_leather", RecipeProvider.a(Items.ob)).a(exporter);
        ShapedRecipeBuilder.b(Items.nm).a(Character.valueOf('X'), Items.ob).b("XXX").b("X X").b("X X").b("has_leather", RecipeProvider.a(Items.ob)).a(exporter);
        ShapedRecipeBuilder.b(Items.rO).a(Character.valueOf('X'), Items.ob).b("X X").b("XXX").b("X X").b("has_leather", RecipeProvider.a(Items.ob)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mm).a(Character.valueOf('S'), TagsItem.j).a(Character.valueOf('B'), Blocks.bO).b("SSS").b(" B ").b(" S ").b("has_book", RecipeProvider.a(Items.om)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.cw).a(Character.valueOf('#'), Blocks.m).a(Character.valueOf('X'), Items.nb).b("X").b("#").b("has_cobblestone", RecipeProvider.a((IMaterial)Blocks.m)).a(exporter);
        RecipeProvider.a(exporter, (IMaterial)Items.oH, (IMaterial)Blocks.bx, "light_blue_dye");
        ShapelessRecipeBuilder.a(Items.oH, 2).c(Items.oP).c(Items.oE).b("light_blue_dye").b("has_blue_dye", RecipeProvider.a(Items.oP)).b("has_white_dye", RecipeProvider.a(Items.oE)).a(exporter, "light_blue_dye_from_blue_white_dye");
        RecipeProvider.a(exporter, (IMaterial)Items.oM, (IMaterial)Blocks.bz, "light_gray_dye");
        ShapelessRecipeBuilder.a(Items.oM, 2).c(Items.oL).c(Items.oE).b("light_gray_dye").b("has_gray_dye", RecipeProvider.a(Items.oL)).b("has_white_dye", RecipeProvider.a(Items.oE)).a(exporter, "light_gray_dye_from_gray_white_dye");
        ShapelessRecipeBuilder.a(Items.oM, 3).c(Items.oT).b(Items.oE, 2).b("light_gray_dye").b("has_white_dye", RecipeProvider.a(Items.oE)).b("has_black_dye", RecipeProvider.a(Items.oT)).a(exporter, "light_gray_dye_from_black_white_dye");
        RecipeProvider.a(exporter, (IMaterial)Items.oM, (IMaterial)Blocks.bE, "light_gray_dye");
        RecipeProvider.a(exporter, (IMaterial)Items.oM, (IMaterial)Blocks.bC, "light_gray_dye");
        RecipeProvider.h(exporter, Blocks.fF, Items.mu);
        ShapedRecipeBuilder.b(Blocks.py).a(Character.valueOf('#'), Items.ms).b("#").b("#").b("#").b("has_copper_ingot", RecipeProvider.a(Items.ms)).a(exporter);
        ShapelessRecipeBuilder.a(Items.oJ, 2).c(Items.oR).c(Items.oE).b("has_green_dye", RecipeProvider.a(Items.oR)).b("has_white_dye", RecipeProvider.a(Items.oE)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.dd).a(Character.valueOf('A'), Blocks.dc).a(Character.valueOf('B'), Blocks.bR).b("A").b("B").b("has_carved_pumpkin", RecipeProvider.a((IMaterial)Blocks.dc)).a(exporter);
        RecipeProvider.a(exporter, (IMaterial)Items.oG, (IMaterial)Blocks.by, "magenta_dye");
        ShapelessRecipeBuilder.a(Items.oG, 4).c(Items.oP).b(Items.oS, 2).c(Items.oE).b("magenta_dye").b("has_blue_dye", RecipeProvider.a(Items.oP)).b("has_rose_red", RecipeProvider.a(Items.oS)).b("has_white_dye", RecipeProvider.a(Items.oE)).a(exporter, "magenta_dye_from_blue_red_white_dye");
        ShapelessRecipeBuilder.a(Items.oG, 3).c(Items.oP).c(Items.oS).c(Items.oK).b("magenta_dye").b("has_pink_dye", RecipeProvider.a(Items.oK)).b("has_blue_dye", RecipeProvider.a(Items.oP)).b("has_red_dye", RecipeProvider.a(Items.oS)).a(exporter, "magenta_dye_from_blue_red_pink");
        RecipeProvider.a(exporter, (IMaterial)Items.oG, (IMaterial)Blocks.hj, "magenta_dye", 2);
        ShapelessRecipeBuilder.a(Items.oG, 2).c(Items.oO).c(Items.oK).b("magenta_dye").b("has_pink_dye", RecipeProvider.a(Items.oK)).b("has_purple_dye", RecipeProvider.a(Items.oO)).a(exporter, "magenta_dye_from_purple_and_pink");
        ShapedRecipeBuilder.b(Blocks.iX).a(Character.valueOf('#'), Items.pK).b("##").b("##").b("has_magma_cream", RecipeProvider.a(Items.pK)).a(exporter);
        ShapelessRecipeBuilder.b(Items.pK).c(Items.pJ).c(Items.on).b("has_blaze_powder", RecipeProvider.a(Items.pJ)).a(exporter);
        ShapedRecipeBuilder.b(Items.rp).a(Character.valueOf('#'), Items.ol).a(Character.valueOf('X'), Items.op).b("###").b("#X#").b("###").b("has_compass", RecipeProvider.a(Items.op)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.dS).a(Character.valueOf('M'), Items.pr).b("MMM").b("MMM").b("MMM").b("has_melon", RecipeProvider.a(Items.pr)).a(exporter);
        ShapelessRecipeBuilder.b(Items.pu).c(Items.pr).b("has_melon", RecipeProvider.a(Items.pr)).a(exporter);
        ShapedRecipeBuilder.b(Items.lM).a(Character.valueOf('#'), Items.mq).b("# #").b("###").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapelessRecipeBuilder.b(Blocks.bP).c(Blocks.m).c(Blocks.dX).b("mossy_cobblestone").b("has_vine", RecipeProvider.a((IMaterial)Blocks.dX)).a(exporter, RecipeProvider.a((IMaterial)Blocks.bP, (IMaterial)Blocks.dX));
        ShapelessRecipeBuilder.b(Blocks.dD).c(Blocks.dC).c(Blocks.dX).b("mossy_stone_bricks").b("has_vine", RecipeProvider.a((IMaterial)Blocks.dX)).a(exporter, RecipeProvider.a((IMaterial)Blocks.dD, (IMaterial)Blocks.dX));
        ShapelessRecipeBuilder.b(Blocks.bP).c(Blocks.m).c(Blocks.pH).b("mossy_cobblestone").b("has_moss_block", RecipeProvider.a((IMaterial)Blocks.pH)).a(exporter, RecipeProvider.a((IMaterial)Blocks.bP, (IMaterial)Blocks.pH));
        ShapelessRecipeBuilder.b(Blocks.dD).c(Blocks.dC).c(Blocks.pH).b("mossy_stone_bricks").b("has_moss_block", RecipeProvider.a((IMaterial)Blocks.pH)).a(exporter, RecipeProvider.a((IMaterial)Blocks.dD, (IMaterial)Blocks.pH));
        ShapelessRecipeBuilder.b(Items.nd).c(Blocks.bI).c(Blocks.bJ).c(Items.nc).b("has_mushroom_stew", RecipeProvider.a(Items.nd)).b("has_bowl", RecipeProvider.a(Items.nc)).b("has_brown_mushroom", RecipeProvider.a((IMaterial)Blocks.bI)).b("has_red_mushroom", RecipeProvider.a((IMaterial)Blocks.bJ)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.ee).a(Character.valueOf('N'), Items.rC).b("NN").b("NN").b("has_netherbrick", RecipeProvider.a(Items.rC)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.iY).a(Character.valueOf('#'), Items.pE).b("###").b("###").b("###").b("has_nether_wart", RecipeProvider.a(Items.pE)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.aC).a(Character.valueOf('#'), TagsItem.c).a(Character.valueOf('X'), Items.kn).b("###").b("#X#").b("###").b("has_redstone", RecipeProvider.a(Items.kn)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.jc).a(Character.valueOf('Q'), Items.mn).a(Character.valueOf('R'), Items.kn).a(Character.valueOf('#'), Blocks.m).b("###").b("RRQ").b("###").b("has_quartz", RecipeProvider.a(Items.mn)).a(exporter);
        RecipeProvider.a(exporter, (IMaterial)Items.oF, (IMaterial)Blocks.bB, "orange_dye");
        ShapelessRecipeBuilder.a(Items.oF, 2).c(Items.oS).c(Items.oI).b("orange_dye").b("has_red_dye", RecipeProvider.a(Items.oS)).b("has_yellow_dye", RecipeProvider.a(Items.oI)).a(exporter, "orange_dye_from_red_yellow");
        ShapedRecipeBuilder.b(Items.nL).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), RecipeItemStack.a(TagsItem.b)).b("###").b("#X#").b("###").b("has_wool", RecipeProvider.a(TagsItem.b)).a(exporter);
        ShapedRecipeBuilder.a(Items.ol, 3).a(Character.valueOf('#'), Blocks.cP).b("###").b("has_reeds", RecipeProvider.a((IMaterial)Blocks.cP)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.fO, 2).a(Character.valueOf('#'), Blocks.fM).b("#").b("#").b("has_chiseled_quartz_block", RecipeProvider.a((IMaterial)Blocks.fN)).b("has_quartz_block", RecipeProvider.a((IMaterial)Blocks.fM)).b("has_quartz_pillar", RecipeProvider.a((IMaterial)Blocks.fO)).a(exporter);
        ShapelessRecipeBuilder.b(Blocks.hh).b(Blocks.cL, 9).b("has_ice", RecipeProvider.a((IMaterial)Blocks.cL)).a(exporter);
        RecipeProvider.a(exporter, (IMaterial)Items.oK, (IMaterial)Blocks.hl, "pink_dye", 2);
        RecipeProvider.a(exporter, (IMaterial)Items.oK, (IMaterial)Blocks.bD, "pink_dye");
        ShapelessRecipeBuilder.a(Items.oK, 2).c(Items.oS).c(Items.oE).b("pink_dye").b("has_white_dye", RecipeProvider.a(Items.oE)).b("has_red_dye", RecipeProvider.a(Items.oS)).a(exporter, "pink_dye_from_red_white_dye");
        ShapedRecipeBuilder.b(Blocks.bc).a(Character.valueOf('R'), Items.kn).a(Character.valueOf('#'), Blocks.m).a(Character.valueOf('T'), TagsItem.c).a(Character.valueOf('X'), Items.mq).b("TTT").b("#X#").b("#R#").b("has_redstone", RecipeProvider.a(Items.kn)).a(exporter);
        RecipeProvider.c(exporter, Blocks.cX, Blocks.cW);
        ShapedRecipeBuilder.b(Blocks.gE).a(Character.valueOf('S'), Items.rD).b("SS").b("SS").b("has_prismarine_shard", RecipeProvider.a(Items.rD)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.gF).a(Character.valueOf('S'), Items.rD).b("SSS").b("SSS").b("SSS").b("has_prismarine_shard", RecipeProvider.a(Items.rD)).a(exporter);
        ShapelessRecipeBuilder.b(Items.ry).c(Blocks.cS).c(Items.oW).c(Items.oo).b("has_carved_pumpkin", RecipeProvider.a((IMaterial)Blocks.dc)).b("has_pumpkin", RecipeProvider.a((IMaterial)Blocks.cS)).a(exporter);
        ShapelessRecipeBuilder.a(Items.pt, 4).c(Blocks.cS).b("has_pumpkin", RecipeProvider.a((IMaterial)Blocks.cS)).a(exporter);
        ShapelessRecipeBuilder.a(Items.oO, 2).c(Items.oP).c(Items.oS).b("has_blue_dye", RecipeProvider.a(Items.oP)).b("has_red_dye", RecipeProvider.a(Items.oS)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.jd).a(Character.valueOf('#'), Blocks.bX).a(Character.valueOf('-'), Items.sx).b("-").b("#").b("-").b("has_shulker_shell", RecipeProvider.a(Items.sx)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.iN, 4).a(Character.valueOf('F'), Items.sm).b("FF").b("FF").b("has_chorus_fruit_popped", RecipeProvider.a(Items.sm)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.iO).a(Character.valueOf('#'), Blocks.iq).b("#").b("#").b("has_purpur_block", RecipeProvider.a((IMaterial)Blocks.iN)).a(exporter);
        RecipeProvider.j((IMaterial)Blocks.iq, RecipeItemStack.a(Blocks.iN, Blocks.iO)).a("has_purpur_block", RecipeProvider.a((IMaterial)Blocks.iN)).a(exporter);
        RecipeProvider.k((IMaterial)Blocks.iP, RecipeItemStack.a(Blocks.iN, Blocks.iO)).a("has_purpur_block", RecipeProvider.a((IMaterial)Blocks.iN)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.fM).a(Character.valueOf('#'), Items.mn).b("##").b("##").b("has_quartz", RecipeProvider.a(Items.mn)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.nW, 4).a(Character.valueOf('#'), Blocks.fM).b("##").b("##").b("has_quartz_block", RecipeProvider.a((IMaterial)Blocks.fM)).a(exporter);
        RecipeProvider.j((IMaterial)Blocks.in, RecipeItemStack.a(Blocks.fN, Blocks.fM, Blocks.fO)).a("has_chiseled_quartz_block", RecipeProvider.a((IMaterial)Blocks.fN)).a("has_quartz_block", RecipeProvider.a((IMaterial)Blocks.fM)).a("has_quartz_pillar", RecipeProvider.a((IMaterial)Blocks.fO)).a(exporter);
        RecipeProvider.k((IMaterial)Blocks.fP, RecipeItemStack.a(Blocks.fN, Blocks.fM, Blocks.fO)).a("has_chiseled_quartz_block", RecipeProvider.a((IMaterial)Blocks.fN)).a("has_quartz_block", RecipeProvider.a((IMaterial)Blocks.fM)).a("has_quartz_pillar", RecipeProvider.a((IMaterial)Blocks.fO)).a(exporter);
        ShapelessRecipeBuilder.b(Items.rH).c(Items.rn).c(Items.rG).c(Items.nc).c(Items.rl).c(Blocks.bI).b("rabbit_stew").b("has_cooked_rabbit", RecipeProvider.a(Items.rG)).a(exporter, RecipeProvider.a((IMaterial)Items.rH, (IMaterial)Items.cF));
        ShapelessRecipeBuilder.b(Items.rH).c(Items.rn).c(Items.rG).c(Items.nc).c(Items.rl).c(Blocks.bJ).b("rabbit_stew").b("has_cooked_rabbit", RecipeProvider.a(Items.rG)).a(exporter, RecipeProvider.a((IMaterial)Items.rH, (IMaterial)Items.cG));
        ShapedRecipeBuilder.a(Blocks.co, 16).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.mq).b("X X").b("X#X").b("X X").b("has_minecart", RecipeProvider.a(Items.lM)).a(exporter);
        RecipeProvider.w(exporter, Items.kn, Items.kp);
        ShapedRecipeBuilder.b(Blocks.es).a(Character.valueOf('R'), Items.kn).a(Character.valueOf('G'), Blocks.da).b(" R ").b("RGR").b(" R ").b("has_glowstone", RecipeProvider.a((IMaterial)Blocks.da)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.cH).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), Items.kn).b("X").b("#").b("has_redstone", RecipeProvider.a(Items.kn)).a(exporter);
        RecipeProvider.a(exporter, (IMaterial)Items.oS, (IMaterial)Items.sn, "red_dye");
        RecipeProvider.a(exporter, (IMaterial)Items.oS, (IMaterial)Blocks.bw, "red_dye");
        RecipeProvider.a(exporter, (IMaterial)Items.oS, (IMaterial)Blocks.hk, "red_dye", 2);
        ShapelessRecipeBuilder.b(Items.oS).c(Blocks.bA).b("red_dye").b("has_red_flower", RecipeProvider.a((IMaterial)Blocks.bA)).a(exporter, "red_dye_from_tulip");
        ShapedRecipeBuilder.b(Blocks.iZ).a(Character.valueOf('W'), Items.pE).a(Character.valueOf('N'), Items.rC).b("NW").b("WN").b("has_nether_wart", RecipeProvider.a(Items.pE)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.hU).a(Character.valueOf('#'), Blocks.D).b("##").b("##").b("has_sand", RecipeProvider.a((IMaterial)Blocks.D)).a(exporter);
        RecipeProvider.j((IMaterial)Blocks.io, RecipeItemStack.a(Blocks.hU, Blocks.hV)).a("has_red_sandstone", RecipeProvider.a((IMaterial)Blocks.hU)).a("has_chiseled_red_sandstone", RecipeProvider.a((IMaterial)Blocks.hV)).a(exporter);
        RecipeProvider.k((IMaterial)Blocks.hX, RecipeItemStack.a(Blocks.hU, Blocks.hV, Blocks.hW)).a("has_red_sandstone", RecipeProvider.a((IMaterial)Blocks.hU)).a("has_chiseled_red_sandstone", RecipeProvider.a((IMaterial)Blocks.hV)).a("has_cut_red_sandstone", RecipeProvider.a((IMaterial)Blocks.hW)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.df).a(Character.valueOf('#'), Blocks.cH).a(Character.valueOf('X'), Items.kn).a(Character.valueOf('I'), Blocks.b).b("#X#").b("III").b("has_redstone_torch", RecipeProvider.a((IMaterial)Blocks.cH)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.az).a(Character.valueOf('#'), Blocks.C).b("##").b("##").b("has_sand", RecipeProvider.a((IMaterial)Blocks.C)).a(exporter);
        RecipeProvider.j((IMaterial)Blocks.ig, RecipeItemStack.a(Blocks.az, Blocks.aA)).a("has_sandstone", RecipeProvider.a((IMaterial)Blocks.az)).a("has_chiseled_sandstone", RecipeProvider.a((IMaterial)Blocks.aA)).a(exporter);
        RecipeProvider.k((IMaterial)Blocks.eu, RecipeItemStack.a(Blocks.az, Blocks.aA, Blocks.aB)).a("has_sandstone", RecipeProvider.a((IMaterial)Blocks.az)).a("has_chiseled_sandstone", RecipeProvider.a((IMaterial)Blocks.aA)).a("has_cut_sandstone", RecipeProvider.a((IMaterial)Blocks.aB)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.gN).a(Character.valueOf('S'), Items.rD).a(Character.valueOf('C'), Items.rE).b("SCS").b("CCC").b("SCS").b("has_prismarine_crystals", RecipeProvider.a(Items.rE)).a(exporter);
        ShapedRecipeBuilder.b(Items.pq).a(Character.valueOf('#'), Items.mq).b(" #").b("# ").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Items.sv).a(Character.valueOf('W'), TagsItem.c).a(Character.valueOf('o'), Items.mq).b("WoW").b("WWW").b(" W ").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        RecipeProvider.w(exporter, Items.on, Items.ku);
        RecipeProvider.d(exporter, Blocks.hW, Blocks.hU);
        RecipeProvider.d(exporter, Blocks.aB, Blocks.az);
        ShapedRecipeBuilder.b(Blocks.cM).a(Character.valueOf('#'), Items.oa).b("##").b("##").b("has_snowball", RecipeProvider.a(Items.oa)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.cK, 6).a(Character.valueOf('#'), Blocks.cM).b("###").b("has_snowball", RecipeProvider.a(Items.oa)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mt).a(Character.valueOf('L'), TagsItem.q).a(Character.valueOf('S'), Items.nb).a(Character.valueOf('#'), TagsItem.ab).b(" S ").b("S#S").b("LLL").b("has_stick", RecipeProvider.a(Items.nb)).b("has_soul_sand", RecipeProvider.a(TagsItem.ab)).a(exporter);
        ShapedRecipeBuilder.b(Items.pO).a(Character.valueOf('#'), Items.pD).a(Character.valueOf('X'), Items.pr).b("###").b("#X#").b("###").b("has_melon", RecipeProvider.a(Items.pr)).a(exporter);
        ShapedRecipeBuilder.a(Items.ss, 2).a(Character.valueOf('#'), Items.ou).a(Character.valueOf('X'), Items.mh).b(" # ").b("#X#").b(" # ").b("has_glowstone_dust", RecipeProvider.a(Items.ou)).a(exporter);
        ShapedRecipeBuilder.b(Items.ot).a(Character.valueOf('#'), Items.mo).a(Character.valueOf('X'), Items.ms).b(" # ").b(" X ").b(" X ").b("has_amethyst_shard", RecipeProvider.a(Items.mo)).a(exporter);
        ShapedRecipeBuilder.a(Items.nb, 4).a(Character.valueOf('#'), TagsItem.c).b("#").b("#").c("sticks").b("has_planks", RecipeProvider.a(TagsItem.c)).a(exporter);
        ShapedRecipeBuilder.a(Items.nb, 1).a(Character.valueOf('#'), Blocks.lm).b("#").b("#").c("sticks").b("has_bamboo", RecipeProvider.a((IMaterial)Blocks.lm)).a(exporter, "stick_from_bamboo_item");
        ShapedRecipeBuilder.b(Blocks.aV).a(Character.valueOf('P'), Blocks.bc).a(Character.valueOf('S'), Items.on).b("S").b("P").b("has_slime_ball", RecipeProvider.a(Items.on)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.dC, 4).a(Character.valueOf('#'), Blocks.b).b("##").b("##").b("has_stone", RecipeProvider.a((IMaterial)Blocks.b)).a(exporter);
        ShapedRecipeBuilder.b(Items.mF).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), TagsItem.ao).b("XX").b("X#").b(" #").b("has_cobblestone", RecipeProvider.a(TagsItem.ao)).a(exporter);
        RecipeProvider.j((IMaterial)Blocks.il, RecipeItemStack.a(Blocks.dC)).a("has_stone_bricks", RecipeProvider.a(TagsItem.d)).a(exporter);
        RecipeProvider.k((IMaterial)Blocks.eb, RecipeItemStack.a(Blocks.dC)).a("has_stone_bricks", RecipeProvider.a(TagsItem.d)).a(exporter);
        ShapedRecipeBuilder.b(Items.mG).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), TagsItem.ao).b("XX").b(" #").b(" #").b("has_cobblestone", RecipeProvider.a(TagsItem.ao)).a(exporter);
        ShapedRecipeBuilder.b(Items.mE).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), TagsItem.ao).b("XXX").b(" # ").b(" # ").b("has_cobblestone", RecipeProvider.a(TagsItem.ao)).a(exporter);
        ShapedRecipeBuilder.b(Items.mD).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), TagsItem.ao).b("X").b("#").b("#").b("has_cobblestone", RecipeProvider.a(TagsItem.ao)).a(exporter);
        RecipeProvider.i(exporter, Blocks.if, Blocks.ir);
        ShapedRecipeBuilder.b(Items.mC).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), TagsItem.ao).b("X").b("X").b("#").b("has_cobblestone", RecipeProvider.a(TagsItem.ao)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.be).a(Character.valueOf('#'), Items.ne).b("##").b("##").b("has_string", RecipeProvider.a(Items.ne)).a(exporter, RecipeProvider.a((IMaterial)Blocks.be, (IMaterial)Items.ne));
        RecipeProvider.a(exporter, (IMaterial)Items.oW, (IMaterial)Blocks.cP, "sugar");
        ShapelessRecipeBuilder.a(Items.oW, 3).c(Items.tw).b("sugar").b("has_honey_bottle", RecipeProvider.a(Items.tw)).a(exporter, RecipeProvider.a((IMaterial)Items.oW, (IMaterial)Items.tw));
        ShapedRecipeBuilder.b(Blocks.np).a(Character.valueOf('H'), Items.gi).a(Character.valueOf('R'), Items.kn).b(" R ").b("RHR").b(" R ").b("has_redstone", RecipeProvider.a(Items.kn)).b("has_hay_block", RecipeProvider.a((IMaterial)Blocks.gO)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.bN).a(Character.valueOf('#'), RecipeItemStack.a(Blocks.C, Blocks.D)).a(Character.valueOf('X'), Items.ng).b("X#X").b("#X#").b("X#X").b("has_gunpowder", RecipeProvider.a(Items.ng)).a(exporter);
        ShapedRecipeBuilder.b(Items.lP).a(Character.valueOf('A'), Blocks.bN).a(Character.valueOf('B'), Items.lM).b("A").b("B").b("has_minecart", RecipeProvider.a(Items.lM)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.bR, 4).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), RecipeItemStack.a(Items.mi, Items.mj)).b("X").b("#").b("has_stone_pickaxe", RecipeProvider.a(Items.mE)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.cY, 4).a(Character.valueOf('X'), RecipeItemStack.a(Items.mi, Items.mj)).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('S'), TagsItem.ab).b("X").b("#").b("S").b("has_soul_sand", RecipeProvider.a(TagsItem.ab)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mq).a(Character.valueOf('#'), Items.dC).a(Character.valueOf('X'), Items.sy).b("XXX").b("X#X").b("XXX").b("has_iron_nugget", RecipeProvider.a(Items.sy)).b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mr).a(Character.valueOf('#'), Items.eo).a(Character.valueOf('X'), Items.sy).b("XXX").b("X#X").b("XXX").b("has_soul_torch", RecipeProvider.a(Items.eo)).a(exporter);
        ShapelessRecipeBuilder.b(Blocks.fE).c(Blocks.bX).c(Blocks.ey).b("has_tripwire_hook", RecipeProvider.a((IMaterial)Blocks.ey)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.ey, 2).a(Character.valueOf('#'), TagsItem.c).a(Character.valueOf('S'), Items.nb).a(Character.valueOf('I'), Items.mq).b("I").b("S").b("#").b("has_string", RecipeProvider.a(Items.ne)).a(exporter);
        ShapedRecipeBuilder.b(Items.mc).a(Character.valueOf('X'), Items.md).b("XXX").b("X X").b("has_scute", RecipeProvider.a(Items.md)).a(exporter);
        ShapelessRecipeBuilder.a(Items.ni, 9).c(Blocks.gO).b("has_hay_block", RecipeProvider.a((IMaterial)Blocks.gO)).a(exporter);
        ShapelessRecipeBuilder.b(Items.oE).c(Items.oU).b("white_dye").b("has_bone_meal", RecipeProvider.a(Items.oU)).a(exporter);
        RecipeProvider.a(exporter, (IMaterial)Items.oE, (IMaterial)Blocks.bH, "white_dye");
        ShapedRecipeBuilder.b(Items.mA).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), TagsItem.c).b("XX").b("X#").b(" #").b("has_stick", RecipeProvider.a(Items.nb)).a(exporter);
        ShapedRecipeBuilder.b(Items.mB).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), TagsItem.c).b("XX").b(" #").b(" #").b("has_stick", RecipeProvider.a(Items.nb)).a(exporter);
        ShapedRecipeBuilder.b(Items.mz).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), TagsItem.c).b("XXX").b(" # ").b(" # ").b("has_stick", RecipeProvider.a(Items.nb)).a(exporter);
        ShapedRecipeBuilder.b(Items.my).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), TagsItem.c).b("X").b("#").b("#").b("has_stick", RecipeProvider.a(Items.nb)).a(exporter);
        ShapedRecipeBuilder.b(Items.mx).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('X'), TagsItem.c).b("X").b("X").b("#").b("has_stick", RecipeProvider.a(Items.nb)).a(exporter);
        ShapelessRecipeBuilder.b(Items.rg).c(Items.om).c(Items.oB).c(Items.nf).b("has_book", RecipeProvider.a(Items.om)).a(exporter);
        RecipeProvider.a(exporter, (IMaterial)Items.oI, (IMaterial)Blocks.bv, "yellow_dye");
        RecipeProvider.a(exporter, (IMaterial)Items.oI, (IMaterial)Blocks.hi, "yellow_dye", 2);
        RecipeProvider.w(exporter, Items.ps, Items.ok);
        ShapedRecipeBuilder.b(Blocks.lk).a(Character.valueOf('#'), Items.sR).a(Character.valueOf('X'), Items.sS).b("###").b("#X#").b("###").b("has_nautilus_core", RecipeProvider.a(Items.sS)).b("has_nautilus_shell", RecipeProvider.a(Items.sR)).a(exporter);
        RecipeProvider.b(exporter, (IMaterial)Blocks.lU, Blocks.hU);
        RecipeProvider.b(exporter, (IMaterial)Blocks.lX, Blocks.dC);
        RecipeProvider.b(exporter, (IMaterial)Blocks.mb, Blocks.az);
        ShapelessRecipeBuilder.b(Items.sX).c(Items.ol).c(Items.rv).b("has_creeper_head", RecipeProvider.a(Items.rv)).a(exporter);
        ShapelessRecipeBuilder.b(Items.sY).c(Items.ol).c(Items.rs).b("has_wither_skeleton_skull", RecipeProvider.a(Items.rs)).a(exporter);
        ShapelessRecipeBuilder.b(Items.sW).c(Items.ol).c(Blocks.bE).b("has_oxeye_daisy", RecipeProvider.a((IMaterial)Blocks.bE)).a(exporter);
        ShapelessRecipeBuilder.b(Items.sZ).c(Items.ol).c(Items.nN).b("has_enchanted_golden_apple", RecipeProvider.a(Items.nN)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.me, 6).a(Character.valueOf('~'), Items.ne).a(Character.valueOf('I'), Blocks.lm).b("I~I").b("I I").b("I I").b("has_bamboo", RecipeProvider.a((IMaterial)Blocks.lm)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.ml).a(Character.valueOf('I'), Items.nb).a(Character.valueOf('-'), Blocks.ie).a(Character.valueOf('#'), TagsItem.c).b("I-I").b("# #").b("has_stone_slab", RecipeProvider.a((IMaterial)Blocks.ie)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mi).a(Character.valueOf('#'), Blocks.ir).a(Character.valueOf('X'), Blocks.cf).a(Character.valueOf('I'), Items.mq).b("III").b("IXI").b("###").b("has_smooth_stone", RecipeProvider.a((IMaterial)Blocks.ir)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mh).a(Character.valueOf('#'), TagsItem.q).a(Character.valueOf('X'), Blocks.cf).b(" # ").b("#X#").b(" # ").b("has_furnace", RecipeProvider.a((IMaterial)Blocks.cf)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mj).a(Character.valueOf('#'), TagsItem.c).a(Character.valueOf('@'), Items.ol).b("@@").b("##").b("##").b("has_paper", RecipeProvider.a(Items.ol)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mn).a(Character.valueOf('#'), TagsItem.c).a(Character.valueOf('@'), Items.mq).b("@@").b("##").b("##").b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mk).a(Character.valueOf('#'), TagsItem.c).a(Character.valueOf('@'), Items.nI).b("@@").b("##").b("##").b("has_flint", RecipeProvider.a(Items.nI)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.mo).a(Character.valueOf('I'), Items.mq).a(Character.valueOf('#'), Blocks.b).b(" I ").b("###").b("has_stone", RecipeProvider.a((IMaterial)Blocks.b)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.nC).a(Character.valueOf('S'), Items.eA).a(Character.valueOf('#'), Items.mv).b("SSS").b("S#S").b("SSS").b("has_netherite_ingot", RecipeProvider.a(Items.mv)).a(exporter);
        RecipeProvider.b(exporter, Items.mv, Items.ar, "netherite_ingot_from_netherite_block", "netherite_ingot");
        ShapelessRecipeBuilder.b(Items.mv).b(Items.mw, 4).b(Items.mu, 4).b("netherite_ingot").b("has_netherite_scrap", RecipeProvider.a(Items.mw)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.nx).a(Character.valueOf('O'), Blocks.nw).a(Character.valueOf('G'), Blocks.da).b("OOO").b("GGG").b("OOO").b("has_obsidian", RecipeProvider.a((IMaterial)Blocks.nw)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.dQ).a(Character.valueOf('I'), Items.mq).a(Character.valueOf('N'), Items.sy).b("N").b("I").b("N").b("has_iron_nugget", RecipeProvider.a(Items.sy)).b("has_iron_ingot", RecipeProvider.a(Items.mq)).a(exporter);
        ShapedRecipeBuilder.a(Blocks.oN, 2).a(Character.valueOf('G'), Blocks.au).a(Character.valueOf('S'), Items.mo).b(" S ").b("SGS").b(" S ").b("has_amethyst_shard", RecipeProvider.a(Items.mo)).a(exporter);
        ShapedRecipeBuilder.b(Blocks.oF).a(Character.valueOf('S'), Items.mo).b("SS").b("SS").b("has_amethyst_shard", RecipeProvider.a(Items.mo)).a(exporter);
        SpecialRecipeBuilder.a(RecipeSerializer.c).a(exporter, "armor_dye");
        SpecialRecipeBuilder.a(RecipeSerializer.k).a(exporter, "banner_duplicate");
        SpecialRecipeBuilder.a(RecipeSerializer.d).a(exporter, "book_cloning");
        SpecialRecipeBuilder.a(RecipeSerializer.g).a(exporter, "firework_rocket");
        SpecialRecipeBuilder.a(RecipeSerializer.h).a(exporter, "firework_star");
        SpecialRecipeBuilder.a(RecipeSerializer.i).a(exporter, "firework_star_fade");
        SpecialRecipeBuilder.a(RecipeSerializer.e).a(exporter, "map_cloning");
        SpecialRecipeBuilder.a(RecipeSerializer.f).a(exporter, "map_extending");
        SpecialRecipeBuilder.a(RecipeSerializer.o).a(exporter, "repair_item");
        SpecialRecipeBuilder.a(RecipeSerializer.l).a(exporter, "shield_decoration");
        SpecialRecipeBuilder.a(RecipeSerializer.m).a(exporter, "shulker_box_coloring");
        SpecialRecipeBuilder.a(RecipeSerializer.j).a(exporter, "tipped_arrow");
        SpecialRecipeBuilder.a(RecipeSerializer.n).a(exporter, "suspicious_stew");
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.rm), Items.rn, 0.35f, 200).b("has_potato", RecipeProvider.a(Items.rm)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.oj), Items.oi, 0.3f, 200).b("has_clay_ball", RecipeProvider.a(Items.oj)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(TagsItem.p), Items.mj, 0.15f, 200).b("has_log", RecipeProvider.a(TagsItem.p)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.sl), Items.sm, 0.1f, 200).b("has_chorus_fruit", RecipeProvider.a(Items.sl)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.pv), Items.pw, 0.35f, 200).b("has_beef", RecipeProvider.a(Items.pv)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.px), Items.py, 0.35f, 200).b("has_chicken", RecipeProvider.a(Items.px)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.ov), Items.oz, 0.35f, 200).b("has_cod", RecipeProvider.a(Items.ov)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.kq), Items.ps, 0.1f, 200).b("has_kelp", RecipeProvider.a((IMaterial)Blocks.kq)).a(exporter, RecipeProvider.e(Items.ps));
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.ow), Items.oA, 0.35f, 200).b("has_salmon", RecipeProvider.a(Items.ow)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.rS), Items.rT, 0.35f, 200).b("has_mutton", RecipeProvider.a(Items.rS)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.nJ), Items.nK, 0.35f, 200).b("has_porkchop", RecipeProvider.a(Items.nJ)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.rF), Items.rG, 0.35f, 200).b("has_rabbit", RecipeProvider.a(Items.rF)).a(exporter);
        RecipeProvider.a(exporter, d, Items.mi, 0.1f, 200, "coal");
        RecipeProvider.a(exporter, e, Items.mq, 0.7f, 200, "iron_ingot");
        RecipeProvider.a(exporter, f, Items.ms, 0.7f, 200, "copper_ingot");
        RecipeProvider.a(exporter, g, Items.mu, 1.0f, 200, "gold_ingot");
        RecipeProvider.a(exporter, h, Items.mk, 1.0f, 200, "diamond");
        RecipeProvider.a(exporter, i, Items.mm, 0.2f, 200, "lapis_lazuli");
        RecipeProvider.a(exporter, j, Items.kn, 0.7f, 200, "redstone");
        RecipeProvider.a(exporter, k, Items.ml, 1.0f, 200, "emerald");
        RecipeProvider.w(exporter, Items.mp, Items.ai);
        RecipeProvider.w(exporter, Items.mr, Items.aj);
        RecipeProvider.w(exporter, Items.mt, Items.ak);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(TagsItem.A), Blocks.au.k(), 0.1f, 200).b("has_sand", RecipeProvider.a(TagsItem.A)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.li), Items.oJ, 0.1f, 200).b("has_sea_pickle", RecipeProvider.a((IMaterial)Blocks.li)).a(exporter, RecipeProvider.e(Items.oJ));
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.cN.k()), Items.oR, 1.0f, 200).b("has_cactus", RecipeProvider.a((IMaterial)Blocks.cN)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.mJ, Items.mI, Items.mK, Items.mL, Items.mH, Items.nA, Items.nB, Items.nC, Items.nD, Items.rM), Items.pD, 0.1f, 200).b("has_golden_pickaxe", RecipeProvider.a(Items.mJ)).b("has_golden_shovel", RecipeProvider.a(Items.mI)).b("has_golden_axe", RecipeProvider.a(Items.mK)).b("has_golden_hoe", RecipeProvider.a(Items.mL)).b("has_golden_sword", RecipeProvider.a(Items.mH)).b("has_golden_helmet", RecipeProvider.a(Items.nA)).b("has_golden_chestplate", RecipeProvider.a(Items.nB)).b("has_golden_leggings", RecipeProvider.a(Items.nC)).b("has_golden_boots", RecipeProvider.a(Items.nD)).b("has_golden_horse_armor", RecipeProvider.a(Items.rM)).a(exporter, RecipeProvider.e(Items.pD));
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Items.mO, Items.mN, Items.mP, Items.mQ, Items.mM, Items.ns, Items.nt, Items.nu, Items.nv, Items.rL, Items.no, Items.np, Items.nq, Items.nr), Items.sy, 0.1f, 200).b("has_iron_pickaxe", RecipeProvider.a(Items.mO)).b("has_iron_shovel", RecipeProvider.a(Items.mN)).b("has_iron_axe", RecipeProvider.a(Items.mP)).b("has_iron_hoe", RecipeProvider.a(Items.mQ)).b("has_iron_sword", RecipeProvider.a(Items.mM)).b("has_iron_helmet", RecipeProvider.a(Items.ns)).b("has_iron_chestplate", RecipeProvider.a(Items.nt)).b("has_iron_leggings", RecipeProvider.a(Items.nu)).b("has_iron_boots", RecipeProvider.a(Items.nv)).b("has_iron_horse_armor", RecipeProvider.a(Items.rL)).b("has_chainmail_helmet", RecipeProvider.a(Items.no)).b("has_chainmail_chestplate", RecipeProvider.a(Items.np)).b("has_chainmail_leggings", RecipeProvider.a(Items.nq)).b("has_chainmail_boots", RecipeProvider.a(Items.nr)).a(exporter, RecipeProvider.e(Items.sy));
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.cO), Blocks.hf.k(), 0.35f, 200).b("has_clay_block", RecipeProvider.a((IMaterial)Blocks.cO)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.cT), Items.rC, 0.1f, 200).b("has_netherrack", RecipeProvider.a((IMaterial)Blocks.cT)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.fK), Items.mn, 0.2f, 200).b("has_nether_quartz_ore", RecipeProvider.a((IMaterial)Blocks.fK)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.at), Blocks.as.k(), 0.15f, 200).b("has_wet_sponge", RecipeProvider.a((IMaterial)Blocks.at)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.m), Blocks.b.k(), 0.1f, 200).b("has_cobblestone", RecipeProvider.a((IMaterial)Blocks.m)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.b), Blocks.ir.k(), 0.1f, 200).b("has_stone", RecipeProvider.a((IMaterial)Blocks.b)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.az), Blocks.is.k(), 0.1f, 200).b("has_sandstone", RecipeProvider.a((IMaterial)Blocks.az)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.hU), Blocks.iu.k(), 0.1f, 200).b("has_red_sandstone", RecipeProvider.a((IMaterial)Blocks.hU)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.fM), Blocks.it.k(), 0.1f, 200).b("has_quartz_block", RecipeProvider.a((IMaterial)Blocks.fM)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.dC), Blocks.dE.k(), 0.1f, 200).b("has_stone_bricks", RecipeProvider.a((IMaterial)Blocks.dC)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.gh), Blocks.jJ.k(), 0.1f, 200).b("has_black_terracotta", RecipeProvider.a((IMaterial)Blocks.gh)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.gd), Blocks.jF.k(), 0.1f, 200).b("has_blue_terracotta", RecipeProvider.a((IMaterial)Blocks.gd)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.ge), Blocks.jG.k(), 0.1f, 200).b("has_brown_terracotta", RecipeProvider.a((IMaterial)Blocks.ge)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.gb), Blocks.jD.k(), 0.1f, 200).b("has_cyan_terracotta", RecipeProvider.a((IMaterial)Blocks.gb)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.fZ), Blocks.jB.k(), 0.1f, 200).b("has_gray_terracotta", RecipeProvider.a((IMaterial)Blocks.fZ)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.gf), Blocks.jH.k(), 0.1f, 200).b("has_green_terracotta", RecipeProvider.a((IMaterial)Blocks.gf)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.fV), Blocks.jx.k(), 0.1f, 200).b("has_light_blue_terracotta", RecipeProvider.a((IMaterial)Blocks.fV)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.ga), Blocks.jC.k(), 0.1f, 200).b("has_light_gray_terracotta", RecipeProvider.a((IMaterial)Blocks.ga)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.fX), Blocks.jz.k(), 0.1f, 200).b("has_lime_terracotta", RecipeProvider.a((IMaterial)Blocks.fX)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.fU), Blocks.jw.k(), 0.1f, 200).b("has_magenta_terracotta", RecipeProvider.a((IMaterial)Blocks.fU)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.fT), Blocks.jv.k(), 0.1f, 200).b("has_orange_terracotta", RecipeProvider.a((IMaterial)Blocks.fT)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.fY), Blocks.jA.k(), 0.1f, 200).b("has_pink_terracotta", RecipeProvider.a((IMaterial)Blocks.fY)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.gc), Blocks.jE.k(), 0.1f, 200).b("has_purple_terracotta", RecipeProvider.a((IMaterial)Blocks.gc)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.gg), Blocks.jI.k(), 0.1f, 200).b("has_red_terracotta", RecipeProvider.a((IMaterial)Blocks.gg)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.fS), Blocks.ju.k(), 0.1f, 200).b("has_white_terracotta", RecipeProvider.a((IMaterial)Blocks.fS)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.fW), Blocks.jy.k(), 0.1f, 200).b("has_yellow_terracotta", RecipeProvider.a((IMaterial)Blocks.fW)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.nv), Items.mw, 2.0f, 200).b("has_ancient_debris", RecipeProvider.a((IMaterial)Blocks.nv)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.cW), Blocks.qi, 0.1f, 200).b("has_basalt", RecipeProvider.a((IMaterial)Blocks.cW)).a(exporter);
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(Blocks.pO), Blocks.pN, 0.1f, 200).b("has_cobbled_deepslate", RecipeProvider.a((IMaterial)Blocks.pO)).a(exporter);
        RecipeProvider.b(exporter, d, Items.mi, 0.1f, 100, "coal");
        RecipeProvider.b(exporter, e, Items.mq, 0.7f, 100, "iron_ingot");
        RecipeProvider.b(exporter, f, Items.ms, 0.7f, 100, "copper_ingot");
        RecipeProvider.b(exporter, g, Items.mu, 1.0f, 100, "gold_ingot");
        RecipeProvider.b(exporter, h, Items.mk, 1.0f, 100, "diamond");
        RecipeProvider.b(exporter, i, Items.mm, 0.2f, 100, "lapis_lazuli");
        RecipeProvider.b(exporter, j, Items.kn, 0.7f, 100, "redstone");
        RecipeProvider.b(exporter, k, Items.ml, 1.0f, 100, "emerald");
        SimpleCookingRecipeBuilder.b(RecipeItemStack.a(Blocks.fK), Items.mn, 0.2f, 100).b("has_nether_quartz_ore", RecipeProvider.a((IMaterial)Blocks.fK)).a(exporter, RecipeProvider.f(Items.mn));
        SimpleCookingRecipeBuilder.b(RecipeItemStack.a(Items.mJ, Items.mI, Items.mK, Items.mL, Items.mH, Items.nA, Items.nB, Items.nC, Items.nD, Items.rM), Items.pD, 0.1f, 100).b("has_golden_pickaxe", RecipeProvider.a(Items.mJ)).b("has_golden_shovel", RecipeProvider.a(Items.mI)).b("has_golden_axe", RecipeProvider.a(Items.mK)).b("has_golden_hoe", RecipeProvider.a(Items.mL)).b("has_golden_sword", RecipeProvider.a(Items.mH)).b("has_golden_helmet", RecipeProvider.a(Items.nA)).b("has_golden_chestplate", RecipeProvider.a(Items.nB)).b("has_golden_leggings", RecipeProvider.a(Items.nC)).b("has_golden_boots", RecipeProvider.a(Items.nD)).b("has_golden_horse_armor", RecipeProvider.a(Items.rM)).a(exporter, RecipeProvider.f(Items.pD));
        SimpleCookingRecipeBuilder.b(RecipeItemStack.a(Items.mO, Items.mN, Items.mP, Items.mQ, Items.mM, Items.ns, Items.nt, Items.nu, Items.nv, Items.rL, Items.no, Items.np, Items.nq, Items.nr), Items.sy, 0.1f, 100).b("has_iron_pickaxe", RecipeProvider.a(Items.mO)).b("has_iron_shovel", RecipeProvider.a(Items.mN)).b("has_iron_axe", RecipeProvider.a(Items.mP)).b("has_iron_hoe", RecipeProvider.a(Items.mQ)).b("has_iron_sword", RecipeProvider.a(Items.mM)).b("has_iron_helmet", RecipeProvider.a(Items.ns)).b("has_iron_chestplate", RecipeProvider.a(Items.nt)).b("has_iron_leggings", RecipeProvider.a(Items.nu)).b("has_iron_boots", RecipeProvider.a(Items.nv)).b("has_iron_horse_armor", RecipeProvider.a(Items.rL)).b("has_chainmail_helmet", RecipeProvider.a(Items.no)).b("has_chainmail_chestplate", RecipeProvider.a(Items.np)).b("has_chainmail_leggings", RecipeProvider.a(Items.nq)).b("has_chainmail_boots", RecipeProvider.a(Items.nr)).a(exporter, RecipeProvider.f(Items.sy));
        SimpleCookingRecipeBuilder.b(RecipeItemStack.a(Blocks.nv), Items.mw, 2.0f, 100).b("has_ancient_debris", RecipeProvider.a((IMaterial)Blocks.nv)).a(exporter, RecipeProvider.f(Items.mw));
        RecipeProvider.a(exporter, "smoking", RecipeSerializer.r, 100);
        RecipeProvider.a(exporter, "campfire_cooking", RecipeSerializer.s, 600);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ie, (IMaterial)Blocks.b, 2);
        RecipeProvider.u(exporter, Blocks.lx, Blocks.b);
        RecipeProvider.u(exporter, Blocks.dC, Blocks.b);
        RecipeProvider.a(exporter, (IMaterial)Blocks.il, (IMaterial)Blocks.b, 2);
        RecipeProvider.u(exporter, Blocks.eb, Blocks.b);
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.b), Blocks.dF).b("has_stone", RecipeProvider.a((IMaterial)Blocks.b)).a(exporter, "chiseled_stone_bricks_stone_from_stonecutting");
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.b), Blocks.lX).b("has_stone", RecipeProvider.a((IMaterial)Blocks.b)).a(exporter, "stone_brick_walls_from_stone_stonecutting");
        RecipeProvider.u(exporter, Blocks.aB, Blocks.az);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ig, (IMaterial)Blocks.az, 2);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ih, (IMaterial)Blocks.az, 2);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ih, (IMaterial)Blocks.aB, 2);
        RecipeProvider.u(exporter, Blocks.eu, Blocks.az);
        RecipeProvider.u(exporter, Blocks.mb, Blocks.az);
        RecipeProvider.u(exporter, Blocks.aA, Blocks.az);
        RecipeProvider.u(exporter, Blocks.hW, Blocks.hU);
        RecipeProvider.a(exporter, (IMaterial)Blocks.io, (IMaterial)Blocks.hU, 2);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ip, (IMaterial)Blocks.hU, 2);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ip, (IMaterial)Blocks.hW, 2);
        RecipeProvider.u(exporter, Blocks.hX, Blocks.hU);
        RecipeProvider.u(exporter, Blocks.lU, Blocks.hU);
        RecipeProvider.u(exporter, Blocks.hV, Blocks.hU);
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.fM), Blocks.in, 2).b("has_quartz_block", RecipeProvider.a((IMaterial)Blocks.fM)).a(exporter, "quartz_slab_from_stonecutting");
        RecipeProvider.u(exporter, Blocks.fP, Blocks.fM);
        RecipeProvider.u(exporter, Blocks.fO, Blocks.fM);
        RecipeProvider.u(exporter, Blocks.fN, Blocks.fM);
        RecipeProvider.u(exporter, Blocks.nW, Blocks.fM);
        RecipeProvider.u(exporter, Blocks.cp, Blocks.m);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ij, (IMaterial)Blocks.m, 2);
        RecipeProvider.u(exporter, Blocks.eG, Blocks.m);
        RecipeProvider.a(exporter, (IMaterial)Blocks.il, (IMaterial)Blocks.dC, 2);
        RecipeProvider.u(exporter, Blocks.eb, Blocks.dC);
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.dC), Blocks.lX).b("has_stone_bricks", RecipeProvider.a((IMaterial)Blocks.dC)).a(exporter, "stone_brick_wall_from_stone_bricks_stonecutting");
        RecipeProvider.u(exporter, Blocks.dF, Blocks.dC);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ik, (IMaterial)Blocks.bM, 2);
        RecipeProvider.u(exporter, Blocks.ea, Blocks.bM);
        RecipeProvider.u(exporter, Blocks.lS, Blocks.bM);
        RecipeProvider.a(exporter, (IMaterial)Blocks.im, (IMaterial)Blocks.ee, 2);
        RecipeProvider.u(exporter, Blocks.eg, Blocks.ee);
        RecipeProvider.u(exporter, Blocks.lY, Blocks.ee);
        RecipeProvider.u(exporter, Blocks.nU, Blocks.ee);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lP, (IMaterial)Blocks.iZ, 2);
        RecipeProvider.u(exporter, Blocks.lC, Blocks.iZ);
        RecipeProvider.u(exporter, Blocks.ma, Blocks.iZ);
        RecipeProvider.a(exporter, (IMaterial)Blocks.iq, (IMaterial)Blocks.iN, 2);
        RecipeProvider.u(exporter, Blocks.iP, Blocks.iN);
        RecipeProvider.u(exporter, Blocks.iO, Blocks.iN);
        RecipeProvider.a(exporter, (IMaterial)Blocks.gK, (IMaterial)Blocks.gE, 2);
        RecipeProvider.u(exporter, Blocks.gH, Blocks.gE);
        RecipeProvider.u(exporter, Blocks.lT, Blocks.gE);
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.gF), Blocks.gL, 2).b("has_prismarine_brick", RecipeProvider.a((IMaterial)Blocks.gF)).a(exporter, "prismarine_brick_slab_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.gF), Blocks.gI).b("has_prismarine_brick", RecipeProvider.a((IMaterial)Blocks.gF)).a(exporter, "prismarine_brick_stairs_from_prismarine_stonecutting");
        RecipeProvider.a(exporter, (IMaterial)Blocks.gM, (IMaterial)Blocks.gG, 2);
        RecipeProvider.u(exporter, Blocks.gJ, Blocks.gG);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lO, (IMaterial)Blocks.g, 2);
        RecipeProvider.u(exporter, Blocks.lB, Blocks.g);
        RecipeProvider.u(exporter, Blocks.lZ, Blocks.g);
        RecipeProvider.u(exporter, Blocks.h, Blocks.g);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lQ, (IMaterial)Blocks.g, 2);
        RecipeProvider.u(exporter, Blocks.lD, Blocks.g);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lQ, (IMaterial)Blocks.h, 2);
        RecipeProvider.u(exporter, Blocks.lD, Blocks.h);
        RecipeProvider.u(exporter, Blocks.cX, Blocks.cW);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lN, (IMaterial)Blocks.c, 2);
        RecipeProvider.u(exporter, Blocks.lA, Blocks.c);
        RecipeProvider.u(exporter, Blocks.lW, Blocks.c);
        RecipeProvider.u(exporter, Blocks.d, Blocks.c);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lF, (IMaterial)Blocks.c, 2);
        RecipeProvider.u(exporter, Blocks.lr, Blocks.c);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lF, (IMaterial)Blocks.d, 2);
        RecipeProvider.u(exporter, Blocks.lr, Blocks.d);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lR, (IMaterial)Blocks.e, 2);
        RecipeProvider.u(exporter, Blocks.lE, Blocks.e);
        RecipeProvider.u(exporter, Blocks.md, Blocks.e);
        RecipeProvider.u(exporter, Blocks.f, Blocks.e);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lI, (IMaterial)Blocks.e, 2);
        RecipeProvider.u(exporter, Blocks.lu, Blocks.e);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lI, (IMaterial)Blocks.f, 2);
        RecipeProvider.u(exporter, Blocks.lu, Blocks.f);
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.dD), Blocks.lH, 2).b("has_mossy_stone_bricks", RecipeProvider.a((IMaterial)Blocks.dD)).a(exporter, "mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.dD), Blocks.lt).b("has_mossy_stone_bricks", RecipeProvider.a((IMaterial)Blocks.dD)).a(exporter, "mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.dD), Blocks.lV).b("has_mossy_stone_bricks", RecipeProvider.a((IMaterial)Blocks.dD)).a(exporter, "mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting");
        RecipeProvider.a(exporter, (IMaterial)Blocks.lJ, (IMaterial)Blocks.bP, 2);
        RecipeProvider.u(exporter, Blocks.lv, Blocks.bP);
        RecipeProvider.u(exporter, Blocks.eH, Blocks.bP);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lL, (IMaterial)Blocks.is, 2);
        RecipeProvider.u(exporter, Blocks.ly, Blocks.is);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lG, (IMaterial)Blocks.iu, 2);
        RecipeProvider.u(exporter, Blocks.ls, Blocks.iu);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lM, (IMaterial)Blocks.it, 2);
        RecipeProvider.u(exporter, Blocks.lz, Blocks.it);
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.iQ), Blocks.lK, 2).b("has_end_stone_brick", RecipeProvider.a((IMaterial)Blocks.iQ)).a(exporter, "end_stone_brick_slab_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.iQ), Blocks.lw).b("has_end_stone_brick", RecipeProvider.a((IMaterial)Blocks.iQ)).a(exporter, "end_stone_brick_stairs_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.a(RecipeItemStack.a(Blocks.iQ), Blocks.mc).b("has_end_stone_brick", RecipeProvider.a((IMaterial)Blocks.iQ)).a(exporter, "end_stone_brick_wall_from_end_stone_brick_stonecutting");
        RecipeProvider.u(exporter, Blocks.iQ, Blocks.eq);
        RecipeProvider.a(exporter, (IMaterial)Blocks.lK, (IMaterial)Blocks.eq, 2);
        RecipeProvider.u(exporter, Blocks.lw, Blocks.eq);
        RecipeProvider.u(exporter, Blocks.mc, Blocks.eq);
        RecipeProvider.a(exporter, (IMaterial)Blocks.if, (IMaterial)Blocks.ir, 2);
        RecipeProvider.a(exporter, (IMaterial)Blocks.nG, (IMaterial)Blocks.nD, 2);
        RecipeProvider.u(exporter, Blocks.nE, Blocks.nD);
        RecipeProvider.u(exporter, Blocks.nF, Blocks.nD);
        RecipeProvider.u(exporter, Blocks.nH, Blocks.nD);
        RecipeProvider.u(exporter, Blocks.nT, Blocks.nD);
        RecipeProvider.a(exporter, (IMaterial)Blocks.nQ, (IMaterial)Blocks.nD, 2);
        RecipeProvider.u(exporter, Blocks.nP, Blocks.nD);
        RecipeProvider.u(exporter, Blocks.nK, Blocks.nD);
        RecipeProvider.u(exporter, Blocks.nI, Blocks.nD);
        RecipeProvider.a(exporter, (IMaterial)Blocks.nL, (IMaterial)Blocks.nD, 2);
        RecipeProvider.u(exporter, Blocks.nM, Blocks.nD);
        RecipeProvider.u(exporter, Blocks.nN, Blocks.nD);
        RecipeProvider.a(exporter, (IMaterial)Blocks.nQ, (IMaterial)Blocks.nH, 2);
        RecipeProvider.u(exporter, Blocks.nP, Blocks.nH);
        RecipeProvider.u(exporter, Blocks.nI, Blocks.nH);
        RecipeProvider.u(exporter, Blocks.nT, Blocks.nH);
        RecipeProvider.a(exporter, (IMaterial)Blocks.nL, (IMaterial)Blocks.nH, 2);
        RecipeProvider.u(exporter, Blocks.nM, Blocks.nH);
        RecipeProvider.u(exporter, Blocks.nN, Blocks.nH);
        RecipeProvider.u(exporter, Blocks.nK, Blocks.nH);
        RecipeProvider.a(exporter, (IMaterial)Blocks.nL, (IMaterial)Blocks.nI, 2);
        RecipeProvider.u(exporter, Blocks.nM, Blocks.nI);
        RecipeProvider.u(exporter, Blocks.nN, Blocks.nI);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ph, (IMaterial)Blocks.oZ, 2);
        RecipeProvider.u(exporter, Blocks.pd, Blocks.oZ);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pg, (IMaterial)Blocks.oY, 2);
        RecipeProvider.u(exporter, Blocks.pc, Blocks.oY);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pf, (IMaterial)Blocks.oX, 2);
        RecipeProvider.u(exporter, Blocks.pb, Blocks.oX);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pe, (IMaterial)Blocks.oW, 2);
        RecipeProvider.u(exporter, Blocks.pa, Blocks.oW);
        RecipeProvider.a(exporter, (IMaterial)Blocks.px, (IMaterial)Blocks.pp, 2);
        RecipeProvider.u(exporter, Blocks.pt, Blocks.pp);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pw, (IMaterial)Blocks.po, 2);
        RecipeProvider.u(exporter, Blocks.ps, Blocks.po);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pv, (IMaterial)Blocks.pn, 2);
        RecipeProvider.u(exporter, Blocks.pr, Blocks.pn);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pu, (IMaterial)Blocks.pm, 2);
        RecipeProvider.u(exporter, Blocks.pq, Blocks.pm);
        RecipeProvider.a(exporter, (IMaterial)Blocks.oZ, (IMaterial)Blocks.oT, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pd, (IMaterial)Blocks.oT, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ph, (IMaterial)Blocks.oT, 8);
        RecipeProvider.a(exporter, (IMaterial)Blocks.oY, (IMaterial)Blocks.oS, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pc, (IMaterial)Blocks.oS, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pg, (IMaterial)Blocks.oS, 8);
        RecipeProvider.a(exporter, (IMaterial)Blocks.oX, (IMaterial)Blocks.oR, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pb, (IMaterial)Blocks.oR, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pf, (IMaterial)Blocks.oR, 8);
        RecipeProvider.a(exporter, (IMaterial)Blocks.oW, (IMaterial)Blocks.oQ, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pa, (IMaterial)Blocks.oQ, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pe, (IMaterial)Blocks.oQ, 8);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pp, (IMaterial)Blocks.pi, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pt, (IMaterial)Blocks.pi, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.px, (IMaterial)Blocks.pi, 8);
        RecipeProvider.a(exporter, (IMaterial)Blocks.po, (IMaterial)Blocks.pk, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.ps, (IMaterial)Blocks.pk, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pw, (IMaterial)Blocks.pk, 8);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pn, (IMaterial)Blocks.pj, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pr, (IMaterial)Blocks.pj, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pv, (IMaterial)Blocks.pj, 8);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pm, (IMaterial)Blocks.pl, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pq, (IMaterial)Blocks.pl, 4);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pu, (IMaterial)Blocks.pl, 8);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pQ, (IMaterial)Blocks.pO, 2);
        RecipeProvider.u(exporter, Blocks.pP, Blocks.pO);
        RecipeProvider.u(exporter, Blocks.pR, Blocks.pO);
        RecipeProvider.u(exporter, Blocks.qe, Blocks.pO);
        RecipeProvider.u(exporter, Blocks.pS, Blocks.pO);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pU, (IMaterial)Blocks.pO, 2);
        RecipeProvider.u(exporter, Blocks.pT, Blocks.pO);
        RecipeProvider.u(exporter, Blocks.pV, Blocks.pO);
        RecipeProvider.u(exporter, Blocks.qa, Blocks.pO);
        RecipeProvider.a(exporter, (IMaterial)Blocks.qc, (IMaterial)Blocks.pO, 2);
        RecipeProvider.u(exporter, Blocks.qb, Blocks.pO);
        RecipeProvider.u(exporter, Blocks.qd, Blocks.pO);
        RecipeProvider.u(exporter, Blocks.pW, Blocks.pO);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pY, (IMaterial)Blocks.pO, 2);
        RecipeProvider.u(exporter, Blocks.pX, Blocks.pO);
        RecipeProvider.u(exporter, Blocks.pZ, Blocks.pO);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pU, (IMaterial)Blocks.pS, 2);
        RecipeProvider.u(exporter, Blocks.pT, Blocks.pS);
        RecipeProvider.u(exporter, Blocks.pV, Blocks.pS);
        RecipeProvider.u(exporter, Blocks.qa, Blocks.pS);
        RecipeProvider.a(exporter, (IMaterial)Blocks.qc, (IMaterial)Blocks.pS, 2);
        RecipeProvider.u(exporter, Blocks.qb, Blocks.pS);
        RecipeProvider.u(exporter, Blocks.qd, Blocks.pS);
        RecipeProvider.u(exporter, Blocks.pW, Blocks.pS);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pY, (IMaterial)Blocks.pS, 2);
        RecipeProvider.u(exporter, Blocks.pX, Blocks.pS);
        RecipeProvider.u(exporter, Blocks.pZ, Blocks.pS);
        RecipeProvider.a(exporter, (IMaterial)Blocks.qc, (IMaterial)Blocks.qa, 2);
        RecipeProvider.u(exporter, Blocks.qb, Blocks.qa);
        RecipeProvider.u(exporter, Blocks.qd, Blocks.qa);
        RecipeProvider.u(exporter, Blocks.pW, Blocks.qa);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pY, (IMaterial)Blocks.qa, 2);
        RecipeProvider.u(exporter, Blocks.pX, Blocks.qa);
        RecipeProvider.u(exporter, Blocks.pZ, Blocks.qa);
        RecipeProvider.a(exporter, (IMaterial)Blocks.pY, (IMaterial)Blocks.pW, 2);
        RecipeProvider.u(exporter, Blocks.pX, Blocks.pW);
        RecipeProvider.u(exporter, Blocks.pZ, Blocks.pW);
        RecipeProvider.a(exporter, Items.nx, Items.nF);
        RecipeProvider.a(exporter, Items.ny, Items.nG);
        RecipeProvider.a(exporter, Items.nw, Items.nE);
        RecipeProvider.a(exporter, Items.nz, Items.nH);
        RecipeProvider.a(exporter, Items.mR, Items.mW);
        RecipeProvider.a(exporter, Items.mU, Items.mZ);
        RecipeProvider.a(exporter, Items.mT, Items.mY);
        RecipeProvider.a(exporter, Items.mV, Items.na);
        RecipeProvider.a(exporter, Items.mS, Items.mX);
    }

    private static void a(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input, @Nullable String group) {
        RecipeProvider.a(exporter, output, input, group, 1);
    }

    private static void a(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input, @Nullable String group, int outputCount) {
        ShapelessRecipeBuilder.a(output, outputCount).c(input).b(group).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter, RecipeProvider.a(output, input));
    }

    private static void a(Consumer<FinishedRecipe> exporter, List<IMaterial> inputs, IMaterial output, float experience, int cookingTime, String group) {
        RecipeProvider.a(exporter, RecipeSerializer.p, inputs, output, experience, cookingTime, group, "_from_smelting");
    }

    private static void b(Consumer<FinishedRecipe> exporter, List<IMaterial> inputs, IMaterial output, float experience, int cookingTime, String group) {
        RecipeProvider.a(exporter, RecipeSerializer.q, inputs, output, experience, cookingTime, group, "_from_blasting");
    }

    private static void a(Consumer<FinishedRecipe> exporter, RecipeSerializerCooking<?> serializer, List<IMaterial> inputs, IMaterial output, float experience, int cookingTime, String group, String baseIdString) {
        for (IMaterial itemLike : inputs) {
            SimpleCookingRecipeBuilder.a(RecipeItemStack.a(itemLike), output, experience, cookingTime, serializer).b(group).b(RecipeProvider.b(itemLike), RecipeProvider.a(itemLike)).a(exporter, RecipeProvider.c(output) + baseIdString + "_" + RecipeProvider.c(itemLike));
        }
    }

    private static void a(Consumer<FinishedRecipe> exporter, Item output, Item input) {
        UpgradeRecipeBuilder.a(RecipeItemStack.a(output), RecipeItemStack.a(Items.mv), input).a("has_netherite_ingot", RecipeProvider.a(Items.mv)).a(exporter, RecipeProvider.c(input) + "_smithing");
    }

    private static void a(Consumer<FinishedRecipe> exporter, IMaterial output, Tag<Item> input) {
        ShapelessRecipeBuilder.a(output, 4).a(input).b("planks").b("has_log", RecipeProvider.a(input)).a(exporter);
    }

    private static void b(Consumer<FinishedRecipe> exporter, IMaterial output, Tag<Item> input) {
        ShapelessRecipeBuilder.a(output, 4).a(input).b("planks").b("has_logs", RecipeProvider.a(input)).a(exporter);
    }

    private static void f(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(output, 3).a(Character.valueOf('#'), input).b("##").b("##").c("bark").b("has_log", RecipeProvider.a(input)).a(exporter);
    }

    private static void g(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.b(output).a(Character.valueOf('#'), input).b("# #").b("###").c("boat").b("in_water", RecipeProvider.a(Blocks.A)).a(exporter);
    }

    private static RecipeBuilder e(IMaterial output, RecipeItemStack input) {
        return ShapelessRecipeBuilder.b(output).a(input);
    }

    private static RecipeBuilder f(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(output, 3).a(Character.valueOf('#'), input).b("##").b("##").b("##");
    }

    private static RecipeBuilder g(IMaterial output, RecipeItemStack input) {
        int i2 = output == Blocks.ef ? 6 : 3;
        Item item = output == Blocks.ef ? Items.rC : Items.nb;
        return ShapedRecipeBuilder.a(output, i2).a(Character.valueOf('W'), input).a(Character.valueOf('#'), item).b("W#W").b("W#W");
    }

    private static RecipeBuilder h(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.b(output).a(Character.valueOf('#'), Items.nb).a(Character.valueOf('W'), input).b("#W#").b("#W#");
    }

    private static void h(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        RecipeProvider.i(output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    private static RecipeBuilder i(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.b(output).a(Character.valueOf('#'), input).b("##");
    }

    private static void i(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        RecipeProvider.j(output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    private static RecipeBuilder j(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(output, 6).a(Character.valueOf('#'), input).b("###");
    }

    private static RecipeBuilder k(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(output, 4).a(Character.valueOf('#'), input).b("#  ").b("## ").b("###");
    }

    private static RecipeBuilder l(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(output, 2).a(Character.valueOf('#'), input).b("###").b("###");
    }

    private static RecipeBuilder m(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(output, 3).c("sign").a(Character.valueOf('#'), input).a(Character.valueOf('X'), Items.nb).b("###").b("###").b(" X ");
    }

    private static void j(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapelessRecipeBuilder.b(output).c(input).c(Blocks.be).b("wool").b("has_white_wool", RecipeProvider.a((IMaterial)Blocks.be)).a(exporter);
    }

    private static void k(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(output, 3).a(Character.valueOf('#'), input).b("##").c("carpet").b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    private static void l(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(output, 8).a(Character.valueOf('#'), Blocks.gP).a(Character.valueOf('$'), input).b("###").b("#$#").b("###").c("carpet").b("has_white_carpet", RecipeProvider.a((IMaterial)Blocks.gP)).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter, RecipeProvider.a(output, (IMaterial)Blocks.gP));
    }

    private static void m(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.b(output).a(Character.valueOf('#'), input).a(Character.valueOf('X'), TagsItem.c).b("###").b("XXX").c("bed").b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    private static void n(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapelessRecipeBuilder.b(output).c(Items.oY).c(input).b("dyed_bed").b("has_bed", RecipeProvider.a(Items.oY)).a(exporter, RecipeProvider.a(output, (IMaterial)Items.oY));
    }

    private static void o(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.b(output).a(Character.valueOf('#'), input).a(Character.valueOf('|'), Items.nb).b("###").b("###").b(" | ").c("banner").b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    private static void p(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(output, 8).a(Character.valueOf('#'), Blocks.au).a(Character.valueOf('X'), input).b("###").b("#X#").b("###").c("stained_glass").b("has_glass", RecipeProvider.a((IMaterial)Blocks.au)).a(exporter);
    }

    private static void q(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(output, 16).a(Character.valueOf('#'), input).b("###").b("###").c("stained_glass_pane").b("has_glass", RecipeProvider.a(input)).a(exporter);
    }

    private static void r(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(output, 8).a(Character.valueOf('#'), Blocks.dR).a(Character.valueOf('$'), input).b("###").b("#$#").b("###").c("stained_glass_pane").b("has_glass_pane", RecipeProvider.a((IMaterial)Blocks.dR)).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter, RecipeProvider.a(output, (IMaterial)Blocks.dR));
    }

    private static void s(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(output, 8).a(Character.valueOf('#'), Blocks.hf).a(Character.valueOf('X'), input).b("###").b("#X#").b("###").c("stained_terracotta").b("has_terracotta", RecipeProvider.a((IMaterial)Blocks.hf)).a(exporter);
    }

    private static void t(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapelessRecipeBuilder.a(output, 8).c(input).b(Blocks.C, 4).b(Blocks.E, 4).b("concrete_powder").b("has_sand", RecipeProvider.a((IMaterial)Blocks.C)).b("has_gravel", RecipeProvider.a((IMaterial)Blocks.E)).a(exporter);
    }

    public static void a(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        ShapelessRecipeBuilder.b(output).c(Blocks.nX).c(input).b("dyed_candle").b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    public static void b(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        RecipeProvider.a(output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    public static RecipeBuilder a(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(output, 6).a(Character.valueOf('#'), input).b("###").b("###");
    }

    public static void c(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        RecipeProvider.b(output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    public static RecipeBuilder b(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(output, 4).a(Character.valueOf('S'), input).b("SS").b("SS");
    }

    public static void d(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        RecipeProvider.c(output, RecipeItemStack.a(input)).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    public static ShapedRecipeBuilder c(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(output, 4).a(Character.valueOf('#'), input).b("##").b("##");
    }

    public static void e(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        RecipeProvider.d(output, RecipeItemStack.a(input)).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    public static ShapedRecipeBuilder d(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.b(output).a(Character.valueOf('#'), input).b("#").b("#");
    }

    private static void u(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        RecipeProvider.a(exporter, output, input, 1);
    }

    private static void a(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input, int count) {
        SingleItemRecipeBuilder.a(RecipeItemStack.a(input), output, count).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter, RecipeProvider.a(output, input) + "_stonecutting");
    }

    private static void v(Consumer<FinishedRecipe> exporter, IMaterial output, IMaterial input) {
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(input), output, 0.1f, 200).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    private static void w(Consumer<FinishedRecipe> exporter, IMaterial compacted, IMaterial input) {
        RecipeProvider.a(exporter, compacted, input, RecipeProvider.d(input), null, RecipeProvider.d(compacted), null);
    }

    private static void a(Consumer<FinishedRecipe> exporter, IMaterial compacted, IMaterial input, String compactedItemId, String compactedItemGroup) {
        RecipeProvider.a(exporter, compacted, input, compactedItemId, compactedItemGroup, RecipeProvider.d(compacted), null);
    }

    private static void b(Consumer<FinishedRecipe> exporter, IMaterial input, IMaterial compacted, String inputItemId, String inputItemGroup) {
        RecipeProvider.a(exporter, input, compacted, RecipeProvider.d(compacted), null, inputItemId, inputItemGroup);
    }

    private static void a(Consumer<FinishedRecipe> exporter, IMaterial input, IMaterial compacted, String compactedItemId, @Nullable String compactedItemGroup, String inputItemId, @Nullable String inputItemGroup) {
        ShapelessRecipeBuilder.a(input, 9).c(compacted).b(inputItemGroup).b(RecipeProvider.b(compacted), RecipeProvider.a(compacted)).a(exporter, new MinecraftKey(inputItemId));
        ShapedRecipeBuilder.b(compacted).a(Character.valueOf('#'), input).b("###").b("###").b("###").c(compactedItemGroup).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter, new MinecraftKey(compactedItemId));
    }

    private static void a(Consumer<FinishedRecipe> exporter, String cooker, RecipeSerializerCooking<?> serializer, int cookingTime) {
        RecipeProvider.a(exporter, cooker, serializer, cookingTime, Items.pv, Items.pw, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, cookingTime, Items.px, Items.py, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, cookingTime, Items.ov, Items.oz, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, cookingTime, Items.cP, Items.ps, 0.1f);
        RecipeProvider.a(exporter, cooker, serializer, cookingTime, Items.ow, Items.oA, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, cookingTime, Items.rS, Items.rT, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, cookingTime, Items.nJ, Items.nK, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, cookingTime, Items.rm, Items.rn, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, cookingTime, Items.rF, Items.rG, 0.35f);
    }

    private static void a(Consumer<FinishedRecipe> exporter, String cooker, RecipeSerializerCooking<?> serializer, int cookingTime, IMaterial input, IMaterial output, float experience) {
        SimpleCookingRecipeBuilder.a(RecipeItemStack.a(input), output, experience, cookingTime, serializer).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter, RecipeProvider.c(output) + "_from_" + cooker);
    }

    private static void b(Consumer<FinishedRecipe> exporter) {
        HoneycombItem.a.get().forEach((input, output) -> ShapelessRecipeBuilder.b(output).c((IMaterial)input).c(Items.tt).b(RecipeProvider.c(output)).b(RecipeProvider.b(input), RecipeProvider.a((IMaterial)input)).a(exporter, RecipeProvider.a((IMaterial)output, (IMaterial)Items.tt)));
    }

    private static void a(Consumer<FinishedRecipe> exporter, BlockFamily family) {
        family.b().forEach((variant, block) -> {
            BiFunction<IMaterial, IMaterial, RecipeBuilder> biFunction = m.get(variant);
            Block itemLike = RecipeProvider.a(family, variant);
            if (biFunction != null) {
                RecipeBuilder recipeBuilder = biFunction.apply((IMaterial)block, itemLike);
                family.e().ifPresent(group -> recipeBuilder.a(group + (String)(variant == BlockFamily.b.d ? "" : "_" + variant.a())));
                recipeBuilder.a(family.f().orElseGet(() -> RecipeProvider.b(itemLike)), RecipeProvider.a((IMaterial)itemLike));
                recipeBuilder.a(exporter);
            }
            if (variant == BlockFamily.b.c) {
                RecipeProvider.v(exporter, block, itemLike);
            }
        });
    }

    private static Block a(BlockFamily family, BlockFamily.b variant) {
        if (variant == BlockFamily.b.b) {
            if (!family.b().containsKey((Object)BlockFamily.b.i)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return family.a(BlockFamily.b.i);
        }
        return family.a();
    }

    private static CriterionTriggerEnterBlock.a a(Block block) {
        return new CriterionTriggerEnterBlock.a(CriterionConditionEntity.b.a, block, CriterionTriggerProperties.a);
    }

    private static CriterionTriggerInventoryChanged.a a(CriterionConditionValue.IntegerRange count, IMaterial item) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(item).a(count).b());
    }

    private static CriterionTriggerInventoryChanged.a a(IMaterial item) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(item).b());
    }

    private static CriterionTriggerInventoryChanged.a a(Tag<Item> tag) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(tag).b());
    }

    private static CriterionTriggerInventoryChanged.a a(CriterionConditionItem ... items) {
        return new CriterionTriggerInventoryChanged.a(CriterionConditionEntity.b.a, CriterionConditionValue.IntegerRange.e, CriterionConditionValue.IntegerRange.e, CriterionConditionValue.IntegerRange.e, items);
    }

    private static String b(IMaterial item) {
        return "has_" + RecipeProvider.c(item);
    }

    private static String c(IMaterial item) {
        return IRegistry.aa.b(item.k()).a();
    }

    private static String d(IMaterial item) {
        return RecipeProvider.c(item);
    }

    private static String a(IMaterial from, IMaterial to) {
        return RecipeProvider.c(from) + "_from_" + RecipeProvider.c(to);
    }

    private static String e(IMaterial item) {
        return RecipeProvider.c(item) + "_from_smelting";
    }

    private static String f(IMaterial item) {
        return RecipeProvider.c(item) + "_from_blasting";
    }

    @Override
    @Override
    public String a() {
        return "Recipes";
    }
}

