/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.blockstates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Selector;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class MultiVariantGenerator
implements BlockStateGenerator {
    private final Block a;
    private final List<Variant> b;
    private final Set<IBlockState<?>> c = Sets.newHashSet();
    private final List<PropertyDispatch> d = Lists.newArrayList();

    private MultiVariantGenerator(Block block, List<Variant> variants) {
        this.a = block;
        this.b = variants;
    }

    public MultiVariantGenerator a(PropertyDispatch map) {
        map.b().forEach(property -> {
            if (this.a.m().a(property.f()) != property) {
                throw new IllegalStateException("Property " + property + " is not defined for block " + this.a);
            }
            if (!this.c.add((IBlockState<?>)property)) {
                throw new IllegalStateException("Values of property " + property + " already defined for block " + this.a);
            }
        });
        this.d.add(map);
        return this;
    }

    @Override
    public JsonElement b() {
        Stream<Object> stream = Stream.of(Pair.of((Object)Selector.a(), this.b));
        for (PropertyDispatch propertyDispatch : this.d) {
            Map<Selector, List<Variant>> map = propertyDispatch.a();
            stream = stream.flatMap(pair -> map.entrySet().stream().map(entry -> {
                Selector selector = ((Selector)pair.getFirst()).a((Selector)entry.getKey());
                List<Variant> list = MultiVariantGenerator.a((List)pair.getSecond(), (List)entry.getValue());
                return Pair.of((Object)selector, list);
            }));
        }
        TreeMap map2 = new TreeMap();
        stream.forEach(pair -> map2.put(((Selector)pair.getFirst()).b(), Variant.a((List)pair.getSecond())));
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("variants", (JsonElement)SystemUtils.a(new JsonObject(), (T jsonObject) -> map2.forEach((arg_0, arg_1) -> ((JsonObject)jsonObject).add(arg_0, arg_1))));
        return jsonObject2;
    }

    private static List<Variant> a(List<Variant> left, List<Variant> right) {
        ImmutableList.Builder builder = ImmutableList.builder();
        left.forEach(variant -> right.forEach(variant2 -> builder.add((Object)Variant.a(variant, variant2))));
        return builder.build();
    }

    @Override
    @Override
    public Block a() {
        return this.a;
    }

    public static MultiVariantGenerator a(Block block) {
        return new MultiVariantGenerator(block, (List<Variant>)ImmutableList.of((Object)Variant.a()));
    }

    public static MultiVariantGenerator a(Block block, Variant variant) {
        return new MultiVariantGenerator(block, (List<Variant>)ImmutableList.of((Object)variant));
    }

    public static MultiVariantGenerator a(Block block, Variant ... variants) {
        return new MultiVariantGenerator(block, (List<Variant>)ImmutableList.copyOf((Object[])variants));
    }

    @Override
    public /* synthetic */ Object get() {
        return this.b();
    }
}

