/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.data.worldgen.NoiseData;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.data.worldgen.WorldGenCarvers;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.data.worldgen.biome.BiomeRegistry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistryGeneration {
    protected static final Logger a = LogManager.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> l = Maps.newLinkedHashMap();
    private static final IRegistryWritable<IRegistryWritable<?>> m = new RegistryMaterials(ResourceKey.a(new MinecraftKey("root")), Lifecycle.experimental());
    public static final IRegistry<? extends IRegistry<?>> b = m;
    public static final IRegistry<WorldGenCarverWrapper<?>> c = RegistryGeneration.a(IRegistry.aL, () -> WorldGenCarvers.a);
    public static final IRegistry<WorldGenFeatureConfigured<?, ?>> d = RegistryGeneration.a(IRegistry.aM, FeatureUtils::a);
    public static final IRegistry<StructureFeature<?, ?>> e = RegistryGeneration.a(IRegistry.aO, StructureFeatures::a);
    public static final IRegistry<PlacedFeature> f = RegistryGeneration.a(IRegistry.aN, PlacementUtils::a);
    public static final IRegistry<ProcessorList> g = RegistryGeneration.a(IRegistry.aP, () -> ProcessorLists.b);
    public static final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> h = RegistryGeneration.a(IRegistry.aQ, WorldGenFeaturePieces::a);
    public static final IRegistry<BiomeBase> i = RegistryGeneration.a(IRegistry.aR, () -> BiomeRegistry.b);
    public static final IRegistry<GeneratorSettingBase> j = RegistryGeneration.a(IRegistry.aK, GeneratorSettingBase::n);
    public static final IRegistry<NoiseGeneratorNormal.a> k = RegistryGeneration.a(IRegistry.aS, NoiseData::a);

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> registryRef, Supplier<T> defaultValueSupplier) {
        return RegistryGeneration.a(registryRef, Lifecycle.stable(), defaultValueSupplier);
    }

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> registryRef, Lifecycle lifecycle, Supplier<T> defaultValueSupplier) {
        return RegistryGeneration.a(registryRef, new RegistryMaterials(registryRef, lifecycle), defaultValueSupplier, lifecycle);
    }

    private static <T, R extends IRegistryWritable<T>> R a(ResourceKey<? extends IRegistry<T>> registryRef, R registry, Supplier<T> defaultValueSupplier, Lifecycle lifecycle) {
        MinecraftKey resourceLocation = registryRef.a();
        l.put(resourceLocation, defaultValueSupplier);
        IRegistryWritable<IRegistryWritable<?>> writableRegistry = m;
        return writableRegistry.a(registryRef, registry, lifecycle);
    }

    public static <T> T a(IRegistry<? super T> registry, String id, T object) {
        return RegistryGeneration.a(registry, new MinecraftKey(id), object);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, MinecraftKey id, T object) {
        return RegistryGeneration.a(registry, ResourceKey.a(registry.g(), id), object);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, ResourceKey<V> key, T object) {
        return ((IRegistryWritable)registry).a(key, object, Lifecycle.stable());
    }

    public static <V, T extends V> T b(IRegistry<V> registry, ResourceKey<V> key, T object) {
        return ((IRegistryWritable)registry).a(key, object, Lifecycle.stable());
    }

    public static void a() {
    }

    static {
        l.forEach((id, supplier) -> {
            if (supplier.get() == null) {
                a.error("Unable to bootstrap registry '{}'", id);
            }
        });
        IRegistry.a(m);
    }
}

