/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.ISourceBlock;
import net.minecraft.core.dispenser.DispenseBehaviorBoat;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.DispenseBehaviorProjectile;
import net.minecraft.core.dispenser.DispenseBehaviorShears;
import net.minecraft.core.dispenser.DispenseBehaviorShulkerBox;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBoneMeal;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.projectiles.CraftBlockProjectileSource;
import org.bukkit.craftbukkit.v1_18_R1.util.DummyGeneratorAccess;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public interface IDispenseBehavior {
    public static final Logger a = LogManager.getLogger();
    public static final IDispenseBehavior b = (isourceblock, itemstack) -> itemstack;

    public net.minecraft.world.item.ItemStack dispense(ISourceBlock var1, net.minecraft.world.item.ItemStack var2);

    public static void c() {
        BlockDispenser.a(Items.mh, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                EntityTippedArrow entitytippedarrow = new EntityTippedArrow(world, position.a(), position.b(), position.c());
                entitytippedarrow.d = EntityArrow.PickupStatus.b;
                return entitytippedarrow;
            }
        });
        BlockDispenser.a(Items.st, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                EntityTippedArrow entitytippedarrow = new EntityTippedArrow(world, position.a(), position.b(), position.c());
                entitytippedarrow.a(stack);
                entitytippedarrow.d = EntityArrow.PickupStatus.b;
                return entitytippedarrow;
            }
        });
        BlockDispenser.a(Items.ss, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                EntitySpectralArrow entityspectralarrow = new EntitySpectralArrow(world, position.a(), position.b(), position.c());
                entityspectralarrow.d = EntityArrow.PickupStatus.b;
                return entityspectralarrow;
            }
        });
        BlockDispenser.a(Items.oo, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                return SystemUtils.a(new EntityEgg(world, position.a(), position.b(), position.c()), entityegg -> entityegg.a(stack));
            }
        });
        BlockDispenser.a(Items.oa, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                return SystemUtils.a(new EntitySnowball(world, position.a(), position.b(), position.c()), entitysnowball -> entitysnowball.a(stack));
            }
        });
        BlockDispenser.a(Items.re, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                return SystemUtils.a(new EntityThrownExpBottle(world, position.a(), position.b(), position.c()), entitythrownexpbottle -> entitythrownexpbottle.a(stack));
            }

            @Override
            protected float a() {
                return super.a() * 0.5f;
            }

            @Override
            protected float b() {
                return super.b() * 1.25f;
            }
        });
        BlockDispenser.a(Items.sr, new IDispenseBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack dispense(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                return new DispenseBehaviorProjectile(){

                    @Override
                    protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                        return SystemUtils.a(new EntityPotion(world, position.a(), position.b(), position.c()), entitypotion -> entitypotion.a(stack));
                    }

                    @Override
                    protected float a() {
                        return super.a() * 0.5f;
                    }

                    @Override
                    protected float b() {
                        return super.b() * 1.25f;
                    }
                }.dispense(pointer, stack);
            }
        });
        BlockDispenser.a(Items.su, new IDispenseBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack dispense(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                return new DispenseBehaviorProjectile(){

                    @Override
                    protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                        return SystemUtils.a(new EntityPotion(world, position.a(), position.b(), position.c()), entitypotion -> entitypotion.a(stack));
                    }

                    @Override
                    protected float a() {
                        return super.a() * 0.5f;
                    }

                    @Override
                    protected float b() {
                        return super.b() * 1.25f;
                    }
                }.dispense(pointer, stack);
            }
        });
        DispenseBehaviorItem dispensebehavioritem = new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                EntityTypes<?> entitytypes = ((ItemMonsterEgg)stack.c()).a(stack.s());
                WorldServer worldserver = pointer.g();
                net.minecraft.world.item.ItemStack itemstack1 = stack.a(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    stack.f(1);
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    stack.f(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.c());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                try {
                    entitytypes.a(pointer.g(), stack, null, pointer.d().a(enumdirection), EnumMobSpawn.o, enumdirection != EnumDirection.b, false);
                }
                catch (Exception exception) {
                    a.error("Error while dispensing spawn egg from dispenser at {}", (Object)pointer.d(), (Object)exception);
                    return net.minecraft.world.item.ItemStack.b;
                }
                pointer.g().a(GameEvent.t, pointer.d());
                return stack;
            }
        };
        for (ItemMonsterEgg itemmonsteregg : ItemMonsterEgg.i()) {
            BlockDispenser.a(itemmonsteregg, dispensebehavioritem);
        }
        BlockDispenser.a(Items.rK, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                BlockPosition blockposition = pointer.d().a(enumdirection);
                WorldServer worldserver = pointer.g();
                net.minecraft.world.item.ItemStack itemstack1 = stack.a(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    stack.f(1);
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    stack.f(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.c());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                EntityArmorStand entityarmorstand = new EntityArmorStand(worldserver, (double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5);
                EntityTypes.a(worldserver, (EntityHuman)null, entityarmorstand, stack.s());
                entityarmorstand.o(enumdirection.o());
                worldserver.b(entityarmorstand);
                return stack;
            }
        });
        BlockDispenser.a(Items.lL, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                List<EntityLiving> list = pointer.g().a(EntityLiving.class, new AxisAlignedBB(blockposition), entityliving -> {
                    if (!(entityliving instanceof ISaddleable)) {
                        return false;
                    }
                    ISaddleable isaddleable = (ISaddleable)((Object)entityliving);
                    return !isaddleable.d() && isaddleable.c();
                });
                if (!list.isEmpty()) {
                    net.minecraft.world.item.ItemStack itemstack1 = stack.a(1);
                    WorldServer world = pointer.g();
                    org.bukkit.block.Block block = world.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                    BlockDispenseArmorEvent event = new BlockDispenseArmorEvent(block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)list.get(0).getBukkitEntity()));
                    if (!BlockDispenser.eventFired) {
                        world.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        stack.f(1);
                        return stack;
                    }
                    if (!event.getItem().equals((Object)craftItem)) {
                        stack.f(1);
                        net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                        IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.c());
                        if (idispensebehavior != b && idispensebehavior != ItemArmor.a) {
                            idispensebehavior.dispense(pointer, eventStack);
                            return stack;
                        }
                    }
                    ((ISaddleable)((Object)list.get(0))).a(SoundCategory.e);
                    this.a(true);
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        DispenseBehaviorMaybe dispensebehaviormaybe = new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EntityHorseAbstract entityhorseabstract2;
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                List<EntityHorseAbstract> list = pointer.g().a(EntityHorseAbstract.class, new AxisAlignedBB(blockposition), entityhorseabstract -> entityhorseabstract.bl() && entityhorseabstract.ge());
                Iterator<EntityHorseAbstract> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    return super.a(pointer, stack);
                } while (!(entityhorseabstract2 = iterator1.next()).m(stack) || entityhorseabstract2.gf() || !entityhorseabstract2.fI());
                net.minecraft.world.item.ItemStack itemstack1 = stack.a(1);
                WorldServer world = pointer.g();
                org.bukkit.block.Block block = world.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent(block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorseabstract2.getBukkitEntity()));
                if (!BlockDispenser.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    stack.f(1);
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    stack.f(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.c());
                    if (idispensebehavior != b && idispensebehavior != ItemArmor.a) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                entityhorseabstract2.k(401).a(CraftItemStack.asNMSCopy(event.getItem()));
                this.a(true);
                return stack;
            }
        };
        BlockDispenser.a(Items.rO, dispensebehaviormaybe);
        BlockDispenser.a(Items.rL, dispensebehaviormaybe);
        BlockDispenser.a(Items.rM, dispensebehaviormaybe);
        BlockDispenser.a(Items.rN, dispensebehaviormaybe);
        BlockDispenser.a(Items.gj, dispensebehaviormaybe);
        BlockDispenser.a(Items.gk, dispensebehaviormaybe);
        BlockDispenser.a(Items.gs, dispensebehaviormaybe);
        BlockDispenser.a(Items.gu, dispensebehaviormaybe);
        BlockDispenser.a(Items.gv, dispensebehaviormaybe);
        BlockDispenser.a(Items.gy, dispensebehaviormaybe);
        BlockDispenser.a(Items.gq, dispensebehaviormaybe);
        BlockDispenser.a(Items.gw, dispensebehaviormaybe);
        BlockDispenser.a(Items.gm, dispensebehaviormaybe);
        BlockDispenser.a(Items.gr, dispensebehaviormaybe);
        BlockDispenser.a(Items.go, dispensebehaviormaybe);
        BlockDispenser.a(Items.gl, dispensebehaviormaybe);
        BlockDispenser.a(Items.gp, dispensebehaviormaybe);
        BlockDispenser.a(Items.gt, dispensebehaviormaybe);
        BlockDispenser.a(Items.gx, dispensebehaviormaybe);
        BlockDispenser.a(Items.gn, dispensebehaviormaybe);
        BlockDispenser.a(Items.dL, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                EntityHorseChestedAbstract entityhorsechestedabstract2;
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                List<EntityHorseChestedAbstract> list = pointer.g().a(EntityHorseChestedAbstract.class, new AxisAlignedBB(blockposition), entityhorsechestedabstract -> entityhorsechestedabstract.bl() && !entityhorsechestedabstract.fy());
                Iterator<EntityHorseChestedAbstract> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    return super.a(pointer, stack);
                } while (!(entityhorsechestedabstract2 = iterator1.next()).fI());
                net.minecraft.world.item.ItemStack itemstack1 = stack.a(1);
                WorldServer world = pointer.g();
                org.bukkit.block.Block block = world.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent(block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorsechestedabstract2.getBukkitEntity()));
                if (!BlockDispenser.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).c())) != b && idispensebehavior != ItemArmor.a) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                entityhorsechestedabstract2.k(499).a(CraftItemStack.asNMSCopy(event.getItem()));
                this.a(true);
                return stack;
            }
        });
        BlockDispenser.a(Items.rz, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                WorldServer worldserver = pointer.g();
                net.minecraft.world.item.ItemStack itemstack1 = stack.a(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(enumdirection.i(), enumdirection.j(), enumdirection.k()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    stack.f(1);
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    stack.f(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.c());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
                EntityFireworks entityfireworks = new EntityFireworks((net.minecraft.world.level.World)pointer.g(), itemstack1, pointer.a(), pointer.b(), pointer.a(), true);
                IDispenseBehavior.a(pointer, entityfireworks, enumdirection);
                entityfireworks.c(enumdirection.i(), enumdirection.j(), enumdirection.k(), 0.5f, 1.0f);
                pointer.g().b(entityfireworks);
                return stack;
            }

            @Override
            protected void a(ISourceBlock pointer) {
                pointer.g().c(1004, pointer.d(), 0);
            }
        });
        BlockDispenser.a(Items.rf, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                IPosition iposition = BlockDispenser.a(pointer);
                double d0 = iposition.a() + (double)((float)enumdirection.i() * 0.3f);
                double d1 = iposition.b() + (double)((float)enumdirection.j() * 0.3f);
                double d2 = iposition.c() + (double)((float)enumdirection.k() * 0.3f);
                WorldServer worldserver = pointer.g();
                Random random = worldserver.w;
                double d3 = random.nextGaussian() * 0.05 + (double)enumdirection.i();
                double d4 = random.nextGaussian() * 0.05 + (double)enumdirection.j();
                double d5 = random.nextGaussian() * 0.05 + (double)enumdirection.k();
                net.minecraft.world.item.ItemStack itemstack1 = stack.a(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(d3, d4, d5));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    stack.f(1);
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    stack.f(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.c());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                EntitySmallFireball entitysmallfireball = new EntitySmallFireball(worldserver, d0, d1, d2, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ());
                entitysmallfireball.a(itemstack1);
                entitysmallfireball.projectileSource = new CraftBlockProjectileSource((TileEntityDispenser)pointer.f());
                worldserver.b(entitysmallfireball);
                return stack;
            }

            @Override
            protected void a(ISourceBlock pointer) {
                pointer.g().c(1018, pointer.d(), 0);
            }
        });
        BlockDispenser.a(Items.lU, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.a));
        BlockDispenser.a(Items.lV, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.b));
        BlockDispenser.a(Items.lW, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.c));
        BlockDispenser.a(Items.lX, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.d));
        BlockDispenser.a(Items.lZ, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.f));
        BlockDispenser.a(Items.lY, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.e));
        DispenseBehaviorItem dispensebehavioritem1 = new DispenseBehaviorItem(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)((Object)stack.c());
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                WorldServer worldserver = pointer.g();
                int x2 = blockposition.u();
                int y2 = blockposition.v();
                int z2 = blockposition.w();
                IBlockData iblockdata = worldserver.a_(blockposition);
                Material material = iblockdata.c();
                if (worldserver.w(blockposition) || !material.b() || material.e() || dispensiblecontaineritem instanceof ItemBucket && iblockdata.b() instanceof IFluidContainer && ((IFluidContainer)((Object)iblockdata.b())).a((IBlockAccess)worldserver, blockposition, iblockdata, ((ItemBucket)dispensiblecontaineritem).a)) {
                    net.minecraft.world.item.ItemStack eventStack;
                    IDispenseBehavior idispensebehavior;
                    org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
                    BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(x2, y2, z2));
                    if (!BlockDispenser.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).c())) != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                    dispensiblecontaineritem = (DispensibleContainerItem)((Object)CraftItemStack.asNMSCopy(event.getItem()).c());
                }
                if (dispensiblecontaineritem.a((EntityHuman)null, (net.minecraft.world.level.World)worldserver, blockposition, (MovingObjectPositionBlock)null)) {
                    dispensiblecontaineritem.a((EntityHuman)null, (net.minecraft.world.level.World)worldserver, stack, blockposition);
                    Item item = Items.nW;
                    stack.g(1);
                    if (stack.b()) {
                        stack = new net.minecraft.world.item.ItemStack(item);
                    } else if (((TileEntityDispenser)pointer.f()).a(new net.minecraft.world.item.ItemStack(item)) < 0) {
                        this.c.dispense(pointer, new net.minecraft.world.item.ItemStack(item));
                    }
                    return stack;
                }
                return this.c.dispense(pointer, stack);
            }
        };
        BlockDispenser.a(Items.nY, dispensebehavioritem1);
        BlockDispenser.a(Items.nX, dispensebehavioritem1);
        BlockDispenser.a(Items.nZ, dispensebehavioritem1);
        BlockDispenser.a(Items.oe, dispensebehavioritem1);
        BlockDispenser.a(Items.of, dispensebehavioritem1);
        BlockDispenser.a(Items.od, dispensebehavioritem1);
        BlockDispenser.a(Items.og, dispensebehavioritem1);
        BlockDispenser.a(Items.oh, dispensebehavioritem1);
        BlockDispenser.a(Items.nW, new DispenseBehaviorItem(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPosition blockposition;
                WorldServer worldserver = pointer.g();
                IBlockData iblockdata = worldserver.a_(blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a)));
                Block block = iblockdata.b();
                if (block instanceof IFluidSource) {
                    net.minecraft.world.item.ItemStack eventStack;
                    IDispenseBehavior idispensebehavior;
                    net.minecraft.world.item.ItemStack itemstack1 = ((IFluidSource)((Object)block)).c(DummyGeneratorAccess.INSTANCE, blockposition, iblockdata);
                    if (itemstack1.b()) {
                        return super.a(pointer, stack);
                    }
                    worldserver.a((Entity)null, GameEvent.z, blockposition);
                    Item item = itemstack1.c();
                    org.bukkit.block.Block bukkitBlock = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
                    BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                    if (!BlockDispenser.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).c())) != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                    itemstack1 = ((IFluidSource)((Object)block)).c(worldserver, blockposition, iblockdata);
                    stack.g(1);
                    if (stack.b()) {
                        return new net.minecraft.world.item.ItemStack(item);
                    }
                    if (((TileEntityDispenser)pointer.f()).a(new net.minecraft.world.item.ItemStack(item)) < 0) {
                        this.c.dispense(pointer, new net.minecraft.world.item.ItemStack(item));
                    }
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.me, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = pointer.g();
                org.bukkit.block.Block bukkitBlock = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).c())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                this.a(true);
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                BlockPosition blockposition = pointer.d().a(enumdirection);
                IBlockData iblockdata = worldserver.a_(blockposition);
                if (BlockFireAbstract.a((net.minecraft.world.level.World)worldserver, blockposition, enumdirection)) {
                    if (!CraftEventFactory.callBlockIgniteEvent((net.minecraft.world.level.World)worldserver, blockposition, pointer.d()).isCancelled()) {
                        worldserver.b(blockposition, BlockFireAbstract.a(worldserver, blockposition));
                        worldserver.a((Entity)null, GameEvent.g, blockposition);
                    }
                } else if (!(BlockCampfire.h(iblockdata) || CandleBlock.g(iblockdata) || CandleCakeBlock.g(iblockdata))) {
                    if (iblockdata.b() instanceof BlockTNT) {
                        BlockTNT.a(worldserver, blockposition);
                        worldserver.a(blockposition, false);
                    } else {
                        this.a(false);
                    }
                } else {
                    worldserver.b(blockposition, (IBlockData)iblockdata.a(BlockProperties.r, true));
                    worldserver.a((Entity)null, GameEvent.b, blockposition);
                }
                if (this.a() && stack.hurt(1, worldserver.w, null)) {
                    stack.e(0);
                }
                return stack;
            }
        });
        BlockDispenser.a(Items.oU, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                this.a(true);
                WorldServer worldserver = pointer.g();
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).c())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                worldserver.captureTreeGeneration = true;
                if (!ItemBoneMeal.a(stack, worldserver, blockposition) && !ItemBoneMeal.a(stack, worldserver, blockposition, null)) {
                    this.a(false);
                } else if (!worldserver.y) {
                    worldserver.c(1505, blockposition, 0);
                }
                worldserver.captureTreeGeneration = false;
                if (worldserver.capturedBlockStates.size() > 0) {
                    TreeType treeType = BlockSapling.treeType;
                    BlockSapling.treeType = null;
                    Location location = new Location((World)worldserver.getWorld(), (double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w());
                    ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(worldserver.capturedBlockStates.values());
                    worldserver.capturedBlockStates.clear();
                    StructureGrowEvent structureEvent = null;
                    if (treeType != null) {
                        structureEvent = new StructureGrowEvent(location, treeType, false, null, blocks);
                        Bukkit.getPluginManager().callEvent((Event)structureEvent);
                    }
                    BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent(location.getBlock(), null, blocks);
                    fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
                    Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
                    if (!fertilizeEvent.isCancelled()) {
                        for (BlockState blockState : blocks) {
                            blockState.update(true);
                        }
                    }
                }
                return stack;
            }
        });
        BlockDispenser.a(Blocks.bN, new DispenseBehaviorItem(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                WorldServer worldserver = pointer.g();
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                net.minecraft.world.item.ItemStack itemstack1 = stack.a(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector((double)blockposition.u() + 0.5, (double)blockposition.v(), (double)blockposition.w() + 0.5));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    stack.f(1);
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    stack.f(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.c());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), null);
                worldserver.b(entitytntprimed);
                worldserver.a((EntityHuman)null, entitytntprimed.dc(), entitytntprimed.de(), entitytntprimed.di(), SoundEffects.sV, SoundCategory.e, 1.0f, 1.0f);
                worldserver.a((Entity)null, GameEvent.t, blockposition);
                return stack;
            }
        });
        DispenseBehaviorMaybe dispensebehaviormaybe1 = new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                this.a(ItemArmor.a(pointer, stack));
                return stack;
            }
        };
        BlockDispenser.a(Items.rv, dispensebehaviormaybe1);
        BlockDispenser.a(Items.ru, dispensebehaviormaybe1);
        BlockDispenser.a(Items.rw, dispensebehaviormaybe1);
        BlockDispenser.a(Items.rr, dispensebehaviormaybe1);
        BlockDispenser.a(Items.rt, dispensebehaviormaybe1);
        BlockDispenser.a(Items.rs, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = pointer.g();
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                BlockPosition blockposition = pointer.d().a(enumdirection);
                org.bukkit.block.Block bukkitBlock = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).c())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (worldserver.w(blockposition) && BlockWitherSkull.b(worldserver, blockposition, stack)) {
                    worldserver.a(blockposition, (IBlockData)Blocks.fr.n().a(BlockSkull.b, enumdirection.n() == EnumDirection.EnumAxis.b ? 0 : enumdirection.f().d() * 4), 3);
                    worldserver.a((Entity)null, GameEvent.g, blockposition);
                    TileEntity tileentity = worldserver.c_(blockposition);
                    if (tileentity instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)worldserver, blockposition, (TileEntitySkull)tileentity);
                    }
                    stack.g(1);
                    this.a(true);
                } else {
                    this.a(ItemArmor.a(pointer, stack));
                }
                return stack;
            }
        });
        BlockDispenser.a(Blocks.dc, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = pointer.g();
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                BlockPumpkinCarved blockpumpkincarved = (BlockPumpkinCarved)Blocks.dc;
                org.bukkit.block.Block bukkitBlock = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).c())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (worldserver.w(blockposition) && blockpumpkincarved.a((IWorldReader)worldserver, blockposition)) {
                    if (!worldserver.y) {
                        worldserver.a(blockposition, blockpumpkincarved.n(), 3);
                        worldserver.a((Entity)null, GameEvent.g, blockposition);
                    }
                    stack.g(1);
                    this.a(true);
                } else {
                    this.a(ItemArmor.a(pointer, stack));
                }
                return stack;
            }
        });
        BlockDispenser.a(Blocks.jd.k(), new DispenseBehaviorShulkerBox());
        for (EnumColor enumcolor : EnumColor.values()) {
            BlockDispenser.a(BlockShulkerBox.a(enumcolor).k(), new DispenseBehaviorShulkerBox());
        }
        BlockDispenser.a(Items.pG.k(), new DispenseBehaviorMaybe(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            private net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack emptyBottleStack, net.minecraft.world.item.ItemStack filledBottleStack) {
                emptyBottleStack.g(1);
                if (emptyBottleStack.b()) {
                    pointer.g().a((Entity)null, GameEvent.z, pointer.d());
                    return filledBottleStack.m();
                }
                if (((TileEntityDispenser)pointer.f()).a(filledBottleStack.m()) < 0) {
                    this.c.dispense(pointer, filledBottleStack.m());
                }
                return emptyBottleStack;
            }

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                this.a(false);
                WorldServer worldserver = pointer.g();
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                IBlockData iblockdata = worldserver.a_(blockposition);
                org.bukkit.block.Block bukkitBlock = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).c())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (iblockdata.a(TagsBlock.at, (BlockBase.BlockData blockbase_blockdata) -> blockbase_blockdata.b(BlockBeehive.b)) && iblockdata.c(BlockBeehive.b) >= 5) {
                    ((BlockBeehive)iblockdata.b()).a((net.minecraft.world.level.World)worldserver, iblockdata, blockposition, (EntityHuman)null, TileEntityBeehive.ReleaseStatus.b);
                    this.a(true);
                    return this.a(pointer, stack, new net.minecraft.world.item.ItemStack(Items.tw));
                }
                if (worldserver.b_(blockposition).a(TagsFluid.b)) {
                    this.a(true);
                    return this.a(pointer, stack, PotionUtil.a(new net.minecraft.world.item.ItemStack(Items.pF), Potions.b));
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.ep, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                BlockPosition blockposition = pointer.d().a(enumdirection);
                WorldServer worldserver = pointer.g();
                IBlockData iblockdata = worldserver.a_(blockposition);
                this.a(true);
                if (iblockdata.a(Blocks.nx)) {
                    if (iblockdata.c(BlockRespawnAnchor.c) != 4) {
                        BlockRespawnAnchor.a((net.minecraft.world.level.World)worldserver, blockposition, iblockdata);
                        stack.g(1);
                    } else {
                        this.a(false);
                    }
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.pq.k(), new DispenseBehaviorShears());
        BlockDispenser.a(Items.tt, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                WorldServer worldserver = pointer.g();
                IBlockData iblockdata = worldserver.a_(blockposition);
                Optional<IBlockData> optional = HoneycombItem.b(iblockdata);
                if (optional.isPresent()) {
                    worldserver.b(blockposition, optional.get());
                    worldserver.c(3003, blockposition, 0);
                    stack.g(1);
                    this.a(true);
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
    }

    public static void a(ISourceBlock pointer, Entity entity, EnumDirection direction) {
        entity.e(pointer.a() + (double)direction.i() * (0.5000099999997474 - (double)entity.cT() / 2.0), pointer.b() + (double)direction.j() * (0.5000099999997474 - (double)entity.cU() / 2.0) - (double)entity.cU() / 2.0, pointer.c() + (double)direction.k() * (0.5000099999997474 - (double)entity.cT() / 2.0));
    }
}

