/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.Particles;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.decoration.Paintings;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IRegistry<T>
implements Keyable,
Registry<T> {
    protected static final Logger d = LogManager.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> b = Maps.newLinkedHashMap();
    public static final MinecraftKey e = new MinecraftKey("root");
    protected static final IRegistryWritable<IRegistryWritable<?>> f = new RegistryMaterials(IRegistry.a("root"), Lifecycle.experimental());
    public static final IRegistry<? extends IRegistry<?>> g = f;
    public static final ResourceKey<IRegistry<SoundEffect>> h = IRegistry.a("sound_event");
    public static final ResourceKey<IRegistry<FluidType>> i = IRegistry.a("fluid");
    public static final ResourceKey<IRegistry<MobEffectList>> j = IRegistry.a("mob_effect");
    public static final ResourceKey<IRegistry<Block>> k = IRegistry.a("block");
    public static final ResourceKey<IRegistry<Enchantment>> l = IRegistry.a("enchantment");
    public static final ResourceKey<IRegistry<EntityTypes<?>>> m = IRegistry.a("entity_type");
    public static final ResourceKey<IRegistry<Item>> n = IRegistry.a("item");
    public static final ResourceKey<IRegistry<PotionRegistry>> o = IRegistry.a("potion");
    public static final ResourceKey<IRegistry<Particle<?>>> p = IRegistry.a("particle_type");
    public static final ResourceKey<IRegistry<TileEntityTypes<?>>> q = IRegistry.a("block_entity_type");
    public static final ResourceKey<IRegistry<Paintings>> r = IRegistry.a("motive");
    public static final ResourceKey<IRegistry<MinecraftKey>> s = IRegistry.a("custom_stat");
    public static final ResourceKey<IRegistry<ChunkStatus>> t = IRegistry.a("chunk_status");
    public static final ResourceKey<IRegistry<DefinedStructureRuleTestType<?>>> u = IRegistry.a("rule_test");
    public static final ResourceKey<IRegistry<PosRuleTestType<?>>> v = IRegistry.a("pos_rule_test");
    public static final ResourceKey<IRegistry<Containers<?>>> w = IRegistry.a("menu");
    public static final ResourceKey<IRegistry<Recipes<?>>> x = IRegistry.a("recipe_type");
    public static final ResourceKey<IRegistry<RecipeSerializer<?>>> y = IRegistry.a("recipe_serializer");
    public static final ResourceKey<IRegistry<AttributeBase>> z = IRegistry.a("attribute");
    public static final ResourceKey<IRegistry<GameEvent>> A = IRegistry.a("game_event");
    public static final ResourceKey<IRegistry<PositionSourceType<?>>> B = IRegistry.a("position_source_type");
    public static final ResourceKey<IRegistry<StatisticWrapper<?>>> C = IRegistry.a("stat_type");
    public static final ResourceKey<IRegistry<VillagerType>> D = IRegistry.a("villager_type");
    public static final ResourceKey<IRegistry<VillagerProfession>> E = IRegistry.a("villager_profession");
    public static final ResourceKey<IRegistry<VillagePlaceType>> F = IRegistry.a("point_of_interest_type");
    public static final ResourceKey<IRegistry<MemoryModuleType<?>>> G = IRegistry.a("memory_module_type");
    public static final ResourceKey<IRegistry<SensorType<?>>> H = IRegistry.a("sensor_type");
    public static final ResourceKey<IRegistry<Schedule>> I = IRegistry.a("schedule");
    public static final ResourceKey<IRegistry<Activity>> J = IRegistry.a("activity");
    public static final ResourceKey<IRegistry<LootEntryType>> K = IRegistry.a("loot_pool_entry_type");
    public static final ResourceKey<IRegistry<LootItemFunctionType>> L = IRegistry.a("loot_function_type");
    public static final ResourceKey<IRegistry<LootItemConditionType>> M = IRegistry.a("loot_condition_type");
    public static final ResourceKey<IRegistry<LootNumberProviderType>> N = IRegistry.a("loot_number_provider_type");
    public static final ResourceKey<IRegistry<LootNbtProviderType>> O = IRegistry.a("loot_nbt_provider_type");
    public static final ResourceKey<IRegistry<LootScoreProviderType>> P = IRegistry.a("loot_score_provider_type");
    public static final ResourceKey<IRegistry<DimensionManager>> Q = IRegistry.a("dimension_type");
    public static final ResourceKey<IRegistry<World>> R = IRegistry.a("dimension");
    public static final ResourceKey<IRegistry<WorldDimension>> S = IRegistry.a("dimension");
    public static final RegistryBlocks<GameEvent> T = IRegistry.a(A, "step", () -> GameEvent.Q);
    public static final IRegistry<SoundEffect> U = IRegistry.a(h, () -> SoundEffects.jv);
    public static final RegistryBlocks<FluidType> V = IRegistry.a(i, "empty", () -> FluidTypes.a);
    public static final IRegistry<MobEffectList> W = IRegistry.a(j, () -> MobEffects.z);
    public static final RegistryBlocks<Block> X = IRegistry.a(k, "air", () -> Blocks.a);
    public static final IRegistry<Enchantment> Y = IRegistry.a(l, () -> Enchantments.w);
    public static final RegistryBlocks<EntityTypes<?>> Z = IRegistry.a(m, "pig", () -> EntityTypes.an);
    public static final RegistryBlocks<Item> aa = IRegistry.a(n, "air", () -> Items.a);
    public static final RegistryBlocks<PotionRegistry> ab = IRegistry.a(o, "empty", () -> Potions.a);
    public static final IRegistry<Particle<?>> ac = IRegistry.a(p, () -> Particles.c);
    public static final IRegistry<TileEntityTypes<?>> ad = IRegistry.a(q, () -> TileEntityTypes.a);
    public static final RegistryBlocks<Paintings> ae = IRegistry.a(r, "kebab", () -> Paintings.a);
    public static final IRegistry<MinecraftKey> af = IRegistry.a(s, () -> StatisticList.E);
    public static final RegistryBlocks<ChunkStatus> ag = IRegistry.a(t, "empty", () -> ChunkStatus.c);
    public static final IRegistry<DefinedStructureRuleTestType<?>> ah = IRegistry.a(u, () -> DefinedStructureRuleTestType.a);
    public static final IRegistry<PosRuleTestType<?>> ai = IRegistry.a(v, () -> PosRuleTestType.a);
    public static final IRegistry<Containers<?>> aj = IRegistry.a(w, () -> Containers.h);
    public static final IRegistry<Recipes<?>> ak = IRegistry.a(x, () -> Recipes.a);
    public static final IRegistry<RecipeSerializer<?>> al = IRegistry.a(y, () -> RecipeSerializer.b);
    public static final IRegistry<AttributeBase> am = IRegistry.a(z, () -> GenericAttributes.k);
    public static final IRegistry<PositionSourceType<?>> an = IRegistry.a(B, () -> PositionSourceType.a);
    public static final IRegistry<StatisticWrapper<?>> ao = IRegistry.a(C, () -> StatisticList.c);
    public static final RegistryBlocks<VillagerType> ap = IRegistry.a(D, "plains", () -> VillagerType.c);
    public static final RegistryBlocks<VillagerProfession> aq = IRegistry.a(E, "none", () -> VillagerProfession.a);
    public static final RegistryBlocks<VillagePlaceType> ar = IRegistry.a(F, "unemployed", () -> VillagePlaceType.c);
    public static final RegistryBlocks<MemoryModuleType<?>> as = IRegistry.a(G, "dummy", () -> MemoryModuleType.a);
    public static final RegistryBlocks<SensorType<?>> at = IRegistry.a(H, "dummy", () -> SensorType.a);
    public static final IRegistry<Schedule> au = IRegistry.a(I, () -> Schedule.c);
    public static final IRegistry<Activity> av = IRegistry.a(J, () -> Activity.b);
    public static final IRegistry<LootEntryType> aw = IRegistry.a(K, () -> LootEntries.a);
    public static final IRegistry<LootItemFunctionType> ax = IRegistry.a(L, () -> LootItemFunctions.b);
    public static final IRegistry<LootItemConditionType> ay = IRegistry.a(M, () -> LootItemConditions.a);
    public static final IRegistry<LootNumberProviderType> az = IRegistry.a(N, () -> NumberProviders.a);
    public static final IRegistry<LootNbtProviderType> aA = IRegistry.a(O, () -> NbtProviders.b);
    public static final IRegistry<LootScoreProviderType> aB = IRegistry.a(P, () -> ScoreboardNameProviders.b);
    public static final ResourceKey<IRegistry<FloatProviderType<?>>> aC = IRegistry.a("float_provider_type");
    public static final IRegistry<FloatProviderType<?>> aD = IRegistry.a(aC, () -> FloatProviderType.a);
    public static final ResourceKey<IRegistry<IntProviderType<?>>> aE = IRegistry.a("int_provider_type");
    public static final IRegistry<IntProviderType<?>> aF = IRegistry.a(aE, () -> IntProviderType.a);
    public static final ResourceKey<IRegistry<HeightProviderType<?>>> aG = IRegistry.a("height_provider_type");
    public static final IRegistry<HeightProviderType<?>> aH = IRegistry.a(aG, () -> HeightProviderType.a);
    public static final ResourceKey<IRegistry<BlockPredicateType<?>>> aI = IRegistry.a("block_predicate_type");
    public static final IRegistry<BlockPredicateType<?>> aJ = IRegistry.a(aI, () -> BlockPredicateType.k);
    public static final ResourceKey<IRegistry<GeneratorSettingBase>> aK = IRegistry.a("worldgen/noise_settings");
    public static final ResourceKey<IRegistry<WorldGenCarverWrapper<?>>> aL = IRegistry.a("worldgen/configured_carver");
    public static final ResourceKey<IRegistry<WorldGenFeatureConfigured<?, ?>>> aM = IRegistry.a("worldgen/configured_feature");
    public static final ResourceKey<IRegistry<PlacedFeature>> aN = IRegistry.a("worldgen/placed_feature");
    public static final ResourceKey<IRegistry<StructureFeature<?, ?>>> aO = IRegistry.a("worldgen/configured_structure_feature");
    public static final ResourceKey<IRegistry<ProcessorList>> aP = IRegistry.a("worldgen/processor_list");
    public static final ResourceKey<IRegistry<WorldGenFeatureDefinedStructurePoolTemplate>> aQ = IRegistry.a("worldgen/template_pool");
    public static final ResourceKey<IRegistry<BiomeBase>> aR = IRegistry.a("worldgen/biome");
    public static final ResourceKey<IRegistry<NoiseGeneratorNormal.a>> aS = IRegistry.a("worldgen/noise");
    public static final ResourceKey<IRegistry<WorldGenCarverAbstract<?>>> aT = IRegistry.a("worldgen/carver");
    public static final IRegistry<WorldGenCarverAbstract<?>> aU = IRegistry.a(aT, () -> WorldGenCarverAbstract.a);
    public static final ResourceKey<IRegistry<WorldGenerator<?>>> aV = IRegistry.a("worldgen/feature");
    public static final IRegistry<WorldGenerator<?>> aW = IRegistry.a(aV, () -> WorldGenerator.K);
    public static final ResourceKey<IRegistry<StructureGenerator<?>>> aX = IRegistry.a("worldgen/structure_feature");
    public static final IRegistry<StructureGenerator<?>> aY = IRegistry.a(aX, () -> StructureGenerator.d);
    public static final ResourceKey<IRegistry<WorldGenFeatureStructurePieceType>> aZ = IRegistry.a("worldgen/structure_piece");
    public static final IRegistry<WorldGenFeatureStructurePieceType> ba = IRegistry.a(aZ, () -> WorldGenFeatureStructurePieceType.c);
    public static final ResourceKey<IRegistry<PlacementModifierType<?>>> bb = IRegistry.a("worldgen/placement_modifier_type");
    public static final IRegistry<PlacementModifierType<?>> bc = IRegistry.a(bb, () -> PlacementModifierType.f);
    public static final ResourceKey<IRegistry<WorldGenFeatureStateProviders<?>>> bd = IRegistry.a("worldgen/block_state_provider_type");
    public static final ResourceKey<IRegistry<WorldGenFoilagePlacers<?>>> be = IRegistry.a("worldgen/foliage_placer_type");
    public static final ResourceKey<IRegistry<TrunkPlacers<?>>> bf = IRegistry.a("worldgen/trunk_placer_type");
    public static final ResourceKey<IRegistry<WorldGenFeatureTrees<?>>> bg = IRegistry.a("worldgen/tree_decorator_type");
    public static final ResourceKey<IRegistry<FeatureSizeType<?>>> bh = IRegistry.a("worldgen/feature_size_type");
    public static final ResourceKey<IRegistry<Codec<? extends WorldChunkManager>>> bi = IRegistry.a("worldgen/biome_source");
    public static final ResourceKey<IRegistry<Codec<? extends ChunkGenerator>>> bj = IRegistry.a("worldgen/chunk_generator");
    public static final ResourceKey<IRegistry<Codec<? extends SurfaceRules.f>>> bk = IRegistry.a("worldgen/material_condition");
    public static final ResourceKey<IRegistry<Codec<? extends SurfaceRules.o>>> bl = IRegistry.a("worldgen/material_rule");
    public static final ResourceKey<IRegistry<DefinedStructureStructureProcessorType<?>>> bm = IRegistry.a("worldgen/structure_processor");
    public static final ResourceKey<IRegistry<WorldGenFeatureDefinedStructurePools<?>>> bn = IRegistry.a("worldgen/structure_pool_element");
    public static final IRegistry<WorldGenFeatureStateProviders<?>> bo = IRegistry.a(bd, () -> WorldGenFeatureStateProviders.a);
    public static final IRegistry<WorldGenFoilagePlacers<?>> bp = IRegistry.a(be, () -> WorldGenFoilagePlacers.a);
    public static final IRegistry<TrunkPlacers<?>> bq = IRegistry.a(bf, () -> TrunkPlacers.a);
    public static final IRegistry<WorldGenFeatureTrees<?>> br = IRegistry.a(bg, () -> WorldGenFeatureTrees.b);
    public static final IRegistry<FeatureSizeType<?>> bs = IRegistry.a(bh, () -> FeatureSizeType.a);
    public static final IRegistry<Codec<? extends WorldChunkManager>> bt = IRegistry.a(bi, Lifecycle.stable(), () -> WorldChunkManager.a);
    public static final IRegistry<Codec<? extends ChunkGenerator>> bu = IRegistry.a(bj, Lifecycle.stable(), () -> ChunkGenerator.a);
    public static final IRegistry<Codec<? extends SurfaceRules.f>> bv = IRegistry.a(bk, SurfaceRules.f::c);
    public static final IRegistry<Codec<? extends SurfaceRules.o>> bw = IRegistry.a(bl, SurfaceRules.o::d);
    public static final IRegistry<DefinedStructureStructureProcessorType<?>> bx = IRegistry.a(bm, () -> DefinedStructureStructureProcessorType.a);
    public static final IRegistry<WorldGenFeatureDefinedStructurePools<?>> by = IRegistry.a(bn, () -> WorldGenFeatureDefinedStructurePools.d);
    private final ResourceKey<? extends IRegistry<T>> c;
    private final Lifecycle bz;

    private static <T> ResourceKey<IRegistry<T>> a(String registryId) {
        return ResourceKey.a(new MinecraftKey(registryId));
    }

    public static <T extends IRegistryWritable<?>> void a(IRegistryWritable<T> registry) {
        registry.forEach(writableRegistry2 -> {
            if (writableRegistry2.d().isEmpty()) {
                SystemUtils.a("Registry '" + registry.b(writableRegistry2) + "' was empty after loading");
            }
            if (writableRegistry2 instanceof RegistryBlocks) {
                MinecraftKey resourceLocation = ((RegistryBlocks)writableRegistry2).a();
                Validate.notNull(writableRegistry2.a(resourceLocation), (String)("Missing default of DefaultedMappedRegistry: " + resourceLocation), (Object[])new Object[0]);
            }
        });
    }

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, Supplier<T> defaultEntry) {
        return IRegistry.a(key, Lifecycle.experimental(), defaultEntry);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, Supplier<T> defaultEntry) {
        return IRegistry.a(key, defaultId, Lifecycle.experimental(), defaultEntry);
    }

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, Supplier<T> defaultEntry) {
        return IRegistry.a(key, new RegistryMaterials(key, lifecycle), defaultEntry, lifecycle);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, Lifecycle lifecycle, Supplier<T> defaultEntry) {
        return IRegistry.a(key, new RegistryBlocks(defaultId, key, lifecycle), defaultEntry, lifecycle);
    }

    private static <T, R extends IRegistryWritable<T>> R a(ResourceKey<? extends IRegistry<T>> key, R registry, Supplier<T> defaultEntry, Lifecycle lifecycle) {
        MinecraftKey resourceLocation = key.a();
        b.put(resourceLocation, defaultEntry);
        IRegistryWritable<IRegistryWritable<?>> writableRegistry = f;
        return writableRegistry.a(key, registry, lifecycle);
    }

    protected IRegistry(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle) {
        DispenserRegistry.a(() -> "registry " + key);
        this.c = key;
        this.bz = lifecycle;
    }

    public ResourceKey<? extends IRegistry<T>> g() {
        return this.c;
    }

    public Lifecycle h() {
        return this.bz;
    }

    @Override
    public String toString() {
        return "Registry[" + this.c + " (" + this.bz + ")]";
    }

    public Codec<T> i() {
        Codec codec = MinecraftKey.a.flatXmap(resourceLocation -> Optional.ofNullable(this.a((MinecraftKey)resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry key in " + this.c + ": " + resourceLocation))), object -> this.c(object).map(ResourceKey::a).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry element in " + this.c + ":" + object))));
        Codec<Object> codec2 = ExtraCodecs.a((E object) -> this.c(object).isPresent() ? this.a(object) : -1, this::a, -1);
        return ExtraCodecs.a(ExtraCodecs.b(codec, codec2), this::d, (E object) -> this.bz);
    }

    public <U> Stream<U> keys(DynamicOps<U> dynamicOps) {
        return this.d().stream().map(resourceLocation -> dynamicOps.createString(resourceLocation.toString()));
    }

    @Nullable
    public abstract MinecraftKey b(T var1);

    public abstract Optional<ResourceKey<T>> c(T var1);

    @Override
    @Override
    public abstract int a(@Nullable T var1);

    @Nullable
    public abstract T a(@Nullable ResourceKey<T> var1);

    @Nullable
    public abstract T a(@Nullable MinecraftKey var1);

    public abstract Lifecycle d(T var1);

    public abstract Lifecycle c();

    public Optional<T> b(@Nullable MinecraftKey id) {
        return Optional.ofNullable(this.a(id));
    }

    public Optional<T> c(@Nullable ResourceKey<T> key) {
        return Optional.ofNullable(this.a(key));
    }

    public T d(ResourceKey<T> key) {
        T object = this.a(key);
        if (object == null) {
            throw new IllegalStateException("Missing key in " + this.c + ": " + key);
        }
        return object;
    }

    public abstract Set<MinecraftKey> d();

    public abstract Set<Map.Entry<ResourceKey<T>, T>> e();

    @Nullable
    public abstract T a(Random var1);

    public Stream<T> j() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public abstract boolean c(MinecraftKey var1);

    public abstract boolean b(ResourceKey<T> var1);

    public static <T> T a(IRegistry<? super T> registry, String id, T entry) {
        return IRegistry.a(registry, new MinecraftKey(id), entry);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, MinecraftKey id, T entry) {
        return IRegistry.a(registry, ResourceKey.a(registry.c, id), entry);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, ResourceKey<V> key, T entry) {
        return ((IRegistryWritable)registry).a(key, entry, Lifecycle.stable());
    }

    public static <V, T extends V> T a(IRegistry<V> registry, int rawId, String id, T entry) {
        return ((IRegistryWritable)registry).a(rawId, ResourceKey.a(registry.c, new MinecraftKey(id)), entry, Lifecycle.stable());
    }

    static {
        RegistryGeneration.a();
        b.forEach((? super K id, ? super V defaultEntry) -> {
            if (defaultEntry.get() == null) {
                d.error("Unable to bootstrap registry '{}'", id);
            }
        });
        IRegistry.a(f);
    }
}

