/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.AbstractIterator;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Immutable
public class BlockPosition
extends BaseBlockPosition {
    public static final Codec<BlockPosition> a = Codec.INT_STREAM.comapFlatMap(stream -> SystemUtils.a(stream, 3).map(values -> new BlockPosition(values[0], values[1], values[2])), pos -> IntStream.of(pos.u(), pos.v(), pos.w())).stable();
    private static final Logger d = LogManager.getLogger();
    public static final BlockPosition b = new BlockPosition(0, 0, 0);
    private static final int e = 26;
    private static final int h = 26;
    public static final int c = 12;
    private static final long i = 0x3FFFFFFL;
    private static final long j = 4095L;
    private static final long k = 0x3FFFFFFL;
    private static final int m = 12;
    private static final int n = 38;

    public BlockPosition(int x2, int y2, int z2) {
        super(x2, y2, z2);
    }

    public BlockPosition(double x2, double y2, double z2) {
        super(x2, y2, z2);
    }

    public BlockPosition(Vec3D pos) {
        this(pos.b, pos.c, pos.d);
    }

    public BlockPosition(IPosition pos) {
        this(pos.a(), pos.b(), pos.c());
    }

    public BlockPosition(BaseBlockPosition pos) {
        this(pos.u(), pos.v(), pos.w());
    }

    public static long getAdjacent(int baseX, int baseY, int baseZ, EnumDirection enumdirection) {
        return BlockPosition.a(baseX + enumdirection.i(), baseY + enumdirection.j(), baseZ + enumdirection.k());
    }

    public static long a(long value, EnumDirection direction) {
        return BlockPosition.a(value, direction.i(), direction.j(), direction.k());
    }

    public static long a(long value, int x2, int y2, int z2) {
        return BlockPosition.a((int)(value >> 38) + x2, (int)(value << 52 >> 52) + y2, (int)(value << 26 >> 38) + z2);
    }

    public static int a(long packedPos) {
        return (int)(packedPos >> 38);
    }

    public static int b(long packedPos) {
        return (int)(packedPos << 52 >> 52);
    }

    public static int c(long packedPos) {
        return (int)(packedPos << 26 >> 38);
    }

    public static BlockPosition d(long packedPos) {
        return new BlockPosition((int)(packedPos >> 38), (int)(packedPos << 52 >> 52), (int)(packedPos << 26 >> 38));
    }

    public long a() {
        return BlockPosition.a(this.u(), this.v(), this.w());
    }

    public static long a(int x2, int y2, int z2) {
        return ((long)x2 & 0x3FFFFFFL) << 38 | (long)y2 & 0xFFFL | ((long)z2 & 0x3FFFFFFL) << 12;
    }

    public static long e(long y2) {
        return y2 & 0xFFFFFFFFFFFFFFF0L;
    }

    public BlockPosition a(double d2, double e2, double f2) {
        return d2 == 0.0 && e2 == 0.0 && f2 == 0.0 ? this : new BlockPosition((double)this.u() + d2, (double)this.v() + e2, (double)this.w() + f2);
    }

    public BlockPosition b(int i2, int j2, int k2) {
        return i2 == 0 && j2 == 0 && k2 == 0 ? this : new BlockPosition(this.u() + i2, this.v() + j2, this.w() + k2);
    }

    public BlockPosition a(BaseBlockPosition vec3i) {
        return this.b(vec3i.u(), vec3i.v(), vec3i.w());
    }

    public BlockPosition b(BaseBlockPosition vec3i) {
        return this.b(-vec3i.u(), -vec3i.v(), -vec3i.w());
    }

    public BlockPosition a(int i2) {
        if (i2 == 1) {
            return this;
        }
        return i2 == 0 ? b : new BlockPosition(this.u() * i2, this.v() * i2, this.w() * i2);
    }

    public BlockPosition b() {
        return new BlockPosition(this.u(), this.v() + 1, this.w());
    }

    public BlockPosition b(int distance) {
        return distance == 0 ? this : new BlockPosition(this.u(), this.v() + distance, this.w());
    }

    public BlockPosition c() {
        return new BlockPosition(this.u(), this.v() - 1, this.w());
    }

    public BlockPosition c(int i2) {
        return i2 == 0 ? this : new BlockPosition(this.u(), this.v() - i2, this.w());
    }

    public BlockPosition d() {
        return new BlockPosition(this.u(), this.v(), this.w() - 1);
    }

    public BlockPosition d(int distance) {
        return distance == 0 ? this : new BlockPosition(this.u(), this.v(), this.w() - distance);
    }

    public BlockPosition e() {
        return new BlockPosition(this.u(), this.v(), this.w() + 1);
    }

    public BlockPosition e(int distance) {
        return distance == 0 ? this : new BlockPosition(this.u(), this.v(), this.w() + distance);
    }

    public BlockPosition f() {
        return new BlockPosition(this.u() - 1, this.v(), this.w());
    }

    public BlockPosition f(int distance) {
        return distance == 0 ? this : new BlockPosition(this.u() - distance, this.v(), this.w());
    }

    public BlockPosition g() {
        return new BlockPosition(this.u() + 1, this.v(), this.w());
    }

    public BlockPosition g(int distance) {
        return distance == 0 ? this : new BlockPosition(this.u() + distance, this.v(), this.w());
    }

    public BlockPosition a(EnumDirection direction) {
        switch (direction) {
            case b: {
                return new BlockPosition(this.u(), this.v() + 1, this.w());
            }
            case a: {
                return new BlockPosition(this.u(), this.v() - 1, this.w());
            }
            case c: {
                return new BlockPosition(this.u(), this.v(), this.w() - 1);
            }
            case d: {
                return new BlockPosition(this.u(), this.v(), this.w() + 1);
            }
            case e: {
                return new BlockPosition(this.u() - 1, this.v(), this.w());
            }
            case f: {
                return new BlockPosition(this.u() + 1, this.v(), this.w());
            }
        }
        return new BlockPosition(this.u() + direction.i(), this.v() + direction.j(), this.w() + direction.k());
    }

    public BlockPosition a(EnumDirection direction, int i2) {
        return i2 == 0 ? this : new BlockPosition(this.u() + direction.i() * i2, this.v() + direction.j() * i2, this.w() + direction.k() * i2);
    }

    public BlockPosition a(EnumDirection.EnumAxis axis, int i2) {
        if (i2 == 0) {
            return this;
        }
        int j2 = axis == EnumDirection.EnumAxis.a ? i2 : 0;
        int k2 = axis == EnumDirection.EnumAxis.b ? i2 : 0;
        int l2 = axis == EnumDirection.EnumAxis.c ? i2 : 0;
        return new BlockPosition(this.u() + j2, this.v() + k2, this.w() + l2);
    }

    public BlockPosition a(EnumBlockRotation rotation) {
        switch (rotation) {
            default: {
                return this;
            }
            case b: {
                return new BlockPosition(-this.w(), this.v(), this.u());
            }
            case c: {
                return new BlockPosition(-this.u(), this.v(), -this.w());
            }
            case d: 
        }
        return new BlockPosition(this.w(), this.v(), -this.u());
    }

    public BlockPosition c(BaseBlockPosition pos) {
        return new BlockPosition(this.v() * pos.w() - this.w() * pos.v(), this.w() * pos.u() - this.u() * pos.w(), this.u() * pos.v() - this.v() * pos.u());
    }

    public BlockPosition h(int y2) {
        return new BlockPosition(this.u(), y2, this.w());
    }

    public BlockPosition h() {
        return this;
    }

    public MutableBlockPosition i() {
        return new MutableBlockPosition(this.u(), this.v(), this.w());
    }

    public static Iterable<BlockPosition> a(Random random, int count, BlockPosition around, int range) {
        return BlockPosition.a(random, count, around.u() - range, around.v() - range, around.w() - range, around.u() + range, around.v() + range, around.w() + range);
    }

    public static Iterable<BlockPosition> a(final Random random, final int count, final int minX, final int minY, final int minZ, int maxX, int maxY, int maxZ) {
        final int i2 = maxX - minX + 1;
        final int j2 = maxY - minY + 1;
        final int k2 = maxZ - minZ + 1;
        return () -> new AbstractIterator<BlockPosition>(){
            final MutableBlockPosition a = new MutableBlockPosition();
            int b = count;

            protected BlockPosition a() {
                if (this.b <= 0) {
                    return (BlockPosition)this.endOfData();
                }
                MutableBlockPosition blockPos = this.a.d(minX + random.nextInt(i2), minY + random.nextInt(j2), minZ + random.nextInt(k2));
                --this.b;
                return blockPos;
            }
        };
    }

    public static Iterable<BlockPosition> a(BlockPosition center, final int rangeX, final int rangeY, final int rangeZ) {
        final int i2 = rangeX + rangeY + rangeZ;
        final int centerX = center.u();
        final int centerY = center.v();
        final int centerZ = center.w();
        return () -> new AbstractIterator<BlockPosition>(){
            private final MutableBlockPosition h = new MutableBlockPosition();
            private int i;
            private int j;
            private int k;
            private int l;
            private int m;
            private boolean n;

            protected BlockPosition a() {
                if (this.n) {
                    this.n = false;
                    this.h.r(centerZ - (this.h.w() - centerZ));
                    return this.h;
                }
                MutableBlockPosition blockPos = null;
                while (blockPos == null) {
                    if (this.m > this.k) {
                        ++this.l;
                        if (this.l > this.j) {
                            ++this.i;
                            if (this.i > i2) {
                                return (BlockPosition)this.endOfData();
                            }
                            this.j = Math.min(rangeX, this.i);
                            this.l = -this.j;
                        }
                        this.k = Math.min(rangeY, this.i - Math.abs(this.l));
                        this.m = -this.k;
                    }
                    int i22 = this.l;
                    int j2 = this.m;
                    int k2 = this.i - Math.abs(i22) - Math.abs(j2);
                    if (k2 <= rangeZ) {
                        this.n = k2 != 0;
                        blockPos = this.h.d(centerX + i22, centerY + j2, centerZ + k2);
                    }
                    ++this.m;
                }
                return blockPos;
            }
        };
    }

    public static Optional<BlockPosition> a(BlockPosition pos, int horizontalRange, int verticalRange, Predicate<BlockPosition> condition) {
        for (BlockPosition blockPos : BlockPosition.a(pos, horizontalRange, verticalRange, horizontalRange)) {
            if (!condition.test(blockPos)) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    public static Stream<BlockPosition> b(BlockPosition center, int maxX, int maxY, int maxZ) {
        return StreamSupport.stream(BlockPosition.a(center, maxX, maxY, maxZ).spliterator(), false);
    }

    public static Iterable<BlockPosition> a(BlockPosition start, BlockPosition end) {
        return BlockPosition.b(Math.min(start.u(), end.u()), Math.min(start.v(), end.v()), Math.min(start.w(), end.w()), Math.max(start.u(), end.u()), Math.max(start.v(), end.v()), Math.max(start.w(), end.w()));
    }

    public static Stream<BlockPosition> b(BlockPosition start, BlockPosition end) {
        return StreamSupport.stream(BlockPosition.a(start, end).spliterator(), false);
    }

    public static Stream<BlockPosition> a(StructureBoundingBox box) {
        return BlockPosition.a(Math.min(box.g(), box.j()), Math.min(box.h(), box.k()), Math.min(box.i(), box.l()), Math.max(box.g(), box.j()), Math.max(box.h(), box.k()), Math.max(box.i(), box.l()));
    }

    public static Stream<BlockPosition> a(AxisAlignedBB box) {
        return BlockPosition.a(MathHelper.b(box.a), MathHelper.b(box.b), MathHelper.b(box.c), MathHelper.b(box.d), MathHelper.b(box.e), MathHelper.b(box.f));
    }

    public static Stream<BlockPosition> a(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        return StreamSupport.stream(BlockPosition.b(startX, startY, startZ, endX, endY, endZ).spliterator(), false);
    }

    public static Iterable<BlockPosition> b(final int startX, final int startY, final int startZ, int endX, int endY, int endZ) {
        final int i2 = endX - startX + 1;
        final int j2 = endY - startY + 1;
        int k2 = endZ - startZ + 1;
        final int l2 = i2 * j2 * k2;
        return () -> new AbstractIterator<BlockPosition>(){
            private final MutableBlockPosition g = new MutableBlockPosition();
            private int h;

            protected BlockPosition a() {
                if (this.h == l2) {
                    return (BlockPosition)this.endOfData();
                }
                int offsetX = this.h % i2;
                int u2 = this.h / i2;
                int offsetY = u2 % j2;
                int offsetZ = u2 / j2;
                ++this.h;
                return this.g.d(startX + offsetX, startY + offsetY, startZ + offsetZ);
            }
        };
    }

    public static Iterable<MutableBlockPosition> a(final BlockPosition center, final int radius, final EnumDirection firstDirection, final EnumDirection secondDirection) {
        Validate.validState((firstDirection.n() != secondDirection.n() ? 1 : 0) != 0, (String)"The two directions cannot be on the same axis", (Object[])new Object[0]);
        return () -> new AbstractIterator<MutableBlockPosition>(){
            private final EnumDirection[] e;
            private final MutableBlockPosition f;
            private final int g;
            private int h;
            private int i;
            private int j;
            private int k;
            private int l;
            private int m;
            {
                this.e = new EnumDirection[]{firstDirection, secondDirection, firstDirection.f(), secondDirection.f()};
                this.f = center.i().c(secondDirection);
                this.g = 4 * radius;
                this.h = -1;
                this.k = this.f.u();
                this.l = this.f.v();
                this.m = this.f.w();
            }

            protected MutableBlockPosition a() {
                this.f.d(this.k, this.l, this.m).c(this.e[(this.h + 4) % 4]);
                this.k = this.f.u();
                this.l = this.f.v();
                this.m = this.f.w();
                if (this.j >= this.i) {
                    if (this.h >= this.g) {
                        return (MutableBlockPosition)this.endOfData();
                    }
                    ++this.h;
                    this.j = 0;
                    this.i = this.h / 2 + 1;
                }
                ++this.j;
                return this.f;
            }
        };
    }

    public static class MutableBlockPosition
    extends BlockPosition {
        public MutableBlockPosition() {
            this(0, 0, 0);
        }

        public MutableBlockPosition(int x2, int y2, int z2) {
            super(x2, y2, z2);
        }

        public MutableBlockPosition(double x2, double y2, double z2) {
            this(MathHelper.b(x2), MathHelper.b(y2), MathHelper.b(z2));
        }

        @Override
        public BlockPosition a(double d2, double e2, double f2) {
            return super.a(d2, e2, f2).h();
        }

        @Override
        public BlockPosition b(int i2, int j2, int k2) {
            return super.b(i2, j2, k2).h();
        }

        @Override
        public BlockPosition a(int i2) {
            return super.a(i2).h();
        }

        @Override
        public BlockPosition a(EnumDirection direction, int i2) {
            return super.a(direction, i2).h();
        }

        @Override
        public BlockPosition a(EnumDirection.EnumAxis axis, int i2) {
            return super.a(axis, i2).h();
        }

        @Override
        public BlockPosition a(EnumBlockRotation rotation) {
            return super.a(rotation).h();
        }

        public MutableBlockPosition d(int x2, int y2, int z2) {
            ((BaseBlockPosition)this).a = x2;
            ((BaseBlockPosition)this).b = y2;
            ((BaseBlockPosition)this).c = z2;
            return this;
        }

        public MutableBlockPosition c(double x2, double y2, double z2) {
            return this.d(MathHelper.b(x2), MathHelper.b(y2), MathHelper.b(z2));
        }

        public MutableBlockPosition g(BaseBlockPosition pos) {
            return this.d(pos.u(), pos.v(), pos.w());
        }

        public MutableBlockPosition f(long pos) {
            return this.d(MutableBlockPosition.a(pos), MutableBlockPosition.b(pos), MutableBlockPosition.c(pos));
        }

        public MutableBlockPosition a(EnumAxisCycle axis, int x2, int y2, int z2) {
            return this.d(axis.a(x2, y2, z2, EnumDirection.EnumAxis.a), axis.a(x2, y2, z2, EnumDirection.EnumAxis.b), axis.a(x2, y2, z2, EnumDirection.EnumAxis.c));
        }

        public MutableBlockPosition a(BaseBlockPosition pos, EnumDirection direction) {
            return this.d(pos.u() + direction.i(), pos.v() + direction.j(), pos.w() + direction.k());
        }

        public MutableBlockPosition a(BaseBlockPosition pos, int x2, int y2, int z2) {
            return this.d(pos.u() + x2, pos.v() + y2, pos.w() + z2);
        }

        public MutableBlockPosition a(BaseBlockPosition vec1, BaseBlockPosition vec2) {
            return this.d(vec1.u() + vec2.u(), vec1.v() + vec2.v(), vec1.w() + vec2.w());
        }

        public MutableBlockPosition c(EnumDirection direction) {
            return this.c(direction, 1);
        }

        public MutableBlockPosition c(EnumDirection direction, int distance) {
            return this.d(this.u() + direction.i() * distance, this.v() + direction.j() * distance, this.w() + direction.k() * distance);
        }

        public MutableBlockPosition e(int dx, int dy, int dz) {
            return this.d(this.u() + dx, this.v() + dy, this.w() + dz);
        }

        public MutableBlockPosition h(BaseBlockPosition vec) {
            return this.d(this.u() + vec.u(), this.v() + vec.v(), this.w() + vec.w());
        }

        public MutableBlockPosition a(EnumDirection.EnumAxis axis, int min, int max) {
            switch (axis) {
                case a: {
                    return this.d(MathHelper.a(this.u(), min, max), this.v(), this.w());
                }
                case b: {
                    return this.d(this.u(), MathHelper.a(this.v(), min, max), this.w());
                }
                case c: {
                    return this.d(this.u(), this.v(), MathHelper.a(this.w(), min, max));
                }
            }
            throw new IllegalStateException("Unable to clamp axis " + axis);
        }

        public MutableBlockPosition p(int i2) {
            ((BaseBlockPosition)this).a = i2;
            return this;
        }

        public MutableBlockPosition q(int i2) {
            ((BaseBlockPosition)this).b = i2;
            return this;
        }

        public MutableBlockPosition r(int i2) {
            ((BaseBlockPosition)this).c = i2;
            return this;
        }

        @Override
        public BlockPosition h() {
            return new BlockPosition(this);
        }
    }
}

