/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentAngle;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEnchantment;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentEntitySummon;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ArgumentMathOperation;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentMobEffect;
import net.minecraft.commands.arguments.ArgumentNBTBase;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentSerializerVoid;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializers;
import net.minecraft.gametest.framework.GameTestHarnessTestClassArgument;
import net.minecraft.gametest.framework.GameTestHarnessTestFunctionArgument;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArgumentRegistry {
    private static final Logger a = LogManager.getLogger();
    private static final Map<Class<?>, a<?>> b = Maps.newHashMap();
    private static final Map<MinecraftKey, a<?>> c = Maps.newHashMap();

    public static <T extends ArgumentType<?>> void a(String id, Class<T> argClass, ArgumentSerializer<T> serializer) {
        MinecraftKey resourceLocation = new MinecraftKey(id);
        if (b.containsKey(argClass)) {
            throw new IllegalArgumentException("Class " + argClass.getName() + " already has a serializer!");
        }
        if (c.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("'" + resourceLocation + "' is already a registered serializer!");
        }
        a<T> entry = new a<T>(argClass, serializer, resourceLocation);
        b.put(argClass, entry);
        c.put(resourceLocation, entry);
    }

    public static void a() {
        ArgumentSerializers.a();
        ArgumentRegistry.a("entity", ArgumentEntity.class, new ArgumentEntity.a());
        ArgumentRegistry.a("game_profile", ArgumentProfile.class, new ArgumentSerializerVoid<ArgumentProfile>(ArgumentProfile::a));
        ArgumentRegistry.a("block_pos", ArgumentPosition.class, new ArgumentSerializerVoid<ArgumentPosition>(ArgumentPosition::a));
        ArgumentRegistry.a("column_pos", ArgumentVec2I.class, new ArgumentSerializerVoid<ArgumentVec2I>(ArgumentVec2I::a));
        ArgumentRegistry.a("vec3", ArgumentVec3.class, new ArgumentSerializerVoid<ArgumentVec3>(ArgumentVec3::a));
        ArgumentRegistry.a("vec2", ArgumentVec2.class, new ArgumentSerializerVoid<ArgumentVec2>(ArgumentVec2::a));
        ArgumentRegistry.a("block_state", ArgumentTile.class, new ArgumentSerializerVoid<ArgumentTile>(ArgumentTile::a));
        ArgumentRegistry.a("block_predicate", ArgumentBlockPredicate.class, new ArgumentSerializerVoid<ArgumentBlockPredicate>(ArgumentBlockPredicate::a));
        ArgumentRegistry.a("item_stack", ArgumentItemStack.class, new ArgumentSerializerVoid<ArgumentItemStack>(ArgumentItemStack::a));
        ArgumentRegistry.a("item_predicate", ArgumentItemPredicate.class, new ArgumentSerializerVoid<ArgumentItemPredicate>(ArgumentItemPredicate::a));
        ArgumentRegistry.a("color", ArgumentChatFormat.class, new ArgumentSerializerVoid<ArgumentChatFormat>(ArgumentChatFormat::a));
        ArgumentRegistry.a("component", ArgumentChatComponent.class, new ArgumentSerializerVoid<ArgumentChatComponent>(ArgumentChatComponent::a));
        ArgumentRegistry.a("message", ArgumentChat.class, new ArgumentSerializerVoid<ArgumentChat>(ArgumentChat::a));
        ArgumentRegistry.a("nbt_compound_tag", ArgumentNBTTag.class, new ArgumentSerializerVoid<ArgumentNBTTag>(ArgumentNBTTag::a));
        ArgumentRegistry.a("nbt_tag", ArgumentNBTBase.class, new ArgumentSerializerVoid<ArgumentNBTBase>(ArgumentNBTBase::a));
        ArgumentRegistry.a("nbt_path", ArgumentNBTKey.class, new ArgumentSerializerVoid<ArgumentNBTKey>(ArgumentNBTKey::a));
        ArgumentRegistry.a("objective", ArgumentScoreboardObjective.class, new ArgumentSerializerVoid<ArgumentScoreboardObjective>(ArgumentScoreboardObjective::a));
        ArgumentRegistry.a("objective_criteria", ArgumentScoreboardCriteria.class, new ArgumentSerializerVoid<ArgumentScoreboardCriteria>(ArgumentScoreboardCriteria::a));
        ArgumentRegistry.a("operation", ArgumentMathOperation.class, new ArgumentSerializerVoid<ArgumentMathOperation>(ArgumentMathOperation::a));
        ArgumentRegistry.a("particle", ArgumentParticle.class, new ArgumentSerializerVoid<ArgumentParticle>(ArgumentParticle::a));
        ArgumentRegistry.a("angle", ArgumentAngle.class, new ArgumentSerializerVoid<ArgumentAngle>(ArgumentAngle::a));
        ArgumentRegistry.a("rotation", ArgumentRotation.class, new ArgumentSerializerVoid<ArgumentRotation>(ArgumentRotation::a));
        ArgumentRegistry.a("scoreboard_slot", ArgumentScoreboardSlot.class, new ArgumentSerializerVoid<ArgumentScoreboardSlot>(ArgumentScoreboardSlot::a));
        ArgumentRegistry.a("score_holder", ArgumentScoreholder.class, new ArgumentScoreholder.c());
        ArgumentRegistry.a("swizzle", ArgumentRotationAxis.class, new ArgumentSerializerVoid<ArgumentRotationAxis>(ArgumentRotationAxis::a));
        ArgumentRegistry.a("team", ArgumentScoreboardTeam.class, new ArgumentSerializerVoid<ArgumentScoreboardTeam>(ArgumentScoreboardTeam::a));
        ArgumentRegistry.a("item_slot", ArgumentInventorySlot.class, new ArgumentSerializerVoid<ArgumentInventorySlot>(ArgumentInventorySlot::a));
        ArgumentRegistry.a("resource_location", ArgumentMinecraftKeyRegistered.class, new ArgumentSerializerVoid<ArgumentMinecraftKeyRegistered>(ArgumentMinecraftKeyRegistered::a));
        ArgumentRegistry.a("mob_effect", ArgumentMobEffect.class, new ArgumentSerializerVoid<ArgumentMobEffect>(ArgumentMobEffect::a));
        ArgumentRegistry.a("function", ArgumentTag.class, new ArgumentSerializerVoid<ArgumentTag>(ArgumentTag::a));
        ArgumentRegistry.a("entity_anchor", ArgumentAnchor.class, new ArgumentSerializerVoid<ArgumentAnchor>(ArgumentAnchor::a));
        ArgumentRegistry.a("int_range", ArgumentCriterionValue.b.class, new ArgumentSerializerVoid<ArgumentCriterionValue.b>(ArgumentCriterionValue::a));
        ArgumentRegistry.a("float_range", ArgumentCriterionValue.a.class, new ArgumentSerializerVoid<ArgumentCriterionValue.a>(ArgumentCriterionValue::b));
        ArgumentRegistry.a("item_enchantment", ArgumentEnchantment.class, new ArgumentSerializerVoid<ArgumentEnchantment>(ArgumentEnchantment::a));
        ArgumentRegistry.a("entity_summon", ArgumentEntitySummon.class, new ArgumentSerializerVoid<ArgumentEntitySummon>(ArgumentEntitySummon::a));
        ArgumentRegistry.a("dimension", ArgumentDimension.class, new ArgumentSerializerVoid<ArgumentDimension>(ArgumentDimension::a));
        ArgumentRegistry.a("time", ArgumentTime.class, new ArgumentSerializerVoid<ArgumentTime>(ArgumentTime::a));
        ArgumentRegistry.a("uuid", ArgumentUUID.class, new ArgumentSerializerVoid<ArgumentUUID>(ArgumentUUID::a));
        if (SharedConstants.aJ) {
            ArgumentRegistry.a("test_argument", GameTestHarnessTestFunctionArgument.class, new ArgumentSerializerVoid<GameTestHarnessTestFunctionArgument>(GameTestHarnessTestFunctionArgument::a));
            ArgumentRegistry.a("test_class", GameTestHarnessTestClassArgument.class, new ArgumentSerializerVoid<GameTestHarnessTestClassArgument>(GameTestHarnessTestClassArgument::a));
        }
    }

    @Nullable
    private static a<?> a(MinecraftKey id) {
        return c.get(id);
    }

    @Nullable
    private static a<?> b(ArgumentType<?> type) {
        return b.get(type.getClass());
    }

    public static <T extends ArgumentType<?>> void a(PacketDataSerializer buf, T type) {
        a<?> entry = ArgumentRegistry.b(type);
        if (entry == null) {
            a.error("Could not serialize {} ({}) - will not be sent to client!", type, type.getClass());
            buf.a(new MinecraftKey(""));
            return;
        }
        buf.a(entry.c);
        entry.b.a(type, buf);
    }

    @Nullable
    public static ArgumentType<?> a(PacketDataSerializer buf) {
        MinecraftKey resourceLocation = buf.q();
        a<?> entry = ArgumentRegistry.a(resourceLocation);
        if (entry == null) {
            a.error("Could not deserialize {}", (Object)resourceLocation);
            return null;
        }
        return entry.b.b(buf);
    }

    private static <T extends ArgumentType<?>> void a(JsonObject json, T type) {
        a<?> entry = ArgumentRegistry.b(type);
        if (entry == null) {
            a.error("Could not serialize argument {} ({})!", type, type.getClass());
            json.addProperty("type", "unknown");
        } else {
            json.addProperty("type", "argument");
            json.addProperty("parser", entry.c.toString());
            JsonObject jsonObject = new JsonObject();
            entry.b.a(type, jsonObject);
            if (jsonObject.size() > 0) {
                json.add("properties", (JsonElement)jsonObject);
            }
        }
    }

    public static <S> JsonObject a(CommandDispatcher<S> dispatcher, CommandNode<S> commandNode) {
        Collection<String> collection;
        JsonObject jsonObject = new JsonObject();
        if (commandNode instanceof RootCommandNode) {
            jsonObject.addProperty("type", "root");
        } else if (commandNode instanceof LiteralCommandNode) {
            jsonObject.addProperty("type", "literal");
        } else if (commandNode instanceof ArgumentCommandNode) {
            ArgumentRegistry.a(jsonObject, ((ArgumentCommandNode)commandNode).getType());
        } else {
            a.error("Could not serialize node {} ({})!", commandNode, commandNode.getClass());
            jsonObject.addProperty("type", "unknown");
        }
        JsonObject jsonObject2 = new JsonObject();
        for (CommandNode<S> commandNode2 : commandNode.getChildren()) {
            jsonObject2.add(commandNode2.getName(), (JsonElement)ArgumentRegistry.a(dispatcher, commandNode2));
        }
        if (jsonObject2.size() > 0) {
            jsonObject.add("children", (JsonElement)jsonObject2);
        }
        if (commandNode.getCommand() != null) {
            jsonObject.addProperty("executable", Boolean.valueOf(true));
        }
        if (commandNode.getRedirect() != null && !(collection = dispatcher.getPath(commandNode.getRedirect())).isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (String string : collection) {
                jsonArray.add(string);
            }
            jsonObject.add("redirect", (JsonElement)jsonArray);
        }
        return jsonObject;
    }

    public static boolean a(ArgumentType<?> type) {
        return ArgumentRegistry.b(type) != null;
    }

    public static <T> Set<ArgumentType<?>> a(CommandNode<T> node) {
        Set set = Sets.newIdentityHashSet();
        HashSet set2 = Sets.newHashSet();
        ArgumentRegistry.a(node, set2, set);
        return set2;
    }

    private static <T> void a(CommandNode<T> node2, Set<ArgumentType<?>> argumentTypes, Set<CommandNode<T>> ignoredNodes) {
        if (!ignoredNodes.add(node2)) {
            return;
        }
        if (node2 instanceof ArgumentCommandNode) {
            argumentTypes.add(((ArgumentCommandNode)node2).getType());
        }
        node2.getChildren().forEach(node -> ArgumentRegistry.a(node, argumentTypes, ignoredNodes));
        CommandNode<T> commandNode = node2.getRedirect();
        if (commandNode != null) {
            ArgumentRegistry.a(commandNode, argumentTypes, ignoredNodes);
        }
    }

    static class a<T extends ArgumentType<?>> {
        public final Class<T> a;
        public final ArgumentSerializer<T> b;
        public final MinecraftKey c;

        a(Class<T> argClass, ArgumentSerializer<T> serializer, MinecraftKey id) {
            this.a = argClass;
            this.b = serializer;
            this.c = id;
        }
    }
}

