/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntitySelector {
    public static final int a = Integer.MAX_VALUE;
    private static final EntityTypeTest<Entity, ?> b = new EntityTypeTest<Entity, Entity>(){

        @Override
        public Entity a(Entity obj) {
            return obj;
        }

        @Override
        public Class<? extends Entity> a() {
            return Entity.class;
        }
    };
    private final int c;
    private final boolean d;
    private final boolean e;
    private final Predicate<Entity> f;
    private final CriterionConditionValue.DoubleRange g;
    private final Function<Vec3D, Vec3D> h;
    @Nullable
    private final AxisAlignedBB i;
    private final BiConsumer<Vec3D, List<? extends Entity>> j;
    private final boolean k;
    @Nullable
    private final String l;
    @Nullable
    private final UUID m;
    private EntityTypeTest<Entity, ?> n;
    private final boolean o;

    public EntitySelector(int count, boolean includesNonPlayers, boolean localWorldOnly, Predicate<Entity> basePredicate, CriterionConditionValue.DoubleRange distance, Function<Vec3D, Vec3D> positionOffset, @Nullable AxisAlignedBB box, BiConsumer<Vec3D, List<? extends Entity>> sorter, boolean senderOnly, @Nullable String playerName, @Nullable UUID uuid, @Nullable EntityTypes<?> type, boolean usesAt) {
        this.c = count;
        this.d = includesNonPlayers;
        this.e = localWorldOnly;
        this.f = basePredicate;
        this.g = distance;
        this.h = positionOffset;
        this.i = box;
        this.j = sorter;
        this.k = senderOnly;
        this.l = playerName;
        this.m = uuid;
        this.n = type == null ? b : type;
        this.o = usesAt;
    }

    public int a() {
        return this.c;
    }

    public boolean b() {
        return this.d;
    }

    public boolean c() {
        return this.k;
    }

    public boolean d() {
        return this.e;
    }

    public boolean e() {
        return this.o;
    }

    private void e(CommandListenerWrapper source) throws CommandSyntaxException {
        if (this.o && !source.hasPermission(2, "minecraft.command.selector")) {
            throw ArgumentEntity.f.create();
        }
    }

    public Entity a(CommandListenerWrapper source) throws CommandSyntaxException {
        this.e(source);
        List<? extends Entity> list = this.b(source);
        if (list.isEmpty()) {
            throw ArgumentEntity.d.create();
        }
        if (list.size() > 1) {
            throw ArgumentEntity.a.create();
        }
        return list.get(0);
    }

    public List<? extends Entity> b(CommandListenerWrapper source) throws CommandSyntaxException {
        this.e(source);
        if (!this.d) {
            return this.d(source);
        }
        if (this.l != null) {
            EntityPlayer entityplayer = source.j().ac().a(this.l);
            return entityplayer == null ? Collections.emptyList() : Lists.newArrayList((Object[])new EntityPlayer[]{entityplayer});
        }
        if (this.m != null) {
            WorldServer worldserver;
            Entity entity;
            Iterator<WorldServer> iterator = source.j().F().iterator();
            do {
                if (iterator.hasNext()) continue;
                return Collections.emptyList();
            } while ((entity = (worldserver = iterator.next()).a(this.m)) == null);
            return Lists.newArrayList((Object[])new Entity[]{entity});
        }
        Vec3D vec3d = this.h.apply(source.d());
        Predicate<Entity> predicate = this.a(vec3d);
        if (this.k) {
            return source.f() != null && predicate.test(source.f()) ? Lists.newArrayList((Object[])new Entity[]{source.f()}) : Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        if (this.d()) {
            this.a(list, source.e(), vec3d, predicate);
        } else {
            for (WorldServer worldserver1 : source.j().F()) {
                this.a(list, worldserver1, vec3d, predicate);
            }
        }
        return this.a(vec3d, list);
    }

    private void a(List<Entity> result, WorldServer world, Vec3D pos, Predicate<Entity> predicate) {
        if (this.i != null) {
            result.addAll(world.a(this.n, this.i.c(pos), predicate));
        } else {
            result.addAll(world.a(this.n, predicate));
        }
    }

    public EntityPlayer c(CommandListenerWrapper source) throws CommandSyntaxException {
        this.e(source);
        List<EntityPlayer> list = this.d(source);
        if (list.size() != 1) {
            throw ArgumentEntity.e.create();
        }
        return list.get(0);
    }

    public List<EntityPlayer> d(CommandListenerWrapper source) throws CommandSyntaxException {
        List<Object> object;
        this.e(source);
        if (this.l != null) {
            EntityPlayer entityplayer = source.j().ac().a(this.l);
            return entityplayer == null ? Collections.emptyList() : Lists.newArrayList((Object[])new EntityPlayer[]{entityplayer});
        }
        if (this.m != null) {
            EntityPlayer entityplayer = source.j().ac().a(this.m);
            return entityplayer == null ? Collections.emptyList() : Lists.newArrayList((Object[])new EntityPlayer[]{entityplayer});
        }
        Vec3D vec3d = this.h.apply(source.d());
        Predicate<Entity> predicate = this.a(vec3d);
        if (this.k) {
            EntityPlayer entityplayer1;
            if (source.f() instanceof EntityPlayer && predicate.test(entityplayer1 = (EntityPlayer)source.f())) {
                return Lists.newArrayList((Object[])new EntityPlayer[]{entityplayer1});
            }
            return Collections.emptyList();
        }
        if (this.d()) {
            object = source.e().a(predicate);
        } else {
            object = Lists.newArrayList();
            for (EntityPlayer entityplayer2 : source.j().ac().t()) {
                if (!predicate.test(entityplayer2)) continue;
                ((List)object).add(entityplayer2);
            }
        }
        return this.a(vec3d, object);
    }

    private Predicate<Entity> a(Vec3D pos) {
        Predicate<Entity> predicate = this.f;
        if (this.i != null) {
            AxisAlignedBB axisalignedbb = this.i.c(pos);
            predicate = predicate.and(entity -> axisalignedbb.c(entity.cw()));
        }
        if (!this.g.c()) {
            predicate = predicate.and(entity -> this.g.e(entity.f(pos)));
        }
        return predicate;
    }

    private <T extends Entity> List<T> a(Vec3D pos, List<T> entities) {
        if (entities.size() > 1) {
            this.j.accept(pos, entities);
        }
        return entities.subList(0, Math.min(this.c, entities.size()));
    }

    public static IChatBaseComponent a(List<? extends Entity> entities) {
        return ChatComponentUtils.b(entities, Entity::C_);
    }
}

