/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.ITagRegistry;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ArgumentBlockPredicate
implements ArgumentType<b> {
    private static final Collection<String> a = Arrays.asList("stone", "minecraft:stone", "stone[foo=bar]", "#stone", "#stone[foo=bar]{baz=nbt}");
    static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(id -> new ChatMessage("arguments.block.tag.unknown", id));

    public static ArgumentBlockPredicate a() {
        return new ArgumentBlockPredicate();
    }

    public b a(StringReader stringReader) throws CommandSyntaxException {
        final ArgumentBlock blockStateParser = new ArgumentBlock(stringReader, true).a(true);
        if (blockStateParser.b() != null) {
            final a blockPredicate = new a(blockStateParser.b(), blockStateParser.a().keySet(), blockStateParser.c());
            return new b(){

                @Override
                @Override
                public Predicate<ShapeDetectorBlock> a(ITagRegistry manager) {
                    return blockPredicate;
                }

                @Override
                @Override
                public boolean a() {
                    return blockPredicate.a();
                }
            };
        }
        final MinecraftKey resourceLocation = blockStateParser.d();
        return new b(){

            @Override
            @Override
            public Predicate<ShapeDetectorBlock> a(ITagRegistry manager) throws CommandSyntaxException {
                Tag<Block> tag = manager.a(IRegistry.k, resourceLocation, id -> b.create((Object)id.toString()));
                return new c(tag, blockStateParser.j(), blockStateParser.c());
            }

            @Override
            @Override
            public boolean a() {
                return blockStateParser.c() != null;
            }
        };
    }

    public static Predicate<ShapeDetectorBlock> a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ((b)context.getArgument(name, b.class)).a(((CommandListenerWrapper)context.getSource()).j().aD());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        StringReader stringReader = new StringReader(suggestionsBuilder.getInput());
        stringReader.setCursor(suggestionsBuilder.getStart());
        ArgumentBlock blockStateParser = new ArgumentBlock(stringReader, true);
        try {
            blockStateParser.a(true);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return blockStateParser.a(suggestionsBuilder, TagsBlock.a());
    }

    public Collection<String> getExamples() {
        return a;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    static class a
    implements Predicate<ShapeDetectorBlock> {
        private final IBlockData a;
        private final Set<IBlockState<?>> b;
        @Nullable
        private final NBTTagCompound c;

        public a(IBlockData state, Set<IBlockState<?>> properties, @Nullable NBTTagCompound nbt) {
            this.a = state;
            this.b = properties;
            this.c = nbt;
        }

        @Override
        public boolean a(ShapeDetectorBlock blockInWorld) {
            IBlockData blockState = blockInWorld.a();
            if (!blockState.a(this.a.b())) {
                return false;
            }
            for (IBlockState<?> property : this.b) {
                if (blockState.c(property) == this.a.c(property)) continue;
                return false;
            }
            if (this.c != null) {
                TileEntity blockEntity = blockInWorld.b();
                return blockEntity != null && GameProfileSerializer.a((NBTBase)this.c, blockEntity.m(), true);
            }
            return true;
        }

        public boolean a() {
            return this.c != null;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((ShapeDetectorBlock)object);
        }
    }

    public static interface b {
        public Predicate<ShapeDetectorBlock> a(ITagRegistry var1) throws CommandSyntaxException;

        public boolean a();
    }

    static class c
    implements Predicate<ShapeDetectorBlock> {
        private final Tag<Block> a;
        @Nullable
        private final NBTTagCompound b;
        private final Map<String, String> c;

        c(Tag<Block> tag, Map<String, String> properties, @Nullable NBTTagCompound nbt) {
            this.a = tag;
            this.c = properties;
            this.b = nbt;
        }

        @Override
        public boolean a(ShapeDetectorBlock blockInWorld) {
            IBlockData blockState = blockInWorld.a();
            if (!blockState.a(this.a)) {
                return false;
            }
            for (Map.Entry<String, String> entry : this.c.entrySet()) {
                IBlockState<?> property = blockState.b().m().a(entry.getKey());
                if (property == null) {
                    return false;
                }
                Comparable comparable = property.b(entry.getValue()).orElse(null);
                if (comparable == null) {
                    return false;
                }
                if (blockState.c(property) == comparable) continue;
                return false;
            }
            if (this.b != null) {
                TileEntity blockEntity = blockInWorld.b();
                return blockEntity != null && GameProfileSerializer.a((NBTBase)this.b, blockEntity.m(), true);
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((ShapeDetectorBlock)object);
        }
    }
}

