/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world;

import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.WorldUtil;
import io.papermc.paper.world.ChunkEntitySlices;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.AxisAlignedBB;

public final class EntitySliceManager {
    protected static final int REGION_SHIFT = 5;
    protected static final int REGION_MASK = 31;
    protected static final int REGION_SIZE = 32;
    public final WorldServer world;
    private final StampedLock stateLock = new StampedLock();
    protected final Long2ObjectOpenHashMap<ChunkSlicesRegion> regions = new Long2ObjectOpenHashMap(64, 0.7f);
    private final int minSection;
    private final int maxSection;
    protected final Long2ObjectOpenHashMap<PlayerChunk.State> statusMap = new Long2ObjectOpenHashMap();

    public EntitySliceManager(WorldServer world) {
        this.statusMap.defaultReturnValue((Object)PlayerChunk.State.a);
        this.world = world;
        this.minSection = WorldUtil.getMinSection(world);
        this.maxSection = WorldUtil.getMaxSection(world);
    }

    public void chunkStatusChange(int x2, int z2, PlayerChunk.State newStatus) {
        if (newStatus == PlayerChunk.State.a) {
            this.statusMap.remove(CoordinateUtils.getChunkKey(x2, z2));
        } else {
            this.statusMap.put(CoordinateUtils.getChunkKey(x2, z2), (Object)newStatus);
            ChunkEntitySlices slices = this.getChunk(x2, z2);
            if (slices != null) {
                slices.updateStatus(newStatus);
            }
        }
    }

    public synchronized void addEntity(Entity entity) {
        BlockPosition pos = entity.cW();
        int sectionX = pos.u() >> 4;
        int sectionY = MathHelper.a(pos.v() >> 4, this.minSection, this.maxSection);
        int sectionZ = pos.w() >> 4;
        ChunkEntitySlices slices = this.getOrCreateChunk(sectionX, sectionZ);
        slices.addEntity(entity, sectionY);
        entity.sectionX = sectionX;
        entity.sectionY = sectionY;
        entity.sectionZ = sectionZ;
    }

    public synchronized void removeEntity(Entity entity) {
        ChunkEntitySlices slices = this.getChunk(entity.sectionX, entity.sectionZ);
        slices.removeEntity(entity, entity.sectionY);
        if (slices.isEmpty()) {
            this.removeChunk(entity.sectionX, entity.sectionZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveEntity(Entity entity) {
        BlockPosition newPos = entity.cW();
        int newSectionX = newPos.u() >> 4;
        int newSectionY = MathHelper.a(newPos.v() >> 4, this.minSection, this.maxSection);
        int newSectionZ = newPos.w() >> 4;
        if (newSectionX == entity.sectionX && newSectionY == entity.sectionY && newSectionZ == entity.sectionZ) {
            return;
        }
        EntitySliceManager entitySliceManager = this;
        synchronized (entitySliceManager) {
            ChunkEntitySlices slices;
            if (newSectionX != entity.sectionX || newSectionZ != entity.sectionZ) {
                ChunkEntitySlices old;
                ChunkEntitySlices slices2 = this.getOrCreateChunk(newSectionX, newSectionZ);
                ChunkEntitySlices chunkEntitySlices = old = this.getChunk(entity.sectionX, entity.sectionZ);
                synchronized (chunkEntitySlices) {
                    old.removeEntity(entity, entity.sectionY);
                    if (old.isEmpty()) {
                        this.removeChunk(entity.sectionX, entity.sectionZ);
                    }
                }
                chunkEntitySlices = slices2;
                synchronized (chunkEntitySlices) {
                    slices2.addEntity(entity, newSectionY);
                    entity.sectionX = newSectionX;
                    entity.sectionY = newSectionY;
                    entity.sectionZ = newSectionZ;
                }
            }
            ChunkEntitySlices chunkEntitySlices = slices = this.getChunk(newSectionX, newSectionZ);
            synchronized (chunkEntitySlices) {
                slices.removeEntity(entity, entity.sectionY);
                slices.addEntity(entity, newSectionY);
            }
            entity.sectionY = newSectionY;
        }
    }

    public void getEntities(Entity except, AxisAlignedBB box, List<Entity> into, Predicate<? super Entity> predicate) {
        int minChunkX = MathHelper.b(box.a) - 2 >> 4;
        int minChunkZ = MathHelper.b(box.c) - 2 >> 4;
        int maxChunkX = MathHelper.b(box.d) + 2 >> 4;
        int maxChunkZ = MathHelper.b(box.f) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.a(PlayerChunk.State.b)) continue;
                        chunk.getEntities(except, box, into, predicate);
                    }
                }
            }
        }
    }

    public void getHardCollidingEntities(Entity except, AxisAlignedBB box, List<Entity> into, Predicate<? super Entity> predicate) {
        int minChunkX = MathHelper.b(box.a) - 2 >> 4;
        int minChunkZ = MathHelper.b(box.c) - 2 >> 4;
        int maxChunkX = MathHelper.b(box.d) + 2 >> 4;
        int maxChunkZ = MathHelper.b(box.f) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.a(PlayerChunk.State.b)) continue;
                        chunk.getHardCollidingEntities(except, box, into, predicate);
                    }
                }
            }
        }
    }

    public <T extends Entity> void getEntities(EntityTypes<?> type, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        int minChunkX = MathHelper.b(box.a) - 2 >> 4;
        int minChunkZ = MathHelper.b(box.c) - 2 >> 4;
        int maxChunkX = MathHelper.b(box.d) + 2 >> 4;
        int maxChunkZ = MathHelper.b(box.f) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.a(PlayerChunk.State.b)) continue;
                        chunk.getEntities(type, box, into, predicate);
                    }
                }
            }
        }
    }

    public <T extends Entity> void getEntities(Class<? extends T> clazz, Entity except, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        int minChunkX = MathHelper.b(box.a) - 2 >> 4;
        int minChunkZ = MathHelper.b(box.c) - 2 >> 4;
        int maxChunkX = MathHelper.b(box.d) + 2 >> 4;
        int maxChunkZ = MathHelper.b(box.f) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.a(PlayerChunk.State.b)) continue;
                        chunk.getEntities(clazz, except, box, into, predicate);
                    }
                }
            }
        }
    }

    public ChunkEntitySlices getChunk(int chunkX, int chunkZ) {
        ChunkSlicesRegion region = this.getRegion(chunkX >> 5, chunkZ >> 5);
        if (region == null) {
            return null;
        }
        return region.get(chunkX & 0x1F | (chunkZ & 0x1F) << 5);
    }

    public ChunkEntitySlices getOrCreateChunk(int chunkX, int chunkZ) {
        ChunkEntitySlices ret;
        ChunkSlicesRegion region = this.getRegion(chunkX >> 5, chunkZ >> 5);
        if (region == null || (ret = region.get(chunkX & 0x1F | (chunkZ & 0x1F) << 5)) == null) {
            ret = new ChunkEntitySlices(this.world, chunkX, chunkZ, (PlayerChunk.State)((Object)this.statusMap.get(CoordinateUtils.getChunkKey(chunkX, chunkZ))), WorldUtil.getMinSection(this.world), WorldUtil.getMaxSection(this.world));
            this.addChunk(chunkX, chunkZ, ret);
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkSlicesRegion getRegion(int regionX, int regionZ) {
        long key = CoordinateUtils.getChunkKey(regionX, regionZ);
        long attempt = this.stateLock.tryOptimisticRead();
        if (attempt != 0L) {
            try {
                ChunkSlicesRegion ret = (ChunkSlicesRegion)this.regions.get(key);
                if (this.stateLock.validate(attempt)) {
                    return ret;
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.stateLock.readLock();
        try {
            ChunkSlicesRegion chunkSlicesRegion = (ChunkSlicesRegion)this.regions.get(key);
            return chunkSlicesRegion;
        }
        finally {
            this.stateLock.tryUnlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeChunk(int chunkX, int chunkZ) {
        long key = CoordinateUtils.getChunkKey(chunkX >> 5, chunkZ >> 5);
        int relIndex = chunkX & 0x1F | (chunkZ & 0x1F) << 5;
        ChunkSlicesRegion region = (ChunkSlicesRegion)this.regions.get(key);
        int remaining = region.remove(relIndex);
        if (remaining == 0) {
            this.stateLock.writeLock();
            try {
                this.regions.remove(key);
            }
            finally {
                this.stateLock.tryUnlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addChunk(int chunkX, int chunkZ, ChunkEntitySlices slices) {
        long key = CoordinateUtils.getChunkKey(chunkX >> 5, chunkZ >> 5);
        int relIndex = chunkX & 0x1F | (chunkZ & 0x1F) << 5;
        ChunkSlicesRegion region = (ChunkSlicesRegion)this.regions.get(key);
        if (region != null) {
            region.add(relIndex, slices);
        } else {
            region = new ChunkSlicesRegion();
            region.add(relIndex, slices);
            this.stateLock.writeLock();
            try {
                this.regions.put(key, (Object)region);
            }
            finally {
                this.stateLock.tryUnlockWrite();
            }
        }
    }

    public static final class ChunkSlicesRegion {
        protected final ChunkEntitySlices[] slices = new ChunkEntitySlices[1024];
        protected int sliceCount;

        public ChunkEntitySlices get(int index) {
            return this.slices[index];
        }

        public int remove(int index) {
            ChunkEntitySlices slices = this.slices[index];
            if (slices == null) {
                throw new IllegalStateException();
            }
            this.slices[index] = null;
            return --this.sliceCount;
        }

        public void add(int index, ChunkEntitySlices slices) {
            ChunkEntitySlices curr = this.slices[index];
            if (curr != null) {
                throw new IllegalStateException();
            }
            this.slices[index] = slices;
            ++this.sliceCount;
        }
    }
}

