/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;

public final class TickThread
extends Thread {
    public static final boolean STRICT_THREAD_CHECKS = Boolean.getBoolean("paper.strict-thread-checks");
    public final int id;

    public static void softEnsureTickThread(String reason) {
        if (!STRICT_THREAD_CHECKS) {
            return;
        }
        TickThread.ensureTickThread(reason);
    }

    public static void ensureTickThread(String reason) {
        if (!Bukkit.isPrimaryThread()) {
            MinecraftServer.r.fatal("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public TickThread(Runnable run, String name, int id) {
        super(run, name);
        this.id = id;
    }

    public static TickThread getCurrentTickThread() {
        return (TickThread)Thread.currentThread();
    }

    static {
        if (STRICT_THREAD_CHECKS) {
            MinecraftServer.r.warn("Strict thread checks enabled - performance may suffer");
        }
    }
}

