/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3fa;
import net.minecraft.util.MathHelper;

public class Vector4f {
    private float a;
    private float b;
    private float c;
    private float d;

    public Vector4f() {
    }

    public Vector4f(float x2, float y2, float z2, float w2) {
        this.a = x2;
        this.b = y2;
        this.c = z2;
        this.d = w2;
    }

    public Vector4f(Vector3fa vector) {
        this(vector.a(), vector.b(), vector.c(), 1.0f);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Vector4f vector4f = (Vector4f)object;
        if (Float.compare(vector4f.a, this.a) != 0) {
            return false;
        }
        if (Float.compare(vector4f.b, this.b) != 0) {
            return false;
        }
        if (Float.compare(vector4f.c, this.c) != 0) {
            return false;
        }
        return Float.compare(vector4f.d, this.d) == 0;
    }

    @Override
    public int hashCode() {
        int i2 = Float.floatToIntBits(this.a);
        i2 = 31 * i2 + Float.floatToIntBits(this.b);
        i2 = 31 * i2 + Float.floatToIntBits(this.c);
        i2 = 31 * i2 + Float.floatToIntBits(this.d);
        return i2;
    }

    public float a() {
        return this.a;
    }

    public float b() {
        return this.b;
    }

    public float c() {
        return this.c;
    }

    public float d() {
        return this.d;
    }

    public void a(float value) {
        this.a *= value;
        this.b *= value;
        this.c *= value;
        this.d *= value;
    }

    public void a(Vector3fa vector) {
        this.a *= vector.a();
        this.b *= vector.b();
        this.c *= vector.c();
    }

    public void a(float x2, float y2, float z2, float w2) {
        this.a = x2;
        this.b = y2;
        this.c = z2;
        this.d = w2;
    }

    public void b(float x2, float y2, float z2, float w2) {
        this.a += x2;
        this.b += y2;
        this.c += z2;
        this.d += w2;
    }

    public float a(Vector4f other) {
        return this.a * other.a + this.b * other.b + this.c * other.c + this.d * other.d;
    }

    public boolean e() {
        float f2 = this.a * this.a + this.b * this.b + this.c * this.c + this.d * this.d;
        if ((double)f2 < 1.0E-5) {
            return false;
        }
        float g2 = MathHelper.i(f2);
        this.a *= g2;
        this.b *= g2;
        this.c *= g2;
        this.d *= g2;
        return true;
    }

    public void a(Matrix4f matrix) {
        float f2 = this.a;
        float g2 = this.b;
        float h2 = this.c;
        float i2 = this.d;
        this.a = matrix.a * f2 + matrix.b * g2 + matrix.c * h2 + matrix.d * i2;
        this.b = matrix.e * f2 + matrix.f * g2 + matrix.g * h2 + matrix.h * i2;
        this.c = matrix.i * f2 + matrix.j * g2 + matrix.k * h2 + matrix.l * i2;
        this.d = matrix.m * f2 + matrix.n * g2 + matrix.o * h2 + matrix.p * i2;
    }

    public void a(Quaternion rotation) {
        Quaternion quaternion = new Quaternion(rotation);
        quaternion.a(new Quaternion(this.a(), this.b(), this.c(), 0.0f));
        Quaternion quaternion2 = new Quaternion(rotation);
        quaternion2.i();
        quaternion.a(quaternion2);
        this.a(quaternion.e(), quaternion.f(), quaternion.g(), this.d());
    }

    public void f() {
        this.a /= this.d;
        this.b /= this.d;
        this.c /= this.d;
        this.d = 1.0f;
    }

    public void a(Vector4f to, float delta) {
        float f2 = 1.0f - delta;
        this.a = this.a * f2 + to.a * delta;
        this.b = this.b * f2 + to.b * delta;
        this.c = this.c * f2 + to.c * delta;
        this.d = this.d * f2 + to.d * delta;
    }

    @Override
    public String toString() {
        return "[" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + "]";
    }
}

