/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.Vector3fa;
import net.minecraft.util.MathHelper;

public final class Quaternion {
    public static final Quaternion a = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private float b;
    private float c;
    private float d;
    private float e;

    public Quaternion(float x2, float y2, float z2, float w2) {
        this.b = x2;
        this.c = y2;
        this.d = z2;
        this.e = w2;
    }

    public Quaternion(Vector3fa axis, float rotationAngle, boolean degrees) {
        if (degrees) {
            rotationAngle *= (float)Math.PI / 180;
        }
        float f2 = Quaternion.c(rotationAngle / 2.0f);
        this.b = axis.a() * f2;
        this.c = axis.b() * f2;
        this.d = axis.c() * f2;
        this.e = Quaternion.b(rotationAngle / 2.0f);
    }

    public Quaternion(float x2, float y2, float z2, boolean degrees) {
        if (degrees) {
            x2 *= (float)Math.PI / 180;
            y2 *= (float)Math.PI / 180;
            z2 *= (float)Math.PI / 180;
        }
        float f2 = Quaternion.c(0.5f * x2);
        float g2 = Quaternion.b(0.5f * x2);
        float h2 = Quaternion.c(0.5f * y2);
        float i2 = Quaternion.b(0.5f * y2);
        float j2 = Quaternion.c(0.5f * z2);
        float k2 = Quaternion.b(0.5f * z2);
        this.b = f2 * i2 * k2 + g2 * h2 * j2;
        this.c = g2 * h2 * k2 - f2 * i2 * j2;
        this.d = f2 * h2 * k2 + g2 * i2 * j2;
        this.e = g2 * i2 * k2 - f2 * h2 * j2;
    }

    public Quaternion(Quaternion other) {
        this.b = other.b;
        this.c = other.c;
        this.d = other.d;
        this.e = other.e;
    }

    public static Quaternion a(float x2, float y2, float z2) {
        Quaternion quaternion = a.k();
        quaternion.a(new Quaternion(0.0f, (float)Math.sin(x2 / 2.0f), 0.0f, (float)Math.cos(x2 / 2.0f)));
        quaternion.a(new Quaternion((float)Math.sin(y2 / 2.0f), 0.0f, 0.0f, (float)Math.cos(y2 / 2.0f)));
        quaternion.a(new Quaternion(0.0f, 0.0f, (float)Math.sin(z2 / 2.0f), (float)Math.cos(z2 / 2.0f)));
        return quaternion;
    }

    public static Quaternion a(Vector3fa vector) {
        return Quaternion.b((float)Math.toRadians(vector.a()), (float)Math.toRadians(vector.b()), (float)Math.toRadians(vector.c()));
    }

    public static Quaternion b(Vector3fa vector) {
        return Quaternion.b(vector.a(), vector.b(), vector.c());
    }

    public static Quaternion b(float x2, float y2, float z2) {
        Quaternion quaternion = a.k();
        quaternion.a(new Quaternion((float)Math.sin(x2 / 2.0f), 0.0f, 0.0f, (float)Math.cos(x2 / 2.0f)));
        quaternion.a(new Quaternion(0.0f, (float)Math.sin(y2 / 2.0f), 0.0f, (float)Math.cos(y2 / 2.0f)));
        quaternion.a(new Quaternion(0.0f, 0.0f, (float)Math.sin(z2 / 2.0f), (float)Math.cos(z2 / 2.0f)));
        return quaternion;
    }

    public Vector3fa a() {
        float f2 = this.h() * this.h();
        float g2 = this.e() * this.e();
        float h2 = this.f() * this.f();
        float i2 = this.g() * this.g();
        float j2 = f2 + g2 + h2 + i2;
        float k2 = 2.0f * this.h() * this.e() - 2.0f * this.f() * this.g();
        float l2 = (float)Math.asin(k2 / j2);
        if (Math.abs(k2) > 0.999f * j2) {
            return new Vector3fa(2.0f * (float)Math.atan2(this.e(), this.h()), l2, 0.0f);
        }
        return new Vector3fa((float)Math.atan2(2.0f * this.f() * this.g() + 2.0f * this.e() * this.h(), f2 - g2 - h2 + i2), l2, (float)Math.atan2(2.0f * this.e() * this.f() + 2.0f * this.h() * this.g(), f2 + g2 - h2 - i2));
    }

    public Vector3fa b() {
        Vector3fa vector3f = this.a();
        return new Vector3fa((float)Math.toDegrees(vector3f.a()), (float)Math.toDegrees(vector3f.b()), (float)Math.toDegrees(vector3f.c()));
    }

    public Vector3fa c() {
        float f2 = this.h() * this.h();
        float g2 = this.e() * this.e();
        float h2 = this.f() * this.f();
        float i2 = this.g() * this.g();
        float j2 = f2 + g2 + h2 + i2;
        float k2 = 2.0f * this.h() * this.e() - 2.0f * this.f() * this.g();
        float l2 = (float)Math.asin(k2 / j2);
        if (Math.abs(k2) > 0.999f * j2) {
            return new Vector3fa(l2, 2.0f * (float)Math.atan2(this.f(), this.h()), 0.0f);
        }
        return new Vector3fa(l2, (float)Math.atan2(2.0f * this.e() * this.g() + 2.0f * this.f() * this.h(), f2 - g2 - h2 + i2), (float)Math.atan2(2.0f * this.e() * this.f() + 2.0f * this.h() * this.g(), f2 - g2 + h2 - i2));
    }

    public Vector3fa d() {
        Vector3fa vector3f = this.c();
        return new Vector3fa((float)Math.toDegrees(vector3f.a()), (float)Math.toDegrees(vector3f.b()), (float)Math.toDegrees(vector3f.c()));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Quaternion quaternion = (Quaternion)object;
        if (Float.compare(quaternion.b, this.b) != 0) {
            return false;
        }
        if (Float.compare(quaternion.c, this.c) != 0) {
            return false;
        }
        if (Float.compare(quaternion.d, this.d) != 0) {
            return false;
        }
        return Float.compare(quaternion.e, this.e) == 0;
    }

    @Override
    public int hashCode() {
        int i2 = Float.floatToIntBits(this.b);
        i2 = 31 * i2 + Float.floatToIntBits(this.c);
        i2 = 31 * i2 + Float.floatToIntBits(this.d);
        i2 = 31 * i2 + Float.floatToIntBits(this.e);
        return i2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Quaternion[").append(this.h()).append(" + ");
        stringBuilder.append(this.e()).append("i + ");
        stringBuilder.append(this.f()).append("j + ");
        stringBuilder.append(this.g()).append("k]");
        return stringBuilder.toString();
    }

    public float e() {
        return this.b;
    }

    public float f() {
        return this.c;
    }

    public float g() {
        return this.d;
    }

    public float h() {
        return this.e;
    }

    public void a(Quaternion other) {
        float f2 = this.e();
        float g2 = this.f();
        float h2 = this.g();
        float i2 = this.h();
        float j2 = other.e();
        float k2 = other.f();
        float l2 = other.g();
        float m2 = other.h();
        this.b = i2 * j2 + f2 * m2 + g2 * l2 - h2 * k2;
        this.c = i2 * k2 - f2 * l2 + g2 * m2 + h2 * j2;
        this.d = i2 * l2 + f2 * k2 - g2 * j2 + h2 * m2;
        this.e = i2 * m2 - f2 * j2 - g2 * k2 - h2 * l2;
    }

    public void a(float scale) {
        this.b *= scale;
        this.c *= scale;
        this.d *= scale;
        this.e *= scale;
    }

    public void i() {
        this.b = -this.b;
        this.c = -this.c;
        this.d = -this.d;
    }

    public void a(float x2, float y2, float z2, float w2) {
        this.b = x2;
        this.c = y2;
        this.d = z2;
        this.e = w2;
    }

    private static float b(float value) {
        return (float)Math.cos(value);
    }

    private static float c(float value) {
        return (float)Math.sin(value);
    }

    public void j() {
        float f2 = this.e() * this.e() + this.f() * this.f() + this.g() * this.g() + this.h() * this.h();
        if (f2 > 1.0E-6f) {
            float g2 = MathHelper.i(f2);
            this.b *= g2;
            this.c *= g2;
            this.d *= g2;
            this.e *= g2;
        } else {
            this.b = 0.0f;
            this.c = 0.0f;
            this.d = 0.0f;
            this.e = 0.0f;
        }
    }

    public void a(Quaternion quaternion, float f2) {
        throw new UnsupportedOperationException();
    }

    public Quaternion k() {
        return new Quaternion(this);
    }
}

