/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3fa;
import java.nio.FloatBuffer;

public final class Matrix4f {
    private static final int q = 4;
    protected float a;
    protected float b;
    protected float c;
    protected float d;
    protected float e;
    protected float f;
    protected float g;
    protected float h;
    protected float i;
    protected float j;
    protected float k;
    protected float l;
    protected float m;
    protected float n;
    protected float o;
    protected float p;

    public Matrix4f() {
    }

    public Matrix4f(Matrix4f matrix) {
        this.a = matrix.a;
        this.b = matrix.b;
        this.c = matrix.c;
        this.d = matrix.d;
        this.e = matrix.e;
        this.f = matrix.f;
        this.g = matrix.g;
        this.h = matrix.h;
        this.i = matrix.i;
        this.j = matrix.j;
        this.k = matrix.k;
        this.l = matrix.l;
        this.m = matrix.m;
        this.n = matrix.n;
        this.o = matrix.o;
        this.p = matrix.p;
    }

    public Matrix4f(Quaternion quaternion) {
        float f2 = quaternion.e();
        float g2 = quaternion.f();
        float h2 = quaternion.g();
        float i2 = quaternion.h();
        float j2 = 2.0f * f2 * f2;
        float k2 = 2.0f * g2 * g2;
        float l2 = 2.0f * h2 * h2;
        this.a = 1.0f - k2 - l2;
        this.f = 1.0f - l2 - j2;
        this.k = 1.0f - j2 - k2;
        this.p = 1.0f;
        float m2 = f2 * g2;
        float n2 = g2 * h2;
        float o2 = h2 * f2;
        float p2 = f2 * i2;
        float q2 = g2 * i2;
        float r2 = h2 * i2;
        this.e = 2.0f * (m2 + r2);
        this.b = 2.0f * (m2 - r2);
        this.i = 2.0f * (o2 - q2);
        this.c = 2.0f * (o2 + q2);
        this.j = 2.0f * (n2 + p2);
        this.g = 2.0f * (n2 - p2);
    }

    public boolean a() {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m = 1.0f;
        matrix4f.n = 1.0f;
        matrix4f.o = 1.0f;
        matrix4f.p = 0.0f;
        Matrix4f matrix4f2 = this.h();
        matrix4f2.b(matrix4f);
        return Matrix4f.b(matrix4f2.a / matrix4f2.d) && Matrix4f.b(matrix4f2.e / matrix4f2.h) && Matrix4f.b(matrix4f2.i / matrix4f2.l) && Matrix4f.b(matrix4f2.b / matrix4f2.d) && Matrix4f.b(matrix4f2.f / matrix4f2.h) && Matrix4f.b(matrix4f2.j / matrix4f2.l) && Matrix4f.b(matrix4f2.c / matrix4f2.d) && Matrix4f.b(matrix4f2.g / matrix4f2.h) && Matrix4f.b(matrix4f2.k / matrix4f2.l);
    }

    private static boolean b(float value) {
        return (double)Math.abs(value - (float)Math.round(value)) <= 1.0E-5;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Matrix4f matrix4f = (Matrix4f)object;
        return Float.compare(matrix4f.a, this.a) == 0 && Float.compare(matrix4f.b, this.b) == 0 && Float.compare(matrix4f.c, this.c) == 0 && Float.compare(matrix4f.d, this.d) == 0 && Float.compare(matrix4f.e, this.e) == 0 && Float.compare(matrix4f.f, this.f) == 0 && Float.compare(matrix4f.g, this.g) == 0 && Float.compare(matrix4f.h, this.h) == 0 && Float.compare(matrix4f.i, this.i) == 0 && Float.compare(matrix4f.j, this.j) == 0 && Float.compare(matrix4f.k, this.k) == 0 && Float.compare(matrix4f.l, this.l) == 0 && Float.compare(matrix4f.m, this.m) == 0 && Float.compare(matrix4f.n, this.n) == 0 && Float.compare(matrix4f.o, this.o) == 0 && Float.compare(matrix4f.p, this.p) == 0;
    }

    @Override
    public int hashCode() {
        int i2 = this.a != 0.0f ? Float.floatToIntBits(this.a) : 0;
        i2 = 31 * i2 + (this.b != 0.0f ? Float.floatToIntBits(this.b) : 0);
        i2 = 31 * i2 + (this.c != 0.0f ? Float.floatToIntBits(this.c) : 0);
        i2 = 31 * i2 + (this.d != 0.0f ? Float.floatToIntBits(this.d) : 0);
        i2 = 31 * i2 + (this.e != 0.0f ? Float.floatToIntBits(this.e) : 0);
        i2 = 31 * i2 + (this.f != 0.0f ? Float.floatToIntBits(this.f) : 0);
        i2 = 31 * i2 + (this.g != 0.0f ? Float.floatToIntBits(this.g) : 0);
        i2 = 31 * i2 + (this.h != 0.0f ? Float.floatToIntBits(this.h) : 0);
        i2 = 31 * i2 + (this.i != 0.0f ? Float.floatToIntBits(this.i) : 0);
        i2 = 31 * i2 + (this.j != 0.0f ? Float.floatToIntBits(this.j) : 0);
        i2 = 31 * i2 + (this.k != 0.0f ? Float.floatToIntBits(this.k) : 0);
        i2 = 31 * i2 + (this.l != 0.0f ? Float.floatToIntBits(this.l) : 0);
        i2 = 31 * i2 + (this.m != 0.0f ? Float.floatToIntBits(this.m) : 0);
        i2 = 31 * i2 + (this.n != 0.0f ? Float.floatToIntBits(this.n) : 0);
        i2 = 31 * i2 + (this.o != 0.0f ? Float.floatToIntBits(this.o) : 0);
        i2 = 31 * i2 + (this.p != 0.0f ? Float.floatToIntBits(this.p) : 0);
        return i2;
    }

    private static int a(int x2, int y2) {
        return y2 * 4 + x2;
    }

    public void a(FloatBuffer buf) {
        this.a = buf.get(Matrix4f.a(0, 0));
        this.b = buf.get(Matrix4f.a(0, 1));
        this.c = buf.get(Matrix4f.a(0, 2));
        this.d = buf.get(Matrix4f.a(0, 3));
        this.e = buf.get(Matrix4f.a(1, 0));
        this.f = buf.get(Matrix4f.a(1, 1));
        this.g = buf.get(Matrix4f.a(1, 2));
        this.h = buf.get(Matrix4f.a(1, 3));
        this.i = buf.get(Matrix4f.a(2, 0));
        this.j = buf.get(Matrix4f.a(2, 1));
        this.k = buf.get(Matrix4f.a(2, 2));
        this.l = buf.get(Matrix4f.a(2, 3));
        this.m = buf.get(Matrix4f.a(3, 0));
        this.n = buf.get(Matrix4f.a(3, 1));
        this.o = buf.get(Matrix4f.a(3, 2));
        this.p = buf.get(Matrix4f.a(3, 3));
    }

    public void b(FloatBuffer buf) {
        this.a = buf.get(Matrix4f.a(0, 0));
        this.b = buf.get(Matrix4f.a(1, 0));
        this.c = buf.get(Matrix4f.a(2, 0));
        this.d = buf.get(Matrix4f.a(3, 0));
        this.e = buf.get(Matrix4f.a(0, 1));
        this.f = buf.get(Matrix4f.a(1, 1));
        this.g = buf.get(Matrix4f.a(2, 1));
        this.h = buf.get(Matrix4f.a(3, 1));
        this.i = buf.get(Matrix4f.a(0, 2));
        this.j = buf.get(Matrix4f.a(1, 2));
        this.k = buf.get(Matrix4f.a(2, 2));
        this.l = buf.get(Matrix4f.a(3, 2));
        this.m = buf.get(Matrix4f.a(0, 3));
        this.n = buf.get(Matrix4f.a(1, 3));
        this.o = buf.get(Matrix4f.a(2, 3));
        this.p = buf.get(Matrix4f.a(3, 3));
    }

    public void a(FloatBuffer buf, boolean rowMajor) {
        if (rowMajor) {
            this.b(buf);
        } else {
            this.a(buf);
        }
    }

    public void a(Matrix4f source) {
        this.a = source.a;
        this.b = source.b;
        this.c = source.c;
        this.d = source.d;
        this.e = source.e;
        this.f = source.f;
        this.g = source.g;
        this.h = source.h;
        this.i = source.i;
        this.j = source.j;
        this.k = source.k;
        this.l = source.l;
        this.m = source.m;
        this.n = source.n;
        this.o = source.o;
        this.p = source.p;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Matrix4f:\n");
        stringBuilder.append(this.a);
        stringBuilder.append(" ");
        stringBuilder.append(this.b);
        stringBuilder.append(" ");
        stringBuilder.append(this.c);
        stringBuilder.append(" ");
        stringBuilder.append(this.d);
        stringBuilder.append("\n");
        stringBuilder.append(this.e);
        stringBuilder.append(" ");
        stringBuilder.append(this.f);
        stringBuilder.append(" ");
        stringBuilder.append(this.g);
        stringBuilder.append(" ");
        stringBuilder.append(this.h);
        stringBuilder.append("\n");
        stringBuilder.append(this.i);
        stringBuilder.append(" ");
        stringBuilder.append(this.j);
        stringBuilder.append(" ");
        stringBuilder.append(this.k);
        stringBuilder.append(" ");
        stringBuilder.append(this.l);
        stringBuilder.append("\n");
        stringBuilder.append(this.m);
        stringBuilder.append(" ");
        stringBuilder.append(this.n);
        stringBuilder.append(" ");
        stringBuilder.append(this.o);
        stringBuilder.append(" ");
        stringBuilder.append(this.p);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public void c(FloatBuffer buf) {
        buf.put(Matrix4f.a(0, 0), this.a);
        buf.put(Matrix4f.a(0, 1), this.b);
        buf.put(Matrix4f.a(0, 2), this.c);
        buf.put(Matrix4f.a(0, 3), this.d);
        buf.put(Matrix4f.a(1, 0), this.e);
        buf.put(Matrix4f.a(1, 1), this.f);
        buf.put(Matrix4f.a(1, 2), this.g);
        buf.put(Matrix4f.a(1, 3), this.h);
        buf.put(Matrix4f.a(2, 0), this.i);
        buf.put(Matrix4f.a(2, 1), this.j);
        buf.put(Matrix4f.a(2, 2), this.k);
        buf.put(Matrix4f.a(2, 3), this.l);
        buf.put(Matrix4f.a(3, 0), this.m);
        buf.put(Matrix4f.a(3, 1), this.n);
        buf.put(Matrix4f.a(3, 2), this.o);
        buf.put(Matrix4f.a(3, 3), this.p);
    }

    public void d(FloatBuffer buf) {
        buf.put(Matrix4f.a(0, 0), this.a);
        buf.put(Matrix4f.a(1, 0), this.b);
        buf.put(Matrix4f.a(2, 0), this.c);
        buf.put(Matrix4f.a(3, 0), this.d);
        buf.put(Matrix4f.a(0, 1), this.e);
        buf.put(Matrix4f.a(1, 1), this.f);
        buf.put(Matrix4f.a(2, 1), this.g);
        buf.put(Matrix4f.a(3, 1), this.h);
        buf.put(Matrix4f.a(0, 2), this.i);
        buf.put(Matrix4f.a(1, 2), this.j);
        buf.put(Matrix4f.a(2, 2), this.k);
        buf.put(Matrix4f.a(3, 2), this.l);
        buf.put(Matrix4f.a(0, 3), this.m);
        buf.put(Matrix4f.a(1, 3), this.n);
        buf.put(Matrix4f.a(2, 3), this.o);
        buf.put(Matrix4f.a(3, 3), this.p);
    }

    public void b(FloatBuffer buf, boolean rowMajor) {
        if (rowMajor) {
            this.d(buf);
        } else {
            this.c(buf);
        }
    }

    public void b() {
        this.a = 1.0f;
        this.b = 0.0f;
        this.c = 0.0f;
        this.d = 0.0f;
        this.e = 0.0f;
        this.f = 1.0f;
        this.g = 0.0f;
        this.h = 0.0f;
        this.i = 0.0f;
        this.j = 0.0f;
        this.k = 1.0f;
        this.l = 0.0f;
        this.m = 0.0f;
        this.n = 0.0f;
        this.o = 0.0f;
        this.p = 1.0f;
    }

    public float c() {
        float f2 = this.a * this.f - this.b * this.e;
        float g2 = this.a * this.g - this.c * this.e;
        float h2 = this.a * this.h - this.d * this.e;
        float i2 = this.b * this.g - this.c * this.f;
        float j2 = this.b * this.h - this.d * this.f;
        float k2 = this.c * this.h - this.d * this.g;
        float l2 = this.i * this.n - this.j * this.m;
        float m2 = this.i * this.o - this.k * this.m;
        float n2 = this.i * this.p - this.l * this.m;
        float o2 = this.j * this.o - this.k * this.n;
        float p2 = this.j * this.p - this.l * this.n;
        float q2 = this.k * this.p - this.l * this.o;
        float r2 = this.f * q2 - this.g * p2 + this.h * o2;
        float s2 = -this.e * q2 + this.g * n2 - this.h * m2;
        float t2 = this.e * p2 - this.f * n2 + this.h * l2;
        float u2 = -this.e * o2 + this.f * m2 - this.g * l2;
        float v2 = -this.b * q2 + this.c * p2 - this.d * o2;
        float w2 = this.a * q2 - this.c * n2 + this.d * m2;
        float x2 = -this.a * p2 + this.b * n2 - this.d * l2;
        float y2 = this.a * o2 - this.b * m2 + this.c * l2;
        float z2 = this.n * k2 - this.o * j2 + this.p * i2;
        float aa2 = -this.m * k2 + this.o * h2 - this.p * g2;
        float ab = this.m * j2 - this.n * h2 + this.p * f2;
        float ac = -this.m * i2 + this.n * g2 - this.o * f2;
        float ad = -this.j * k2 + this.k * j2 - this.l * i2;
        float ae = this.i * k2 - this.k * h2 + this.l * g2;
        float af = -this.i * j2 + this.j * h2 - this.l * f2;
        float ag = this.i * i2 - this.j * g2 + this.k * f2;
        this.a = r2;
        this.e = s2;
        this.i = t2;
        this.m = u2;
        this.b = v2;
        this.f = w2;
        this.j = x2;
        this.n = y2;
        this.c = z2;
        this.g = aa2;
        this.k = ab;
        this.o = ac;
        this.d = ad;
        this.h = ae;
        this.l = af;
        this.p = ag;
        return f2 * q2 - g2 * p2 + h2 * o2 + i2 * n2 - j2 * m2 + k2 * l2;
    }

    public float d() {
        float f2 = this.a * this.f - this.b * this.e;
        float g2 = this.a * this.g - this.c * this.e;
        float h2 = this.a * this.h - this.d * this.e;
        float i2 = this.b * this.g - this.c * this.f;
        float j2 = this.b * this.h - this.d * this.f;
        float k2 = this.c * this.h - this.d * this.g;
        float l2 = this.i * this.n - this.j * this.m;
        float m2 = this.i * this.o - this.k * this.m;
        float n2 = this.i * this.p - this.l * this.m;
        float o2 = this.j * this.o - this.k * this.n;
        float p2 = this.j * this.p - this.l * this.n;
        float q2 = this.k * this.p - this.l * this.o;
        return f2 * q2 - g2 * p2 + h2 * o2 + i2 * n2 - j2 * m2 + k2 * l2;
    }

    public void e() {
        float f2 = this.e;
        this.e = this.b;
        this.b = f2;
        f2 = this.i;
        this.i = this.c;
        this.c = f2;
        f2 = this.j;
        this.j = this.g;
        this.g = f2;
        f2 = this.m;
        this.m = this.d;
        this.d = f2;
        f2 = this.n;
        this.n = this.h;
        this.h = f2;
        f2 = this.o;
        this.o = this.l;
        this.l = f2;
    }

    public boolean f() {
        float f2 = this.c();
        if (Math.abs(f2) > 1.0E-6f) {
            this.a(f2);
            return true;
        }
        return false;
    }

    public void b(Matrix4f matrix) {
        float f2 = this.a * matrix.a + this.b * matrix.e + this.c * matrix.i + this.d * matrix.m;
        float g2 = this.a * matrix.b + this.b * matrix.f + this.c * matrix.j + this.d * matrix.n;
        float h2 = this.a * matrix.c + this.b * matrix.g + this.c * matrix.k + this.d * matrix.o;
        float i2 = this.a * matrix.d + this.b * matrix.h + this.c * matrix.l + this.d * matrix.p;
        float j2 = this.e * matrix.a + this.f * matrix.e + this.g * matrix.i + this.h * matrix.m;
        float k2 = this.e * matrix.b + this.f * matrix.f + this.g * matrix.j + this.h * matrix.n;
        float l2 = this.e * matrix.c + this.f * matrix.g + this.g * matrix.k + this.h * matrix.o;
        float m2 = this.e * matrix.d + this.f * matrix.h + this.g * matrix.l + this.h * matrix.p;
        float n2 = this.i * matrix.a + this.j * matrix.e + this.k * matrix.i + this.l * matrix.m;
        float o2 = this.i * matrix.b + this.j * matrix.f + this.k * matrix.j + this.l * matrix.n;
        float p2 = this.i * matrix.c + this.j * matrix.g + this.k * matrix.k + this.l * matrix.o;
        float q2 = this.i * matrix.d + this.j * matrix.h + this.k * matrix.l + this.l * matrix.p;
        float r2 = this.m * matrix.a + this.n * matrix.e + this.o * matrix.i + this.p * matrix.m;
        float s2 = this.m * matrix.b + this.n * matrix.f + this.o * matrix.j + this.p * matrix.n;
        float t2 = this.m * matrix.c + this.n * matrix.g + this.o * matrix.k + this.p * matrix.o;
        float u2 = this.m * matrix.d + this.n * matrix.h + this.o * matrix.l + this.p * matrix.p;
        this.a = f2;
        this.b = g2;
        this.c = h2;
        this.d = i2;
        this.e = j2;
        this.f = k2;
        this.g = l2;
        this.h = m2;
        this.i = n2;
        this.j = o2;
        this.k = p2;
        this.l = q2;
        this.m = r2;
        this.n = s2;
        this.o = t2;
        this.p = u2;
    }

    public void a(Quaternion quaternion) {
        this.b(new Matrix4f(quaternion));
    }

    public void a(float scalar) {
        this.a *= scalar;
        this.b *= scalar;
        this.c *= scalar;
        this.d *= scalar;
        this.e *= scalar;
        this.f *= scalar;
        this.g *= scalar;
        this.h *= scalar;
        this.i *= scalar;
        this.j *= scalar;
        this.k *= scalar;
        this.l *= scalar;
        this.m *= scalar;
        this.n *= scalar;
        this.o *= scalar;
        this.p *= scalar;
    }

    public void c(Matrix4f matrix) {
        this.a += matrix.a;
        this.b += matrix.b;
        this.c += matrix.c;
        this.d += matrix.d;
        this.e += matrix.e;
        this.f += matrix.f;
        this.g += matrix.g;
        this.h += matrix.h;
        this.i += matrix.i;
        this.j += matrix.j;
        this.k += matrix.k;
        this.l += matrix.l;
        this.m += matrix.m;
        this.n += matrix.n;
        this.o += matrix.o;
        this.p += matrix.p;
    }

    public void d(Matrix4f matrix) {
        this.a -= matrix.a;
        this.b -= matrix.b;
        this.c -= matrix.c;
        this.d -= matrix.d;
        this.e -= matrix.e;
        this.f -= matrix.f;
        this.g -= matrix.g;
        this.h -= matrix.h;
        this.i -= matrix.i;
        this.j -= matrix.j;
        this.k -= matrix.k;
        this.l -= matrix.l;
        this.m -= matrix.m;
        this.n -= matrix.n;
        this.o -= matrix.o;
        this.p -= matrix.p;
    }

    public float g() {
        return this.a + this.f + this.k + this.p;
    }

    public static Matrix4f a(double fov, float aspectRatio, float cameraDepth, float viewDistance) {
        float f2 = (float)(1.0 / Math.tan(fov * 0.01745329238474369 / 2.0));
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.a = f2 / aspectRatio;
        matrix4f.f = f2;
        matrix4f.k = (viewDistance + cameraDepth) / (cameraDepth - viewDistance);
        matrix4f.o = -1.0f;
        matrix4f.l = 2.0f * viewDistance * cameraDepth / (cameraDepth - viewDistance);
        return matrix4f;
    }

    public static Matrix4f a(float width, float height, float nearPlane, float farPlane) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.a = 2.0f / width;
        matrix4f.f = 2.0f / height;
        float f2 = farPlane - nearPlane;
        matrix4f.k = -2.0f / f2;
        matrix4f.p = 1.0f;
        matrix4f.d = -1.0f;
        matrix4f.h = 1.0f;
        matrix4f.l = -(farPlane + nearPlane) / f2;
        return matrix4f;
    }

    public static Matrix4f a(float left, float right, float bottom, float top, float nearPlane, float farPlane) {
        Matrix4f matrix4f = new Matrix4f();
        float f2 = right - left;
        float g2 = bottom - top;
        float h2 = farPlane - nearPlane;
        matrix4f.a = 2.0f / f2;
        matrix4f.f = 2.0f / g2;
        matrix4f.k = -2.0f / h2;
        matrix4f.d = -(right + left) / f2;
        matrix4f.h = -(bottom + top) / g2;
        matrix4f.l = -(farPlane + nearPlane) / h2;
        matrix4f.p = 1.0f;
        return matrix4f;
    }

    public void a(Vector3fa vector) {
        this.d += vector.a();
        this.h += vector.b();
        this.l += vector.c();
    }

    public Matrix4f h() {
        return new Matrix4f(this);
    }

    public void a(float x2, float y2, float z2) {
        this.d = this.a * x2 + this.b * y2 + this.c * z2 + this.d;
        this.h = this.e * x2 + this.f * y2 + this.g * z2 + this.h;
        this.l = this.i * x2 + this.j * y2 + this.k * z2 + this.l;
        this.p = this.m * x2 + this.n * y2 + this.o * z2 + this.p;
    }

    public static Matrix4f b(float x2, float y2, float z2) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.a = x2;
        matrix4f.f = y2;
        matrix4f.k = z2;
        matrix4f.p = 1.0f;
        return matrix4f;
    }

    public static Matrix4f c(float x2, float y2, float z2) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.a = 1.0f;
        matrix4f.f = 1.0f;
        matrix4f.k = 1.0f;
        matrix4f.p = 1.0f;
        matrix4f.d = x2;
        matrix4f.h = y2;
        matrix4f.l = z2;
        return matrix4f;
    }
}

