/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3fa;
import java.nio.FloatBuffer;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.tuple.Triple;

public final class Matrix3f {
    private static final int j = 3;
    private static final float k = 3.0f + 2.0f * (float)Math.sqrt(2.0);
    private static final float l = (float)Math.cos(0.39269908169872414);
    private static final float m = (float)Math.sin(0.39269908169872414);
    private static final float n = 1.0f / (float)Math.sqrt(2.0);
    protected float a;
    protected float b;
    protected float c;
    protected float d;
    protected float e;
    protected float f;
    protected float g;
    protected float h;
    protected float i;

    public Matrix3f() {
    }

    public Matrix3f(Quaternion quaternion) {
        float f2 = quaternion.e();
        float g2 = quaternion.f();
        float h2 = quaternion.g();
        float i2 = quaternion.h();
        float j2 = 2.0f * f2 * f2;
        float k2 = 2.0f * g2 * g2;
        float l2 = 2.0f * h2 * h2;
        this.a = 1.0f - k2 - l2;
        this.e = 1.0f - l2 - j2;
        this.i = 1.0f - j2 - k2;
        float m2 = f2 * g2;
        float n2 = g2 * h2;
        float o2 = h2 * f2;
        float p2 = f2 * i2;
        float q2 = g2 * i2;
        float r2 = h2 * i2;
        this.d = 2.0f * (m2 + r2);
        this.b = 2.0f * (m2 - r2);
        this.g = 2.0f * (o2 - q2);
        this.c = 2.0f * (o2 + q2);
        this.h = 2.0f * (n2 + p2);
        this.f = 2.0f * (n2 - p2);
    }

    public static Matrix3f a(float x2, float y2, float z2) {
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.a = x2;
        matrix3f.e = y2;
        matrix3f.i = z2;
        return matrix3f;
    }

    public Matrix3f(Matrix4f matrix) {
        this.a = matrix.a;
        this.b = matrix.b;
        this.c = matrix.c;
        this.d = matrix.e;
        this.e = matrix.f;
        this.f = matrix.g;
        this.g = matrix.i;
        this.h = matrix.j;
        this.i = matrix.k;
    }

    public Matrix3f(Matrix3f source) {
        this.a = source.a;
        this.b = source.b;
        this.c = source.c;
        this.d = source.d;
        this.e = source.e;
        this.f = source.f;
        this.g = source.g;
        this.h = source.h;
        this.i = source.i;
    }

    private static Pair<Float, Float> b(float upperLeft, float diagonalAverage, float lowerRight) {
        float g2 = diagonalAverage;
        float f2 = 2.0f * (upperLeft - lowerRight);
        if (k * g2 * g2 < f2 * f2) {
            float h2 = MathHelper.i(g2 * g2 + f2 * f2);
            return Pair.of((Object)Float.valueOf(h2 * g2), (Object)Float.valueOf(h2 * f2));
        }
        return Pair.of((Object)Float.valueOf(m), (Object)Float.valueOf(l));
    }

    private static Pair<Float, Float> a(float f2, float g2) {
        float h2 = (float)Math.hypot(f2, g2);
        float i2 = h2 > 1.0E-6f ? g2 : 0.0f;
        float j2 = Math.abs(f2) + Math.max(h2, 1.0E-6f);
        if (f2 < 0.0f) {
            float k2 = i2;
            i2 = j2;
            j2 = k2;
        }
        float l2 = MathHelper.i(j2 * j2 + i2 * i2);
        return Pair.of((Object)Float.valueOf(i2 *= l2), (Object)Float.valueOf(j2 *= l2));
    }

    private static Quaternion e(Matrix3f matrix) {
        Matrix3f matrix3f = new Matrix3f();
        Quaternion quaternion = Quaternion.a.k();
        if (matrix.b * matrix.b + matrix.d * matrix.d > 1.0E-6f) {
            Pair<Float, Float> pair = Matrix3f.b(matrix.a, 0.5f * (matrix.b + matrix.d), matrix.e);
            Float float_ = (Float)pair.getFirst();
            Float float2 = (Float)pair.getSecond();
            Quaternion quaternion2 = new Quaternion(0.0f, 0.0f, float_.floatValue(), float2.floatValue());
            float f2 = float2.floatValue() * float2.floatValue() - float_.floatValue() * float_.floatValue();
            float g2 = -2.0f * float_.floatValue() * float2.floatValue();
            float h2 = float2.floatValue() * float2.floatValue() + float_.floatValue() * float_.floatValue();
            quaternion.a(quaternion2);
            matrix3f.c();
            matrix3f.a = f2;
            matrix3f.e = f2;
            matrix3f.d = -g2;
            matrix3f.b = g2;
            matrix3f.i = h2;
            matrix.b(matrix3f);
            matrix3f.a();
            matrix3f.b(matrix);
            matrix.a(matrix3f);
        }
        if (matrix.c * matrix.c + matrix.g * matrix.g > 1.0E-6f) {
            Pair<Float, Float> pair2 = Matrix3f.b(matrix.a, 0.5f * (matrix.c + matrix.g), matrix.i);
            float i2 = -((Float)pair2.getFirst()).floatValue();
            Float float3 = (Float)pair2.getSecond();
            Quaternion quaternion3 = new Quaternion(0.0f, i2, 0.0f, float3.floatValue());
            float j2 = float3.floatValue() * float3.floatValue() - i2 * i2;
            float k2 = -2.0f * i2 * float3.floatValue();
            float l2 = float3.floatValue() * float3.floatValue() + i2 * i2;
            quaternion.a(quaternion3);
            matrix3f.c();
            matrix3f.a = j2;
            matrix3f.i = j2;
            matrix3f.g = k2;
            matrix3f.c = -k2;
            matrix3f.e = l2;
            matrix.b(matrix3f);
            matrix3f.a();
            matrix3f.b(matrix);
            matrix.a(matrix3f);
        }
        if (matrix.f * matrix.f + matrix.h * matrix.h > 1.0E-6f) {
            Pair<Float, Float> pair3 = Matrix3f.b(matrix.e, 0.5f * (matrix.f + matrix.h), matrix.i);
            Float float4 = (Float)pair3.getFirst();
            Float float5 = (Float)pair3.getSecond();
            Quaternion quaternion4 = new Quaternion(float4.floatValue(), 0.0f, 0.0f, float5.floatValue());
            float m2 = float5.floatValue() * float5.floatValue() - float4.floatValue() * float4.floatValue();
            float n2 = -2.0f * float4.floatValue() * float5.floatValue();
            float o2 = float5.floatValue() * float5.floatValue() + float4.floatValue() * float4.floatValue();
            quaternion.a(quaternion4);
            matrix3f.c();
            matrix3f.e = m2;
            matrix3f.i = m2;
            matrix3f.h = -n2;
            matrix3f.f = n2;
            matrix3f.a = o2;
            matrix.b(matrix3f);
            matrix3f.a();
            matrix3f.b(matrix);
            matrix.a(matrix3f);
        }
        return quaternion;
    }

    private static void a(Matrix3f matrix, Quaternion quaternion) {
        float f2 = matrix.a * matrix.a + matrix.d * matrix.d + matrix.g * matrix.g;
        float g2 = matrix.b * matrix.b + matrix.e * matrix.e + matrix.h * matrix.h;
        float h2 = matrix.c * matrix.c + matrix.f * matrix.f + matrix.i * matrix.i;
        if (f2 < g2) {
            float i2 = matrix.d;
            matrix.d = -matrix.a;
            matrix.a = i2;
            i2 = matrix.e;
            matrix.e = -matrix.b;
            matrix.b = i2;
            i2 = matrix.f;
            matrix.f = -matrix.c;
            matrix.c = i2;
            Quaternion quaternion2 = new Quaternion(0.0f, 0.0f, n, n);
            quaternion.a(quaternion2);
            i2 = f2;
            f2 = g2;
            g2 = i2;
        }
        if (f2 < h2) {
            float j2 = matrix.g;
            matrix.g = -matrix.a;
            matrix.a = j2;
            j2 = matrix.h;
            matrix.h = -matrix.b;
            matrix.b = j2;
            j2 = matrix.i;
            matrix.i = -matrix.c;
            matrix.c = j2;
            Quaternion quaternion3 = new Quaternion(0.0f, n, 0.0f, n);
            quaternion.a(quaternion3);
            h2 = f2;
        }
        if (g2 < h2) {
            float k2 = matrix.g;
            matrix.g = -matrix.d;
            matrix.d = k2;
            k2 = matrix.h;
            matrix.h = -matrix.e;
            matrix.e = k2;
            k2 = matrix.i;
            matrix.i = -matrix.f;
            matrix.f = k2;
            Quaternion quaternion4 = new Quaternion(n, 0.0f, 0.0f, n);
            quaternion.a(quaternion4);
        }
    }

    public void a() {
        float f2 = this.b;
        this.b = this.d;
        this.d = f2;
        f2 = this.c;
        this.c = this.g;
        this.g = f2;
        f2 = this.f;
        this.f = this.h;
        this.h = f2;
    }

    public Triple<Quaternion, Vector3fa, Quaternion> b() {
        Quaternion quaternion = Quaternion.a.k();
        Quaternion quaternion2 = Quaternion.a.k();
        Matrix3f matrix3f = this.h();
        matrix3f.a();
        matrix3f.b(this);
        for (int i2 = 0; i2 < 5; ++i2) {
            quaternion2.a(Matrix3f.e(matrix3f));
        }
        quaternion2.j();
        Matrix3f matrix3f2 = new Matrix3f(this);
        matrix3f2.b(new Matrix3f(quaternion2));
        float f2 = 1.0f;
        Pair<Float, Float> pair = Matrix3f.a(matrix3f2.a, matrix3f2.d);
        Float float_ = (Float)pair.getFirst();
        Float float2 = (Float)pair.getSecond();
        float g2 = float2.floatValue() * float2.floatValue() - float_.floatValue() * float_.floatValue();
        float h2 = -2.0f * float_.floatValue() * float2.floatValue();
        float j2 = float2.floatValue() * float2.floatValue() + float_.floatValue() * float_.floatValue();
        Quaternion quaternion3 = new Quaternion(0.0f, 0.0f, float_.floatValue(), float2.floatValue());
        quaternion.a(quaternion3);
        Matrix3f matrix3f3 = new Matrix3f();
        matrix3f3.c();
        matrix3f3.a = g2;
        matrix3f3.e = g2;
        matrix3f3.d = h2;
        matrix3f3.b = -h2;
        matrix3f3.i = j2;
        f2 *= j2;
        matrix3f3.b(matrix3f2);
        pair = Matrix3f.a(matrix3f3.a, matrix3f3.g);
        float k2 = -((Float)pair.getFirst()).floatValue();
        Float float3 = (Float)pair.getSecond();
        float l2 = float3.floatValue() * float3.floatValue() - k2 * k2;
        float m2 = -2.0f * k2 * float3.floatValue();
        float n2 = float3.floatValue() * float3.floatValue() + k2 * k2;
        Quaternion quaternion4 = new Quaternion(0.0f, k2, 0.0f, float3.floatValue());
        quaternion.a(quaternion4);
        Matrix3f matrix3f4 = new Matrix3f();
        matrix3f4.c();
        matrix3f4.a = l2;
        matrix3f4.i = l2;
        matrix3f4.g = -m2;
        matrix3f4.c = m2;
        matrix3f4.e = n2;
        f2 *= n2;
        matrix3f4.b(matrix3f3);
        pair = Matrix3f.a(matrix3f4.e, matrix3f4.h);
        Float float4 = (Float)pair.getFirst();
        Float float5 = (Float)pair.getSecond();
        float o2 = float5.floatValue() * float5.floatValue() - float4.floatValue() * float4.floatValue();
        float p2 = -2.0f * float4.floatValue() * float5.floatValue();
        float q2 = float5.floatValue() * float5.floatValue() + float4.floatValue() * float4.floatValue();
        Quaternion quaternion5 = new Quaternion(float4.floatValue(), 0.0f, 0.0f, float5.floatValue());
        quaternion.a(quaternion5);
        Matrix3f matrix3f5 = new Matrix3f();
        matrix3f5.c();
        matrix3f5.e = o2;
        matrix3f5.i = o2;
        matrix3f5.h = p2;
        matrix3f5.f = -p2;
        matrix3f5.a = q2;
        f2 *= q2;
        matrix3f5.b(matrix3f4);
        f2 = 1.0f / f2;
        quaternion.a((float)Math.sqrt(f2));
        Vector3fa vector3f = new Vector3fa(matrix3f5.a * f2, matrix3f5.e * f2, matrix3f5.i * f2);
        return Triple.of((Object)quaternion, (Object)vector3f, (Object)quaternion2);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Matrix3f matrix3f = (Matrix3f)object;
        return Float.compare(matrix3f.a, this.a) == 0 && Float.compare(matrix3f.b, this.b) == 0 && Float.compare(matrix3f.c, this.c) == 0 && Float.compare(matrix3f.d, this.d) == 0 && Float.compare(matrix3f.e, this.e) == 0 && Float.compare(matrix3f.f, this.f) == 0 && Float.compare(matrix3f.g, this.g) == 0 && Float.compare(matrix3f.h, this.h) == 0 && Float.compare(matrix3f.i, this.i) == 0;
    }

    @Override
    public int hashCode() {
        int i2 = this.a != 0.0f ? Float.floatToIntBits(this.a) : 0;
        i2 = 31 * i2 + (this.b != 0.0f ? Float.floatToIntBits(this.b) : 0);
        i2 = 31 * i2 + (this.c != 0.0f ? Float.floatToIntBits(this.c) : 0);
        i2 = 31 * i2 + (this.d != 0.0f ? Float.floatToIntBits(this.d) : 0);
        i2 = 31 * i2 + (this.e != 0.0f ? Float.floatToIntBits(this.e) : 0);
        i2 = 31 * i2 + (this.f != 0.0f ? Float.floatToIntBits(this.f) : 0);
        i2 = 31 * i2 + (this.g != 0.0f ? Float.floatToIntBits(this.g) : 0);
        i2 = 31 * i2 + (this.h != 0.0f ? Float.floatToIntBits(this.h) : 0);
        i2 = 31 * i2 + (this.i != 0.0f ? Float.floatToIntBits(this.i) : 0);
        return i2;
    }

    private static int a(int x2, int y2) {
        return y2 * 3 + x2;
    }

    public void a(FloatBuffer buf) {
        this.a = buf.get(Matrix3f.a(0, 0));
        this.b = buf.get(Matrix3f.a(0, 1));
        this.c = buf.get(Matrix3f.a(0, 2));
        this.d = buf.get(Matrix3f.a(1, 0));
        this.e = buf.get(Matrix3f.a(1, 1));
        this.f = buf.get(Matrix3f.a(1, 2));
        this.g = buf.get(Matrix3f.a(2, 0));
        this.h = buf.get(Matrix3f.a(2, 1));
        this.i = buf.get(Matrix3f.a(2, 2));
    }

    public void b(FloatBuffer buf) {
        this.a = buf.get(Matrix3f.a(0, 0));
        this.b = buf.get(Matrix3f.a(1, 0));
        this.c = buf.get(Matrix3f.a(2, 0));
        this.d = buf.get(Matrix3f.a(0, 1));
        this.e = buf.get(Matrix3f.a(1, 1));
        this.f = buf.get(Matrix3f.a(2, 1));
        this.g = buf.get(Matrix3f.a(0, 2));
        this.h = buf.get(Matrix3f.a(1, 2));
        this.i = buf.get(Matrix3f.a(2, 2));
    }

    public void a(FloatBuffer buf, boolean rowMajor) {
        if (rowMajor) {
            this.b(buf);
        } else {
            this.a(buf);
        }
    }

    public void a(Matrix3f source) {
        this.a = source.a;
        this.b = source.b;
        this.c = source.c;
        this.d = source.d;
        this.e = source.e;
        this.f = source.f;
        this.g = source.g;
        this.h = source.h;
        this.i = source.i;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Matrix3f:\n");
        stringBuilder.append(this.a);
        stringBuilder.append(" ");
        stringBuilder.append(this.b);
        stringBuilder.append(" ");
        stringBuilder.append(this.c);
        stringBuilder.append("\n");
        stringBuilder.append(this.d);
        stringBuilder.append(" ");
        stringBuilder.append(this.e);
        stringBuilder.append(" ");
        stringBuilder.append(this.f);
        stringBuilder.append("\n");
        stringBuilder.append(this.g);
        stringBuilder.append(" ");
        stringBuilder.append(this.h);
        stringBuilder.append(" ");
        stringBuilder.append(this.i);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public void c(FloatBuffer buf) {
        buf.put(Matrix3f.a(0, 0), this.a);
        buf.put(Matrix3f.a(0, 1), this.b);
        buf.put(Matrix3f.a(0, 2), this.c);
        buf.put(Matrix3f.a(1, 0), this.d);
        buf.put(Matrix3f.a(1, 1), this.e);
        buf.put(Matrix3f.a(1, 2), this.f);
        buf.put(Matrix3f.a(2, 0), this.g);
        buf.put(Matrix3f.a(2, 1), this.h);
        buf.put(Matrix3f.a(2, 2), this.i);
    }

    public void d(FloatBuffer buf) {
        buf.put(Matrix3f.a(0, 0), this.a);
        buf.put(Matrix3f.a(1, 0), this.b);
        buf.put(Matrix3f.a(2, 0), this.c);
        buf.put(Matrix3f.a(0, 1), this.d);
        buf.put(Matrix3f.a(1, 1), this.e);
        buf.put(Matrix3f.a(2, 1), this.f);
        buf.put(Matrix3f.a(0, 2), this.g);
        buf.put(Matrix3f.a(1, 2), this.h);
        buf.put(Matrix3f.a(2, 2), this.i);
    }

    public void b(FloatBuffer buf, boolean rowMajor) {
        if (rowMajor) {
            this.d(buf);
        } else {
            this.c(buf);
        }
    }

    public void c() {
        this.a = 1.0f;
        this.b = 0.0f;
        this.c = 0.0f;
        this.d = 0.0f;
        this.e = 1.0f;
        this.f = 0.0f;
        this.g = 0.0f;
        this.h = 0.0f;
        this.i = 1.0f;
    }

    public float d() {
        float f2 = this.e * this.i - this.f * this.h;
        float g2 = -(this.d * this.i - this.f * this.g);
        float h2 = this.d * this.h - this.e * this.g;
        float i2 = -(this.b * this.i - this.c * this.h);
        float j2 = this.a * this.i - this.c * this.g;
        float k2 = -(this.a * this.h - this.b * this.g);
        float l2 = this.b * this.f - this.c * this.e;
        float m2 = -(this.a * this.f - this.c * this.d);
        float n2 = this.a * this.e - this.b * this.d;
        float o2 = this.a * f2 + this.b * g2 + this.c * h2;
        this.a = f2;
        this.d = g2;
        this.g = h2;
        this.b = i2;
        this.e = j2;
        this.h = k2;
        this.c = l2;
        this.f = m2;
        this.i = n2;
        return o2;
    }

    public float e() {
        float f2 = this.e * this.i - this.f * this.h;
        float g2 = -(this.d * this.i - this.f * this.g);
        float h2 = this.d * this.h - this.e * this.g;
        return this.a * f2 + this.b * g2 + this.c * h2;
    }

    public boolean f() {
        float f2 = this.d();
        if (Math.abs(f2) > 1.0E-6f) {
            this.a(f2);
            return true;
        }
        return false;
    }

    public void a(int x2, int y2, float value) {
        if (x2 == 0) {
            if (y2 == 0) {
                this.a = value;
            } else if (y2 == 1) {
                this.b = value;
            } else {
                this.c = value;
            }
        } else if (x2 == 1) {
            if (y2 == 0) {
                this.d = value;
            } else if (y2 == 1) {
                this.e = value;
            } else {
                this.f = value;
            }
        } else if (y2 == 0) {
            this.g = value;
        } else if (y2 == 1) {
            this.h = value;
        } else {
            this.i = value;
        }
    }

    public void b(Matrix3f other) {
        float f2 = this.a * other.a + this.b * other.d + this.c * other.g;
        float g2 = this.a * other.b + this.b * other.e + this.c * other.h;
        float h2 = this.a * other.c + this.b * other.f + this.c * other.i;
        float i2 = this.d * other.a + this.e * other.d + this.f * other.g;
        float j2 = this.d * other.b + this.e * other.e + this.f * other.h;
        float k2 = this.d * other.c + this.e * other.f + this.f * other.i;
        float l2 = this.g * other.a + this.h * other.d + this.i * other.g;
        float m2 = this.g * other.b + this.h * other.e + this.i * other.h;
        float n2 = this.g * other.c + this.h * other.f + this.i * other.i;
        this.a = f2;
        this.b = g2;
        this.c = h2;
        this.d = i2;
        this.e = j2;
        this.f = k2;
        this.g = l2;
        this.h = m2;
        this.i = n2;
    }

    public void a(Quaternion quaternion) {
        this.b(new Matrix3f(quaternion));
    }

    public void a(float scalar) {
        this.a *= scalar;
        this.b *= scalar;
        this.c *= scalar;
        this.d *= scalar;
        this.e *= scalar;
        this.f *= scalar;
        this.g *= scalar;
        this.h *= scalar;
        this.i *= scalar;
    }

    public void c(Matrix3f matrix) {
        this.a += matrix.a;
        this.b += matrix.b;
        this.c += matrix.c;
        this.d += matrix.d;
        this.e += matrix.e;
        this.f += matrix.f;
        this.g += matrix.g;
        this.h += matrix.h;
        this.i += matrix.i;
    }

    public void d(Matrix3f matrix) {
        this.a -= matrix.a;
        this.b -= matrix.b;
        this.c -= matrix.c;
        this.d -= matrix.d;
        this.e -= matrix.e;
        this.f -= matrix.f;
        this.g -= matrix.g;
        this.h -= matrix.h;
        this.i -= matrix.i;
    }

    public float g() {
        return this.a + this.e + this.i;
    }

    public Matrix3f h() {
        return new Matrix3f(this);
    }
}

