/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.network;

import com.destroystokyo.paper.network.PaperServerListPingEventImpl;
import com.destroystokyo.paper.network.PaperStatusClient;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.adventure.AdventureComponent;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.status.PacketStatusOutServerInfo;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.server.MinecraftServer;
import org.bukkit.event.Event;

public final class StandardPaperServerListPingEventImpl
extends PaperServerListPingEventImpl {
    private static final GameProfile[] EMPTY_PROFILES = new GameProfile[0];
    private static final UUID FAKE_UUID = new UUID(0L, 0L);
    private GameProfile[] originalSample;

    private StandardPaperServerListPingEventImpl(MinecraftServer server, NetworkManager networkManager, ServerPing ping) {
        super(server, new PaperStatusClient(networkManager), ping.c() != null ? ping.c().b() : -1, server.server.getServerIcon());
        this.originalSample = ping.b() == null ? null : ping.b().c();
    }

    @Nonnull
    public List<PlayerProfile> getPlayerSample() {
        List sample = super.getPlayerSample();
        if (this.originalSample != null) {
            for (GameProfile profile : this.originalSample) {
                sample.add(CraftPlayerProfile.asBukkitCopy(profile));
            }
            this.originalSample = null;
        }
        return sample;
    }

    private GameProfile[] getPlayerSampleHandle() {
        if (this.originalSample != null) {
            return this.originalSample;
        }
        List entries = super.getPlayerSample();
        if (entries.isEmpty()) {
            return EMPTY_PROFILES;
        }
        GameProfile[] profiles = new GameProfile[entries.size()];
        for (int i2 = 0; i2 < profiles.length; ++i2) {
            PlayerProfile profile = (PlayerProfile)entries.get(i2);
            profiles[i2] = profile.getId() != null && profile.getName() != null ? CraftPlayerProfile.asAuthlib(profile) : new GameProfile((UUID)MoreObjects.firstNonNull((Object)profile.getId(), (Object)FAKE_UUID), Strings.nullToEmpty((String)profile.getName()));
        }
        return profiles;
    }

    public static void processRequest(MinecraftServer server, NetworkManager networkManager) {
        StandardPaperServerListPingEventImpl event = new StandardPaperServerListPingEventImpl(server, networkManager, server.ap());
        server.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            networkManager.a((IChatBaseComponent)null);
            return;
        }
        ServerPing ping = new ServerPing();
        ping.a(new AdventureComponent(event.motd()));
        if (!event.shouldHidePlayers()) {
            ping.a(new ServerPing.ServerPingPlayerSample(event.getMaxPlayers(), event.getNumPlayers()));
            ping.b().a(event.getPlayerSampleHandle());
        }
        ping.a(new ServerPing.ServerData(event.getVersion(), event.getProtocolVersion()));
        if (event.getServerIcon() != null) {
            ping.a(event.getServerIcon().getData());
        }
        networkManager.a(new PacketStatusOutServerInfo(ping));
    }
}

