/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.network;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.network.PaperServerListPingEventImpl;
import com.destroystokyo.paper.network.StatusClient;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public final class PaperLegacyStatusClient
implements StatusClient {
    private final InetSocketAddress address;
    private final int protocolVersion;
    @Nullable
    private final InetSocketAddress virtualHost;

    private PaperLegacyStatusClient(InetSocketAddress address, int protocolVersion, @Nullable InetSocketAddress virtualHost) {
        this.address = address;
        this.protocolVersion = protocolVersion;
        this.virtualHost = virtualHost;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Nullable
    public InetSocketAddress getVirtualHost() {
        return this.virtualHost;
    }

    public boolean isLegacy() {
        return true;
    }

    public static PaperServerListPingEvent processRequest(MinecraftServer server, InetSocketAddress address, int protocolVersion, @Nullable InetSocketAddress virtualHost) {
        PaperServerListPingEventImpl event = new PaperServerListPingEventImpl(server, new PaperLegacyStatusClient(address, protocolVersion, virtualHost), 127, null);
        server.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        return event;
    }

    public static String getMotd(PaperServerListPingEvent event) {
        return PaperLegacyStatusClient.getFirstLine(event.getMotd());
    }

    public static String getUnformattedMotd(PaperServerListPingEvent event) {
        return PaperLegacyStatusClient.getFirstLine(StringUtils.remove((String)ChatColor.stripColor((String)event.getMotd()), (char)'\u00a7'));
    }

    private static String getFirstLine(String s2) {
        int pos = s2.indexOf(10);
        return pos >= 0 ? s2.substring(0, pos) : s2;
    }
}

