/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.loottable;

import com.destroystokyo.paper.PaperWorldConfig;
import com.destroystokyo.paper.loottable.LootableInventoryReplenishEvent;
import com.destroystokyo.paper.loottable.PaperLootableInventory;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.entity.Player;
import org.bukkit.loot.LootTable;

public class PaperLootableInventoryData {
    private static final Random RANDOM = new Random();
    private long lastFill = -1L;
    private long nextRefill = -1L;
    private int numRefills = 0;
    private Map<UUID, Long> lootedPlayers;
    private final PaperLootableInventory lootable;

    public PaperLootableInventoryData(PaperLootableInventory lootable) {
        this.lootable = lootable;
    }

    long getLastFill() {
        return this.lastFill;
    }

    long getNextRefill() {
        return this.nextRefill;
    }

    long setNextRefill(long nextRefill) {
        long prev = this.nextRefill;
        this.nextRefill = nextRefill;
        return prev;
    }

    public boolean shouldReplenish(@Nullable EntityHuman player) {
        LootTable table = this.lootable.getLootTable();
        if (table == null) {
            return false;
        }
        if (this.lastFill == -1L || !this.lootable.getNMSWorld().paperConfig.autoReplenishLootables) {
            return true;
        }
        if (player == null) {
            return false;
        }
        if (this.nextRefill == -1L) {
            return false;
        }
        PaperWorldConfig paperConfig = this.lootable.getNMSWorld().paperConfig;
        if (paperConfig.maxLootableRefills != -1 && this.numRefills >= paperConfig.maxLootableRefills) {
            return false;
        }
        if (this.nextRefill > System.currentTimeMillis()) {
            return false;
        }
        Player bukkitPlayer = (Player)player.getBukkitEntity();
        LootableInventoryReplenishEvent event = new LootableInventoryReplenishEvent(bukkitPlayer, this.lootable.getAPILootableInventory());
        if (paperConfig.restrictPlayerReloot && this.hasPlayerLooted(player.cm())) {
            event.setCancelled(true);
        }
        return event.callEvent();
    }

    public void processRefill(@Nullable EntityHuman player) {
        this.lastFill = System.currentTimeMillis();
        PaperWorldConfig paperConfig = this.lootable.getNMSWorld().paperConfig;
        if (paperConfig.autoReplenishLootables) {
            int min = paperConfig.lootableRegenMin;
            int max = paperConfig.lootableRegenMax;
            this.nextRefill = this.lastFill + (long)(min + RANDOM.nextInt(max - min + 1)) * 1000L;
            ++this.numRefills;
            if (paperConfig.changeLootTableSeedOnFill) {
                this.lootable.setSeed(0L);
            }
            if (player != null) {
                this.setPlayerLootedState(player.cm(), true);
            }
        } else {
            this.lootable.clearLootTable();
        }
    }

    public void loadNbt(NBTTagCompound base) {
        if (!base.b("Paper.LootableData", 10)) {
            return;
        }
        NBTTagCompound comp = base.p("Paper.LootableData");
        if (comp.e("lastFill")) {
            this.lastFill = comp.i("lastFill");
        }
        if (comp.e("nextRefill")) {
            this.nextRefill = comp.i("nextRefill");
        }
        if (comp.e("numRefills")) {
            this.numRefills = comp.h("numRefills");
        }
        if (comp.b("lootedPlayers", 9)) {
            NBTTagList list = comp.c("lootedPlayers", 10);
            int size = list.size();
            if (size > 0) {
                this.lootedPlayers = new HashMap<UUID, Long>(list.size());
            }
            for (int i2 = 0; i2 < size; ++i2) {
                NBTTagCompound cmp = list.a(i2);
                this.lootedPlayers.put(cmp.a("UUID"), cmp.i("Time"));
            }
        }
    }

    public void saveNbt(NBTTagCompound base) {
        NBTTagCompound comp = new NBTTagCompound();
        if (this.nextRefill != -1L) {
            comp.a("nextRefill", this.nextRefill);
        }
        if (this.lastFill != -1L) {
            comp.a("lastFill", this.lastFill);
        }
        if (this.numRefills != 0) {
            comp.a("numRefills", this.numRefills);
        }
        if (this.lootedPlayers != null && !this.lootedPlayers.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<UUID, Long> entry : this.lootedPlayers.entrySet()) {
                NBTTagCompound cmp = new NBTTagCompound();
                cmp.a("UUID", entry.getKey());
                cmp.a("Time", entry.getValue());
                list.add(cmp);
            }
            comp.a("lootedPlayers", list);
        }
        if (!comp.f()) {
            base.a("Paper.LootableData", comp);
        }
    }

    void setPlayerLootedState(UUID player, boolean looted) {
        if (looted && this.lootedPlayers == null) {
            this.lootedPlayers = new HashMap<UUID, Long>();
        }
        if (looted) {
            if (!this.lootedPlayers.containsKey(player)) {
                this.lootedPlayers.put(player, System.currentTimeMillis());
            }
        } else if (this.lootedPlayers != null) {
            this.lootedPlayers.remove(player);
        }
    }

    boolean hasPlayerLooted(UUID player) {
        return this.lootedPlayers != null && this.lootedPlayers.containsKey(player);
    }

    Long getLastLooted(UUID player) {
        return this.lootedPlayers != null ? this.lootedPlayers.get(player) : null;
    }
}

