/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.io.chunk;

import com.destroystokyo.paper.io.IOUtil;
import com.destroystokyo.paper.io.PaperFileIOThread;
import com.destroystokyo.paper.io.PrioritizedTaskQueue;
import com.destroystokyo.paper.io.QueueExecutorThread;
import com.destroystokyo.paper.io.chunk.ChunkLoadTask;
import com.destroystokyo.paper.io.chunk.ChunkSaveTask;
import com.destroystokyo.paper.io.chunk.ChunkTask;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.bukkit.Bukkit;
import org.spigotmc.AsyncCatcher;

public final class ChunkTaskManager {
    private final QueueExecutorThread<ChunkTask>[] workers;
    private final WorldServer world;
    private final PrioritizedTaskQueue<ChunkTask> queue;
    private final boolean perWorldQueue;
    final ConcurrentHashMap<Long, ChunkLoadTask> chunkLoadTasks = new ConcurrentHashMap(64, 0.5f);
    final ConcurrentHashMap<Long, ChunkSaveTask> chunkSaveTasks = new ConcurrentHashMap(64, 0.5f);
    private final PrioritizedTaskQueue<ChunkTask> chunkTasks = new PrioritizedTaskQueue();
    protected static QueueExecutorThread<ChunkTask>[] globalWorkers;
    protected static PrioritizedTaskQueue<ChunkTask> globalQueue;
    protected static final ConcurrentLinkedQueue<Runnable> CHUNK_WAIT_QUEUE;
    public static final ArrayDeque<ChunkInfo> WAITING_CHUNKS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushChunkWait(WorldServer world, int chunkX, int chunkZ) {
        ArrayDeque<ChunkInfo> arrayDeque = WAITING_CHUNKS;
        synchronized (arrayDeque) {
            WAITING_CHUNKS.push(new ChunkInfo(chunkX, chunkZ, world));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popChunkWait() {
        ArrayDeque<ChunkInfo> arrayDeque = WAITING_CHUNKS;
        synchronized (arrayDeque) {
            WAITING_CHUNKS.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChunkInfo[] getChunkInfos() {
        ChunkInfo[] chunks;
        ArrayDeque<ChunkInfo> arrayDeque = WAITING_CHUNKS;
        synchronized (arrayDeque) {
            chunks = WAITING_CHUNKS.toArray(new ChunkInfo[0]);
        }
        return chunks;
    }

    public static void dumpAllChunkLoadInfo() {
        ChunkInfo[] chunks = ChunkTaskManager.getChunkInfos();
        if (chunks.length > 0) {
            PaperFileIOThread.LOGGER.log(Level.ERROR, "Chunk wait task info below: ");
            for (ChunkInfo chunkInfo : chunks) {
                long key = IOUtil.getCoordinateKey(chunkInfo.chunkX, chunkInfo.chunkZ);
                ChunkLoadTask loadTask = chunkInfo.world.asyncChunkTaskManager.chunkLoadTasks.get(key);
                ChunkSaveTask saveTask = chunkInfo.world.asyncChunkTaskManager.chunkSaveTasks.get(key);
                PaperFileIOThread.LOGGER.log(Level.ERROR, chunkInfo.chunkX + "," + chunkInfo.chunkZ + " in '" + chunkInfo.world.getWorld().getName() + ":");
                PaperFileIOThread.LOGGER.log(Level.ERROR, "Load Task - " + (loadTask == null ? "none" : loadTask.toString()));
                PaperFileIOThread.LOGGER.log(Level.ERROR, "Save Task - " + (saveTask == null ? "none" : saveTask.toString()));
                PlayerChunk chunkHolder = chunkInfo.world.k().a.b(key);
                ChunkTaskManager.dumpChunkInfo(new HashSet<PlayerChunk>(), chunkHolder, chunkInfo.chunkX, chunkInfo.chunkZ);
            }
        }
    }

    static void dumpChunkInfo(Set<PlayerChunk> seenChunks, PlayerChunk chunkHolder, int x2, int z2) {
        ChunkTaskManager.dumpChunkInfo(seenChunks, chunkHolder, x2, z2, 0, 4);
    }

    static void dumpChunkInfo(Set<PlayerChunk> seenChunks, PlayerChunk chunkHolder, int x2, int z2, int indent, int maxDepth) {
        if (seenChunks.contains(chunkHolder)) {
            return;
        }
        if (indent > maxDepth) {
            return;
        }
        seenChunks.add(chunkHolder);
        String indentStr = StringUtils.repeat((String)"  ", (int)indent);
        if (chunkHolder == null) {
            PaperFileIOThread.LOGGER.log(Level.ERROR, indentStr + "Chunk Holder - null for (" + x2 + "," + z2 + ")");
        } else {
            IChunkAccess chunk = chunkHolder.f();
            ChunkStatus holderStatus = chunkHolder.getChunkHolderStatus();
            PaperFileIOThread.LOGGER.log(Level.ERROR, indentStr + "Chunk Holder - non-null");
            PaperFileIOThread.LOGGER.log(Level.ERROR, indentStr + "Chunk Status - " + (chunk == null ? "null chunk" : chunk.j().toString()));
            PaperFileIOThread.LOGGER.log(Level.ERROR, indentStr + "Chunk Ticket Status - " + PlayerChunk.b(chunkHolder.j()));
            PaperFileIOThread.LOGGER.log(Level.ERROR, indentStr + "Chunk Holder Status - " + (holderStatus == null ? "null" : holderStatus.toString()));
            PaperFileIOThread.LOGGER.log(Level.ERROR, indentStr + "Chunk Holder Priority - " + chunkHolder.q);
            if (!chunkHolder.neighbors.isEmpty()) {
                if (indent >= maxDepth) {
                    PaperFileIOThread.LOGGER.log(Level.ERROR, indentStr + "Chunk Neighbors: (Can't show, too deeply nested)");
                    return;
                }
                PaperFileIOThread.LOGGER.log(Level.ERROR, indentStr + "Chunk Neighbors: ");
                for (PlayerChunk neighbor : chunkHolder.neighbors.keySet()) {
                    ChunkStatus status = neighbor.getChunkHolderStatus();
                    if (status != null && status.b(PlayerChunk.b(neighbor.j()))) continue;
                    int nx = neighbor.r.c;
                    int nz = neighbor.r.d;
                    if (seenChunks.contains(neighbor)) {
                        PaperFileIOThread.LOGGER.log(Level.ERROR, indentStr + "  " + nx + "," + nz + " in " + chunkHolder.getWorld().getWorld().getName() + " (CIRCULAR)");
                        continue;
                    }
                    PaperFileIOThread.LOGGER.log(Level.ERROR, indentStr + "  " + nx + "," + nz + " in " + chunkHolder.getWorld().getWorld().getName() + ":");
                    ChunkTaskManager.dumpChunkInfo(seenChunks, neighbor, nx, nz, indent + 1, maxDepth);
                }
            }
        }
    }

    public static void initGlobalLoadThreads(int threads) {
        if (threads <= 0 || globalWorkers != null) {
            return;
        }
        globalWorkers = new QueueExecutorThread[++threads];
        globalQueue = new PrioritizedTaskQueue();
        for (int i2 = 0; i2 < threads - 1; ++i2) {
            ChunkTaskManager.globalWorkers[i2] = new QueueExecutorThread<ChunkTask>(globalQueue, 100000L);
            globalWorkers[i2].setName("Paper Async Chunk Task Thread #" + i2);
            globalWorkers[i2].setPriority(4);
            globalWorkers[i2].setUncaughtExceptionHandler((thread, throwable) -> PaperFileIOThread.LOGGER.fatal("Thread '" + thread.getName() + "' threw an uncaught exception!", throwable));
            globalWorkers[i2].start();
        }
        ChunkTaskManager.globalWorkers[threads - 1] = new QueueExecutorThread<ChunkTask>(globalQueue, 100000L);
        globalWorkers[threads - 1].setName("Paper Async Chunk Urgent Task Thread");
        globalWorkers[threads - 1].setPriority(6);
        globalWorkers[threads - 1].setUncaughtExceptionHandler((thread, throwable) -> PaperFileIOThread.LOGGER.fatal("Thread '" + thread.getName() + "' threw an uncaught exception!", throwable));
        globalWorkers[threads - 1].setLowestPriorityToPoll(0);
        globalWorkers[threads - 1].start();
    }

    public ChunkTaskManager(WorldServer world, int threads) {
        this.world = world;
        this.workers = threads <= 0 ? null : new QueueExecutorThread[threads];
        this.queue = new PrioritizedTaskQueue();
        this.perWorldQueue = true;
        for (int i2 = 0; i2 < threads; ++i2) {
            this.workers[i2] = new QueueExecutorThread<ChunkTask>(this.queue, 100000L);
            this.workers[i2].setName("Async chunk loader thread #" + i2 + " for world: " + world.getWorld().getName());
            this.workers[i2].setPriority(4);
            this.workers[i2].setUncaughtExceptionHandler((thread, throwable) -> PaperFileIOThread.LOGGER.fatal("Thread '" + thread.getName() + "' threw an uncaught exception!", throwable));
            this.workers[i2].start();
        }
    }

    public ChunkTaskManager(WorldServer world) {
        this.world = world;
        this.workers = globalWorkers;
        this.queue = globalQueue;
        this.perWorldQueue = false;
    }

    public boolean pollNextChunkTask() {
        ChunkTask task = this.chunkTasks.poll();
        if (task != null) {
            task.run();
            return true;
        }
        return false;
    }

    public static boolean pollChunkWaitQueue() {
        Runnable run = CHUNK_WAIT_QUEUE.poll();
        if (run != null) {
            run.run();
            return true;
        }
        return false;
    }

    public static void queueChunkWaitTask(Runnable runnable) {
        CHUNK_WAIT_QUEUE.add(runnable);
    }

    private static void drainChunkWaitQueue() {
        Runnable run;
        while ((run = CHUNK_WAIT_QUEUE.poll()) != null) {
            run.run();
        }
    }

    public ChunkLoadTask scheduleChunkLoad(int chunkX, int chunkZ, int priority, Consumer<ChunkRegionLoader.InProgressChunkHolder> onComplete, boolean intendingToBlock, CompletableFuture<NBTTagCompound> dataFuture) {
        WorldServer world = this.world;
        return this.chunkLoadTasks.compute(IOUtil.getCoordinateKey(chunkX, chunkZ), (keyInMap, valueInMap) -> {
            if (valueInMap != null) {
                if (!valueInMap.cancelled) {
                    throw new IllegalStateException("Double scheduling chunk load for task: " + valueInMap.toString());
                }
                valueInMap.cancelled = false;
                valueInMap.onComplete = onComplete;
                return valueInMap;
            }
            ChunkLoadTask ret = new ChunkLoadTask(world, chunkX, chunkZ, priority, this, onComplete);
            dataFuture.thenAccept(data -> {
                boolean failed = data == PaperFileIOThread.FAILURE_VALUE;
                PaperFileIOThread.Holder.INSTANCE.loadChunkDataAsync(world, chunkX, chunkZ, priority, chunkData -> {
                    ret.chunkData = chunkData;
                    if (!failed) {
                        chunkData.chunkData = data;
                    }
                    this.internalSchedule(ret);
                }, true, failed, intendingToBlock);
            });
            return ret;
        });
    }

    public void cancelChunkLoad(int chunkX, int chunkZ) {
        this.chunkLoadTasks.compute(IOUtil.getCoordinateKey(chunkX, chunkZ), (keyInMap, valueInMap) -> {
            if (valueInMap == null) {
                return null;
            }
            if (valueInMap.cancelled) {
                PaperFileIOThread.LOGGER.warn("Task " + valueInMap.toString() + " is already cancelled!");
            }
            valueInMap.cancelled = true;
            if (valueInMap.cancel()) {
                return null;
            }
            return valueInMap;
        });
    }

    public ChunkLoadTask scheduleChunkLoad(int chunkX, int chunkZ, int priority, Consumer<ChunkRegionLoader.InProgressChunkHolder> onComplete, boolean intendingToBlock) {
        WorldServer world = this.world;
        return this.chunkLoadTasks.compute(IOUtil.getCoordinateKey(chunkX, chunkZ), (keyInMap, valueInMap) -> {
            if (valueInMap != null) {
                if (!valueInMap.cancelled) {
                    throw new IllegalStateException("Double scheduling chunk load for task: " + valueInMap.toString());
                }
                valueInMap.cancelled = false;
                valueInMap.onComplete = onComplete;
                return valueInMap;
            }
            ChunkLoadTask ret = new ChunkLoadTask(world, chunkX, chunkZ, priority, this, onComplete);
            PaperFileIOThread.Holder.INSTANCE.loadChunkDataAsync(world, chunkX, chunkZ, priority, chunkData -> {
                ret.chunkData = chunkData;
                this.internalSchedule(ret);
            }, true, true, intendingToBlock);
            return ret;
        });
    }

    public ChunkSaveTask scheduleChunkSave(int chunkX, int chunkZ, int priority, ChunkRegionLoader.AsyncSaveData asyncSaveData, IChunkAccess chunk) {
        AsyncCatcher.catchOp("chunk save schedule");
        WorldServer world = this.world;
        return this.chunkSaveTasks.compute(IOUtil.getCoordinateKey(chunkX, chunkZ), (keyInMap, valueInMap) -> {
            if (valueInMap != null) {
                throw new IllegalStateException("Double scheduling chunk save for task: " + valueInMap.toString());
            }
            ChunkSaveTask ret = new ChunkSaveTask(world, chunkX, chunkZ, priority, this, asyncSaveData, chunk);
            this.internalSchedule(ret);
            return ret;
        });
    }

    public CompletableFuture<NBTTagCompound> getChunkSaveFuture(int chunkX, int chunkZ) {
        ChunkSaveTask chunkSaveTask = this.chunkSaveTasks.get(IOUtil.getCoordinateKey(chunkX, chunkZ));
        if (chunkSaveTask == null) {
            return null;
        }
        return chunkSaveTask.onComplete;
    }

    public IChunkAccess getChunkInSaveProgress(int chunkX, int chunkZ) {
        ChunkSaveTask chunkSaveTask = this.chunkSaveTasks.get(IOUtil.getCoordinateKey(chunkX, chunkZ));
        if (chunkSaveTask == null) {
            return null;
        }
        return chunkSaveTask.chunk;
    }

    public void flush() {
        ChunkTaskManager.drainChunkWaitQueue();
        PaperFileIOThread.Holder.INSTANCE.flush();
        ChunkTaskManager.drainChunkWaitQueue();
        if (this.workers == null) {
            if (Bukkit.isPrimaryThread() || MinecraftServer.getServer().hasStopped()) {
                this.world.k().h.bp();
            } else {
                CompletableFuture wait = new CompletableFuture();
                MinecraftServer.getServer().scheduleOnMain(() -> this.world.k().h.bp());
                wait.join();
            }
        } else {
            for (QueueExecutorThread<ChunkTask> worker : this.workers) {
                worker.flush();
            }
        }
        ChunkTaskManager.drainChunkWaitQueue();
        PaperFileIOThread.Holder.INSTANCE.flush();
    }

    public void close(boolean wait) {
        PaperFileIOThread.Holder.INSTANCE.flush();
        if (this.workers == null) {
            if (wait) {
                this.flush();
            }
            return;
        }
        if (this.workers != globalWorkers) {
            for (QueueExecutorThread<ChunkTask> worker : this.workers) {
                worker.close(false, this.perWorldQueue);
            }
        }
        if (wait) {
            this.flush();
        }
    }

    public void raisePriority(int chunkX, int chunkZ, int priority) {
        ChunkLoadTask chunkLoadTask;
        Long chunkKey = IOUtil.getCoordinateKey(chunkX, chunkZ);
        ChunkTask chunkSaveTask = this.chunkSaveTasks.get(chunkKey);
        if (chunkSaveTask != null) {
            this.raiseTaskPriority(chunkSaveTask, priority != 0 ? priority : 2);
        }
        if ((chunkLoadTask = this.chunkLoadTasks.get(chunkKey)) != null) {
            this.raiseTaskPriority(chunkLoadTask, priority);
        }
    }

    private void raiseTaskPriority(ChunkTask task, int priority) {
        boolean raised = task.raisePriority(priority);
        if (task.isScheduled() && raised && this.workers != null) {
            if (priority == 0) {
                this.internalScheduleNotifyUrgent();
            }
            this.internalScheduleNotify();
        }
    }

    protected void internalSchedule(ChunkTask task) {
        if (this.workers == null) {
            this.chunkTasks.add(task);
            return;
        }
        this.queue.add(task);
        this.internalScheduleNotify();
        if (task.getPriority() == 0) {
            this.internalScheduleNotifyUrgent();
        }
    }

    protected void internalScheduleNotify() {
        QueueExecutorThread<ChunkTask> worker;
        if (this.workers == null) {
            return;
        }
        int len = this.workers.length - 1;
        for (int i2 = 0; i2 < len && !(worker = this.workers[i2]).notifyTasks(); ++i2) {
        }
    }

    protected void internalScheduleNotifyUrgent() {
        if (this.workers == null) {
            return;
        }
        this.workers[this.workers.length - 1].notifyTasks();
    }

    static {
        CHUNK_WAIT_QUEUE = new ConcurrentLinkedQueue();
        WAITING_CHUNKS = new ArrayDeque();
    }

    private static final class ChunkInfo {
        public final int chunkX;
        public final int chunkZ;
        public final WorldServer world;

        public ChunkInfo(int chunkX, int chunkZ, WorldServer world) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.world = world;
        }

        public String toString() {
            return "[( " + this.chunkX + "," + this.chunkZ + ") in '" + this.world.getWorld().getName() + "']";
        }
    }
}

