/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.io;

import com.destroystokyo.paper.io.IOUtil;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class PrioritizedTaskQueue<T extends PrioritizedTask> {
    public static final int COMPLETING_PRIORITY = -1;
    public static final int HIGHEST_PRIORITY = 0;
    public static final int HIGHER_PRIORITY = 1;
    public static final int HIGH_PRIORITY = 2;
    public static final int NORMAL_PRIORITY = 3;
    public static final int LOW_PRIORITY = 4;
    public static final int LOWEST_PRIORITY = 5;
    private static final int TOTAL_PRIORITIES = 6;
    final ConcurrentLinkedQueue<T>[] queues = new ConcurrentLinkedQueue[6];
    private final AtomicBoolean shutdown = new AtomicBoolean();

    public PrioritizedTaskQueue() {
        for (int i2 = 0; i2 < 6; ++i2) {
            this.queues[i2] = new ConcurrentLinkedQueue();
        }
    }

    public static boolean validPriority(int priority) {
        return priority >= 0 && priority < 6;
    }

    public void add(T task) throws IllegalStateException {
        int priority = ((PrioritizedTask)task).getPriority();
        if (priority != -1) {
            ((PrioritizedTask)task).setQueue(this);
            this.queues[priority].add(task);
        }
        if (this.shutdown.get()) {
            throw new IllegalStateException("Queue has shutdown, refusing to execute task " + IOUtil.genericToString(task));
        }
    }

    public T poll() {
        for (int i2 = 0; i2 < 6; ++i2) {
            PrioritizedTask task;
            ConcurrentLinkedQueue<T> queue = this.queues[i2];
            while ((task = (PrioritizedTask)queue.poll()) != null) {
                int prevPriority = task.tryComplete(i2);
                if (prevPriority == -1 || prevPriority > i2) continue;
                return (T)task;
            }
        }
        return null;
    }

    public T poll(int lowestPriority) {
        int max = Math.min(5, lowestPriority);
        for (int i2 = 0; i2 <= max; ++i2) {
            PrioritizedTask task;
            ConcurrentLinkedQueue<T> queue = this.queues[i2];
            while ((task = (PrioritizedTask)queue.poll()) != null) {
                int prevPriority = task.tryComplete(i2);
                if (prevPriority == -1 || prevPriority > i2) continue;
                return (T)task;
            }
        }
        return null;
    }

    public boolean hasTasks() {
        for (int i2 = 0; i2 < 6; ++i2) {
            ConcurrentLinkedQueue<T> queue = this.queues[i2];
            if (queue.peek() == null) continue;
            return true;
        }
        return false;
    }

    public boolean shutdown() {
        return this.shutdown.getAndSet(false);
    }

    public static abstract class PrioritizedTask {
        protected final AtomicReference<PrioritizedTaskQueue> queue = new AtomicReference();
        protected final AtomicInteger priority;

        protected PrioritizedTask() {
            this(3);
        }

        protected PrioritizedTask(int priority) {
            if (!PrioritizedTaskQueue.validPriority(priority)) {
                throw new IllegalArgumentException("Invalid priority " + priority);
            }
            this.priority = new AtomicInteger(priority);
        }

        public final int getPriority() {
            return this.priority.get();
        }

        public boolean isScheduled() {
            return this.queue.get() != null;
        }

        final int tryComplete(int minPriority) {
            int curr = this.getPriorityVolatile();
            do {
                if (curr == -1) {
                    return -1;
                }
                if (curr <= minPriority) continue;
                return curr;
            } while (curr != (curr = this.compareAndExchangePriorityVolatile(curr, -1)));
            return curr;
        }

        public boolean cancel() {
            return this.exchangePriorityVolatile(-1) != -1;
        }

        public boolean raisePriority(int priority) {
            if (!PrioritizedTaskQueue.validPriority(priority)) {
                throw new IllegalArgumentException("Invalid priority");
            }
            int curr = this.getPriorityVolatile();
            do {
                if (curr == -1) {
                    return false;
                }
                if (priority < curr) continue;
                return true;
            } while (curr != (curr = this.compareAndExchangePriorityVolatile(curr, priority)));
            PrioritizedTaskQueue queue = this.queue.get();
            if (queue != null) {
                queue.queues[priority].add(this);
            }
            return true;
        }

        public boolean updatePriority(int priority) {
            if (!PrioritizedTaskQueue.validPriority(priority)) {
                throw new IllegalArgumentException("Invalid priority");
            }
            int curr = this.getPriorityVolatile();
            do {
                if (curr == -1) {
                    return false;
                }
                if (curr != priority) continue;
                return true;
            } while (curr != (curr = this.compareAndExchangePriorityVolatile(curr, priority)));
            PrioritizedTaskQueue queue = this.queue.get();
            if (queue != null) {
                queue.queues[priority].add(this);
            }
            return true;
        }

        void setQueue(PrioritizedTaskQueue queue) {
            this.queue.set(queue);
        }

        protected final int getPriorityVolatile() {
            return this.priority.get();
        }

        protected final int compareAndExchangePriorityVolatile(int expect, int update) {
            if (this.priority.compareAndSet(expect, update)) {
                return expect;
            }
            return this.priority.get();
        }

        protected final int exchangePriorityVolatile(int value) {
            return this.priority.getAndSet(value);
        }
    }
}

