/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.io;

import com.destroystokyo.paper.io.IOUtil;
import com.destroystokyo.paper.io.PrioritizedTaskQueue;
import com.destroystokyo.paper.io.QueueExecutorThread;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFile;
import org.apache.logging.log4j.Logger;

public final class PaperFileIOThread
extends QueueExecutorThread {
    public static final Logger LOGGER = MinecraftServer.r;
    public static final NBTTagCompound FAILURE_VALUE = new NBTTagCompound();
    private final AtomicLong writeCounter = new AtomicLong();

    private PaperFileIOThread() {
        super(new PrioritizedTaskQueue(), 1000000L);
        this.setName("Paper RegionFile IO Thread");
        this.setPriority(4);
        this.setUncaughtExceptionHandler((unused, thr) -> LOGGER.fatal("Uncaught exception thrown from IO thread, report this!", thr));
    }

    public void bumpPriority(WorldServer world, int chunkX, int chunkZ, int priority) {
        if (!PrioritizedTaskQueue.validPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority: " + priority);
        }
        Long key = IOUtil.getCoordinateKey(chunkX, chunkZ);
        ChunkDataTask poiTask = world.poiDataController.tasks.get(key);
        ChunkDataTask chunkTask = world.chunkDataController.tasks.get(key);
        if (poiTask != null) {
            poiTask.raisePriority(priority);
        }
        if (chunkTask != null) {
            chunkTask.raisePriority(priority);
        }
    }

    public NBTTagCompound getPendingWrite(WorldServer world, int chunkX, int chunkZ, boolean poiData) {
        ChunkDataController taskController = poiData ? world.poiDataController : world.chunkDataController;
        ChunkDataTask dataTask = taskController.tasks.get(IOUtil.getCoordinateKey(chunkX, chunkZ));
        if (dataTask == null) {
            return null;
        }
        ChunkDataController.InProgressWrite write = dataTask.inProgressWrite;
        if (write == null) {
            return null;
        }
        return write.data;
    }

    public void setPriority(WorldServer world, int chunkX, int chunkZ, int priority) {
        if (!PrioritizedTaskQueue.validPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority: " + priority);
        }
        Long key = IOUtil.getCoordinateKey(chunkX, chunkZ);
        ChunkDataTask poiTask = world.poiDataController.tasks.get(key);
        ChunkDataTask chunkTask = world.chunkDataController.tasks.get(key);
        if (poiTask != null) {
            poiTask.updatePriority(priority);
        }
        if (chunkTask != null) {
            chunkTask.updatePriority(priority);
        }
    }

    public void scheduleSave(WorldServer world, int chunkX, int chunkZ, NBTTagCompound poiData, NBTTagCompound chunkData, int priority) throws IllegalArgumentException {
        if (!PrioritizedTaskQueue.validPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority: " + priority);
        }
        long writeCounter = this.writeCounter.getAndIncrement();
        if (poiData != null) {
            this.scheduleWrite(world.poiDataController, world, chunkX, chunkZ, poiData, priority, writeCounter);
        }
        if (chunkData != null) {
            this.scheduleWrite(world.chunkDataController, world, chunkX, chunkZ, chunkData, priority, writeCounter);
        }
    }

    private void scheduleWrite(ChunkDataController dataController, WorldServer world, int chunkX, int chunkZ, NBTTagCompound data, int priority, long writeCounter) {
        dataController.tasks.compute(IOUtil.getCoordinateKey(chunkX, chunkZ), (keyInMap, taskRunning) -> {
            if (taskRunning == null) {
                ChunkDataTask newTask = new ChunkDataTask(priority, world, chunkX, chunkZ, dataController);
                newTask.inProgressWrite = new ChunkDataController.InProgressWrite();
                newTask.inProgressWrite.writeCounter = writeCounter;
                newTask.inProgressWrite.data = data;
                this.queueTask(newTask);
                return newTask;
            }
            taskRunning.raisePriority(priority);
            if (taskRunning.inProgressWrite == null) {
                taskRunning.inProgressWrite = new ChunkDataController.InProgressWrite();
            }
            boolean reschedule = taskRunning.inProgressWrite.writeCounter == -1L;
            ChunkDataTask chunkDataTask = taskRunning;
            synchronized (chunkDataTask) {
                taskRunning.inProgressWrite.data = data;
                taskRunning.inProgressWrite.writeCounter = writeCounter;
            }
            if (reschedule) {
                taskRunning.reschedule(priority);
            }
            return taskRunning;
        });
    }

    public CompletableFuture<ChunkData> loadChunkDataAsyncFuture(WorldServer world, int chunkX, int chunkZ, int priority, boolean readPoiData, boolean readChunkData, boolean intendingToBlock) {
        CompletableFuture<ChunkData> future = new CompletableFuture<ChunkData>();
        this.loadChunkDataAsync(world, chunkX, chunkZ, priority, future::complete, readPoiData, readChunkData, intendingToBlock);
        return future;
    }

    public void loadChunkDataAsync(WorldServer world, int chunkX, int chunkZ, int priority, Consumer<ChunkData> onComplete, boolean readPoiData, boolean readChunkData, boolean intendingToBlock) {
        if (!PrioritizedTaskQueue.validPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority: " + priority);
        }
        if (!(readPoiData | readChunkData)) {
            throw new IllegalArgumentException("Must read chunk data or poi data");
        }
        ChunkData complete = new ChunkData();
        boolean[] requireCompletion = new boolean[]{readPoiData, readChunkData};
        if (readPoiData) {
            this.scheduleRead(world.poiDataController, world, chunkX, chunkZ, poiData -> {
                complete.poiData = poiData;
                boolean[] blArray = requireCompletion;
                synchronized (requireCompletion) {
                    requireCompletion[0] = false;
                    boolean finished = !requireCompletion[1];
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    if (finished) {
                        onComplete.accept(complete);
                    }
                    return;
                }
            }, priority, intendingToBlock);
        }
        if (readChunkData) {
            this.scheduleRead(world.chunkDataController, world, chunkX, chunkZ, chunkData -> {
                complete.chunkData = chunkData;
                boolean[] blArray = requireCompletion;
                synchronized (requireCompletion) {
                    requireCompletion[1] = false;
                    boolean finished = !requireCompletion[0];
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    if (finished) {
                        onComplete.accept(complete);
                    }
                    return;
                }
            }, priority, intendingToBlock);
        }
    }

    private void scheduleRead(ChunkDataController dataController, WorldServer world, int chunkX, int chunkZ, Consumer<NBTTagCompound> onComplete, int priority, boolean intendingToBlock) {
        Function<RegionFile, Boolean> tryLoadFunction = file -> {
            if (file == null) {
                return Boolean.TRUE;
            }
            return file.e(new ChunkCoordIntPair(chunkX, chunkZ));
        };
        dataController.tasks.compute(IOUtil.getCoordinateKey(chunkX, chunkZ), (keyInMap, running) -> {
            if (running == null) {
                Boolean shouldSchedule;
                Boolean bl = shouldSchedule = intendingToBlock ? (Boolean)dataController.computeForRegionFile(chunkX, chunkZ, tryLoadFunction) : (Boolean)dataController.computeForRegionFileIfLoaded(chunkX, chunkZ, tryLoadFunction);
                if (shouldSchedule == Boolean.FALSE) {
                    onComplete.accept(null);
                    return null;
                }
                ChunkDataTask newTask = new ChunkDataTask(priority, world, chunkX, chunkZ, dataController);
                newTask.inProgressRead = new ChunkDataController.InProgressRead();
                newTask.inProgressRead.readFuture.thenAccept((Consumer)onComplete);
                this.queueTask(newTask);
                return newTask;
            }
            running.raisePriority(priority);
            if (running.inProgressWrite == null) {
                running.inProgressRead.readFuture.thenAccept((Consumer)onComplete);
                return running;
            }
            onComplete.accept(running.inProgressWrite.data);
            return running;
        });
    }

    public ChunkData loadChunkData(WorldServer world, int chunkX, int chunkZ, int priority, boolean readPoiData, boolean readChunkData) {
        return this.loadChunkDataAsyncFuture(world, chunkX, chunkZ, priority, readPoiData, readChunkData, true).join();
    }

    public void runTask(int priority, Runnable runnable) {
        this.queueTask(new GeneralTask(priority, runnable));
    }

    public static abstract class ChunkDataController {
        public final ConcurrentHashMap<Long, ChunkDataTask> tasks = new ConcurrentHashMap(64, 0.5f);

        public abstract void writeData(int var1, int var2, NBTTagCompound var3) throws IOException;

        public abstract NBTTagCompound readData(int var1, int var2) throws IOException;

        public abstract <T> T computeForRegionFile(int var1, int var2, Function<RegionFile, T> var3);

        public abstract <T> T computeForRegionFileIfLoaded(int var1, int var2, Function<RegionFile, T> var3);

        public static final class InProgressRead {
            public final CompletableFuture<NBTTagCompound> readFuture = new CompletableFuture();
        }

        public static final class InProgressWrite {
            public long writeCounter;
            public NBTTagCompound data;
        }
    }

    public static final class ChunkDataTask
    extends PrioritizedTaskQueue.PrioritizedTask
    implements Runnable {
        public ChunkDataController.InProgressWrite inProgressWrite;
        public ChunkDataController.InProgressRead inProgressRead;
        private final WorldServer world;
        private final int x;
        private final int z;
        private final ChunkDataController taskController;

        public ChunkDataTask(int priority, WorldServer world, int x2, int z2, ChunkDataController taskController) {
            super(priority);
            this.world = world;
            this.x = x2;
            this.z = z2;
            this.taskController = taskController;
        }

        public String toString() {
            return "Task for world: '" + this.world.getWorld().getName() + "' at " + this.x + "," + this.z + " poi: " + (this.taskController == this.world.poiDataController) + ", hash: " + this.hashCode();
        }

        void reschedule(int priority) {
            this.queue.lazySet(null);
            this.priority.lazySet(priority);
            Holder.INSTANCE.queueTask(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean failedWrite;
            boolean finalFailWrite;
            long writeCounter;
            ChunkDataTask inMap;
            ChunkDataController.InProgressRead read = this.inProgressRead;
            if (read != null) {
                NBTTagCompound compound = FAILURE_VALUE;
                try {
                    compound = this.taskController.readData(this.x, this.z);
                }
                catch (Throwable thr) {
                    if (thr instanceof ThreadDeath) {
                        throw (ThreadDeath)thr;
                    }
                    LOGGER.fatal("Failed to read chunk data for task: " + this.toString(), thr);
                }
                read.readFuture.complete(compound);
            }
            Long chunkKey = IOUtil.getCoordinateKey(this.x, this.z);
            ChunkDataController.InProgressWrite write = this.inProgressWrite;
            if (write == null) {
                ChunkDataTask inMap2 = this.taskController.tasks.compute(chunkKey, (keyInMap, valueInMap) -> {
                    if (valueInMap == null) {
                        throw new IllegalStateException("Write completed concurrently, expected this task: " + this.toString() + ", report this!");
                    }
                    if (valueInMap != this) {
                        throw new IllegalStateException("Chunk task mismatch, expected this task: " + this.toString() + ", got: " + valueInMap.toString() + ", report this!");
                    }
                    return valueInMap.inProgressWrite == null ? null : valueInMap;
                });
                if (inMap2 == null) {
                    return;
                }
                write = this.inProgressWrite;
            }
            do {
                NBTTagCompound data;
                ChunkDataController.InProgressWrite inProgressWrite = write;
                synchronized (inProgressWrite) {
                    writeCounter = write.writeCounter;
                    data = write.data;
                }
                failedWrite = false;
                try {
                    this.taskController.writeData(this.x, this.z, data);
                }
                catch (Throwable thr) {
                    if (thr instanceof ThreadDeath) {
                        throw (ThreadDeath)thr;
                    }
                    LOGGER.fatal("Failed to write chunk data for task: " + this.toString(), thr);
                    failedWrite = true;
                }
            } while ((inMap = this.taskController.tasks.compute(chunkKey, (arg_0, arg_1) -> this.lambda$run$1(writeCounter, finalFailWrite = failedWrite, arg_0, arg_1))) != null);
        }

        private /* synthetic */ ChunkDataTask lambda$run$1(long writeCounter, boolean finalFailWrite, Long keyInMap, ChunkDataTask valueInMap) {
            if (valueInMap == null) {
                throw new IllegalStateException("Write completed concurrently, expected this task: " + this.toString() + ", report this!");
            }
            if (valueInMap != this) {
                throw new IllegalStateException("Chunk task mismatch, expected this task: " + this.toString() + ", got: " + valueInMap.toString() + ", report this!");
            }
            if (valueInMap.inProgressWrite.writeCounter == writeCounter) {
                if (finalFailWrite) {
                    valueInMap.inProgressWrite.writeCounter = -1L;
                }
                return null;
            }
            return valueInMap;
        }
    }

    public static final class ChunkData {
        public NBTTagCompound poiData;
        public NBTTagCompound chunkData;

        public ChunkData() {
        }

        public ChunkData(NBTTagCompound poiData, NBTTagCompound chunkData) {
            this.poiData = poiData;
            this.chunkData = chunkData;
        }
    }

    static final class GeneralTask
    extends PrioritizedTaskQueue.PrioritizedTask
    implements Runnable {
        private final Runnable run;

        public GeneralTask(int priority, Runnable run) {
            super(priority);
            this.run = IOUtil.notNull(run, "Task may not be null");
        }

        @Override
        public void run() {
            try {
                this.run.run();
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                LOGGER.fatal("Failed to execute general task on IO thread " + IOUtil.genericToString(this.run), throwable);
            }
        }
    }

    public static final class Holder {
        public static final PaperFileIOThread INSTANCE = new PaperFileIOThread();

        static {
            INSTANCE.start();
        }
    }
}

