/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.nbt;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.nbt.NBTListType;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;

public final class NBTMapType
implements MapType<String> {
    private final NBTTagCompound map;

    public NBTMapType() {
        this.map = new NBTTagCompound();
    }

    public NBTMapType(NBTTagCompound tag) {
        this.map = tag;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != NBTMapType.class) {
            return false;
        }
        return this.map.equals(((NBTMapType)obj).map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return "NBTMapType{map=" + this.map + "}";
    }

    @Override
    public int size() {
        return this.map.e();
    }

    @Override
    public boolean isEmpty() {
        return this.map.f();
    }

    @Override
    public void clear() {
        this.map.d().clear();
    }

    @Override
    public Set<String> keys() {
        return this.map.d();
    }

    public NBTTagCompound getTag() {
        return this.map;
    }

    @Override
    public MapType<String> copy() {
        return new NBTMapType(this.map.g());
    }

    @Override
    public boolean hasKey(String key) {
        return this.map.c(key) != null;
    }

    @Override
    public boolean hasKey(String key, ObjectType type) {
        NBTBase tag = this.map.c(key);
        if (tag == null) {
            return false;
        }
        ObjectType valueType = NBTListType.getType(tag.a());
        return valueType == type || type == ObjectType.NUMBER && valueType.isNumber();
    }

    @Override
    public void remove(String key) {
        this.map.r(key);
    }

    @Override
    public Object getGeneric(String key) {
        NBTBase tag = this.map.c(key);
        if (tag == null) {
            return null;
        }
        switch (NBTListType.getType(tag.a())) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ((NBTNumber)tag).k();
            }
            case MAP: {
                return new NBTMapType((NBTTagCompound)tag);
            }
            case LIST: {
                return new NBTListType((NBTTagList)tag);
            }
            case STRING: {
                return ((NBTTagString)tag).e_();
            }
            case BYTE_ARRAY: {
                return ((NBTTagByteArray)tag).d();
            }
            case INT_ARRAY: {
                return ((NBTTagIntArray)tag).f();
            }
            case LONG_ARRAY: {
                return ((NBTTagLongArray)tag).f();
            }
        }
        throw new IllegalStateException("Unrecognized type " + tag);
    }

    @Override
    public Number getNumber(String key) {
        return this.getNumber(key, (Number)null);
    }

    @Override
    public Number getNumber(String key, Number dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).k();
        }
        return dfl;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getByte(key) != 0;
    }

    @Override
    public boolean getBoolean(String key, boolean dfl) {
        return this.getByte(key, dfl ? (byte)1 : 0) != 0;
    }

    @Override
    public void setBoolean(String key, boolean val) {
        this.setByte(key, val ? (byte)1 : 0);
    }

    @Override
    public byte getByte(String key) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).h();
        }
        return 0;
    }

    @Override
    public byte getByte(String key, byte dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).h();
        }
        return dfl;
    }

    @Override
    public void setByte(String key, byte val) {
        this.map.a(key, val);
    }

    @Override
    public short getShort(String key) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).g();
        }
        return 0;
    }

    @Override
    public short getShort(String key, short dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).g();
        }
        return dfl;
    }

    @Override
    public void setShort(String key, short val) {
        this.map.a(key, val);
    }

    @Override
    public int getInt(String key) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).f();
        }
        return 0;
    }

    @Override
    public int getInt(String key, int dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).f();
        }
        return dfl;
    }

    @Override
    public void setInt(String key, int val) {
        this.map.a(key, val);
    }

    @Override
    public long getLong(String key) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).e();
        }
        return 0L;
    }

    @Override
    public long getLong(String key, long dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).e();
        }
        return dfl;
    }

    @Override
    public void setLong(String key, long val) {
        this.map.a(key, val);
    }

    @Override
    public float getFloat(String key) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).j();
        }
        return 0.0f;
    }

    @Override
    public float getFloat(String key, float dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).j();
        }
        return dfl;
    }

    @Override
    public void setFloat(String key, float val) {
        this.map.a(key, val);
    }

    @Override
    public double getDouble(String key) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).i();
        }
        return 0.0;
    }

    @Override
    public double getDouble(String key, double dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTNumber) {
            return ((NBTNumber)tag).i();
        }
        return dfl;
    }

    @Override
    public void setDouble(String key, double val) {
        this.map.a(key, val);
    }

    @Override
    public byte[] getBytes(String key) {
        return this.getBytes(key, (byte[])null);
    }

    @Override
    public byte[] getBytes(String key, byte[] dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTTagByteArray) {
            return ((NBTTagByteArray)tag).d();
        }
        return dfl;
    }

    @Override
    public void setBytes(String key, byte[] val) {
        this.map.a(key, val);
    }

    @Override
    public short[] getShorts(String key) {
        return this.getShorts(key, (short[])null);
    }

    @Override
    public short[] getShorts(String key, short[] dfl) {
        return dfl;
    }

    @Override
    public void setShorts(String key, short[] val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getInts(String key) {
        return this.getInts(key, (int[])null);
    }

    @Override
    public int[] getInts(String key, int[] dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTTagIntArray) {
            return ((NBTTagIntArray)tag).f();
        }
        return dfl;
    }

    @Override
    public void setInts(String key, int[] val) {
        this.map.a(key, val);
    }

    @Override
    public long[] getLongs(String key) {
        return this.getLongs(key, (long[])null);
    }

    @Override
    public long[] getLongs(String key, long[] dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTTagLongArray) {
            return ((NBTTagLongArray)tag).f();
        }
        return dfl;
    }

    @Override
    public void setLongs(String key, long[] val) {
        this.map.a(key, val);
    }

    @Override
    public ListType getListUnchecked(String key) {
        return this.getListUnchecked(key, (ListType)null);
    }

    @Override
    public ListType getListUnchecked(String key, ListType dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTTagList) {
            return new NBTListType((NBTTagList)tag);
        }
        return dfl;
    }

    @Override
    public void setList(String key, ListType val) {
        this.map.a(key, ((NBTListType)val).getTag());
    }

    @Override
    public MapType<String> getMap(String key) {
        return this.getMap(key, (MapType)null);
    }

    @Override
    public MapType<String> getMap(String key, MapType dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTTagCompound) {
            return new NBTMapType((NBTTagCompound)tag);
        }
        return dfl;
    }

    @Override
    public void setMap(String key, MapType<?> val) {
        this.map.a(key, ((NBTMapType)val).getTag());
    }

    @Override
    public String getString(String key) {
        return this.getString(key, (String)null);
    }

    @Override
    public String getString(String key, String dfl) {
        NBTBase tag = this.map.c(key);
        if (tag instanceof NBTTagString) {
            return ((NBTTagString)tag).e_();
        }
        return dfl;
    }

    @Override
    public void setString(String key, String val) {
        this.map.a(key, val);
    }
}

