/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types;

import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;

public interface ListType {
    public int hashCode();

    public boolean equals(Object var1);

    public ListType copy();

    public ObjectType getType();

    public int size();

    public void remove(int var1);

    default public Object getGeneric(int index) {
        switch (this.getType()) {
            case NONE: {
                throw new IllegalStateException("List is empty and has no type");
            }
            case BYTE: {
                return this.getByte(index);
            }
            case SHORT: {
                return this.getShort(index);
            }
            case INT: {
                return this.getInt(index);
            }
            case LONG: {
                return this.getLong(index);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(index));
            }
            case DOUBLE: {
                return this.getDouble(index);
            }
            case NUMBER: {
                return this.getNumber(index);
            }
            case BYTE_ARRAY: {
                return this.getBytes(index);
            }
            case SHORT_ARRAY: {
                return this.getShorts(index);
            }
            case INT_ARRAY: {
                return this.getInts(index);
            }
            case LONG_ARRAY: {
                return this.getLongs(index);
            }
            case LIST: {
                return this.getList(index);
            }
            case MAP: {
                return this.getMap(index);
            }
            case STRING: {
                return this.getString(index);
            }
        }
        throw new UnsupportedOperationException(this.getType().name());
    }

    default public void setGeneric(int index, Object to) {
        if (to instanceof Number) {
            if (to instanceof Byte) {
                this.setByte(index, (Byte)to);
                return;
            }
            if (to instanceof Short) {
                this.setShort(index, (Short)to);
                return;
            }
            if (to instanceof Integer) {
                this.setInt(index, (Integer)to);
                return;
            }
            if (to instanceof Long) {
                this.setLong(index, (Long)to);
                return;
            }
            if (to instanceof Float) {
                this.setFloat(index, ((Float)to).floatValue());
                return;
            }
            if (to instanceof Double) {
                this.setDouble(index, (Double)to);
                return;
            }
        } else {
            if (to instanceof MapType) {
                this.setMap(index, (MapType)to);
                return;
            }
            if (to instanceof ListType) {
                this.setList(index, (ListType)to);
                return;
            }
            if (to instanceof String) {
                this.setString(index, (String)to);
                return;
            }
            if (to.getClass().isArray()) {
                if (to instanceof byte[]) {
                    this.setBytes(index, (byte[])to);
                    return;
                }
                if (to instanceof short[]) {
                    this.setShorts(index, (short[])to);
                    return;
                }
                if (to instanceof int[]) {
                    this.setInts(index, (int[])to);
                    return;
                }
                if (to instanceof long[]) {
                    this.setLongs(index, (long[])to);
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Object " + to + " is not a valid type!");
    }

    public Number getNumber(int var1);

    public byte getByte(int var1);

    public void setByte(int var1, byte var2);

    public short getShort(int var1);

    public void setShort(int var1, short var2);

    public int getInt(int var1);

    public void setInt(int var1, int var2);

    public long getLong(int var1);

    public void setLong(int var1, long var2);

    public float getFloat(int var1);

    public void setFloat(int var1, float var2);

    public double getDouble(int var1);

    public void setDouble(int var1, double var2);

    public byte[] getBytes(int var1);

    public void setBytes(int var1, byte[] var2);

    public short[] getShorts(int var1);

    public void setShorts(int var1, short[] var2);

    public int[] getInts(int var1);

    public void setInts(int var1, int[] var2);

    public long[] getLongs(int var1);

    public void setLongs(int var1, long[] var2);

    public ListType getList(int var1);

    public void setList(int var1, ListType var2);

    public <T> MapType<T> getMap(int var1);

    public void setMap(int var1, MapType<?> var2);

    public String getString(int var1);

    public void setString(int var1, String var2);

    default public void addGeneric(Object to) {
        if (to instanceof Number) {
            if (to instanceof Byte) {
                this.addByte((Byte)to);
                return;
            }
            if (to instanceof Short) {
                this.addShort((Short)to);
                return;
            }
            if (to instanceof Integer) {
                this.addInt((Integer)to);
                return;
            }
            if (to instanceof Long) {
                this.addLong((Long)to);
                return;
            }
            if (to instanceof Float) {
                this.addFloat(((Float)to).floatValue());
                return;
            }
            if (to instanceof Double) {
                this.addDouble((Double)to);
                return;
            }
        } else {
            if (to instanceof MapType) {
                this.addMap((MapType)to);
                return;
            }
            if (to instanceof ListType) {
                this.addList((ListType)to);
                return;
            }
            if (to instanceof String) {
                this.addString((String)to);
                return;
            }
            if (to.getClass().isArray()) {
                if (to instanceof byte[]) {
                    this.addByteArray((byte[])to);
                    return;
                }
                if (to instanceof short[]) {
                    this.addShortArray((short[])to);
                    return;
                }
                if (to instanceof int[]) {
                    this.addIntArray((int[])to);
                    return;
                }
                if (to instanceof long[]) {
                    this.addLongArray((long[])to);
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Object " + to + " is not a valid type!");
    }

    public void addByte(byte var1);

    public void addByte(int var1, byte var2);

    public void addShort(short var1);

    public void addShort(int var1, short var2);

    public void addInt(int var1);

    public void addInt(int var1, int var2);

    public void addLong(long var1);

    public void addLong(int var1, long var2);

    public void addFloat(float var1);

    public void addFloat(int var1, float var2);

    public void addDouble(double var1);

    public void addDouble(int var1, double var2);

    public void addByteArray(byte[] var1);

    public void addByteArray(int var1, byte[] var2);

    public void addShortArray(short[] var1);

    public void addShortArray(int var1, short[] var2);

    public void addIntArray(int[] var1);

    public void addIntArray(int var1, int[] var2);

    public void addLongArray(long[] var1);

    public void addLongArray(int var1, long[] var2);

    public void addList(ListType var1);

    public void addList(int var1, ListType var2);

    public void addMap(MapType<?> var1);

    public void addMap(int var1, MapType<?> var2);

    public void addString(String var1);

    public void addString(int var1, String var2);
}

