/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft;

import ca.spottedleaf.dataconverter.converters.datatypes.DataType;
import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplacedDataFixerUpper
implements DataFixer {
    protected static final Set<DSL.TypeReference> WARNED_TYPES = ConcurrentHashMap.newKeySet();
    private static final Logger LOGGER = LogManager.getLogger();
    public final DataFixer wrapped;

    public ReplacedDataFixerUpper(DataFixer wrapped) {
        this.wrapped = wrapped;
    }

    public <T> Dynamic<T> update(DSL.TypeReference type, Dynamic<T> input, int version, int newVersion) {
        DataType equivType = null;
        boolean warn = true;
        if (type == DataConverterTypes.a) {
            warn = false;
        }
        if (type == DataConverterTypes.b) {
            equivType = MCTypeRegistry.PLAYER;
        }
        if (type == DataConverterTypes.c) {
            equivType = MCTypeRegistry.CHUNK;
        }
        if (type == DataConverterTypes.d) {
            warn = false;
        }
        if (type == DataConverterTypes.e) {
            warn = false;
        }
        if (type == DataConverterTypes.f) {
            equivType = MCTypeRegistry.STRUCTURE;
        }
        if (type == DataConverterTypes.g) {
            warn = false;
        }
        if (type == DataConverterTypes.h) {
            equivType = MCTypeRegistry.SAVED_DATA;
        }
        if (type == DataConverterTypes.i) {
            warn = false;
        }
        if (type == DataConverterTypes.j) {
            equivType = MCTypeRegistry.POI_CHUNK;
        }
        if (type == DataConverterTypes.k) {
            equivType = MCTypeRegistry.ENTITY_CHUNK;
        }
        if (type == DataConverterTypes.l) {
            equivType = MCTypeRegistry.TILE_ENTITY;
        }
        if (type == DataConverterTypes.m) {
            equivType = MCTypeRegistry.ITEM_STACK;
        }
        if (type == DataConverterTypes.n) {
            equivType = MCTypeRegistry.BLOCK_STATE;
        }
        if (type == DataConverterTypes.o) {
            equivType = MCTypeRegistry.ENTITY_NAME;
        }
        if (type == DataConverterTypes.p) {
            equivType = MCTypeRegistry.ENTITY;
        }
        if (type == DataConverterTypes.q) {
            // empty if block
        }
        if (type == DataConverterTypes.r) {
            equivType = MCTypeRegistry.BLOCK_NAME;
        }
        if (type == DataConverterTypes.s) {
            equivType = MCTypeRegistry.ITEM_NAME;
        }
        if (type == DataConverterTypes.t) {
            equivType = MCTypeRegistry.UNTAGGED_SPAWNER;
        }
        if (type == DataConverterTypes.u) {
            equivType = MCTypeRegistry.STRUCTURE_FEATURE;
        }
        if (type == DataConverterTypes.v) {
            warn = false;
        }
        if (type == DataConverterTypes.w) {
            warn = false;
        }
        if (type == DataConverterTypes.x) {
            warn = false;
        }
        if (type == DataConverterTypes.y) {
            equivType = MCTypeRegistry.BIOME;
        }
        if (type == DataConverterTypes.z) {
            warn = false;
        }
        if (equivType != null) {
            if (newVersion > version) {
                try {
                    Dynamic<MapType<String>> ret = new Dynamic<MapType<String>>(input.getOps(), MCDataConverter.copy(MCDataConverter.convertUnwrapped(equivType, input.getValue(), false, version, newVersion)));
                    return ret;
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to convert data using DataConverter, falling back to DFU", new Throwable());
                    return this.wrapped.update(type, input, version, newVersion);
                }
            }
            return input;
        }
        if (warn && WARNED_TYPES.add(type)) {
            LOGGER.error("No equiv type for " + type, new Throwable());
        }
        return this.wrapped.update(type, input, version, newVersion);
    }

    public Schema getSchema(int key) {
        return this.wrapped.getSchema(key);
    }
}

