/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.MCVersions;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MCVersionRegistry {
    private static final Logger LOGGER;
    protected static final Int2ObjectLinkedOpenHashMap<String> VERSION_NAMES;
    protected static final IntArrayList VERSION_LIST;
    protected static final LongArrayList DATA_VERSION_LIST;
    protected static final IntArrayList DATACONVERTER_VERSIONS_LIST;
    protected static final IntLinkedOpenHashSet DATACONVERTER_VERSIONS_MAJOR;
    protected static final LongLinkedOpenHashSet DATACONVERTER_VERSIONS;
    protected static final Int2ObjectLinkedOpenHashMap<IntArrayList> SUBVERSIONS;
    protected static final LongArrayList BREAKPOINTS;

    private static void registerSubVersion(int version, int step) {
        if (DATA_VERSION_LIST != null) {
            throw new IllegalStateException("Added too late!");
        }
        ((IntArrayList)SUBVERSIONS.computeIfAbsent(version, keyInMap -> new IntArrayList())).add(step);
    }

    private static void registerBreakpoint(int version) {
        MCVersionRegistry.registerBreakpoint(version, 0);
    }

    private static void registerBreakpoint(int version, int step) {
        BREAKPOINTS.add(DataConverter.encodeVersions(version, step));
    }

    public static boolean hasDataConverters(int version) {
        return DATACONVERTER_VERSIONS_MAJOR.contains(version);
    }

    public String getVersionName(int version) {
        return (String)VERSION_NAMES.get(version);
    }

    public boolean isRegisteredVersion(int version) {
        return VERSION_NAMES.containsKey(version);
    }

    public static IntArrayList getVersionList() {
        return VERSION_LIST;
    }

    public static LongArrayList getDataVersionList() {
        return DATA_VERSION_LIST;
    }

    public static int getMaxVersion() {
        return VERSION_LIST.getInt(VERSION_LIST.size() - 1);
    }

    public static LongArrayList getBreakpoints() {
        return BREAKPOINTS;
    }

    public static void checkVersion(long version) {
        if (!DATACONVERTER_VERSIONS.contains(version)) {
            throw new IllegalStateException("Version " + DataConverter.encodedToString(version) + " is not registered to have dataconverters, yet has a dataconverter");
        }
    }

    static {
        IntListIterator intListIterator;
        int version;
        String name;
        IntListIterator fields;
        LOGGER = LogManager.getLogger();
        VERSION_NAMES = new Int2ObjectLinkedOpenHashMap();
        DATACONVERTER_VERSIONS_MAJOR = new IntLinkedOpenHashSet();
        DATACONVERTER_VERSIONS = new LongLinkedOpenHashSet();
        SUBVERSIONS = new Int2ObjectLinkedOpenHashMap();
        BREAKPOINTS = new LongArrayList();
        int[] converterVersions = new int[]{99, 100, 101, 102, 105, 106, 107, 108, 109, 110, 111, 113, 135, 143, 147, 165, 501, 502, 505, 700, 701, 702, 703, 704, 705, 804, 806, 808, 808, 813, 816, 820, 1022, 1125, 1344, 1446, 1450, 1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451, 1456, 1458, 1460, 1466, 1470, 1474, 1475, 1480, 1481, 1483, 1484, 1486, 1487, 1488, 1490, 1492, 1494, 1496, 1500, 1501, 1502, 1506, 1510, 1514, 1515, 1624, 1800, 1801, 1802, 1803, 1904, 1905, 1906, 1909, 1911, 1917, 1918, 1920, 1925, 1928, 1929, 1931, 1936, 1946, 1948, 1953, 1955, 1961, 1963, 2100, 2202, 2209, 2211, 2218, 2501, 2502, 2503, 2505, 2508, 2509, 2511, 2514, 2516, 2518, 2519, 2522, 2523, 2527, 2528, 2529, 2531, 2533, 2535, 2550, 2551, 2552, 2553, 2558, 2568, 2671, 2679, 2680, 2684, 2686, 2688, 2690, 2691, 2693, 2696, 2700, 2701, 2702, 2704, 2707, 2710, 2717, 2825, 2831, 2832, 2833, 2838, 2841, 2842, 2843, 2846, 2852};
        Arrays.sort(converterVersions);
        DATACONVERTER_VERSIONS_LIST = new IntArrayList(converterVersions);
        DATACONVERTER_VERSIONS_MAJOR.addAll((IntCollection)DATACONVERTER_VERSIONS_LIST);
        MCVersionRegistry.registerSubVersion(808, 1);
        MCVersionRegistry.registerSubVersion(1451, 1);
        MCVersionRegistry.registerSubVersion(1451, 2);
        MCVersionRegistry.registerSubVersion(1451, 3);
        MCVersionRegistry.registerSubVersion(1451, 4);
        MCVersionRegistry.registerSubVersion(1451, 5);
        MCVersionRegistry.registerSubVersion(1451, 6);
        MCVersionRegistry.registerSubVersion(1451, 7);
        MCVersionRegistry.registerBreakpoint(1451);
        MCVersionRegistry.registerBreakpoint(1451, Integer.MAX_VALUE);
        MCVersionRegistry.registerBreakpoint(2730, Integer.MAX_VALUE);
        for (Field field : fields = MCVersions.class.getDeclaredFields()) {
            int value;
            name = field.getName();
            try {
                value = field.getInt(null);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (VERSION_NAMES.containsKey(value) && value != 111) {
                LOGGER.warn("Error registering version \"" + name + "\", version number '" + value + "' is already associated with \"" + (String)VERSION_NAMES.get(value) + "\"");
            }
            VERSION_NAMES.put(value, (Object)name.substring(1).replace("_PRE", "-PRE").replace("_RC", "-RC").replace('_', '.').toLowerCase(Locale.ROOT));
        }
        IntListIterator intListIterator2 = DATACONVERTER_VERSIONS_MAJOR.iterator();
        while (intListIterator2.hasNext()) {
            version = (Integer)intListIterator2.next();
            if (VERSION_NAMES.containsKey(version)) continue;
            int closest = Integer.MAX_VALUE;
            String closestName = null;
            name = VERSION_NAMES.keySet().iterator();
            while (name.hasNext()) {
                int v2 = (Integer)name.next();
                if (v2 <= version || v2 >= closest) continue;
                closest = v2;
                closestName = (String)VERSION_NAMES.get(v2);
            }
            if (closestName == null) {
                VERSION_NAMES.put(version, (Object)("unregistered_v" + version));
                continue;
            }
            VERSION_NAMES.put(version, (Object)(closestName + "-dev" + (closest - version)));
        }
        VERSION_NAMES.put(99, (Object)"pre_converter");
        VERSION_LIST = new IntArrayList((IntCollection)new IntRBTreeSet(VERSION_NAMES.keySet()));
        DATA_VERSION_LIST = new LongArrayList();
        intListIterator2 = VERSION_LIST.iterator();
        while (intListIterator2.hasNext()) {
            version = (Integer)intListIterator2.next();
            DATA_VERSION_LIST.add(DataConverter.encodeVersions(version, 0));
            IntArrayList subVersions = (IntArrayList)SUBVERSIONS.get(version);
            if (subVersions == null) continue;
            intListIterator = subVersions.iterator();
            while (intListIterator.hasNext()) {
                int step = (Integer)intListIterator.next();
                DATA_VERSION_LIST.add(DataConverter.encodeVersions(version, step));
            }
        }
        DATA_VERSION_LIST.sort(Comparator.naturalOrder());
        intListIterator2 = DATACONVERTER_VERSIONS_MAJOR.iterator();
        while (intListIterator2.hasNext()) {
            version = (Integer)intListIterator2.next();
            DATACONVERTER_VERSIONS.add(DataConverter.encodeVersions(version, 0));
            IntArrayList subVersions = (IntArrayList)SUBVERSIONS.get(version);
            if (subVersions == null) continue;
            intListIterator = subVersions.iterator();
            while (intListIterator.hasNext()) {
                int step = (Integer)intListIterator.next();
                DATACONVERTER_VERSIONS.add(DataConverter.encodeVersions(version, step));
            }
        }
    }
}

