/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseSignPortals.utils;

import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.destination.InvalidDestination;
import com.onarandombox.MultiverseSignPortals.MultiverseSignPortals;
import com.onarandombox.MultiverseSignPortals.enums.Axis;
import com.onarandombox.MultiverseSignPortals.exceptions.MoreThanOneSignFoundException;
import com.onarandombox.MultiverseSignPortals.exceptions.NoMultiverseSignFoundException;
import com.onarandombox.MultiverseSignPortals.utils.SignStatus;
import com.onarandombox.MultiverseSignPortals.utils.SignTools;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Squid;
import org.bukkit.util.Vector;

public class PortalDetector {
    public static final Pattern REDSTONE_TELEPORT_PATTERN = Pattern.compile(".*\\[([pPaAmM]|all|ALL):\\d+(:(north|NORTH|south|SOUTH|east|EAST|west|WEST|up|UP|down|DOWN))?\\]");
    private MultiverseSignPortals plugin;
    private static final int ALL = 0;
    private static final int PLAYERS = 1;
    private static final int MONSTERS = 2;
    private static final int ANIMALS = 3;

    public PortalDetector(MultiverseSignPortals plugin) {
        this.plugin = plugin;
    }

    public String getNotchPortalDestination(Player p, Location l) throws MoreThanOneSignFoundException, NoMultiverseSignFoundException {
        Block block = l.getBlock();
        List<Sign> foundSigns = null;
        if (block.getType() == Material.NETHER_PORTAL) {
            if (block.getRelative(1, 0, 0).getType() == Material.NETHER_PORTAL) {
                Location portalEnd = block.getRelative(1, 0, 0).getLocation();
                Location portalStart = block.getRelative(0, 2, 0).getLocation();
                foundSigns = this.checkBlocksOutside(l.getWorld().getBlockAt(portalStart), l.getWorld().getBlockAt(portalEnd), Axis.X);
                this.plugin.log(Level.FINER, "Found normal X");
            } else if (block.getRelative(-1, 0, 0).getType() == Material.NETHER_PORTAL) {
                Location portalEnd = block.getLocation();
                Location portalStart = block.getRelative(-1, 2, 0).getLocation();
                foundSigns = this.checkBlocksOutside(l.getWorld().getBlockAt(portalStart), l.getWorld().getBlockAt(portalEnd), Axis.X);
                this.plugin.log(Level.FINER, "Found inverse X");
            } else if (block.getRelative(0, 0, 1).getType() == Material.NETHER_PORTAL) {
                Location portalEnd = block.getRelative(0, 0, 1).getLocation();
                Location portalStart = block.getRelative(0, 2, 0).getLocation();
                foundSigns = this.checkBlocksOutside(l.getWorld().getBlockAt(portalStart), l.getWorld().getBlockAt(portalEnd), Axis.Z);
                this.plugin.log(Level.FINER, "Found normal Z");
            } else if (block.getRelative(0, 0, -1).getType() == Material.NETHER_PORTAL) {
                Location portalEnd = block.getLocation();
                Location portalStart = block.getRelative(0, 2, -1).getLocation();
                foundSigns = this.checkBlocksOutside(l.getWorld().getBlockAt(portalStart), l.getWorld().getBlockAt(portalEnd), Axis.Z);
                this.plugin.log(Level.FINER, "Found inverse Z");
            }
        }
        if (foundSigns != null) {
            this.plugin.log(Level.FINE, "Woo! Notch Portal!");
            return this.processSigns(foundSigns, p);
        }
        this.plugin.log(Level.FINE, ":( No Notch Portal Here...");
        return null;
    }

    public void activateSignPortal(Player player, String type, Sign sign) {
        if (this.plugin.getCore().getMVPerms().hasPermission((CommandSender)player, "multiverse.signportal.validate", true)) {
            ChatColor colorToChange = ChatColor.DARK_GREEN;
            if (SignTools.isMVSign("mv", ChatColor.GREEN)) {
                colorToChange = ChatColor.DARK_BLUE;
                player.sendMessage("This vanilla sign portal has been " + ChatColor.GREEN + " Validated!");
            } else {
                player.sendMessage("This MV sign portal has been " + ChatColor.GREEN + " Validated!");
            }
            sign.setLine(1, SignTools.setColor(sign.getLine(1), colorToChange));
            sign.update(true);
        } else {
            player.sendMessage("Sorry you don't have permission to activate this " + type + ChatColor.WHITE + " SignPortal.");
        }
    }

    private String processSigns(List<Sign> foundSigns, Player player) throws MoreThanOneSignFoundException, NoMultiverseSignFoundException {
        Sign foundSign = null;
        Sign legacySign = null;
        Sign normalSign = null;
        for (Sign s : foundSigns) {
            if (this.getSignStatus(s) == SignStatus.NetherPortalSign) {
                if (foundSign != null) {
                    throw new MoreThanOneSignFoundException();
                }
                foundSign = s;
                continue;
            }
            if (foundSign == null && this.getSignStatus(s) == SignStatus.Legacy) {
                if (legacySign != null) {
                    throw new MoreThanOneSignFoundException();
                }
                legacySign = s;
                continue;
            }
            if (foundSign != null || this.getSignStatus(s) != SignStatus.SignPortal) continue;
            if (normalSign != null) {
                throw new MoreThanOneSignFoundException();
            }
            normalSign = s;
        }
        if (foundSign == null && legacySign == null && normalSign == null) {
            throw new NoMultiverseSignFoundException();
        }
        if (foundSign != null) {
            this.invalidateOtherSigns(foundSign, foundSigns);
            return foundSign.getLine(2);
        }
        if (legacySign != null && this.plugin.getCore().getMVPerms().hasPermission((CommandSender)player, "multiverse.signportal.validate", true)) {
            this.plugin.log(Level.FINE, "Migrating Legacy Sign");
            legacySign.setLine(1, SignTools.setColor(legacySign.getLine(1), ChatColor.DARK_BLUE));
            legacySign.update(true);
            this.invalidateOtherSigns(legacySign, foundSigns);
            return legacySign.getLine(2);
        }
        if (normalSign != null) {
            this.plugin.log(Level.FINE, "Migrating Normal Sign");
            normalSign.setLine(1, SignTools.setColor(normalSign.getLine(1), ChatColor.DARK_BLUE));
            normalSign.update(true);
            return normalSign.getLine(2);
        }
        throw new NoMultiverseSignFoundException();
    }

    private void invalidateOtherSigns(Sign sign, List<Sign> foundSigns) {
        for (Sign s : foundSigns) {
            if (s.equals(sign)) continue;
            s.setLine(1, SignTools.setColor(s.getLine(1), ChatColor.DARK_RED));
            s.update(true);
        }
    }

    public String processSign(Sign sign) {
        if (SignTools.isMVSign(sign.getLine(1), ChatColor.DARK_GREEN)) {
            this.plugin.log(Level.FINER, "Found a MV Sign");
            return sign.getLine(2) + sign.getLine(3);
        }
        return null;
    }

    public SignStatus getSignStatus(Sign sign) {
        if (SignTools.isMVSign(sign.getLine(1), ChatColor.DARK_GREEN)) {
            this.plugin.log(Level.FINER, "Found a MV Sign (Sign Portal)");
            return SignStatus.SignPortal;
        }
        if (SignTools.isMVSign(sign.getLine(1), ChatColor.DARK_BLUE)) {
            this.plugin.log(Level.FINER, "Found a MV Sign (Nether Portal that has a Sign)");
            return SignStatus.NetherPortalSign;
        }
        if (SignTools.isMVSign(sign.getLine(1), ChatColor.DARK_RED)) {
            this.plugin.log(Level.FINER, "Found a MV Sign (Disabled)");
            return SignStatus.Disabled;
        }
        if (SignTools.isMVSign(sign.getLine(1), null)) {
            this.plugin.log(Level.FINER, "Found a MV Sign (Legacy)");
            return SignStatus.Legacy;
        }
        return SignStatus.NotASignPortal;
    }

    public Entity[] getRedstoneTeleportEntities(Sign sign) {
        if (REDSTONE_TELEPORT_PATTERN.matcher(sign.getLine(0)).matches()) {
            int radius;
            int type;
            String line = ChatColor.stripColor((String)sign.getLine(0).replaceAll("(\\[|\\])", ""));
            String[] data = line.split(":");
            if (data[0].equals("ALL") || data[0].equals("all")) {
                type = 0;
            } else if (data[0].equals("p") || data[0].equals("P")) {
                type = 1;
            } else if (data[0].equals("m") || data[0].equals("M")) {
                type = 2;
            } else if (data[0].equals("a") || data[0].equals("A")) {
                type = 3;
            } else {
                return new Entity[0];
            }
            try {
                radius = Integer.valueOf(data[1]);
            }
            catch (NumberFormatException e) {
                return new Entity[0];
            }
            int xOff = 0;
            int yOff = 0;
            int zOff = 0;
            if (data.length > 2) {
                if (data[2].equals("north") || data[2].equals("NORTH")) {
                    xOff = -radius;
                } else if (data[2].equals("south") || data[2].equals("SOUTH")) {
                    xOff = radius;
                } else if (data[2].equals("east") || data[2].equals("EAST")) {
                    zOff = -radius;
                } else if (data[2].equals("west") || data[2].equals("WEST")) {
                    zOff = radius;
                } else if (data[2].equals("up") || data[2].equals("UP")) {
                    yOff = radius;
                } else if (data[2].equals("down") || data[2].equals("DOWN")) {
                    yOff = -radius;
                }
            }
            Vector signVector = sign.getBlock().getLocation().toVector();
            Vector min = new Vector(signVector.getX() + (double)(xOff - radius), signVector.getY() + (double)(yOff - radius), signVector.getZ() + (double)(zOff - radius));
            Vector max = new Vector(signVector.getX() + (double)(xOff + radius), signVector.getY() + (double)(yOff + radius), signVector.getZ() + (double)(zOff + radius));
            List worldEntities = sign.getBlock().getWorld().getLivingEntities();
            ArrayList<LivingEntity> entitiesInRange = new ArrayList<LivingEntity>(worldEntities.size());
            for (LivingEntity entity : worldEntities) {
                if ((type == 0 || type == 3) && (entity instanceof Animals || entity instanceof Squid)) {
                    if (!entity.getLocation().toVector().isInAABB(min, max)) continue;
                    this.plugin.log(Level.FINEST, "Found " + entity + " within range!");
                    entitiesInRange.add(entity);
                    continue;
                }
                if ((type == 0 || type == 2) && entity instanceof Monster) {
                    if (!entity.getLocation().toVector().isInAABB(min, max)) continue;
                    this.plugin.log(Level.FINEST, "Found " + entity + " within range!");
                    entitiesInRange.add(entity);
                    continue;
                }
                if (type != 0 && type != 1 || !(entity instanceof HumanEntity) || !entity.getLocation().toVector().isInAABB(min, max)) continue;
                this.plugin.log(Level.FINEST, "Found " + entity + " within range!");
                entitiesInRange.add(entity);
            }
            return entitiesInRange.toArray(new Entity[entitiesInRange.size()]);
        }
        return new Entity[0];
    }

    private List<Sign> checkBlocksOutside(Block top, Block bottom, Axis a) {
        int zM;
        int xM = a == Axis.X ? 1 : 0;
        int n = zM = a == Axis.Z ? 1 : 0;
        if (top.getRelative(0, 1, 0).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (top.getRelative(xM, 1, zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        this.plugin.log(Level.FINER, "Found top 2");
        if (bottom.getRelative(0, -1, 0).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (bottom.getRelative(-1 * xM, -1, -1 * zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        this.plugin.log(Level.FINER, "Found bottom 2");
        if (top.getRelative(-1 * xM, 0, -1 * zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (top.getRelative(-1 * xM, -1, -1 * zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (top.getRelative(-1 * xM, -2, -1 * zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        this.plugin.log(Level.FINER, "Found left 3");
        if (bottom.getRelative(xM, 0, zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (bottom.getRelative(xM, 1, zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (bottom.getRelative(xM, 2, zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        this.plugin.log(Level.FINER, "Found right 3");
        Block topper = top.getRelative(-1 - xM, 1, -1 - zM);
        Block bottomer = bottom.getRelative(1 + xM, -1, 1 + zM);
        return this.checkZoneForSigns(topper, bottomer);
    }

    private List<Sign> checkZoneForSigns(Block topper, Block bottomer) {
        Location looking = new Location(topper.getWorld(), 0.0, 0.0, 0.0);
        ArrayList<Sign> signs = new ArrayList<Sign>();
        for (int x = topper.getX(); x <= bottomer.getX(); ++x) {
            looking.setX((double)x);
            for (int y = bottomer.getY(); y <= topper.getY(); ++y) {
                looking.setY((double)y);
                for (int z = topper.getZ(); z <= bottomer.getZ(); ++z) {
                    looking.setZ((double)z);
                    this.plugin.log(Level.FINEST, "Looking for sign at " + this.plugin.getCore().getLocationManipulation().strCoordsRaw(looking));
                    BlockState signBlock = topper.getWorld().getBlockAt(looking).getState();
                    if (!(signBlock instanceof Sign)) continue;
                    this.plugin.log(Level.FINER, "WOO Found one! " + this.plugin.getCore().getLocationManipulation().strCoordsRaw(looking));
                    signs.add((Sign)signBlock);
                }
            }
        }
        return signs;
    }

    public boolean playerCanGoToDestination(Player player, MVDestination d) {
        if (d instanceof InvalidDestination || !d.isValid()) {
            this.plugin.getCore().getMessaging().sendMessage((CommandSender)player, "The Destination on this sign is Invalid!", false);
            return false;
        }
        return this.plugin.getCore().getMVPerms().hasPermission((CommandSender)player, d.getRequiredPermission(), true);
    }
}

