/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseSignPortals.listeners;

import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.event.MVDebugModeEvent;
import com.onarandombox.MultiverseCore.event.MVPlayerTouchedPortalEvent;
import com.onarandombox.MultiverseCore.event.MVVersionEvent;
import com.onarandombox.MultiverseSignPortals.MultiverseSignPortals;
import com.onarandombox.MultiverseSignPortals.exceptions.MoreThanOneSignFoundException;
import com.onarandombox.MultiverseSignPortals.exceptions.NoMultiverseSignFoundException;
import com.onarandombox.MultiverseSignPortals.utils.MVSPLogging;
import com.onarandombox.MultiverseSignPortals.utils.PortalDetector;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class MVSPVersionListener
implements Listener {
    private MultiverseSignPortals plugin;

    public MVSPVersionListener(MultiverseSignPortals plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void versionEvent(MVVersionEvent event) {
        event.appendVersionInfo(this.plugin.getVersionInfo());
    }

    @EventHandler
    public void portalTouchEvent(MVPlayerTouchedPortalEvent event) {
        this.plugin.log(Level.FINER, "Found The TouchedPortal event.");
        Player p = event.getPlayer();
        Location l = event.getBlockTouched();
        PortalDetector detector = new PortalDetector(this.plugin);
        try {
            String destString = detector.getNotchPortalDestination(p, l);
            if (destString != null) {
                MVDestination d = this.plugin.getCore().getDestFactory().getDestination(destString);
                this.plugin.log(Level.FINE, destString + " ::: " + d);
                if (detector.playerCanGoToDestination(p, d)) {
                    this.plugin.log(Level.FINE, "Player could go to destination!");
                    event.setCancelled(true);
                } else {
                    this.plugin.log(Level.FINE, "Player could NOT go to destination!");
                }
            }
        }
        catch (NoMultiverseSignFoundException e) {
            this.plugin.log(Level.FINER, "Did NOT find a Multiverse Sign");
        }
        catch (MoreThanOneSignFoundException e) {
            this.plugin.getCore().getMessaging().sendMessage((CommandSender)p, String.format("%sSorry %sbut more than 1 sign was found where the second line was [mv] or [multiverse]. Please remove one of the signs.", ChatColor.RED, ChatColor.WHITE), false);
        }
    }

    @EventHandler
    public void debugModeChange(MVDebugModeEvent event) {
        MVSPLogging.setDebugLevel(event.getLevel());
    }
}

