/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseSignPortals.listeners;

import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.destination.DestinationFactory;
import com.onarandombox.MultiverseCore.enums.TeleportResult;
import com.onarandombox.MultiverseCore.utils.MVPermissions;
import com.onarandombox.MultiverseSignPortals.MultiverseSignPortals;
import com.onarandombox.MultiverseSignPortals.exceptions.MoreThanOneSignFoundException;
import com.onarandombox.MultiverseSignPortals.exceptions.NoMultiverseSignFoundException;
import com.onarandombox.MultiverseSignPortals.listeners.MVSPTravelAgent;
import com.onarandombox.MultiverseSignPortals.utils.PortalDetector;
import com.onarandombox.MultiverseSignPortals.utils.SignStatus;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.permissions.PermissionDefault;

public class MVSPPlayerListener
implements Listener {
    private MultiverseSignPortals plugin;
    private MVPermissions permissions;
    private PortalDetector pd;

    public MVSPPlayerListener(MultiverseSignPortals plugin) {
        this.plugin = plugin;
        this.permissions = this.plugin.getCore().getMVPerms();
        this.permissions.addPermission("multiverse.signportal.validate", PermissionDefault.OP);
        this.pd = new PortalDetector(this.plugin);
    }

    @EventHandler
    public void playerPortal(PlayerPortalEvent event) {
        if (event.isCancelled()) {
            return;
        }
        PortalDetector detector = new PortalDetector(this.plugin);
        try {
            String destString = detector.getNotchPortalDestination(event.getPlayer(), event.getFrom());
            if (destString != null) {
                this.plugin.log(Level.FINER, "Found a Multiverse Sign");
                DestinationFactory df = this.plugin.getCore().getDestFactory();
                destString = ChatColor.stripColor((String)destString);
                MVDestination dest = df.getDestination(destString);
                MVSPTravelAgent travelAgent = new MVSPTravelAgent(this.plugin.getCore(), dest, event.getPlayer());
                travelAgent.setPortalEventTravelAgent(event);
                event.setTo(dest.getLocation((Entity)event.getPlayer()));
            }
        }
        catch (NoMultiverseSignFoundException e) {
            this.plugin.log(Level.FINER, "Did NOT find a Multiverse Sign");
        }
        catch (MoreThanOneSignFoundException e) {
            this.plugin.getCore().getMessaging().sendMessage((CommandSender)event.getPlayer(), String.format("%sSorry %sbut more than 1 sign was found where the second line was [mv] or [multiverse]. Please remove one of the signs.", ChatColor.RED, ChatColor.WHITE), false);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock().getState() instanceof Sign) {
            this.plugin.log(Level.FINER, "Found a Sign!");
            Sign s = (Sign)event.getClickedBlock().getState();
            SignStatus status = this.pd.getSignStatus(s);
            if (status == SignStatus.SignPortal) {
                String destString = this.pd.processSign(s);
                this.takePlayerToDestination(event.getPlayer(), destString);
                event.setCancelled(true);
            } else if (status == SignStatus.Disabled) {
                this.pd.activateSignPortal(event.getPlayer(), ChatColor.RED + "Disabled", s);
                event.setCancelled(true);
            } else if (status == SignStatus.Legacy) {
                this.pd.activateSignPortal(event.getPlayer(), ChatColor.AQUA + "Legacy", s);
                event.setCancelled(true);
            } else if (status == SignStatus.NetherPortalSign) {
                event.setCancelled(true);
            }
        }
    }

    private void takePlayerToDestination(Player player, String destString) {
        if (destString != null) {
            this.plugin.log(Level.FINER, "Found a SignPortal! (" + destString + ")");
            SafeTTeleporter teleporter = this.plugin.getCore().getSafeTTeleporter();
            DestinationFactory df = this.plugin.getCore().getDestFactory();
            MVDestination d = df.getDestination(destString);
            this.plugin.log(Level.FINER, "Found a Destination! (" + d + ")");
            if (this.pd.playerCanGoToDestination(player, d)) {
                TeleportResult result = teleporter.safelyTeleport((CommandSender)player, (Entity)player, d);
                if (result == TeleportResult.FAIL_UNSAFE) {
                    player.sendMessage("The Destination was not safe! (" + ChatColor.RED + d + ChatColor.WHITE + ")");
                }
            } else {
                this.plugin.log(Level.FINER, "Denied permission to go to destination!");
            }
        } else {
            player.sendMessage("The Destination was not set on the sign!");
        }
    }
}

