/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseSignPortals.listeners;

import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.enums.TeleportResult;
import com.onarandombox.MultiverseCore.utils.MVPermissions;
import com.onarandombox.MultiverseSignPortals.MultiverseSignPortals;
import com.onarandombox.MultiverseSignPortals.utils.PortalDetector;
import com.onarandombox.MultiverseSignPortals.utils.SignStatus;
import com.onarandombox.MultiverseSignPortals.utils.SignTools;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.material.RedstoneTorch;
import org.bukkit.permissions.PermissionDefault;

public class MVSPBlockListener
implements Listener {
    private final String CREATE_PERM = "multiverse.signportal.create";
    private MultiverseSignPortals plugin;
    private MVPermissions permissions;

    public MVSPBlockListener(MultiverseSignPortals plugin) {
        this.plugin = plugin;
        this.permissions = this.plugin.getCore().getMVPerms();
        this.permissions.addPermission("multiverse.signportal.create", PermissionDefault.OP);
    }

    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.plugin.log(Level.FINER, "Sign changed");
        if (event.getLine(1).equalsIgnoreCase("[mv]") || event.getLine(1).equalsIgnoreCase("[multiverse]")) {
            this.createMultiverseSignPortal(event);
        } else {
            this.checkForHack(event);
        }
    }

    @EventHandler
    public void redstonePower(BlockRedstoneEvent event) {
        Block block;
        if (event.getNewCurrent() <= 0) {
            return;
        }
        boolean torch = false;
        if (event.getBlock().getState().getData() instanceof RedstoneTorch) {
            torch = true;
        }
        if ((block = this.getNearbySign(event.getBlock(), torch)) == null) {
            return;
        }
        Sign sign = (Sign)block.getState();
        SignStatus status = this.plugin.getPortalDetector().getSignStatus(sign);
        if (status == SignStatus.SignPortal) {
            String destString = this.plugin.getPortalDetector().processSign(sign);
            for (Entity entity : this.plugin.getPortalDetector().getRedstoneTeleportEntities(sign)) {
                this.takeEntityToDestination(entity, destString);
            }
        }
    }

    private void takeEntityToDestination(Entity entity, String destString) {
        if (destString != null) {
            SafeTTeleporter teleporter = this.plugin.getCore().getSafeTTeleporter();
            MVDestination d = this.plugin.getCore().getDestFactory().getDestination(destString);
            this.plugin.log(Level.FINER, "Found a Destination! (" + d + ")");
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (this.plugin.getPortalDetector().playerCanGoToDestination(player, d)) {
                    TeleportResult result = teleporter.safelyTeleport((CommandSender)Bukkit.getConsoleSender(), (Entity)player, d);
                    if (result == TeleportResult.FAIL_UNSAFE) {
                        this.plugin.log(Level.FINER, "The Destination was not safe! (" + ChatColor.RED + d + ChatColor.WHITE + ")");
                    } else {
                        this.plugin.log(Level.FINER, "Teleported " + entity + " to: " + ChatColor.GREEN + d);
                    }
                } else {
                    this.plugin.log(Level.FINER, "Denied permission to go to destination!");
                }
            } else {
                TeleportResult result = teleporter.safelyTeleport((CommandSender)Bukkit.getConsoleSender(), entity, d.getLocation(entity), true);
                if (result == TeleportResult.FAIL_UNSAFE) {
                    this.plugin.log(Level.FINER, "The Destination was not safe! (" + ChatColor.RED + d + ChatColor.WHITE + ")");
                } else {
                    this.plugin.log(Level.FINER, "Teleported " + entity + " to: " + ChatColor.GREEN + d);
                }
            }
        } else {
            this.plugin.log(Level.FINER, "The destination was not set on the sign!");
        }
    }

    private Block getNearbySign(Block block, boolean torch) {
        Block nearBlock = block.getRelative(BlockFace.EAST);
        if (nearBlock.getState() instanceof Sign) {
            return nearBlock;
        }
        nearBlock = block.getRelative(BlockFace.NORTH);
        if (nearBlock.getState() instanceof Sign) {
            return nearBlock;
        }
        nearBlock = block.getRelative(BlockFace.SOUTH);
        if (nearBlock.getState() instanceof Sign) {
            return nearBlock;
        }
        nearBlock = block.getRelative(BlockFace.WEST);
        if (nearBlock.getState() instanceof Sign) {
            return nearBlock;
        }
        nearBlock = block.getRelative(BlockFace.UP);
        if (nearBlock.getState() instanceof Sign) {
            return nearBlock;
        }
        if (torch && (nearBlock = nearBlock.getRelative(BlockFace.UP)).getState() instanceof Sign) {
            return nearBlock;
        }
        return null;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        BlockState state = event.getBlock().getState();
        if (state instanceof Sign) {
            Sign s = (Sign)state;
            PortalDetector pd = this.plugin.getPortalDetector();
            if (!(pd.getSignStatus(s) != SignStatus.NetherPortalSign && pd.getSignStatus(s) != SignStatus.SignPortal || this.permissions.hasPermission((CommandSender)event.getPlayer(), "multiverse.signportal.create", true))) {
                event.setCancelled(true);
                event.getPlayer().sendMessage("You don't have permission to destroy a SignPortal!");
                event.getPlayer().sendMessage(ChatColor.GREEN + "multiverse.signportal.create");
            }
        }
    }

    private void checkForHack(SignChangeEvent event) {
        if (SignTools.isMVSign(event.getLine(1), ChatColor.DARK_GREEN) || SignTools.isMVSign(event.getLine(1), ChatColor.DARK_BLUE)) {
            this.plugin.log(Level.WARNING, "WOAH! Player: [" + event.getPlayer().getName() + "] tried to HACK a Multiverse SignPortal into existance!");
            this.warnOps("WOAH! Player: [" + event.getPlayer().getName() + "] tried to " + ChatColor.RED + "HACK" + ChatColor.WHITE + " a" + ChatColor.AQUA + " Multiverse SignPortal" + ChatColor.WHITE + " into existance!");
            event.setCancelled(true);
        }
    }

    private void createMultiverseSignPortal(SignChangeEvent event) {
        if (this.plugin.getCore().getMVPerms().hasPermission((CommandSender)event.getPlayer(), "multiverse.signportal.create", true)) {
            this.plugin.log(Level.FINER, "MV SignPortal Created");
            event.setLine(1, ChatColor.DARK_GREEN + event.getLine(1));
            this.checkRedstoneTeleportTargets(event);
        } else {
            this.plugin.log(Level.FINER, "No Perms to create");
            event.setLine(1, ChatColor.DARK_RED + event.getLine(1));
            event.getPlayer().sendMessage("You don't have permission to create a SignPortal!");
            event.getPlayer().sendMessage(ChatColor.GREEN + "multiverse.signportal.create");
        }
    }

    private void checkRedstoneTeleportTargets(SignChangeEvent event) {
        if (PortalDetector.REDSTONE_TELEPORT_PATTERN.matcher(event.getLine(0)).matches()) {
            event.setLine(0, ChatColor.DARK_GREEN + event.getLine(0));
        }
    }

    private void warnOps(String string) {
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            if (!p.isOp()) continue;
            p.sendMessage(string);
        }
    }
}

