/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseSignPortals;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVPlugin;
import com.onarandombox.MultiverseSignPortals.listeners.MVSPBlockListener;
import com.onarandombox.MultiverseSignPortals.listeners.MVSPPlayerListener;
import com.onarandombox.MultiverseSignPortals.listeners.MVSPPluginListener;
import com.onarandombox.MultiverseSignPortals.listeners.MVSPVersionListener;
import com.onarandombox.MultiverseSignPortals.utils.MVSPLogging;
import com.onarandombox.MultiverseSignPortals.utils.PortalDetector;
import java.util.logging.Level;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MultiverseSignPortals
extends JavaPlugin
implements MVPlugin {
    protected MultiverseCore core;
    protected MVSPPlayerListener playerListener;
    protected MVSPPluginListener pluginListener;
    protected MVSPBlockListener blockListener;
    private static final int requiresProtocol = 24;
    private PortalDetector portalDetector;

    public void onEnable() {
        MVSPLogging.init((Plugin)this);
        this.core = (MultiverseCore)this.getServer().getPluginManager().getPlugin("Multiverse-Core");
        if (this.core == null) {
            MVSPLogging.info("Multiverse-Core not found, will keep looking.", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.core.getProtocolVersion() < 24) {
            MVSPLogging.severe("Your Multiverse-Core is OUT OF DATE", new Object[0]);
            MVSPLogging.severe("This version of SignPortals requires Protocol Level: 24", new Object[0]);
            MVSPLogging.severe("Your of Core Protocol Level is: " + this.core.getProtocolVersion(), new Object[0]);
            MVSPLogging.severe("Grab an updated copy at: ", new Object[0]);
            MVSPLogging.severe("http://dev.bukkit.org/bukkit-plugins/multiverse-core/", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        MVSPLogging.setDebugLevel(this.core.getMVConfig().getGlobalDebug());
        this.core.incrementPluginCount();
        this.pluginListener = new MVSPPluginListener(this);
        this.playerListener = new MVSPPlayerListener(this);
        this.blockListener = new MVSPBlockListener(this);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.pluginListener, (Plugin)this);
        pm.registerEvents((Listener)this.playerListener, (Plugin)this);
        pm.registerEvents((Listener)this.blockListener, (Plugin)this);
        pm.registerEvents((Listener)new MVSPVersionListener(this), (Plugin)this);
        this.portalDetector = new PortalDetector(this);
        MVSPLogging.log(true, Level.INFO, " Enabled - By %s", this.getAuthors());
    }

    public void onDisable() {
        MVSPLogging.info("- Disabled", new Object[0]);
    }

    public void onLoad() {
        MVSPLogging.init((Plugin)this);
        this.getDataFolder().mkdirs();
    }

    private String getAuthors() {
        String authors = "";
        for (int i = 0; i < this.getDescription().getAuthors().size(); ++i) {
            authors = i == this.getDescription().getAuthors().size() - 1 ? authors + " and " + (String)this.getDescription().getAuthors().get(i) : authors + ", " + (String)this.getDescription().getAuthors().get(i);
        }
        return authors.substring(2);
    }

    public void log(Level level, String msg) {
        MVSPLogging.log(level, msg, new Object[0]);
    }

    @Deprecated
    public String dumpVersionInfo(String buffer) {
        buffer = buffer + this.logAndAddToPasteBinBuffer(this.getVersionInfo());
        return buffer;
    }

    public String getVersionInfo() {
        return "[Multiverse-SignPortals] Multiverse-SignPortals Version: " + this.getDescription().getVersion() + '\n';
    }

    @Deprecated
    private String logAndAddToPasteBinBuffer(String string) {
        this.log(Level.INFO, string);
        return MVSPLogging.getPrefixedMessage(string, false);
    }

    public MultiverseCore getCore() {
        return this.core;
    }

    public void setCore(MultiverseCore core) {
        this.core = core;
    }

    public int getProtocolVersion() {
        return 1;
    }

    public PortalDetector getPortalDetector() {
        return this.portalDetector;
    }
}

