/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseNetherPortals.utils;

import com.onarandombox.MultiverseNetherPortals.MultiverseNetherPortals;
import java.util.logging.Level;
import org.bukkit.PortalType;

public class MVNameChecker {
    private MultiverseNetherPortals plugin;

    public MVNameChecker(MultiverseNetherPortals plugin) {
        this.plugin = plugin;
    }

    public boolean isValidNetherName(String world) {
        try {
            if (world.matches("^" + this.plugin.getNetherPrefix() + ".+" + this.plugin.getNetherSuffix() + "$")) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public boolean isValidEndName(String world) {
        try {
            if (world.matches("^" + this.plugin.getEndPrefix() + ".+" + this.plugin.getEndSuffix() + "$")) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public String getNetherName(String normalName) {
        String netherName = this.plugin.getNetherPrefix() + normalName + this.plugin.getNetherSuffix();
        if (this.plugin.getCore().getMVWorldManager().isMVWorld(netherName)) {
            this.plugin.log(Level.FINEST, "Selected nether world '" + netherName + "' for normal '" + normalName + "'");
        }
        return netherName;
    }

    public String getEndName(String normalName) {
        String endName = this.plugin.getEndPrefix() + normalName + this.plugin.getEndSuffix();
        if (this.plugin.getCore().getMVWorldManager().isMVWorld(endName)) {
            this.plugin.log(Level.FINEST, "Selected end world '" + endName + "' for normal '" + normalName + "'");
        }
        return endName;
    }

    public String getNormalName(String netherName, PortalType type) {
        String normalName = netherName;
        if (type == PortalType.NETHER) {
            String[] split;
            if (this.plugin.getNetherPrefix().length() > 0) {
                split = normalName.split(this.plugin.getNetherPrefix());
                normalName = split[1];
            }
            if (this.plugin.getNetherSuffix().length() > 0) {
                split = normalName.split(this.plugin.getNetherSuffix());
                normalName = split[0];
            }
        } else if (type == PortalType.ENDER) {
            String[] split;
            if (this.plugin.getNetherPrefix().length() > 0) {
                split = normalName.split(this.plugin.getEndPrefix());
                normalName = split[1];
            }
            if (this.plugin.getNetherSuffix().length() > 0) {
                split = normalName.split(this.plugin.getEndSuffix());
                normalName = split[0];
            }
        }
        if (!normalName.equals(netherName) && this.plugin.getCore().getMVWorldManager().isMVWorld(normalName)) {
            this.plugin.log(Level.FINEST, "Selected normal world '" + normalName + "' for " + type + " '" + netherName + "'");
        }
        return normalName;
    }
}

