/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseNetherPortals.utils;

import com.onarandombox.MultiverseNetherPortals.utils.DebugFileLogger;
import java.io.File;
import java.util.IllegalFormatException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;

public class MVNPLogging {
    static final String ORIGINAL_NAME = MVNPLogging.class.getSimpleName();
    static final String ORIGINAL_VERSION = "v.???";
    static final String ORIGINAL_DEBUG = "-Debug";
    static final boolean SHOW_CONFIG = true;
    static final InterceptedLogger LOG = new InterceptedLogger(Logger.getLogger("Minecraft"));
    static String name = ORIGINAL_NAME;
    static String version = "v.???";
    static String debug = "-Debug";
    static DebugFileLogger debugLog = null;
    static Plugin plugin = null;
    static volatile boolean showConfig = true;

    protected MVNPLogging() {
        throw new AssertionError();
    }

    public static synchronized void init(Plugin plugin) {
        if (MVNPLogging.plugin != null) {
            MVNPLogging.shutdown();
        }
        name = plugin.getName();
        version = plugin.getDescription().getVersion();
        DebugFileLogger.init(name, MVNPLogging.getDebugFileName(plugin));
        MVNPLogging.setDebugLevel(0);
        MVNPLogging.plugin = plugin;
    }

    static synchronized String getDebugFileName(Plugin plugin) {
        return plugin.getDataFolder() + File.separator + "debug.log";
    }

    public static synchronized void shutdown() {
        MVNPLogging.closeDebugLog();
        DebugFileLogger.shutdown();
        plugin = null;
        name = ORIGINAL_NAME;
        version = ORIGINAL_VERSION;
        debug = ORIGINAL_DEBUG;
        showConfig = true;
    }

    static synchronized void closeDebugLog() {
        if (debugLog != null) {
            debugLog.close();
            debugLog = null;
        }
    }

    public static synchronized void setDebugLevel(int debugLevel) {
        if (debugLevel > 3 || debugLevel < 0) {
            throw new IllegalArgumentException("debugLevel must be between 0 and 3!");
        }
        if (debugLevel > 0) {
            debugLog = DebugFileLogger.getDebugLogger();
        } else {
            MVNPLogging.closeDebugLog();
        }
        DebugFileLogger.setDebugLevel(debugLevel);
    }

    public static synchronized int getDebugLevel() {
        return DebugFileLogger.getDebugLevel();
    }

    public static void setShowingConfig(boolean showConfig) {
        MVNPLogging.showConfig = showConfig;
    }

    public static boolean isShowingConfig() {
        return showConfig;
    }

    public static synchronized String getPrefixedMessage(String message, boolean showVersion) {
        StringBuilder builder = new StringBuilder("[").append(name);
        if (showVersion) {
            builder.append(" ").append(version);
        }
        builder.append("] ").append(message);
        return builder.toString();
    }

    public static synchronized void setDebugPrefix(String debugPrefix) {
        debug = debugPrefix;
    }

    public static synchronized String getDebugString(String message) {
        return "[" + name + debug + "] " + message;
    }

    public static Logger getLogger() {
        return LOG;
    }

    public static synchronized void log(boolean showVersion, Level level, String message, Object ... args) {
        int debugLevel = MVNPLogging.getDebugLevel();
        if (level == Level.FINE && debugLevel >= 1 || level == Level.FINER && debugLevel >= 2 || level == Level.FINEST && debugLevel >= 3) {
            MVNPLogging.debug(Level.INFO, message, args);
        } else if (level != Level.FINE && level != Level.FINER && level != Level.FINEST && (level != Level.CONFIG || showConfig)) {
            if (level == Level.CONFIG) {
                LOG._log(Level.INFO, MVNPLogging.getPrefixedMessage(MVNPLogging.format(message, args), showVersion));
            } else {
                LOG._log(level, MVNPLogging.getPrefixedMessage(MVNPLogging.format(message, args), showVersion));
            }
        }
    }

    private static String format(String message, Object[] args) {
        try {
            return String.format(message, args);
        }
        catch (IllegalFormatException e) {
            MVNPLogging.getLogger().fine("Illegal format in the following message:");
            return message;
        }
    }

    public static void log(Level level, String message, Object ... args) {
        MVNPLogging.log(false, level, message, args);
    }

    static void debug(Level level, String message, Object ... args) {
        LOG._log(level, MVNPLogging.getDebugString(MVNPLogging.format(message, args)));
    }

    public static void fine(String message, Object ... args) {
        MVNPLogging.log(false, Level.FINE, message, args);
    }

    public static void finer(String message, Object ... args) {
        MVNPLogging.log(false, Level.FINER, message, args);
    }

    public static void finest(String message, Object ... args) {
        MVNPLogging.log(false, Level.FINEST, message, args);
    }

    public static void config(String message, Object ... args) {
        MVNPLogging.log(false, Level.CONFIG, message, args);
    }

    public static void info(String message, Object ... args) {
        MVNPLogging.log(false, Level.INFO, message, args);
    }

    public static void warning(String message, Object ... args) {
        MVNPLogging.log(false, Level.WARNING, message, args);
    }

    public static void severe(String message, Object ... args) {
        MVNPLogging.log(false, Level.SEVERE, message, args);
    }

    static class InterceptedLogger
    extends Logger {
        final Logger logger;

        InterceptedLogger(Logger logger) {
            super(logger.getName(), logger.getResourceBundleName());
            this.logger = logger;
        }

        synchronized void _log(Level level, String message) {
            LogRecord record = new LogRecord(level, message);
            record.setLoggerName(this.getName());
            record.setResourceBundle(this.getResourceBundle());
            this._log(record);
        }

        synchronized void _log(LogRecord record) {
            this.logger.log(record);
            if (debugLog != null) {
                debugLog.log(record);
            }
        }

        @Override
        public synchronized void log(LogRecord record) {
            Level level = record.getLevel();
            String message = record.getMessage();
            int debugLevel = MVNPLogging.getDebugLevel();
            if (level == Level.FINE && debugLevel >= 1 || level == Level.FINER && debugLevel >= 2 || level == Level.FINEST && debugLevel >= 3) {
                record.setLevel(Level.INFO);
                record.setMessage(MVNPLogging.getDebugString(message));
                LOG._log(record);
            } else if (level != Level.FINE && level != Level.FINER && level != Level.FINEST && (level != Level.CONFIG || showConfig)) {
                if (level == Level.CONFIG) {
                    record.setLevel(Level.INFO);
                }
                record.setMessage(MVNPLogging.getPrefixedMessage(message, false));
                LOG._log(record);
            }
        }
    }
}

