/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseNetherPortals.listeners;

import com.onarandombox.MultiverseCore.api.LocationManipulation;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseMessaging;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.event.MVPlayerTouchedPortalEvent;
import com.onarandombox.MultiverseCore.utils.PermissionTools;
import com.onarandombox.MultiverseNetherPortals.MultiverseNetherPortals;
import com.onarandombox.MultiverseNetherPortals.utils.MVEventRecord;
import com.onarandombox.MultiverseNetherPortals.utils.MVLinkChecker;
import com.onarandombox.MultiverseNetherPortals.utils.MVNameChecker;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class MVNPEntityListener
implements Listener {
    private final MultiverseNetherPortals plugin;
    private final MVNameChecker nameChecker;
    private final MVLinkChecker linkChecker;
    private final MVWorldManager worldManager;
    private final PermissionTools pt;
    private final int cooldown = 250;
    private final MultiverseMessaging messaging;
    private final Map<String, Date> playerErrors;
    private final LocationManipulation locationManipulation;
    private final MVEventRecord eventRecord;

    public MVNPEntityListener(MultiverseNetherPortals plugin) {
        this.plugin = plugin;
        this.nameChecker = new MVNameChecker(this.plugin);
        this.linkChecker = new MVLinkChecker(this.plugin);
        this.worldManager = this.plugin.getCore().getMVWorldManager();
        this.pt = new PermissionTools(this.plugin.getCore());
        this.playerErrors = new HashMap<String, Date>();
        this.messaging = this.plugin.getCore().getMessaging();
        this.locationManipulation = this.plugin.getCore().getLocationManipulation();
        this.eventRecord = new MVEventRecord(this.plugin);
    }

    protected boolean shootPlayer(Player p, Block block, PortalType type) {
        if (!this.plugin.isUsingBounceBack()) {
            this.plugin.log(Level.FINEST, "Bounceback is disabled. The player is free to walk into the portal!");
            return false;
        }
        this.playerErrors.put(p.getName(), new Date());
        double newVecX = 0.0;
        double newVecZ = 0.0;
        double strength = 1.0;
        boolean playerBounced = false;
        StringBuilder debugMessage = new StringBuilder().append("Player: ").append(p.getName());
        if (type == PortalType.ENDER) {
            debugMessage.append(" entered an End Portal. There is currently no bounceback implementation for End Portals.");
        } else if (type == PortalType.NETHER) {
            if (block.getRelative(BlockFace.WEST).getType() == Material.NETHER_PORTAL || block.getRelative(BlockFace.EAST).getType() == Material.NETHER_PORTAL) {
                if (p.getLocation().getZ() < block.getLocation().getZ() + 0.5) {
                    debugMessage.append(" entered Nether Portal from the North");
                    newVecZ = -1.0 * strength;
                } else {
                    debugMessage.append(" entered Nether Portal from the South");
                    newVecZ = 1.0 * strength;
                }
            } else if (p.getLocation().getX() < block.getLocation().getX() + 0.5) {
                debugMessage.append(" entered Nether Portal from the West");
                newVecX = -1.0 * strength;
            } else {
                debugMessage.append(" entered Nether Portal from the East");
                newVecX = 1.0 * strength;
            }
            debugMessage.append(". They will be bounced back!");
            p.teleport(p.getLocation().clone().add(newVecX, 0.2, newVecZ));
            p.setVelocity(new Vector(newVecX, 0.6, newVecZ));
            playerBounced = true;
        } else {
            debugMessage.append(" entered an Unsupported Portal Type (").append(type).append(").");
        }
        this.plugin.log(Level.FINER, debugMessage.toString());
        return playerBounced;
    }

    @Nullable
    private Location getLocation(Entity e, Location currentLocation, PortalType type, String currentWorld, String linkedWorld) {
        Location newTo = null;
        if (!currentWorld.equalsIgnoreCase(linkedWorld)) {
            if (linkedWorld != null) {
                newTo = this.linkChecker.findNewTeleportLocation(currentLocation, linkedWorld, e);
            } else {
                String destinationWorld = "";
                if (this.nameChecker.isValidEndName(currentWorld)) {
                    if (type == PortalType.ENDER) {
                        destinationWorld = this.nameChecker.getNormalName(currentWorld, type);
                    } else if (type == PortalType.NETHER) {
                        destinationWorld = this.nameChecker.getNetherName(this.nameChecker.getNormalName(currentWorld, type));
                    }
                } else if (this.nameChecker.isValidNetherName(currentWorld)) {
                    if (type == PortalType.ENDER) {
                        destinationWorld = this.nameChecker.getEndName(this.nameChecker.getNormalName(currentWorld, type));
                    } else if (type == PortalType.NETHER) {
                        destinationWorld = this.nameChecker.getNormalName(currentWorld, type);
                    }
                } else if (type == PortalType.ENDER) {
                    destinationWorld = this.nameChecker.getEndName(currentWorld);
                } else if (type == PortalType.NETHER) {
                    destinationWorld = this.nameChecker.getNetherName(currentWorld);
                }
                newTo = this.linkChecker.findNewTeleportLocation(currentLocation, destinationWorld, e);
            }
        }
        return newTo;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityPortalEnter(EntityPortalEnterEvent event) {
        String linkedWorld;
        String currentWorld;
        Location toLocation;
        PortalType type;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)event.getEntity();
        Location currentLocation = this.locationManipulation.getBlockLocation(event.getLocation());
        if (!this.plugin.isHandledByNetherPortals(currentLocation)) {
            return;
        }
        if (currentLocation.getBlock().getType() == Material.END_PORTAL) {
            type = PortalType.ENDER;
        } else if (currentLocation.getBlock().getType() == Material.NETHER_PORTAL) {
            type = PortalType.NETHER;
        } else {
            return;
        }
        if (this.eventRecord.isInRecord(type, p.getUniqueId())) {
            return;
        }
        this.eventRecord.addToRecord(type, p.getUniqueId());
        MVPlayerTouchedPortalEvent playerTouchedPortalEvent = new MVPlayerTouchedPortalEvent(p, event.getLocation());
        this.plugin.getServer().getPluginManager().callEvent((Event)playerTouchedPortalEvent);
        Location eventLocation = event.getLocation().clone();
        if (!playerTouchedPortalEvent.canUseThisPortal()) {
            if (this.shootPlayer(p, eventLocation.getBlock(), type)) {
                this.eventRecord.removeFromRecord(type, p.getUniqueId());
            }
            this.plugin.log(Level.FINEST, "Someone requested that this player be bounced back!");
        }
        if (playerTouchedPortalEvent.isCancelled()) {
            this.plugin.log(Level.FINEST, "Someone cancelled the enter Event for NetherPortals!");
            return;
        }
        if (this.playerErrors.containsKey(p.getName())) {
            Date lastTry = this.playerErrors.get(p.getName());
            long l = lastTry.getTime();
            this.getClass();
            if (l + 250L > new Date().getTime()) {
                return;
            }
            this.playerErrors.remove(p.getName());
        }
        if ((toLocation = this.getLocation((Entity)p, currentLocation, type, currentWorld = currentLocation.getWorld().getName(), linkedWorld = this.plugin.getWorldLink(currentWorld, type))) == null) {
            if (this.shootPlayer(p, eventLocation.getBlock(), type)) {
                this.eventRecord.removeFromRecord(type, p.getUniqueId());
            }
            if (currentWorld.equalsIgnoreCase(linkedWorld)) {
                if (this.plugin.isSendingDisabledPortalMessage()) {
                    if (type == PortalType.ENDER) {
                        this.messaging.sendMessage((CommandSender)p, "End Portals have been disabled in this world!", false);
                    } else {
                        this.messaging.sendMessage((CommandSender)p, "Nether Portals have been disabled in this world!", false);
                    }
                }
            } else if (this.plugin.isSendingNoDestinationMessage()) {
                this.messaging.sendMessage((CommandSender)p, "This portal goes nowhere!", false);
                if (type == PortalType.ENDER) {
                    this.messaging.sendMessage((CommandSender)p, "No specific end world has been linked to this world and '" + this.nameChecker.getEndName(currentWorld) + "' is not a world.", true);
                } else {
                    this.messaging.sendMessage((CommandSender)p, "No specific nether world has been linked to this world and '" + this.nameChecker.getNetherName(currentWorld) + "' is not a world.", true);
                }
            }
            return;
        }
        MultiverseWorld fromWorld = this.worldManager.getMVWorld(p.getLocation().getWorld().getName());
        MultiverseWorld toWorld = this.worldManager.getMVWorld(toLocation.getWorld().getName());
        if (fromWorld.getCBWorld().equals(toWorld.getCBWorld())) {
            this.plugin.log(Level.FINER, "Player '" + p.getName() + "' is portaling to the same world.");
            return;
        }
        if (!this.pt.playerHasMoneyToEnter(fromWorld, toWorld, (CommandSender)p, p, false)) {
            if (this.shootPlayer(p, eventLocation.getBlock(), type)) {
                this.eventRecord.removeFromRecord(type, p.getUniqueId());
            }
            this.plugin.log(Level.FINE, "Player '" + p.getName() + "' was DENIED ACCESS to '" + toWorld.getCBWorld().getName() + "' because they don't have the FUNDS required to enter.");
            return;
        }
        if (this.plugin.getCore().getMVConfig().getEnforceAccess()) {
            if (!this.pt.playerCanGoFromTo(fromWorld, toWorld, (CommandSender)p, p)) {
                if (this.shootPlayer(p, eventLocation.getBlock(), type)) {
                    this.eventRecord.removeFromRecord(type, p.getUniqueId());
                }
                this.plugin.log(Level.FINE, "Player '" + p.getName() + "' was DENIED ACCESS to '" + toWorld.getCBWorld().getName() + "' because they don't have: multiverse.access." + toWorld.getCBWorld().getName());
            }
        } else {
            this.plugin.log(Level.FINE, "Player '" + p.getName() + "' was allowed to go to '" + toWorld.getCBWorld().getName() + "' because enforceaccess is off.");
        }
    }

    @EventHandler
    public void onEntityPortal(EntityPortalEvent event) {
        String linkedWorld;
        String currentWorld;
        Location newTo;
        PortalType type;
        if (event.isCancelled()) {
            this.plugin.log(Level.FINEST, "EntityPortalEvent was cancelled! NOT teleporting!");
            return;
        }
        Entity e = event.getEntity();
        Location originalTo = this.locationManipulation.getBlockLocation(event.getTo());
        Location currentLocation = this.locationManipulation.getBlockLocation(event.getFrom());
        if (!this.plugin.isHandledByNetherPortals(currentLocation)) {
            return;
        }
        if (!this.plugin.isTeleportingEntities()) {
            event.setCancelled(true);
            return;
        }
        if (this.nameChecker.isValidNetherName(originalTo.getWorld().getName()) || currentLocation.getWorld().getEnvironment() == World.Environment.NETHER && originalTo.getWorld().getEnvironment() == World.Environment.NORMAL) {
            type = PortalType.NETHER;
        } else if (this.nameChecker.isValidEndName(originalTo.getWorld().getName()) || currentLocation.getWorld().getEnvironment() == World.Environment.THE_END && originalTo.getWorld().getEnvironment() == World.Environment.NORMAL) {
            type = PortalType.ENDER;
        } else {
            return;
        }
        if (type == PortalType.NETHER) {
            try {
                Class.forName("org.bukkit.TravelAgent");
                event.useTravelAgent(true);
            }
            catch (ClassNotFoundException ignore) {
                this.plugin.log(Level.FINE, "TravelAgent not available for EntityPortalEvent for " + e.getName());
            }
        }
        if ((newTo = this.getLocation(e, currentLocation, type, currentWorld = currentLocation.getWorld().getName(), linkedWorld = this.plugin.getWorldLink(currentWorld, type))) == null) {
            event.setCancelled(true);
            return;
        }
        event.setTo(newTo);
        MultiverseWorld fromWorld = this.worldManager.getMVWorld(event.getFrom().getWorld().getName());
        MultiverseWorld toWorld = this.worldManager.getMVWorld(event.getTo().getWorld().getName());
        if (!event.isCancelled()) {
            if (fromWorld.getEnvironment() == World.Environment.THE_END && type == PortalType.ENDER) {
                this.plugin.log(Level.FINE, "Entity '" + e.getName() + "' will be teleported to the spawn of '" + toWorld.getName() + "' since they used an end exit portal.");
                try {
                    Class.forName("org.bukkit.TravelAgent");
                    event.getPortalTravelAgent().setCanCreatePortal(false);
                }
                catch (ClassNotFoundException ignore) {
                    this.plugin.log(Level.FINE, "TravelAgent not available for EntityPortalEvent for " + e.getName() + ". There may be a portal created at spawn.");
                }
                event.setTo(toWorld.getSpawnLocation());
            } else if (fromWorld.getEnvironment() == World.Environment.NETHER && type == PortalType.NETHER) {
                try {
                    Class.forName("org.bukkit.TravelAgent");
                    event.getPortalTravelAgent().setCanCreatePortal(true);
                    event.setTo(event.getPortalTravelAgent().findOrCreate(event.getTo()));
                }
                catch (ClassNotFoundException ignore) {
                    this.plugin.log(Level.FINE, "TravelAgent not available for EntityPortalEvent for " + e.getName() + ". Their destination may not be correct.");
                    event.setTo(event.getTo());
                }
            } else if (toWorld.getEnvironment() == World.Environment.THE_END && type == PortalType.ENDER) {
                Location loc = new Location(event.getTo().getWorld(), 100.0, 50.0, 0.0);
                event.setTo(loc);
                Block block = loc.getBlock();
                for (int x = block.getX() - 2; x <= block.getX() + 2; ++x) {
                    for (int z = block.getZ() - 2; z <= block.getZ() + 2; ++z) {
                        Block platformBlock = loc.getWorld().getBlockAt(x, block.getY() - 1, z);
                        if (platformBlock.getType() != Material.OBSIDIAN) {
                            platformBlock.setType(Material.OBSIDIAN);
                        }
                        for (int yMod = 1; yMod <= 3; ++yMod) {
                            Block b = platformBlock.getRelative(BlockFace.UP, yMod);
                            if (b.getType() == Material.AIR) continue;
                            b.setType(Material.AIR);
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onEntityPortalExit(EntityPortalExitEvent event) {
        if (event.getEntity() instanceof Player) {
            Player p = (Player)event.getEntity();
            this.eventRecord.removeFromRecord(PortalType.ENDER, p.getUniqueId());
            this.eventRecord.removeFromRecord(PortalType.NETHER, p.getUniqueId());
        }
    }
}

