/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseNetherPortals.commands;

import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseNetherPortals.MultiverseNetherPortals;
import com.onarandombox.MultiverseNetherPortals.commands.NetherPortalCommand;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.PortalType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class LinkCommand
extends NetherPortalCommand {
    private MVWorldManager worldManager;

    public LinkCommand(MultiverseNetherPortals plugin) {
        super(plugin);
        this.setName("Sets NP Destination");
        this.setCommandUsage("/mvnp link " + ChatColor.GREEN + "{end|nether} " + ChatColor.GOLD + "[FROM_WORLD] " + ChatColor.GREEN + " {TO_WORLD}");
        this.setArgRange(2, 3);
        this.addKey("mvnp link");
        this.addKey("mvnpl");
        this.addKey("mvnplink");
        this.addCommandExample("/mvnp link end world world_nether");
        this.addCommandExample("/mvnp link end world_nether");
        this.setPermission("multiverse.netherportals.link", "Sets which world to link to when a player enters a NetherPortal in this world.", PermissionDefault.OP);
        this.worldManager = this.plugin.getCore().getMVWorldManager();
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        String toWorldString;
        String fromWorldString;
        if (!(sender instanceof Player) && args.size() == 2) {
            sender.sendMessage("From the command line, FROM_WORLD is required");
            sender.sendMessage("No changes were made...");
            return;
        }
        Object type = args.get(0).equalsIgnoreCase("END") ? PortalType.ENDER : (args.get(0).equalsIgnoreCase("NETHER") ? PortalType.NETHER : null);
        if (args.size() == 2) {
            Player p = (Player)sender;
            fromWorldString = p.getWorld().getName();
            toWorldString = args.get(1);
        } else {
            fromWorldString = args.get(1);
            toWorldString = args.get(2);
        }
        if (type == null) {
            sender.sendMessage("The type must either be 'end' or 'nether'");
            return;
        }
        MultiverseWorld fromWorld = this.worldManager.getMVWorld(fromWorldString);
        MultiverseWorld toWorld = this.worldManager.getMVWorld(toWorldString);
        if (fromWorld == null) {
            this.plugin.getCore().showNotMVWorldMessage(sender, fromWorldString);
            return;
        }
        if (toWorld == null) {
            this.plugin.getCore().showNotMVWorldMessage(sender, toWorldString);
            return;
        }
        this.plugin.addWorldLink(fromWorld.getName(), toWorld.getName(), (PortalType)type);
        String coloredFrom = fromWorld.getColoredWorldString();
        String coloredTo = toWorld.getColoredWorldString();
        if (fromWorld.getName().equals(toWorld.getName())) {
            sender.sendMessage(ChatColor.RED + "NOTE: " + ChatColor.WHITE + "You have successfully disabled " + type.toString() + " Portals in " + coloredTo);
        } else {
            sender.sendMessage("The " + type + " portals in " + coloredFrom + ChatColor.WHITE + " are now linked to " + coloredTo);
        }
    }
}

