/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseNetherPortals;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVPlugin;
import com.onarandombox.MultiverseCore.commands.HelpCommand;
import com.onarandombox.MultiverseNetherPortals.commands.LinkCommand;
import com.onarandombox.MultiverseNetherPortals.commands.ShowLinkCommand;
import com.onarandombox.MultiverseNetherPortals.commands.UnlinkCommand;
import com.onarandombox.MultiverseNetherPortals.listeners.MVNPCoreListener;
import com.onarandombox.MultiverseNetherPortals.listeners.MVNPEntityListener;
import com.onarandombox.MultiverseNetherPortals.listeners.MVNPPlayerListener;
import com.onarandombox.MultiverseNetherPortals.listeners.MVNPPluginListener;
import com.onarandombox.MultiverseNetherPortals.utils.MVNPLogging;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.commandhandler.CommandHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MultiverseNetherPortals
extends JavaPlugin
implements MVPlugin {
    private static final String NETEHR_PORTALS_CONFIG = "config.yml";
    protected MultiverseCore core;
    protected Plugin multiversePortals;
    protected MVNPPluginListener pluginListener;
    protected MVNPPlayerListener playerListener;
    protected MVNPCoreListener customListener;
    protected FileConfiguration MVNPconfiguration;
    private static final String DEFAULT_NETHER_SUFFIX = "_nether";
    private static final String DEFAULT_END_SUFFIX = "_the_end";
    private String netherPrefix = "";
    private String netherSuffix = "_nether";
    private String endPrefix = "";
    private String endSuffix = "_the_end";
    private Map<String, String> linkMap;
    private Map<String, String> endLinkMap;
    protected CommandHandler commandHandler;
    private static final int requiresProtocol = 24;
    private MVNPEntityListener entityListener;

    public void onEnable() {
        MVNPLogging.init((Plugin)this);
        this.core = (MultiverseCore)this.getServer().getPluginManager().getPlugin("Multiverse-Core");
        this.multiversePortals = this.getServer().getPluginManager().getPlugin("Multiverse-Portals");
        if (this.core == null) {
            MVNPLogging.info("Multiverse-Core not found, will keep looking.", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.core.getProtocolVersion() < 24) {
            MVNPLogging.severe("Your Multiverse-Core is OUT OF DATE", new Object[0]);
            MVNPLogging.severe("This version of NetherPortals requires Protocol Level: 24", new Object[0]);
            MVNPLogging.severe("Your of Core Protocol Level is: " + this.core.getProtocolVersion(), new Object[0]);
            MVNPLogging.severe("Grab an updated copy at: ", new Object[0]);
            MVNPLogging.severe("http://dev.bukkit.org/bukkit-plugins/multiverse-core/", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        MVNPLogging.setDebugLevel(this.core.getMVConfig().getGlobalDebug());
        this.core.incrementPluginCount();
        this.pluginListener = new MVNPPluginListener(this);
        this.playerListener = new MVNPPlayerListener(this);
        this.entityListener = new MVNPEntityListener(this);
        this.customListener = new MVNPCoreListener(this);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.pluginListener, (Plugin)this);
        pm.registerEvents((Listener)this.playerListener, (Plugin)this);
        pm.registerEvents((Listener)this.entityListener, (Plugin)this);
        pm.registerEvents((Listener)this.customListener, (Plugin)this);
        this.loadConfig();
        this.registerCommands();
        MVNPLogging.log(true, Level.INFO, " Enabled - By %s", this.getAuthors());
    }

    public void loadConfig() {
        Set worldKeys;
        this.MVNPconfiguration = new YamlConfiguration();
        try {
            this.MVNPconfiguration.load(new File(this.getDataFolder(), NETEHR_PORTALS_CONFIG));
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "Could not load config.yml");
        }
        catch (InvalidConfigurationException e) {
            this.log(Level.SEVERE, "config.yml contained INVALID YAML. Please look at the file.");
        }
        this.linkMap = new HashMap<String, String>();
        this.endLinkMap = new HashMap<String, String>();
        this.setUsingBounceBack(this.isUsingBounceBack());
        this.setTeleportingEntities(this.isTeleportingEntities());
        this.setSendingNoDestinationMessage(this.isSendingNoDestinationMessage());
        this.setSendingDisabledPortalMessage(this.isSendingDisabledPortalMessage());
        this.setNetherPrefix(this.MVNPconfiguration.getString("netherportals.name.prefix", this.getNetherPrefix()));
        this.setNetherSuffix(this.MVNPconfiguration.getString("netherportals.name.suffix", this.getNetherSuffix()));
        if (this.getNetherPrefix().length() == 0 && this.getNetherSuffix().length() == 0) {
            MVNPLogging.warning("I didn't find a prefix OR a suffix defined! I made the suffix \"_nether\" for you.", new Object[0]);
            this.setNetherSuffix(this.MVNPconfiguration.getString("netherportals.name.suffix", this.getNetherSuffix()));
        }
        if (this.MVNPconfiguration.getConfigurationSection("worlds") == null) {
            this.MVNPconfiguration.createSection("worlds");
        }
        if ((worldKeys = this.MVNPconfiguration.getConfigurationSection("worlds").getKeys(false)) != null) {
            for (String worldString : worldKeys) {
                String nether = this.MVNPconfiguration.getString("worlds." + worldString + ".portalgoesto.NETHER", null);
                String ender = this.MVNPconfiguration.getString("worlds." + worldString + ".portalgoesto.END", null);
                if (nether != null) {
                    this.linkMap.put(worldString, nether);
                }
                if (ender == null) continue;
                this.endLinkMap.put(worldString, ender);
            }
        }
        this.saveMVNPConfig();
    }

    private void registerCommands() {
        this.commandHandler = this.core.getCommandHandler();
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new LinkCommand(this));
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new UnlinkCommand(this));
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new ShowLinkCommand(this));
        for (com.onarandombox.commandhandler.Command c : this.commandHandler.getAllCommands()) {
            if (!(c instanceof HelpCommand)) continue;
            c.addKey("mvnp");
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (!this.isEnabled()) {
            sender.sendMessage("This plugin is Disabled!");
            return true;
        }
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList(args));
        allArgs.add(0, command.getName());
        return this.commandHandler.locateAndRunCommand(sender, allArgs);
    }

    public void onDisable() {
        MVNPLogging.info("- Disabled", new Object[0]);
    }

    public void onLoad() {
        this.getDataFolder().mkdirs();
    }

    private String getAuthors() {
        String authors = "";
        for (int i = 0; i < this.getDescription().getAuthors().size(); ++i) {
            authors = i == this.getDescription().getAuthors().size() - 1 ? authors + " and " + (String)this.getDescription().getAuthors().get(i) : authors + ", " + (String)this.getDescription().getAuthors().get(i);
        }
        return authors.substring(2);
    }

    public void setNetherPrefix(String netherPrefix) {
        this.netherPrefix = netherPrefix;
    }

    public String getNetherPrefix() {
        return this.netherPrefix;
    }

    public void setNetherSuffix(String netherSuffix) {
        this.netherSuffix = netherSuffix;
    }

    public String getNetherSuffix() {
        return this.netherSuffix;
    }

    public String getEndPrefix() {
        return this.endPrefix;
    }

    public String getEndSuffix() {
        return this.endSuffix;
    }

    public String getWorldLink(String fromWorld, PortalType type) {
        if (type == PortalType.NETHER) {
            return this.linkMap.get(fromWorld);
        }
        if (type == PortalType.ENDER) {
            return this.endLinkMap.get(fromWorld);
        }
        return null;
    }

    public Map<String, String> getWorldLinks() {
        return this.linkMap;
    }

    public Map<String, String> getEndWorldLinks() {
        return this.endLinkMap;
    }

    public boolean addWorldLink(String from, String to, PortalType type) {
        if (type == PortalType.NETHER) {
            this.linkMap.put(from, to);
        } else if (type == PortalType.ENDER) {
            this.endLinkMap.put(from, to);
        } else {
            return false;
        }
        this.MVNPconfiguration.set("worlds." + from + ".portalgoesto." + type, (Object)to);
        this.saveMVNPConfig();
        return true;
    }

    public void removeWorldLink(String from, String to, PortalType type) {
        if (type == PortalType.NETHER) {
            this.linkMap.remove(from);
        } else if (type == PortalType.ENDER) {
            this.endLinkMap.remove(from);
        } else {
            return;
        }
        this.MVNPconfiguration.set("worlds." + from + ".portalgoesto." + type, null);
        this.saveMVNPConfig();
    }

    public boolean saveMVNPConfig() {
        try {
            this.MVNPconfiguration.save(new File(this.getDataFolder(), NETEHR_PORTALS_CONFIG));
            return true;
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "Could not save config.yml");
            return false;
        }
    }

    public boolean isUsingBounceBack() {
        return this.MVNPconfiguration.getBoolean("bounceback", true);
    }

    public void setUsingBounceBack(boolean useBounceBack) {
        this.MVNPconfiguration.set("bounceback", (Object)useBounceBack);
    }

    public boolean isTeleportingEntities() {
        return this.MVNPconfiguration.getBoolean("teleport_entities", true);
    }

    public void setTeleportingEntities(boolean teleportingEntities) {
        this.MVNPconfiguration.set("teleport_entities", (Object)teleportingEntities);
    }

    public boolean isSendingDisabledPortalMessage() {
        return this.MVNPconfiguration.getBoolean("send_disabled_portal_message", true);
    }

    public void setSendingDisabledPortalMessage(boolean sendDisabledPortalMessage) {
        this.MVNPconfiguration.set("send_disabled_portal_message", (Object)sendDisabledPortalMessage);
    }

    public boolean isSendingNoDestinationMessage() {
        return this.MVNPconfiguration.getBoolean("send_no_destination_message", true);
    }

    public void setSendingNoDestinationMessage(boolean sendNoDestinationMessage) {
        this.MVNPconfiguration.set("send_no_destination_message", (Object)sendNoDestinationMessage);
    }

    public boolean isHandledByNetherPortals(Location l) {
        if (this.multiversePortals != null) {
            try {
                MultiversePortals portals = (MultiversePortals)this.multiversePortals;
                if (portals.getPortalManager().isPortal(l)) {
                    return false;
                }
            }
            catch (Throwable t) {
                this.getLogger().log(Level.WARNING, "Error checking if portal is handled by Multiverse-Portals", t);
            }
        }
        return true;
    }

    public void setPortals(Plugin multiversePortals) {
        this.multiversePortals = multiversePortals;
    }

    public Plugin getPortals() {
        return this.multiversePortals;
    }

    public MultiverseCore getCore() {
        return this.core;
    }

    public void log(Level level, String msg) {
        MVNPLogging.log(level, msg, new Object[0]);
    }

    public void setCore(MultiverseCore core) {
        this.core = core;
    }

    public int getProtocolVersion() {
        return 1;
    }

    public String dumpVersionInfo(String buffer) {
        buffer = buffer + this.logAndAddToPasteBinBuffer("Multiverse-NetherPortals Version: " + this.getDescription().getVersion());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Nether Prefix: " + this.getNetherPrefix());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Nether Suffix: " + this.getNetherSuffix());
        buffer = buffer + this.logAndAddToPasteBinBuffer("End Prefix: " + this.getEndPrefix());
        buffer = buffer + this.logAndAddToPasteBinBuffer("End Suffix: " + this.getEndSuffix());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Nether Links: " + this.getWorldLinks());
        buffer = buffer + this.logAndAddToPasteBinBuffer("End Links: " + this.getEndWorldLinks());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Bounceback: " + this.isUsingBounceBack());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Teleport Entities: " + this.isTeleportingEntities());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Send Disabled Portal Message: " + this.isSendingDisabledPortalMessage());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Send No Destination Message: " + this.isSendingNoDestinationMessage());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Special Code: FRN001");
        return buffer;
    }

    private String logAndAddToPasteBinBuffer(String string) {
        this.log(Level.INFO, string);
        return "[Multiverse-NetherPortals] " + string + '\n';
    }

    public String getVersionInfo() {
        return "[Multiverse-NetherPortals] Multiverse-NetherPortals Version: " + this.getDescription().getVersion() + '\n' + "[Multiverse-NetherPortals] Nether Prefix: " + this.getNetherPrefix() + '\n' + "[Multiverse-NetherPortals] Nether Suffix: " + this.getNetherSuffix() + '\n' + "[Multiverse-NetherPortals] End Prefix: " + this.getEndPrefix() + '\n' + "[Multiverse-NetherPortals] End Suffix: " + this.getEndSuffix() + '\n' + "[Multiverse-NetherPortals] Nether Links: " + this.getWorldLinks() + '\n' + "[Multiverse-NetherPortals] End Links: " + this.getEndWorldLinks() + '\n' + "[Multiverse-NetherPortals] Bounceback: " + this.isUsingBounceBack() + '\n' + "[Multiverse-NetherPortals] Teleport Entities: " + this.isTeleportingEntities() + '\n' + "[Multiverse-NetherPortals] Send Disabled Portal Message: " + this.isSendingDisabledPortalMessage() + '\n' + "[Multiverse-NetherPortals] Send No Destination Message: " + this.isSendingNoDestinationMessage() + '\n' + "[Multiverse-NetherPortals] Special Code: FRN001" + '\n';
    }
}

