/*
 * Decompiled with CFR 0.152.
 */
package org.serversmc.autorestart.interfaces;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.serversmc.autorestart.core.AutoRestartKt;
import org.serversmc.autorestart.utils.Console;
import org.serversmc.autorestart.utils.Lang;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0015\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00112\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H&\u00a8\u0006\u0018"}, d2={"Lorg/serversmc/autorestart/interfaces/ConfigAPI;", "", "addFile", "", "fileName", "", "combineSubConfigs", "getBoolean", "", "path", "getDouble", "", "getInt", "", "getIntegerList", "", "getString", "Lorg/jetbrains/annotations/NotNull;", "getStringList", "init", "reloadConfig", "setupConfigs", "Companion", "ConfigFile", "AutoRestart-v4"})
public interface ConfigAPI {
    public static final Companion Companion = org.serversmc.autorestart.interfaces.ConfigAPI$Companion.$$INSTANCE;

    @NotNull
    public String getString(@NotNull String var1);

    public int getInt(@NotNull String var1);

    public double getDouble(@NotNull String var1);

    public boolean getBoolean(@NotNull String var1);

    @NotNull
    public List<Integer> getIntegerList(@NotNull String var1);

    @NotNull
    public List<String> getStringList(@NotNull String var1);

    public void addFile(@NotNull String var1);

    public void setupConfigs();

    public void reloadConfig();

    public void init();

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/serversmc/autorestart/interfaces/ConfigAPI$ConfigFile;", "", "fileName", "", "(Ljava/lang/String;)V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "version", "", "getVersion", "()I", "setVersion", "(I)V", "yamlConfiguration", "Lorg/bukkit/configuration/file/YamlConfiguration;", "getYamlConfiguration", "()Lorg/bukkit/configuration/file/YamlConfiguration;", "setYamlConfiguration", "(Lorg/bukkit/configuration/file/YamlConfiguration;)V", "AutoRestart-v4"})
    public static final class ConfigFile {
        @NotNull
        private final File file;
        @NotNull
        private YamlConfiguration yamlConfiguration;
        private int version;

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final YamlConfiguration getYamlConfiguration() {
            return this.yamlConfiguration;
        }

        public final void setYamlConfiguration(@NotNull YamlConfiguration yamlConfiguration) {
            Intrinsics.checkParameterIsNotNull(yamlConfiguration, "<set-?>");
            this.yamlConfiguration = yamlConfiguration;
        }

        public final int getVersion() {
            return this.version;
        }

        public final void setVersion(int n) {
            this.version = n;
        }

        public ConfigFile(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull(fileName, "fileName");
            this.file = new File(AutoRestartKt.getPLUGIN().getDataFolder(), fileName + ".yml");
            this.yamlConfiguration = new YamlConfiguration();
            if (!this.file.exists()) {
                AutoRestartKt.getPLUGIN().saveResource(this.file.getName(), false);
                String string = Lang.INSTANCE.getNode("config-api.created");
                String string2 = this.file.getName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "file.name");
                Console.INSTANCE.info(StringsKt.replace$default(string, "%f", string2, false, 4, null));
            }
            this.yamlConfiguration.load(this.file);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static String getString(ConfigAPI $this, @NotNull String path) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            String string = ChatColor.translateAlternateColorCodes((char)'&', (String)String.valueOf(Companion.getGlobalConfig().getString(path)));
            Intrinsics.checkExpressionValueIsNotNull(string, "ChatColor.translateAlter\u2026tString(path).toString())");
            return string;
        }

        public static int getInt(ConfigAPI $this, @NotNull String path) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            return Companion.getGlobalConfig().getInt(path);
        }

        public static double getDouble(ConfigAPI $this, @NotNull String path) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            return Companion.getGlobalConfig().getDouble(path);
        }

        public static boolean getBoolean(ConfigAPI $this, @NotNull String path) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            return Companion.getGlobalConfig().getBoolean(path);
        }

        @NotNull
        public static List<Integer> getIntegerList(ConfigAPI $this, @NotNull String path) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            List list = Companion.getGlobalConfig().getIntegerList(path);
            Intrinsics.checkExpressionValueIsNotNull(list, "globalConfig.getIntegerList(path)");
            return list;
        }

        @NotNull
        public static List<String> getStringList(ConfigAPI $this, @NotNull String path) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            List list = Companion.getGlobalConfig().getStringList(path);
            Intrinsics.checkExpressionValueIsNotNull(list, "globalConfig.getStringList(path)");
            return list;
        }

        public static void addFile(ConfigAPI $this, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull(fileName, "fileName");
            Companion.getConfigList().add(new ConfigFile(fileName));
        }

        private static void combineSubConfigs(ConfigAPI $this) {
            Iterable $this$forEach$iv = Companion.getConfigList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConfigFile config = (ConfigFile)element$iv;
                boolean bl = false;
                YamlConfiguration yaml = config.getYamlConfiguration();
                for (String key : yaml.getKeys(true)) {
                    Companion.getGlobalConfig().set(key, yaml.get(key));
                }
            }
            Companion.getGlobalConfig().addDefault("version", null);
        }

        public static void reloadConfig(ConfigAPI $this) {
            Companion.getConfigList().clear();
            $this.setupConfigs();
            DefaultImpls.combineSubConfigs($this);
        }

        public static void init(ConfigAPI $this) {
            $this.setupConfigs();
            Iterable $this$forEach$iv = Companion.getConfigList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Calendar cal;
                YamlConfiguration defaultConfig;
                InputStream inputStream;
                ConfigFile subConfig = (ConfigFile)element$iv;
                boolean bl = false;
                File file = subConfig.getFile();
                YamlConfiguration yaml = subConfig.getYamlConfiguration();
                if (AutoRestartKt.getPLUGIN().getResource(file.getName()) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.io.InputStream");
                }
                Intrinsics.checkExpressionValueIsNotNull(YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream)), "YamlConfiguration.loadCo\u2026treamReader(inputStream))");
                Companion.getGlobalConfig().addDefaults((Configuration)defaultConfig);
                subConfig.setVersion(yaml.getInt("version"));
                if (yaml.getInt("version") == Companion.getGlobalConfig().getInt("version")) continue;
                String string = Lang.INSTANCE.getNode("config-api.update");
                String string2 = file.getName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "file.name");
                Console.INSTANCE.info(StringsKt.replace$default(string, "%f", string2, false, 4, null));
                Calendar calendar = cal = Calendar.getInstance();
                Intrinsics.checkExpressionValueIsNotNull(calendar, "cal");
                String string3 = calendar.getTime().toString();
                Intrinsics.checkExpressionValueIsNotNull(string3, "cal.time.toString()");
                String time = StringsKt.replace$default(string3, ":", "_", false, 4, null);
                File rename = new File(AutoRestartKt.getPLUGIN().getDataFolder(), '(' + time + ") " + file.getName());
                if (rename.exists()) {
                    rename.delete();
                }
                file.renameTo(rename);
                AutoRestartKt.getPLUGIN().saveResource(file.getName(), false);
                yaml.load(file);
                subConfig.setVersion(yaml.getInt("version"));
                String string4 = Lang.INSTANCE.getNode("config-api.backup");
                String string5 = rename.getName();
                Intrinsics.checkExpressionValueIsNotNull(string5, "rename.name");
                Console.INSTANCE.warn(StringsKt.replace$default(string4, "%f", string5, false, 4, null));
            }
            DefaultImpls.combineSubConfigs($this);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/serversmc/autorestart/interfaces/ConfigAPI$Companion;", "", "()V", "configList", "Ljava/util/ArrayList;", "Lorg/serversmc/autorestart/interfaces/ConfigAPI$ConfigFile;", "Lkotlin/collections/ArrayList;", "getConfigList", "()Ljava/util/ArrayList;", "globalConfig", "Lorg/bukkit/configuration/file/YamlConfiguration;", "getGlobalConfig", "()Lorg/bukkit/configuration/file/YamlConfiguration;", "setGlobalConfig", "(Lorg/bukkit/configuration/file/YamlConfiguration;)V", "AutoRestart-v4"})
    public static final class Companion {
        @NotNull
        private static YamlConfiguration globalConfig;
        @NotNull
        private static final ArrayList<ConfigFile> configList;
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final YamlConfiguration getGlobalConfig() {
            return globalConfig;
        }

        public final void setGlobalConfig(@NotNull YamlConfiguration yamlConfiguration) {
            Intrinsics.checkParameterIsNotNull(yamlConfiguration, "<set-?>");
            globalConfig = yamlConfiguration;
        }

        @NotNull
        public final ArrayList<ConfigFile> getConfigList() {
            return configList;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            globalConfig = new YamlConfiguration();
            configList = new ArrayList();
        }
    }
}

