/*
 * Decompiled with CFR 0.152.
 */
package org.serversmc.autorestart.enums;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.serversmc.autorestart.core.TimerThread;
import org.serversmc.autorestart.utils.Config;
import org.serversmc.autorestart.utils.Console;
import org.serversmc.autorestart.utils.Lang;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lorg/serversmc/autorestart/enums/RestartMode;", "", "(Ljava/lang/String;I)V", "calculate", "", "INTERVAL", "TIMESTAMP", "NONE", "Companion", "AutoRestart-v4"})
public abstract class RestartMode
extends Enum<RestartMode> {
    public static final /* enum */ RestartMode INTERVAL;
    public static final /* enum */ RestartMode TIMESTAMP;
    public static final /* enum */ RestartMode NONE;
    private static final /* synthetic */ RestartMode[] $VALUES;
    public static final Companion Companion;

    static {
        RestartMode[] restartModeArray = new RestartMode[3];
        RestartMode[] restartModeArray2 = restartModeArray;
        restartModeArray[0] = INTERVAL = new INTERVAL("INTERVAL", 0);
        restartModeArray[1] = TIMESTAMP = new TIMESTAMP("TIMESTAMP", 1);
        restartModeArray[2] = NONE = new NONE("NONE", 2);
        $VALUES = restartModeArray;
        Companion = new Companion(null);
    }

    public abstract void calculate();

    private RestartMode() {
    }

    public /* synthetic */ RestartMode(String $enum_name_or_ordinal$0, int $enum_name_or_ordinal$1, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static RestartMode[] values() {
        return (RestartMode[])$VALUES.clone();
    }

    public static RestartMode valueOf(String string) {
        return Enum.valueOf(RestartMode.class, string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lorg/serversmc/autorestart/enums/RestartMode$INTERVAL;", "Lorg/serversmc/autorestart/enums/RestartMode;", "calculate", "", "AutoRestart-v4"})
    static final class INTERVAL
    extends RestartMode {
        @Override
        public void calculate() {
            Config.INSTANCE.getMain_Modes_Interval_Factor().calculate();
        }

        /*
         * WARNING - void declaration
         */
        INTERVAL() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lorg/serversmc/autorestart/enums/RestartMode$TIMESTAMP;", "Lorg/serversmc/autorestart/enums/RestartMode;", "calculate", "", "AutoRestart-v4"})
    static final class TIMESTAMP
    extends RestartMode {
        @Override
        public void calculate() {
            List<Config.TimeStamp> timestamps = Config.INSTANCE.getMain_Modes_Timestamp();
            ArrayList<Long> differences = new ArrayList<Long>();
            Iterable $this$forEach$iv = timestamps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Config.TimeStamp it = (Config.TimeStamp)element$iv;
                boolean bl = false;
                if (it.getH() < 0 || it.getH() > 23) {
                    Console.INSTANCE.err(it + ' ' + Lang.INSTANCE.getNode("restart-mode.hour-out-of-range"));
                }
                if (it.getM() < 0 || it.getM() > 59) {
                    Console.INSTANCE.err(it + ' ' + Lang.INSTANCE.getNode("restart-mode.min-out-of-range"));
                }
                long l = it.getTimeInMillis();
                Calendar calendar = Calendar.getInstance();
                Intrinsics.checkExpressionValueIsNotNull(calendar, "Calendar.getInstance()");
                differences.add(l - calendar.getTimeInMillis());
            }
            if (differences.isEmpty()) {
                Console.INSTANCE.warn(Lang.INSTANCE.getNode("restart-mode.no-timestamp"));
                return;
            }
            Object t = CollectionsKt.min((Iterable)differences);
            if (t == null) {
                Intrinsics.throwNpe();
            }
            long time = ((Number)t).longValue();
            TimerThread.INSTANCE.setTIME((int)time / 1000);
        }

        /*
         * WARNING - void declaration
         */
        TIMESTAMP() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lorg/serversmc/autorestart/enums/RestartMode$NONE;", "Lorg/serversmc/autorestart/enums/RestartMode;", "calculate", "", "AutoRestart-v4"})
    static final class NONE
    extends RestartMode {
        @Override
        public void calculate() {
            Console.INSTANCE.err(StringsKt.replace$default(Lang.INSTANCE.getNode("restart-mode.mode-not-found"), "%m", Config.INSTANCE.getMain_RestartMode_Raw(), false, 4, null));
            INTERVAL.calculate();
        }

        /*
         * WARNING - void declaration
         */
        NONE() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/serversmc/autorestart/enums/RestartMode$Companion;", "", "()V", "parse", "Lorg/serversmc/autorestart/enums/RestartMode;", "name", "", "AutoRestart-v4"})
    public static final class Companion {
        @NotNull
        public final RestartMode parse(@NotNull String name) {
            Object object;
            Intrinsics.checkParameterIsNotNull(name, "name");
            try {
                object = name;
                boolean bl = false;
                String string = object.toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull(string, "(this as java.lang.String).toUpperCase()");
                object = RestartMode.valueOf(string);
            }
            catch (IllegalArgumentException e) {
                object = NONE;
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

