/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.util;

import com.froobworld.viewdistancetweaks.hook.tick.TickHook;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Queue;
import java.util.function.Consumer;

public class TpsTracker
implements Consumer<Integer> {
    private final TickHook tickHook;
    private final int collectionPeriod;
    private final Queue<Double> tickDurations;
    private long lastTickTime;
    private double tickDurationSum;
    private final double trimToWithinRange;

    public TpsTracker(int collectionPeriod, TickHook tickHook, double trimToWithinRange) {
        this.tickHook = tickHook;
        this.collectionPeriod = collectionPeriod <= 0 ? 1200 : collectionPeriod;
        this.trimToWithinRange = trimToWithinRange / 100.0;
        this.tickDurations = new ArrayDeque<Double>(Collections.nCopies(collectionPeriod, 50.0));
        this.tickDurationSum = 50.0 * (double)collectionPeriod;
    }

    public void register() {
        this.tickHook.addTickStartCallback(this);
    }

    public void unregister() {
        this.tickHook.removeTickStartCallback(this);
        this.tickDurationSum = 0.0;
        this.lastTickTime = 0L;
        this.tickDurations.clear();
    }

    private double getAverageTickTime() {
        return this.tickDurations.size() < this.collectionPeriod ? 50.0 : this.tickDurationSum / (double)this.collectionPeriod;
    }

    public double getTps() {
        return 1000.0 / this.getAverageTickTime();
    }

    @Override
    public void accept(Integer integer) {
        long curTimeMillis = System.currentTimeMillis();
        double tickDuration = Math.min(Math.max(this.lastTickTime == 0L ? 50.0 : (double)(curTimeMillis - this.lastTickTime), (1.0 - this.trimToWithinRange) * this.getAverageTickTime()), (1.0 + this.trimToWithinRange) * this.getAverageTickTime());
        this.tickDurationSum -= this.tickDurations.remove().doubleValue();
        this.tickDurations.add(tickDuration);
        this.tickDurationSum += tickDuration;
        this.lastTickTime = curTimeMillis;
    }
}

