/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.util;

import com.froobworld.viewdistancetweaks.util.ChunkCounter;
import com.froobworld.viewdistancetweaks.util.RectangleUnionAreaFinder;
import java.util.function.Function;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class StandardChunkCounter
implements ChunkCounter {
    private final Function<World, Double> chunkWeight;
    private final Function<World, Boolean> excludeOverlap;

    public StandardChunkCounter(Function<World, Double> chunkWeight, Function<World, Boolean> excludeOverlap) {
        this.chunkWeight = chunkWeight;
        this.excludeOverlap = excludeOverlap;
    }

    @Override
    public double countChunks(World world, int viewDistance) {
        int unweightedCount;
        double chunkWeight = this.chunkWeight.apply(world);
        boolean excludeOverlap = this.excludeOverlap.apply(world);
        if (excludeOverlap) {
            RectangleUnionAreaFinder areaFinder = new RectangleUnionAreaFinder();
            for (Player player : world.getPlayers()) {
                areaFinder.addRect(player.getLocation().getBlockX() >> 4, player.getLocation().getBlockZ() >> 4, (player.getLocation().getBlockX() >> 4) + 2 * viewDistance + 1, (player.getLocation().getBlockZ() >> 4) + 2 * viewDistance + 1);
            }
            unweightedCount = areaFinder.area();
        } else {
            unweightedCount = world.getPlayers().size() * (int)Math.pow(2 * viewDistance + 1, 2.0);
        }
        return (double)unweightedCount * chunkWeight;
    }
}

